/*
 * Decompiled with CFR 0.152.
 */
package org.pagemodel.gen.gradle.writers;

import org.pagemodel.gen.gradle.PageModelConfig;
import org.pagemodel.gen.gradle.writers.InnerComponentModelWriter;
import org.pagemodel.gen.gradle.writers.SectionModelWriter;

public class InnerSectionModelWriter
extends SectionModelWriter {
    @Override
    protected String getComponentClassDef(PageModelConfig pageModel) {
        return String.format("public class %s extends ExtendedSectionModel<%s, %s ,%s> {", pageModel.modelName, this.getSectionTypeParam(pageModel), this.getSectionPageParam(pageModel), this.getSectionTypeParam(pageModel));
    }

    @Override
    protected String getSectionTypeParam(PageModelConfig pageModel) {
        return pageModel.modelName;
    }

    @Override
    protected String getSectionPageParam(PageModelConfig pageModel) {
        switch (pageModel.parentPage.modelType) {
            case "PageModel": {
                return pageModel.parentPage.modelName;
            }
            case "AbstractPageModel": {
                return "P";
            }
            case "ComponentModel": {
                return pageModel.parentPage.parentPage == null ? "P" : new InnerComponentModelWriter().getComponentPageParam(pageModel.parentPage);
            }
            case "SectionModel": {
                return pageModel.parentPage.modelName + (pageModel.parentPage.parentPage == null ? "<P>" : "");
            }
        }
        return pageModel.parentPage.modelName;
    }
}

