/*
 * Decompiled with CFR 0.152.
 */
package org.pagemodel.gen.gradle;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.TaskAction;
import org.pagemodel.gen.gradle.GradleGenExtension;
import org.pagemodel.gen.gradle.PageModelConfig;
import org.pagemodel.gen.gradle.PageModelJavaWriter;
import org.pagemodel.gen.gradle.PageModelReader;

public class GradleGenTask
extends DefaultTask {
    @TaskAction
    public void pagegen() throws IOException {
        GradleGenExtension extension = (GradleGenExtension)this.getProject().getExtensions().findByType(GradleGenExtension.class);
        if (extension == null) {
            extension = new GradleGenExtension();
        }
        File modelDir = new File(this.getProject().getProjectDir(), extension.getSrcDir());
        File outDir = new File(this.getProject().getProjectDir(), extension.getGenRootDir());
        Boolean cleanGenDir = extension.getCleanGenDir();
        if (cleanGenDir.booleanValue() && outDir.exists()) {
            GradleGenTask.deleteDirectory(outDir);
        }
        GradleGenTask.generatePageModelClasses(modelDir, outDir, cleanGenDir);
    }

    private static boolean deleteDirectory(File directory) {
        File[] files;
        if (directory.exists() && null != (files = directory.listFiles())) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    GradleGenTask.deleteDirectory(files[i]);
                    continue;
                }
                files[i].delete();
            }
        }
        return directory.delete();
    }

    public static void generatePageModelClasses(File inputDir, File outputDir, boolean cleanGenDir) throws IOException {
        if (!inputDir.exists()) {
            throw new RuntimeException("Error: pagemodel directory does not exist [" + inputDir.getPath() + "]");
        }
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        for (File pagemodel : inputDir.listFiles(file -> file.getName().endsWith(".pagemodel"))) {
            GradleGenTask.generatePageModelClass(pagemodel, outputDir);
        }
        for (File modelDir : inputDir.listFiles(file -> file.isDirectory())) {
            GradleGenTask.generatePageModelClasses(modelDir, outputDir, cleanGenDir);
        }
    }

    public static void generatePageModelClass(File inputFile, File outputDir) throws IOException {
        try {
            String path = inputFile.getAbsolutePath();
            System.out.println("Generating: " + path);
            PageModelConfig config = new PageModelReader().readPageModel(path);
            String javaContent = new PageModelJavaWriter().generatePageModelJavaFile(config);
            String javaFile = inputFile.getName().replaceAll("\\.pagemodel$", ".java");
            String javaDir = outputDir.getAbsolutePath() + "/" + config.modelPackage.replaceAll("\\.", "/") + "/";
            String javaPath = javaDir + javaFile;
            new File(javaDir).mkdirs();
            FileWriter writer = new FileWriter(javaPath);
            writer.write(javaContent);
            writer.flush();
            writer.close();
        }
        catch (Throwable ex) {
            System.out.println();
        }
    }
}

