/*
 * Decompiled with CFR 0.152.
 */
package org.pagemodel.gen.gradle;

import java.lang.invoke.MethodHandles;
import java.util.List;
import org.pagemodel.gen.gradle.PageModelConfig;
import org.pagemodel.gen.gradle.writers.AbstractPageModelWriter;
import org.pagemodel.gen.gradle.writers.ComponentModelWriter;
import org.pagemodel.gen.gradle.writers.InnerComponentModelWriter;
import org.pagemodel.gen.gradle.writers.InnerSectionModelWriter;
import org.pagemodel.gen.gradle.writers.PageModelWriter;
import org.pagemodel.gen.gradle.writers.SectionModelWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageModelJavaWriter {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String INDENT = "\t";

    public String generatePageModelJavaFile(PageModelConfig pageModel) {
        StringBuilder sb = new StringBuilder();
        this.generateFileHeader(pageModel, sb);
        this.generatePageModelClass(pageModel, sb, "");
        return sb.toString();
    }

    private StringBuilder generateFileHeader(PageModelConfig pageModel, StringBuilder sb) {
        sb.append("package ").append(pageModel.modelPackage).append(";").append(System.lineSeparator()).append(System.lineSeparator());
        sb.append("import org.pagemodel.web.*;").append(System.lineSeparator()).append("import org.pagemodel.web.testers.*;").append(System.lineSeparator()).append("import org.pagemodel.core.testers.*;").append(System.lineSeparator()).append("import org.pagemodel.tools.*;").append(System.lineSeparator()).append("import java.util.function.Consumer;").append(System.lineSeparator()).append("import org.openqa.selenium.By;").append(System.lineSeparator()).append("import org.openqa.selenium.WebElement;").append(System.lineSeparator());
        for (String imprt : pageModel.imports) {
            sb.append(imprt).append(System.lineSeparator());
        }
        return sb;
    }

    private StringBuilder generatePageModelClass(PageModelConfig pageModel, StringBuilder sb, String indent) {
        PageModelWriter writer = PageModelJavaWriter.getWriterType(pageModel);
        writer.generateClassStart(pageModel, sb, indent);
        writer.generateModelDisplayed(pageModel, sb, indent);
        writer.generateElementGetters(pageModel, sb, indent);
        writer.generateElementTesters(pageModel, sb, indent);
        this.generateInnerComponents(pageModel, sb, indent);
        this.generateCustomJava(pageModel, sb, indent);
        writer.generateClassEnd(pageModel, sb, indent);
        return sb;
    }

    private StringBuilder generateCustomJava(PageModelConfig pageModel, StringBuilder sb, String indent) {
        for (List<String> block : pageModel.customJava) {
            for (String line : block) {
                sb.append(System.lineSeparator()).append(indent).append(line);
            }
            sb.append(System.lineSeparator());
        }
        return sb;
    }

    private StringBuilder generateInnerComponents(PageModelConfig pageModel, StringBuilder sb, String indent) {
        for (PageModelConfig inner : pageModel.innerModels) {
            sb.append(System.lineSeparator());
            this.generatePageModelClass(inner, sb, indent + INDENT);
        }
        return sb;
    }

    private static PageModelWriter getWriterType(PageModelConfig pageModel) {
        switch (pageModel.modelType) {
            case "PageModel": {
                return new PageModelWriter();
            }
            case "AbstractPageModel": {
                return new AbstractPageModelWriter();
            }
            case "ComponentModel": {
                return pageModel.parentPage == null ? new ComponentModelWriter() : new InnerComponentModelWriter();
            }
            case "SectionModel": {
                return pageModel.parentPage == null ? new SectionModelWriter() : new InnerSectionModelWriter();
            }
        }
        return new PageModelWriter();
    }
}

