/*
 * Decompiled with CFR 0.152.
 */
package org.pagemodel.gen.gradle.writers;

import org.pagemodel.gen.gradle.ElementConfig;
import org.pagemodel.gen.gradle.PageModelConfig;
import org.pagemodel.gen.gradle.writers.PageModelWriter;

public class ComponentModelWriter
extends PageModelWriter {
    @Override
    public StringBuilder generateClassStart(PageModelConfig pageModel, StringBuilder sb, String indent) {
        String classIndent = indent + "\t";
        String methodIndent = classIndent + "\t";
        String innerIndent = methodIndent + "\t";
        sb.append(System.lineSeparator()).append(indent).append(this.getComponentClassDef(pageModel)).append(System.lineSeparator()).append(classIndent).append("public ").append(pageModel.modelName).append("(ClickAction<?, ").append(this.getComponentPageParam(pageModel)).append("> clickAction, TestEvaluator testEvaluator) {").append(System.lineSeparator()).append(methodIndent).append("super(clickAction, testEvaluator);").append(System.lineSeparator()).append(classIndent).append("}").append(System.lineSeparator()).append(System.lineSeparator()).append(classIndent).append("public ").append(pageModel.modelName).append("(R returnObj, ClickAction<?, ").append(this.getComponentPageParam(pageModel)).append("> clickAction, TestEvaluator testEvaluator) {").append(System.lineSeparator()).append(methodIndent).append("super(returnObj, clickAction, testEvaluator);").append(System.lineSeparator()).append(classIndent).append("}").append(System.lineSeparator()).append(System.lineSeparator()).append(classIndent).append("public class ").append(pageModel.modelName).append("_section extends ").append(pageModel.modelName).append("<").append(this.getComponentSectionTypeParams(pageModel)).append("> {").append(System.lineSeparator()).append(methodIndent).append("public ").append(pageModel.modelName).append("_section(ClickAction<?, ").append(this.getComponentPageParam(pageModel)).append("> clickAction, TestEvaluator testEvaluator) {").append(System.lineSeparator()).append(innerIndent).append("super(clickAction, testEvaluator);").append(System.lineSeparator()).append(innerIndent).append("setReturnObj(this);").append(System.lineSeparator()).append(methodIndent).append("}").append(System.lineSeparator()).append(System.lineSeparator()).append(methodIndent).append("public ").append(this.getComponentPageParam(pageModel)).append(" testSectionParent() {").append(System.lineSeparator()).append(innerIndent).append("return ").append(this.getTesterPageReturnObj(pageModel)).append(";").append(System.lineSeparator()).append(methodIndent).append("}").append(System.lineSeparator()).append(classIndent).append("}").append(System.lineSeparator()).append(System.lineSeparator()).append(classIndent).append("public ").append(pageModel.modelName).append("_section asSection(){").append(System.lineSeparator()).append(methodIndent).append("return new ").append(pageModel.modelName).append("_section(clickAction, getEvaluator());").append(System.lineSeparator()).append(classIndent).append("}").append(System.lineSeparator());
        return sb;
    }

    protected String getComponentClassDef(PageModelConfig pageModel) {
        return String.format("public class %s<R, P extends ExtendedModelBase<? super P>> extends ComponentModel<R,P,%s<R,P>> {", pageModel.modelName, pageModel.modelName);
    }

    protected String getComponentPageParam(PageModelConfig pageModel) {
        return "P";
    }

    protected String getComponentSectionTypeParams(PageModelConfig pageModel) {
        return pageModel.modelName + "_section, P";
    }

    @Override
    protected String getModelDisplayedType(PageModelConfig pageModel) {
        return pageModel.modelName + "_section";
    }

    @Override
    protected String getModelDisplayedStart(PageModelConfig pageModel) {
        return "return page -> page";
    }

    @Override
    protected String getModelDisplayedEnd(PageModelConfig pageModel) {
        return ";";
    }

    @Override
    protected String getPageTypeParam(PageModelConfig pageModel) {
        return "R";
    }

    @Override
    protected String getPageNavTypeParam(PageModelConfig pageModel) {
        return "P";
    }

    @Override
    protected String getTesterNavReturnValue(PageModelConfig pageModel) {
        return "(P)page";
    }

    @Override
    protected String getTesterPageReturnObj(PageModelConfig pageModel) {
        return "(P)page";
    }

    @Override
    protected String getClickActionWrap(PageModelConfig pageModel, String clickAction) {
        return "getReturnObj(), " + clickAction + ", getEvaluator()";
    }

    @Override
    protected String getTesterNavParentPageType(PageModelConfig pageModel, ElementConfig elem) {
        return "P";
    }

    @Override
    protected String getTesterNavParentPageValue(PageModelConfig pageModel, ElementConfig elem) {
        return "(P)page";
    }
}

