/*
 * Decompiled with CFR 0.152.
 */
package org.pagemodel.gen.gradle.writers;

import org.pagemodel.gen.gradle.PageModelConfig;
import org.pagemodel.gen.gradle.writers.ComponentModelWriter;

public class InnerComponentModelWriter
extends ComponentModelWriter {
    @Override
    protected String getComponentClassDef(PageModelConfig pageModel) {
        return String.format("public class %s<R> extends ComponentModel<R,%s,%s<R>> {", pageModel.modelName, this.getComponentPageParam(pageModel), pageModel.modelName);
    }

    @Override
    protected String getComponentPageParam(PageModelConfig pageModel) {
        switch (pageModel.parentPage.modelType) {
            case "PageModel": {
                return pageModel.parentPage.modelName;
            }
            case "AbstractPageModel": {
                return "P";
            }
            case "ComponentModel": {
                return pageModel.parentPage.parentPage == null ? "P" : this.getComponentPageParam(pageModel.parentPage);
            }
            case "SectionModel": {
                return pageModel.parentPage.parentPage == null ? pageModel.parentPage.modelName + "<P>" : pageModel.parentPage.modelName;
            }
        }
        return "P";
    }

    @Override
    protected String getComponentSectionTypeParams(PageModelConfig pageModel) {
        return pageModel.modelName + "_section";
    }

    @Override
    protected String getPageTypeParam(PageModelConfig pageModel) {
        return "R";
    }

    @Override
    protected String getPageNavTypeParam(PageModelConfig pageModel) {
        return this.getComponentPageParam(pageModel);
    }

    @Override
    protected String getTesterNavReturnValue(PageModelConfig pageModel) {
        return "(" + this.getComponentPageParam(pageModel) + ")page";
    }

    @Override
    protected String getTesterPageReturnObj(PageModelConfig pageModel) {
        return "(" + this.getComponentPageParam(pageModel) + ")page";
    }
}

