/*
 * Decompiled with CFR 0.152.
 */
package org.pagemodel.gen.gradle.writers;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.pagemodel.gen.gradle.ElementConfig;
import org.pagemodel.gen.gradle.PageModelConfig;

public class PageModelWriter {
    public StringBuilder generateClassStart(PageModelConfig pageModel, StringBuilder sb, String indent) {
        String classIndent = indent + "\t";
        String methodIndent = classIndent + "\t";
        sb.append(System.lineSeparator()).append(indent).append("public class ").append(pageModel.modelName).append(" extends ").append(pageModel.modelInherit).append("<").append(pageModel.modelName).append("> {").append(System.lineSeparator()).append(classIndent).append("public ").append(pageModel.modelName).append("(ExtendedTestContext testContext) {").append(System.lineSeparator()).append(methodIndent).append("super(testContext);").append(System.lineSeparator()).append(classIndent).append("}").append(System.lineSeparator());
        return sb;
    }

    protected String getModelDisplayedType(PageModelConfig pageModel) {
        return this.getPageTypeParam(pageModel);
    }

    protected String getModelDisplayedStart(PageModelConfig pageModel) {
        return "return super.testModelDisplayed().andThen(page -> page";
    }

    protected String getModelDisplayedEnd(PageModelConfig pageModel) {
        return ");";
    }

    protected String getPageTypeParam(PageModelConfig pageModel) {
        return pageModel.modelName;
    }

    protected String getPageNavTypeParam(PageModelConfig pageModel) {
        return this.getPageTypeParam(pageModel);
    }

    protected String getTesterNavReturnValue(PageModelConfig pageModel) {
        return pageModel.modelName + ".class";
    }

    protected String getTesterNavParentPageType(PageModelConfig pageModel, ElementConfig elem) {
        return pageModel.modelName;
    }

    protected String getTesterNavParentPageValue(PageModelConfig pageModel, ElementConfig elem) {
        return "this";
    }

    protected String getClickActionWrap(PageModelConfig pageModel, String clickAction) {
        return clickAction + ", getEvaluator()";
    }

    protected String getTesterPageReturnObj(PageModelConfig pageModel) {
        return "this";
    }

    public StringBuilder generateClassEnd(PageModelConfig pageModel, StringBuilder sb, String indent) {
        return sb.append(indent).append("}").append(System.lineSeparator());
    }

    public StringBuilder generateModelDisplayed(PageModelConfig pageModel, StringBuilder sb, String indent) {
        String classIndent = indent + "\t";
        String methodIndent = classIndent + "\t";
        String continueIndent = methodIndent + "\t" + "\t";
        boolean display = false;
        for (ElementConfig elem : pageModel.elements) {
            if (!elem.displayed) continue;
            display = true;
            break;
        }
        if (!display) {
            return sb;
        }
        sb.append(System.lineSeparator()).append(classIndent).append("@Override").append(System.lineSeparator()).append(classIndent).append("protected Consumer<").append(this.getModelDisplayedType(pageModel)).append("> testModelDisplayed() {").append(System.lineSeparator()).append(methodIndent).append(this.getModelDisplayedStart(pageModel));
        for (ElementConfig elem : pageModel.elements) {
            if (!elem.displayed) continue;
            sb.append(System.lineSeparator()).append(continueIndent).append(".test").append(elem.name).append("()").append(elem.displayTest);
        }
        sb.append(this.getModelDisplayedEnd(pageModel)).append(System.lineSeparator()).append(classIndent).append("}").append(System.lineSeparator());
        return sb;
    }

    public StringBuilder generateElementGetters(PageModelConfig pageModel, StringBuilder sb, String indent) {
        String classIndent = indent + "\t";
        sb.append(System.lineSeparator()).append(classIndent).append("// ================ begin protected web elements ==============");
        for (ElementConfig elem : pageModel.elements) {
            this.generateElementGetter(pageModel, elem, sb, indent);
        }
        sb.append(classIndent).append("// ================ end protected web elements ================").append(System.lineSeparator());
        return sb;
    }

    public StringBuilder generateElementGetter(PageModelConfig pageModel, ElementConfig elem, StringBuilder sb, String indent) {
        String classIndent = indent + "\t";
        String methodIndent = classIndent + "\t";
        String locator = elem.byLocator;
        List<LocatorArg> args = this.findVars(locator);
        for (LocatorArg arg2 : args) {
            locator = locator.replaceAll(arg2.locatorString, "\" + " + arg2.name + " + \"");
        }
        String methodArgs = String.join((CharSequence)", ", (CharSequence[])args.stream().map(arg -> arg.argString).toArray(String[]::new));
        sb.append(System.lineSeparator()).append(classIndent).append("protected LocatedWebElement get").append(elem.name).append("(").append(methodArgs).append(") {").append(System.lineSeparator()).append(methodIndent).append("return ").append(elem.findMethod).append("(\"").append(elem.name).append("\", By.").append(elem.byType).append("(\"").append(locator).append("\"));").append(System.lineSeparator()).append(classIndent).append("}").append(System.lineSeparator());
        return sb;
    }

    public StringBuilder generateElementTesters(PageModelConfig pageModel, StringBuilder sb, String indent) {
        String classIndent = indent + "\t";
        sb.append(System.lineSeparator()).append(classIndent).append("// ================ begin public testers ======================");
        for (ElementConfig elem : pageModel.elements) {
            this.generateElementTester(pageModel, elem, sb, indent);
        }
        sb.append(classIndent).append("// ================ end public testers ========================").append(System.lineSeparator());
        return sb;
    }

    public StringBuilder generateElementTester(PageModelConfig pageModel, ElementConfig elem, StringBuilder sb, String indent) {
        String classIndent = indent + "\t";
        String methodIndent = classIndent + "\t";
        String continueIndent = methodIndent + "\t" + "\t";
        String locator = elem.byLocator;
        List<LocatorArg> args = this.findVars(locator);
        String methodArgs = String.join((CharSequence)", ", (CharSequence[])args.stream().map(arg -> arg.argString).toArray(String[]::new));
        String callArgs = String.join((CharSequence)", ", (CharSequence[])args.stream().map(arg -> arg.name).toArray(String[]::new));
        String clickAction = this.getClickAction(pageModel, elem, callArgs, continueIndent);
        TesterType tester = this.getTesterType(pageModel, elem);
        sb.append(System.lineSeparator()).append(classIndent).append("public ").append(tester.type).append(tester.params).append(" test").append(elem.name).append("(").append(methodArgs).append(") {").append(System.lineSeparator()).append(methodIndent).append("return new ").append(tester.type).append(tester.infer).append("(").append(clickAction).append(");").append(System.lineSeparator()).append(classIndent).append("}").append(System.lineSeparator());
        return sb;
    }

    protected TesterType getTesterType(PageModelConfig pageModel, ElementConfig elem) {
        TesterType tester = new TesterType();
        String returnType = this.getTesterNavTypeParam(pageModel, elem);
        if (elem.testerType.startsWith("@@@")) {
            tester.type = elem.testerType.substring(3);
            tester.params = "<" + this.getPageTypeParam(pageModel) + ", " + returnType + ">";
        } else if (elem.testerType.startsWith("@@")) {
            tester.type = elem.testerType.substring(2);
            tester.params = "<" + this.getPageTypeParam(pageModel) + ">";
        } else if (elem.testerType.startsWith("@")) {
            tester.type = elem.testerType.substring(1);
            tester.params = "";
        } else {
            tester.type = elem.testerType;
            tester.params = "<" + this.getPageTypeParam(pageModel) + ", " + returnType + ">";
        }
        tester.infer = tester.params.isEmpty() ? "" : "<>";
        return tester;
    }

    protected String getTesterNavTypeParam(PageModelConfig pageModel, ElementConfig elem) {
        if (elem.returnType == null) {
            return this.getPageNavTypeParam(pageModel);
        }
        if (elem.returnType.equals("P") || elem.returnType.startsWith("P:")) {
            return this.getTesterNavParentPageType(pageModel, elem);
        }
        if (elem.returnType.contains(":")) {
            return elem.returnType.split(":")[0];
        }
        return elem.returnType;
    }

    protected String getReturnValue(PageModelConfig pageModel, ElementConfig elem) {
        if (elem.returnType == null) {
            return this.getTesterNavReturnValue(pageModel);
        }
        if (elem.returnType.equals("P") || elem.returnType.startsWith("P:")) {
            return this.getTesterNavParentPageValue(pageModel, elem);
        }
        if (elem.returnType.contains(":")) {
            return "test" + elem.returnType.split(":")[1] + "()";
        }
        return elem.returnType + ".class";
    }

    protected String getClickAction(PageModelConfig pageModel, ElementConfig elem, String callArgs, String continueIndent) {
        String clickAction = null;
        String elemGetter = callArgs == null || callArgs.isEmpty() ? "this::get" + elem.name : "() -> get" + elem.name + "(" + callArgs + ")";
        clickAction = elem.returnType == null ? "ClickAction.make(" + elemGetter + ", " + this.getTesterPageReturnObj(pageModel) + ", getEvaluator())" : "ClickAction.makeNav(" + elemGetter + ", " + this.getTesterPageReturnObj(pageModel) + ", " + this.getReturnValue(pageModel, elem) + ", getEvaluator())";
        if (elem.clickModifier != null && !elem.clickModifier.isEmpty()) {
            clickAction = clickAction + System.lineSeparator() + continueIndent + elem.clickModifier;
        }
        return this.getClickActionWrap(pageModel, clickAction);
    }

    protected List<LocatorArg> findVars(String locator) {
        ArrayList<LocatorArg> args = new ArrayList<LocatorArg>();
        Matcher matcher = Pattern.compile("[si]%[^ %]+%").matcher(locator);
        while (matcher.find()) {
            args.add(new LocatorArg(matcher.group()));
        }
        return args;
    }

    class LocatorArg {
        public String locatorString;
        public String argString;
        public String name;

        public LocatorArg(String locatorString) {
            this.locatorString = locatorString;
            this.argString = locatorString.startsWith("i") ? "int" : "String";
            this.name = locatorString.substring(2, locatorString.length() - 1);
            this.argString = this.argString + " " + this.name;
        }
    }

    class TesterType {
        public String type;
        public String params;
        public String infer;

        TesterType() {
        }
    }
}

