/*
 * Decompiled with CFR 0.152.
 */
package org.pagemodel.gen.gradle.writers;

import org.pagemodel.gen.gradle.ElementConfig;
import org.pagemodel.gen.gradle.PageModelConfig;
import org.pagemodel.gen.gradle.writers.PageModelWriter;

public class SectionModelWriter
extends PageModelWriter {
    @Override
    public StringBuilder generateClassStart(PageModelConfig pageModel, StringBuilder sb, String indent) {
        String classIndent = indent + "\t";
        String methodIndent = classIndent + "\t";
        sb.append(System.lineSeparator()).append(indent).append(this.getComponentClassDef(pageModel)).append(System.lineSeparator()).append(classIndent).append("public ").append(pageModel.modelName).append("(ClickAction<").append(this.getSectionPageParam(pageModel)).append(", ").append(this.getSectionPageParam(pageModel)).append("> clickAction, TestEvaluator testEvaluator) {").append(System.lineSeparator()).append(methodIndent).append("super(clickAction, testEvaluator);").append(System.lineSeparator()).append(classIndent).append("}").append(System.lineSeparator());
        return sb;
    }

    protected String getComponentClassDef(PageModelConfig pageModel) {
        return String.format("public class %s<P extends ExtendedModelBase<? super P>> extends ExtendedSectionModel<%s,P,%s> {", pageModel.modelName, this.getSectionTypeParam(pageModel), this.getSectionTypeParam(pageModel));
    }

    protected String getSectionTypeParam(PageModelConfig pageModel) {
        return pageModel.modelName + "<P>";
    }

    protected String getSectionPageParam(PageModelConfig pageModel) {
        return "P";
    }

    @Override
    protected String getModelDisplayedType(PageModelConfig pageModel) {
        return this.getSectionTypeParam(pageModel);
    }

    @Override
    protected String getPageTypeParam(PageModelConfig pageModel) {
        return this.getSectionTypeParam(pageModel);
    }

    @Override
    protected String getTesterNavReturnValue(PageModelConfig pageModel) {
        return "this";
    }

    @Override
    protected String getTesterPageReturnObj(PageModelConfig pageModel) {
        return "this";
    }

    @Override
    protected String getTesterNavParentPageType(PageModelConfig pageModel, ElementConfig elem) {
        return this.getSectionPageParam(pageModel);
    }

    @Override
    protected String getTesterNavParentPageValue(PageModelConfig pageModel, ElementConfig elem) {
        return "parentPage";
    }
}

