/*
 * Decompiled with CFR 0.152.
 */
package org.pagemodel.gen.gradle;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import org.pagemodel.gen.gradle.ElementConfig;
import org.pagemodel.gen.gradle.ElementType;
import org.pagemodel.gen.gradle.PageModelConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageModelReader {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public PageModelConfig readPageModel(String filepath) throws IOException {
        PageModelConfig rootPageModel = new PageModelConfig();
        rootPageModel.parentPage = null;
        PageModelConfig pageModel = rootPageModel;
        boolean topLineParsed = false;
        boolean inJavaBlock = false;
        pageModel.modelName = new File(filepath).getName().replaceAll("\\.pagemodel", "");
        BufferedReader reader = new BufferedReader(new FileReader(filepath));
        String line = reader.readLine();
        while (line != null) {
            if (!topLineParsed) {
                if (!line.isEmpty()) {
                    pageModel = this.parseTopLine(line, pageModel);
                    topLineParsed = true;
                }
            } else if (inJavaBlock) {
                if (this.parseJavaEnd(line, pageModel)) {
                    inJavaBlock = false;
                } else {
                    List<String> block = pageModel.customJava.get(pageModel.customJava.size() - 1);
                    if (block.size() > 0 && block.get(0).equals("\t@Override")) {
                        line = "\t" + line;
                    }
                    block.add(line);
                }
            } else if (this.parseJavaStart(line, pageModel)) {
                inJavaBlock = true;
            } else {
                pageModel = this.parseModelLine(line, pageModel);
            }
            line = reader.readLine();
        }
        reader.close();
        return rootPageModel;
    }

    private PageModelConfig parseTopLine(String line, PageModelConfig pageModel) {
        List<String> parts = this.parseArgString(line);
        String modelInherit = parts.get(0);
        String modelType = modelInherit;
        if (!PageModelConfig.MODEL_TYPES.contains(modelType)) {
            modelType = "PageModel";
        }
        if (modelInherit.startsWith("@")) {
            modelInherit = modelInherit.substring(1);
            modelType = "AbstractPageModel";
        }
        if (modelInherit.equals("PageModel") || modelInherit.equals("AbstractPageModel")) {
            modelInherit = "ExtendedPageModel";
        } else if (modelInherit.equals("SectionModel")) {
            modelInherit = "ExtendedSectionModel";
        }
        pageModel.modelInherit = modelInherit;
        pageModel.modelType = modelType;
        pageModel.modelPackage = parts.get(1);
        return pageModel;
    }

    private boolean parseJavaStart(String line, PageModelConfig pageModel) {
        if (!line.trim().startsWith("%")) {
            return false;
        }
        if (line.trim().equals("%%start")) {
            pageModel.customJava.add(new ArrayList());
            return true;
        }
        ArrayList<String> javaBlock = new ArrayList<String>();
        javaBlock.add("\t@Override");
        javaBlock.add("\tpublic void " + line.trim().substring(1) + "() {");
        pageModel.customJava.add(javaBlock);
        return true;
    }

    private boolean parseJavaEnd(String line, PageModelConfig pageModel) {
        if (line.trim().equals("%%end")) {
            return true;
        }
        if (line.trim().equals("%end")) {
            pageModel.customJava.get(pageModel.customJava.size() - 1).add("\t}" + System.lineSeparator());
            return true;
        }
        return false;
    }

    private PageModelConfig parseModelLine(String line, PageModelConfig pageModel) {
        List<String> parts = this.parseArgString(line);
        if (parts.isEmpty() || parts.get(0).startsWith("#")) {
            return pageModel;
        }
        String first = parts.get(0);
        if (first.equals("import")) {
            String imprt = line;
            if (!imprt.endsWith(";")) {
                imprt = imprt + ";";
            }
            pageModel.imports.add(imprt);
            return pageModel;
        }
        if (first.equals("@ComponentModel")) {
            PageModelConfig inner = new PageModelConfig();
            inner.parentPage = pageModel;
            inner.modelPackage = pageModel.modelPackage;
            inner.modelType = "ComponentModel";
            inner.modelInherit = "ComponentModel";
            inner.modelName = parts.get(1);
            pageModel.innerModels.add(inner);
            return inner;
        }
        if (first.equals("@SectionModel")) {
            PageModelConfig inner = new PageModelConfig();
            inner.parentPage = pageModel;
            inner.modelPackage = pageModel.modelPackage;
            inner.modelType = "SectionModel";
            inner.modelInherit = "SectionModel";
            inner.modelName = parts.get(1);
            pageModel.innerModels.add(inner);
            return inner;
        }
        if (first.equals("@EndComponent") || first.equals("@EndSection")) {
            return pageModel.parentPage;
        }
        return this.parseElementLine(parts, pageModel);
    }

    private PageModelConfig parseElementLine(List<String> parts, PageModelConfig pageModel) {
        ElementConfig elem = new ElementConfig();
        int i = 0;
        if (parts.get(i).equals("*")) {
            elem.displayed = true;
            elem.displayTest = ".isDisplayed()";
        }
        int n = ++i;
        elem.name = parts.get(n);
        elem.testerType = parts.get(++i).startsWith("@") ? parts.get(i++) : ElementType.getTesterType(elem.name);
        elem.byType = parts.get(i++);
        if (pageModel.modelType.equals("ComponentModel") || pageModel.modelType.equals("SectionModel")) {
            elem.findMethod = "findComponentElement";
            if (elem.byType.startsWith("^")) {
                elem.byType = elem.byType.substring(1);
                elem.findMethod = "findPageElement";
            }
        } else {
            elem.findMethod = "findPageElement";
        }
        elem.byLocator = parts.get(i++);
        while (i < parts.size()) {
            if (parts.get(i).startsWith("*")) {
                elem.displayTest = parts.get(i++).substring(1);
                continue;
            }
            if (parts.get(i).startsWith("_")) {
                elem.clickModifier = parts.get(i++).substring(1);
                continue;
            }
            if (elem.returnType != null) {
                log.warn("Warning: Unknown element parameter [" + parts.get(i++) + "] in line [" + String.join((CharSequence)" ", parts) + "]");
                continue;
            }
            elem.returnType = parts.get(i++);
        }
        elem.clickNav = elem.returnType != null;
        pageModel.elements.add(elem);
        return pageModel;
    }

    private List<String> parseArgString(String line) {
        ArrayList<String> parts = new ArrayList<String>();
        line = line.trim();
        StringBuilder part = new StringBuilder();
        boolean inQuote = false;
        boolean partialQutoe = false;
        Character quoteStart = null;
        char[] cArray = line.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character c = Character.valueOf(cArray[i]);
            if (inQuote) {
                if (c == quoteStart) {
                    inQuote = false;
                    quoteStart = null;
                    if (partialQutoe) {
                        part.append(c);
                        partialQutoe = false;
                        continue;
                    }
                    parts.add(part.toString());
                    part = new StringBuilder();
                    continue;
                }
                part.append(c);
                continue;
            }
            if (c.equals(Character.valueOf('\"')) || c.equals(Character.valueOf('\''))) {
                quoteStart = c;
                inQuote = true;
                if (part.toString().isEmpty()) {
                    partialQutoe = false;
                    continue;
                }
                part.append(c);
                partialQutoe = true;
                continue;
            }
            if (c.equals(Character.valueOf(' ')) || c.equals(Character.valueOf('\t'))) {
                if (part.toString().trim().isEmpty()) continue;
                parts.add(part.toString());
                part = new StringBuilder();
                continue;
            }
            part.append(c);
        }
        if (!part.toString().isEmpty()) {
            parts.add(part.toString());
        }
        return parts;
    }
}

