/*
 * Decompiled with CFR 0.152.
 */
package org.pagemodel.junit4;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.recovery.ResilientFileOutputStream;
import java.io.File;
import java.util.Date;
import java.util.Iterator;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.pagemodel.core.testers.TestEvaluator;
import org.pagemodel.core.utils.TestRuntimeException;
import org.pagemodel.core.utils.Unique;
import org.pagemodel.core.utils.json.StacktraceFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingTestRule
implements MethodRule {
    private static final Logger log = LoggerFactory.getLogger((String)LoggingTestRule.class.getName());
    private static SynchronizedCounter testQueueCount = new SynchronizedCounter();
    private static SynchronizedCounter testStartCount = new SynchronizedCounter();
    private static SynchronizedCounter testEndCount = new SynchronizedCounter();
    private static SynchronizedCounter testFailCount = new SynchronizedCounter();
    private static SynchronizedCounter testPassCount = new SynchronizedCounter();
    private static Date firstStart = new Date();
    private static boolean loggedReportPath = false;
    private static String reportPath = null;
    private TestEvaluator evalLogger = new TestEvaluator.Now();
    private FrameworkMethod method;

    public LoggingTestRule() {
        LoggingTestRule.startLoggers();
    }

    private static void startLoggers() {
        if (loggedReportPath) {
            return;
        }
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        for (ch.qos.logback.classic.Logger logger : context.getLoggerList()) {
            Iterator index = logger.iteratorForAppenders();
            while (index.hasNext()) {
                Appender appender = (Appender)index.next();
                if (!appender.getName().equals("HTML") || !(appender instanceof FileAppender)) continue;
                FileAppender fa = (FileAppender)appender;
                ResilientFileOutputStream rfos = (ResilientFileOutputStream)fa.getOutputStream();
                File file = rfos.getFile();
                log.info("Html Test Report: file://" + file.getAbsolutePath());
                reportPath = file.getAbsolutePath();
                loggedReportPath = true;
                return;
            }
        }
    }

    public Statement apply(final Statement base, final FrameworkMethod method, Object target) {
        this.method = method;
        testQueueCount.increment();
        StacktraceFilter.highlights.addMethodHighlight(method.getMethod());
        return new Statement(){

            public void evaluate() throws Throwable {
                int count = testStartCount.increment();
                if (count == 1) {
                    firstStart = new Date();
                }
                String testId = Unique.shortString();
                Date start = new Date();
                LoggingTestRule.this.evalLogger.logEvent("Test", "start", op -> op.addValue("class", (Object)method.getDeclaringClass().getName()).addValue("method", (Object)method.getName()).addValue("count", (Object)count).addValue("total", (Object)testQueueCount.getCount()).addValue("start", (Object)start).addValue("testId", (Object)testId));
                try {
                    base.evaluate();
                }
                catch (Throwable t) {
                    LoggingTestRule.this.logTestEnd(start, "fail", testId, count);
                    if (!(t instanceof TestRuntimeException)) {
                        LoggingTestRule.this.evalLogger.logException(t);
                    }
                    throw t;
                }
                LoggingTestRule.this.logTestEnd(start, "pass", testId, count);
            }
        };
    }

    private void logTestEnd(Date start, String status, String testId, int count) {
        Date end = new Date();
        long durationMsec = end.getTime() - start.getTime();
        int endCount = testEndCount.increment();
        if (status.equals("pass")) {
            testPassCount.increment();
        } else if (status.equals("fail")) {
            testFailCount.increment();
            log.info("Html Test Report: file://" + reportPath);
        }
        this.evalLogger.logEvent("Test", "end", op -> op.addValue("class", (Object)this.method.getDeclaringClass().getName()).addValue("method", (Object)this.method.getName()).addValue("testId", (Object)testId).addValue("count", (Object)endCount).addValue("total", (Object)testQueueCount.getCount()).addValue("duration", (Object)durationMsec).addValue("end", (Object)end));
        this.evalLogger.logEvent("Test", status, op -> op.addValue("class", (Object)this.method.getDeclaringClass().getName()).addValue("method", (Object)this.method.getName()).addValue("testId", (Object)testId).addValue("duration", (Object)durationMsec).addValue("start", (Object)start).addValue("end", (Object)end));
        long totalTimeMsec = end.getTime() - firstStart.getTime();
        this.evalLogger.logEvent("Test", "summary", op -> op.addValue("pass", (Object)testPassCount.getCount()).addValue("fail", (Object)testFailCount.getCount()).addValue("total", (Object)testQueueCount.getCount()).addValue("duration", (Object)totalTimeMsec).addValue("start", (Object)firstStart).addValue("end", (Object)end));
    }

    public String getDeclaringClass() {
        return this.method.getDeclaringClass().getName();
    }

    public String getMethod() {
        return this.method.getName();
    }

    static class SynchronizedCounter {
        private int count = 0;

        SynchronizedCounter() {
        }

        synchronized int getCount() {
            return this.count;
        }

        synchronized int increment() {
            return ++this.count;
        }
    }
}

