/*
 * Decompiled with CFR 0.152.
 */
package org.pagemodel.mail;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Objects;

public class Attachment {
    protected String filename;
    protected String contentType;
    protected byte[] byteContent;

    public Attachment(String filename, byte[] byteContent, String contentType) {
        this.filename = filename;
        this.contentType = contentType;
        this.byteContent = byteContent;
    }

    public Attachment(String filename, File contents, String contentType) {
        this(filename, Attachment.fileBytes(contents), contentType);
    }

    public Attachment(File contents, String contentType) {
        this(contents.getName(), Attachment.fileBytes(contents), contentType);
    }

    private static byte[] fileBytes(File file) {
        try {
            return Files.readAllBytes(file.toPath());
        }
        catch (Exception ex) {
            throw new RuntimeException("Error: file byte copy failed for file [" + file.getAbsolutePath() + "]", ex);
        }
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public byte[] getByteContent() {
        return this.byteContent;
    }

    public void setByteContent(byte[] byteContent) {
        this.byteContent = byteContent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Attachment)) {
            return false;
        }
        Attachment that = (Attachment)o;
        return this.filename.equals(that.filename) && this.contentType.equals(that.contentType) && Arrays.equals(this.byteContent, that.byteContent);
    }

    public int hashCode() {
        int result = Objects.hash(this.filename, this.contentType);
        result = 31 * result + Arrays.hashCode(this.byteContent);
        return result;
    }

    public static class TextAttachment
    extends Attachment {
        private Charset charset;

        public TextAttachment(String filename, String contents) {
            this(filename, contents, "text/plain");
        }

        public TextAttachment(String filename, String contents, String contentType) {
            super(filename, contents.getBytes(), contentType);
            this.charset = null;
        }

        public TextAttachment(String filename, String contents, Charset charset) {
            this(filename, contents, charset, "text/plain");
        }

        public TextAttachment(String filename, String contents, Charset charset, String contentType) {
            super(filename, contents.getBytes(charset), contentType);
            this.charset = charset;
        }

        public String getTextContent() {
            if (this.charset != null) {
                return new String(this.byteContent, this.charset);
            }
            return new String(this.byteContent);
        }

        public void setTextContent(String textContent) {
            this.charset = null;
            this.setByteContent(textContent.getBytes());
        }

        public void setTextContent(String textContent, Charset charset) {
            this.charset = charset;
            this.setByteContent(textContent.getBytes(charset));
        }
    }
}

