/*
 * Decompiled with CFR 0.152.
 */
package org.pagemodel.mail;

import java.util.Map;
import java.util.concurrent.Callable;
import org.pagemodel.core.TestContext;
import org.pagemodel.core.testers.StringTester;
import org.pagemodel.core.testers.TestEvaluator;
import org.pagemodel.core.utils.ThrowingFunction;
import org.pagemodel.core.utils.json.JsonBuilder;
import org.pagemodel.mail.Attachment;

public class AttachmentTester<R> {
    protected R returnObj;
    protected final Callable<Attachment> ref;
    protected final TestContext testContext;
    private TestEvaluator testEvaluator;

    public AttachmentTester(Callable<Attachment> ref, R returnObj, TestContext testContext, TestEvaluator testEvaluator) {
        this.ref = ref;
        this.returnObj = returnObj;
        this.testContext = testContext;
        this.testEvaluator = testEvaluator;
    }

    protected Attachment callRef() {
        try {
            return this.ref.call();
        }
        catch (Throwable t) {
            return null;
        }
    }

    protected TestEvaluator getEvaluator() {
        return this.testEvaluator;
    }

    public R exists() {
        return (R)this.getEvaluator().testCondition("exists", op -> op.addValue("attachment", this.getAttachmentJson()), () -> this.callRef() != null, this.returnObj, this.testContext);
    }

    public R notExists() {
        return (R)this.getEvaluator().testCondition("not exists", op -> op.addValue("attachment", this.getAttachmentJson()), () -> this.callRef() == null, this.returnObj, this.testContext);
    }

    public StringTester<R> filename() {
        this.getEvaluator().setSourceFindEvent("filename", op -> op.addValue("attachment", this.getAttachmentJson()));
        return new StringTester(() -> this.callRef().getFilename(), this.returnObj, this.testContext, this.getEvaluator());
    }

    public StringTester<R> contentType() {
        this.getEvaluator().setSourceFindEvent("content type", op -> op.addValue("attachment", this.getAttachmentJson()));
        return new StringTester(() -> this.callRef().getContentType(), this.returnObj, this.testContext, this.getEvaluator());
    }

    public StringTester<R> textContent() {
        this.getEvaluator().setSourceFindEvent("text content", op -> op.addValue("attachment", this.getAttachmentJson()));
        return new StringTester(() -> new String(this.callRef().getByteContent()), this.returnObj, this.testContext, this.getEvaluator());
    }

    public R byteContent(ThrowingFunction<byte[], Boolean, ?> byteTest) {
        return (R)this.getEvaluator().testCondition("byte content", op -> op.addValue("attachment", this.getAttachmentJson()), () -> (Boolean)ThrowingFunction.unchecked((ThrowingFunction)byteTest).apply(this.callRef().getByteContent()), this.returnObj, this.testContext);
    }

    protected Map<String, Object> getAttachmentJson() {
        Attachment attachment = this.callRef();
        if (attachment == null) {
            return null;
        }
        return JsonBuilder.object().addValue("filename", (Object)attachment.getFilename()).toMap();
    }
}

