/*
 * Decompiled with CFR 0.152.
 */
package org.pagemodel.mail;

import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.pagemodel.mail.Attachment;
import org.pagemodel.mail.MailMessage;
import org.pagemodel.mail.MimeMailAdapter;

public class LazyMailMessage
extends MailMessage {
    private boolean recipientsLoaded = false;
    private boolean bodyLoaded = false;
    private boolean attachmentsLoaded = false;
    private boolean headersLoaded = false;

    public LazyMailMessage(Message message) {
        try {
            MimeMessage messageCopy = new MimeMessage((MimeMessage)message);
            this.setMessage((Message)messageCopy);
        }
        catch (MessagingException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public String getSender() {
        this.loadSender();
        return super.getSender();
    }

    @Override
    public List<String> getRecipientsTo() {
        this.loadRecipients();
        return super.getRecipientsTo();
    }

    @Override
    public List<String> getRecipientsCc() {
        this.loadRecipients();
        return super.getRecipientsCc();
    }

    @Override
    public List<String> getRecipientsBcc() {
        this.loadRecipients();
        return super.getRecipientsBcc();
    }

    @Override
    public String getSubject() {
        this.loadSubject();
        return super.getSubject();
    }

    @Override
    public Date getSentDate() {
        this.loadSentDate();
        return super.getSentDate();
    }

    @Override
    public String getTextBody() {
        this.loadBody();
        return super.getTextBody();
    }

    @Override
    public String getHtmlBody() {
        this.loadBody();
        return super.getHtmlBody();
    }

    @Override
    public String getHeader(String name) {
        this.loadHeaders();
        return super.getHeader(name);
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        this.loadHeaders();
        return super.getHeaders();
    }

    @Override
    public List<Attachment> getAttachments() {
        this.loadAttachments();
        return super.getAttachments();
    }

    public void loadAll() {
        this.loadSender();
        this.loadRecipients();
        this.loadSubject();
        this.loadSentDate();
        this.loadBody();
        this.loadHeaders();
        this.loadAttachments();
    }

    public void loadSender() {
        if (this.sender == null) {
            try {
                Address[] from = this.message.getFrom();
                if (from == null) {
                    this.setSender(null);
                } else {
                    this.setSender(String.join((CharSequence)",", (CharSequence[])Arrays.stream(this.message.getFrom()).map(this::getEmail).toArray(String[]::new)));
                }
            }
            catch (MessagingException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private String getEmail(Address address) {
        if (address instanceof InternetAddress) {
            return ((InternetAddress)address).getAddress();
        }
        return address.toString();
    }

    public void loadRecipients() {
        if (this.recipientsLoaded) {
            return;
        }
        try {
            for (Address address : MimeMailAdapter.getRecipients(this.message, Message.RecipientType.TO)) {
                this.addRecipientsTo(this.getEmail(address));
            }
            for (Address address : MimeMailAdapter.getRecipients(this.message, Message.RecipientType.CC)) {
                this.addRecipientsCc(this.getEmail(address));
            }
            for (Address address : MimeMailAdapter.getRecipients(this.message, Message.RecipientType.BCC)) {
                this.addRecipientsBcc(this.getEmail(address));
            }
        }
        catch (MessagingException ex) {
            throw new RuntimeException(ex);
        }
        this.recipientsLoaded = true;
    }

    public void loadSubject() {
        if (this.subject == null) {
            try {
                this.setSubject(this.message.getSubject());
            }
            catch (MessagingException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public void loadSentDate() {
        if (this.sentDate == null) {
            try {
                this.setSentDate(this.message.getSentDate());
            }
            catch (MessagingException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public void loadBody() {
        if (!this.bodyLoaded) {
            try {
                MimeMailAdapter.readBody(this.message.getContent(), this);
            }
            catch (IOException | MessagingException ex) {
                throw new RuntimeException(ex);
            }
            this.bodyLoaded = true;
        }
    }

    public void loadHeaders() {
        if (!this.headersLoaded) {
            try {
                MimeMailAdapter.readHeaders(this.message, this);
            }
            catch (MessagingException ex) {
                throw new RuntimeException(ex);
            }
            this.headersLoaded = true;
        }
    }

    public void loadAttachments() {
        if (!this.attachmentsLoaded) {
            try {
                MimeMailAdapter.readAttachments((Part)this.message, this);
            }
            catch (IOException | MessagingException ex) {
                throw new RuntimeException(ex);
            }
            this.attachmentsLoaded = true;
        }
    }
}

