/*
 * Decompiled with CFR 0.152.
 */
package org.pagemodel.mail;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.mail.Message;
import org.pagemodel.core.utils.json.JsonBuilder;
import org.pagemodel.mail.Attachment;

public class MailMessage {
    protected String sender;
    protected List<String> recipientsTo = new ArrayList<String>();
    protected List<String> recipientsCc = new ArrayList<String>();
    protected List<String> recipientsBcc = new ArrayList<String>();
    protected String subject;
    protected String textBody;
    protected String htmlBody;
    protected Map<String, List<String>> headers = new HashMap<String, List<String>>();
    protected Date sentDate;
    protected List<Attachment> attachments = new ArrayList<Attachment>();
    protected Message message;

    public String getSender() {
        return this.sender;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    protected List<String> getRecipientsAll() {
        ArrayList<String> all = new ArrayList<String>(this.recipientsTo);
        all.addAll(this.recipientsCc);
        all.addAll(this.recipientsBcc);
        return all;
    }

    public List<String> getRecipientsTo() {
        return this.recipientsTo;
    }

    public void addRecipientsTo(String ... recipients) {
        for (String recipient : recipients) {
            if (this.recipientsTo.contains(recipient)) continue;
            this.recipientsTo.add(recipient);
        }
    }

    public List<String> getRecipientsCc() {
        return this.recipientsCc;
    }

    public void addRecipientsCc(String ... recipients) {
        for (String recipient : recipients) {
            if (this.recipientsCc.contains(recipient)) continue;
            this.recipientsCc.add(recipient);
        }
    }

    public List<String> getRecipientsBcc() {
        return this.recipientsBcc;
    }

    public void addRecipientsBcc(String ... recipients) {
        for (String recipient : recipients) {
            if (this.recipientsBcc.contains(recipient)) continue;
            this.recipientsBcc.add(recipient);
        }
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public Date getSentDate() {
        return this.sentDate;
    }

    public void setSentDate(Date sentDate) {
        this.sentDate = sentDate;
    }

    public String getTextBody() {
        return this.textBody;
    }

    public void setTextBody(String messageBody) {
        this.textBody = messageBody;
    }

    public String getHtmlBody() {
        return this.htmlBody;
    }

    public void setHtmlBody(String htmlBody) {
        this.htmlBody = htmlBody;
    }

    public void setBody(String messageBody) {
        this.textBody = messageBody;
        this.htmlBody = messageBody;
    }

    public void setHeader(String name, String value) {
        if (!this.headers.containsKey(name = name.toLowerCase())) {
            this.headers.put(name, new LinkedList());
        }
        this.headers.get(name).add(value);
    }

    public String getHeader(String name) {
        return this.headers.get(name.toLowerCase()).get(0);
    }

    public List<String> getHeaderList(String name) {
        return this.headers.get(name.toLowerCase());
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public void addAttachment(Attachment attachment) {
        this.attachments.add(attachment);
    }

    public void addAttachment(File contents, String contentType) {
        this.addAttachment(new Attachment(contents, contentType));
    }

    public void addAttachment(String filename, File contents, String contentType) {
        this.addAttachment(new Attachment(filename, contents, contentType));
    }

    public void addAttachment(String filename, String contents, String contentType) {
        this.attachments.add(new Attachment.TextAttachment(filename, contents, contentType));
    }

    public void addAttachment(String filename, byte[] contents, String contentType) {
        this.attachments.add(new Attachment(filename, contents, contentType));
    }

    public Message getMessage() {
        return this.message;
    }

    public void setMessage(Message message) {
        this.message = message;
    }

    public String toString() {
        return "mail(subject:[" + this.subject + "], sender:[" + this.sender + "], recipientsTo:[" + String.join((CharSequence)", ", this.recipientsTo) + "])";
    }

    public Map<String, Object> toJson() {
        return JsonBuilder.object().addValue("subject", (Object)this.subject).addValue("sender", (Object)this.sender).addValue("recipientsTo", (Object)String.join((CharSequence)", ", this.recipientsTo)).toMap();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MailMessage)) {
            return false;
        }
        MailMessage that = (MailMessage)o;
        return this.sender.equals(that.sender) && this.recipientsTo.equals(that.recipientsTo) && this.recipientsCc.equals(that.recipientsCc) && this.recipientsBcc.equals(that.recipientsBcc) && Objects.equals(this.subject, that.subject) && Objects.equals(this.textBody, that.textBody) && Objects.equals(this.htmlBody, that.htmlBody) && this.headers.equals(that.headers) && Objects.equals(this.sentDate, that.sentDate) && this.attachments.equals(that.attachments);
    }

    public int hashCode() {
        return Objects.hash(this.sender, this.recipientsTo, this.recipientsCc, this.recipientsBcc, this.subject, this.textBody, this.htmlBody, this.headers, this.sentDate, this.attachments);
    }
}

