/*
 * Decompiled with CFR 0.152.
 */
package org.pagemodel.mail;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import javax.mail.Message;
import javax.mail.internet.MimeMessage;
import org.pagemodel.core.TestContext;
import org.pagemodel.core.testers.TestEvaluator;
import org.pagemodel.core.utils.Unique;
import org.pagemodel.mail.LazyMailMessage;
import org.pagemodel.mail.MailMessage;
import org.pagemodel.mail.MailTester;
import org.pagemodel.mail.MimeMailAdapter;
import org.pagemodel.mail.SmtpServer;

public class MailMessageBuilder<R> {
    protected MailMessage mailMessage = new MailMessage();
    protected TestContext testContext;
    protected R returnObj;
    private TestEvaluator testEvaluator;

    public MailMessageBuilder(R returnObj, TestContext testContext, TestEvaluator testEvaluator) {
        this.testContext = testContext;
        this.returnObj = returnObj;
        this.testEvaluator = testEvaluator;
        this.mailMessage.setSubject(Unique.string((String)"MailMessage subject"));
        this.mailMessage.setBody(Unique.string((String)"MailMessage body"));
    }

    protected TestEvaluator getEvaluator() {
        return this.testEvaluator;
    }

    public MailMessage getMailMessage() {
        return this.mailMessage;
    }

    public MailTester.SentMailTester<R> send(SmtpServer smtpServer) {
        MailMessage[] refMail = new MailMessage[1];
        return (MailTester.SentMailTester)this.getEvaluator().testRun("Execute", "send mail", op -> op.addValue("mail", this.getMailMessage().toJson()), () -> {
            refMail[0] = smtpServer.send(this.getMailMessage());
        }, new MailTester.SentMailTester<R>(() -> refMail[0], this.returnObj, this.testContext, this.getEvaluator()), this.testContext);
    }

    public R store(String key) {
        this.testContext.store(key, (Object)this.getMailMessage());
        return this.returnObj;
    }

    public MailTester.SentMailTester<R> sendAndStore(String key, SmtpServer smtpServer) {
        this.store(key);
        return this.send(smtpServer);
    }

    public MailMessageBuilder<R> from(String address) {
        return (MailMessageBuilder)this.getEvaluator().testRun("Build", "set from", op -> op.addValue("value", (Object)address), () -> this.mailMessage.setSender(address), (Object)this, this.testContext);
    }

    public MailMessageBuilder<R> to(String ... addresses) {
        return (MailMessageBuilder)this.getEvaluator().testRun("Build", "set to", op -> op.addValue("value", (Object)Arrays.toString(addresses)), () -> this.mailMessage.addRecipientsTo(addresses), (Object)this, this.testContext);
    }

    public MailMessageBuilder<R> cc(String ... addresses) {
        return (MailMessageBuilder)this.getEvaluator().testRun("Build", "set cc", op -> op.addValue("value", (Object)Arrays.toString(addresses)), () -> this.mailMessage.addRecipientsCc(addresses), (Object)this, this.testContext);
    }

    public MailMessageBuilder<R> bcc(String ... addresses) {
        return (MailMessageBuilder)this.getEvaluator().testRun("Build", "set bcc", op -> op.addValue("value", (Object)Arrays.toString(addresses)), () -> this.mailMessage.addRecipientsBcc(addresses), (Object)this, this.testContext);
    }

    public MailMessageBuilder<R> clearRecipients() {
        return (MailMessageBuilder)this.getEvaluator().testRun("Build", "clear recipients", op -> op.addValue("actual", this.getMailMessage().getRecipientsAll()), () -> {
            this.mailMessage.recipientsTo.clear();
            this.mailMessage.recipientsCc.clear();
            this.mailMessage.recipientsBcc.clear();
        }, (Object)this, this.testContext);
    }

    public MailMessageBuilder<R> tagSubject() {
        return this.subject(this.mailMessage.getSubject());
    }

    public MailMessageBuilder<R> subjectUntagged(String subject) {
        return (MailMessageBuilder)this.getEvaluator().testRun("Build", "set subject", op -> op.addValue("value", (Object)subject), () -> this.mailMessage.setSubject(subject), (Object)this, this.testContext);
    }

    public MailMessageBuilder<R> subject(String subject) {
        return this.subjectUntagged(Unique.string((String)subject));
    }

    public MailMessageBuilder<R> bodyUntagged(String content) {
        return (MailMessageBuilder)this.getEvaluator().testRun("Build", "set body", op -> op.addValue("value", (Object)content), () -> this.mailMessage.setBody(content), (Object)this, this.testContext);
    }

    public MailMessageBuilder<R> body(String content) {
        return this.bodyUntagged(Unique.string((String)content));
    }

    public MailMessageBuilder<R> htmlBodyUntagged(String content) {
        return (MailMessageBuilder)this.getEvaluator().testRun("Build", "set html body", op -> op.addValue("value", (Object)content), () -> this.mailMessage.setHtmlBody(content), (Object)this, this.testContext);
    }

    public MailMessageBuilder<R> htmlBody(String content) {
        return this.htmlBodyUntagged(Unique.string((String)content));
    }

    public MailMessageBuilder<R> textBodyUntagged(String content) {
        return (MailMessageBuilder)this.getEvaluator().testRun("Build", "set text body", op -> op.addValue("value", (Object)content), () -> this.mailMessage.setTextBody(content), (Object)this, this.testContext);
    }

    public MailMessageBuilder<R> textBody(String content) {
        return this.textBodyUntagged(Unique.string((String)content));
    }

    public MailMessageBuilder<R> header(String headerName, String value) {
        return (MailMessageBuilder)this.getEvaluator().testRun("Build", "set header", op -> op.addValue("name", (Object)headerName).addValue("value", (Object)value), () -> this.mailMessage.setHeader(headerName, value), (Object)this, this.testContext);
    }

    public MailMessageBuilder<R> readMime(File file) {
        String path = file == null ? null : file.getAbsolutePath();
        return (MailMessageBuilder)this.getEvaluator().testRun("Load", "read MIME", op -> op.addValue("value", (Object)path), () -> {
            try {
                MimeMessage mime = new MimeMessage(null, (InputStream)new FileInputStream(file));
                LazyMailMessage mail = new LazyMailMessage((Message)mime);
                mail.loadAll();
                this.mailMessage = mail;
            }
            catch (Exception ex) {
                throw this.testContext.createException("Unable to read MIME from file:[" + path + "]");
            }
        }, (Object)this, this.testContext);
    }

    public MailMessageBuilder<R> writeMime(File file) {
        String path = file == null ? null : file.getAbsolutePath();
        return (MailMessageBuilder)this.getEvaluator().testRun("Store", "write MIME", op -> op.addValue("value", (Object)path), () -> {
            try {
                MimeMessage mime = MimeMailAdapter.createMimeMessage(this.mailMessage, null);
                mime.writeTo((OutputStream)new FileOutputStream(file));
            }
            catch (Exception ex) {
                throw this.testContext.createException("Unable to write MIME to file:[" + path + "]");
            }
        }, (Object)this, this.testContext);
    }

    public MailMessageBuilder<R> withAttachment(File contents, String contentType) {
        return (MailMessageBuilder)this.getEvaluator().testRun("Build", "add attachment", op -> op.addValue("contentType", (Object)contentType).addValue("value", (Object)contents.getAbsolutePath()), () -> this.mailMessage.addAttachment(contents, contentType), (Object)this, this.testContext);
    }

    public MailMessageBuilder<R> withAttachment(String filename, String contents, String contentType) {
        return (MailMessageBuilder)this.getEvaluator().testRun("Build", "add attachment", op -> op.addValue("value", (Object)contents).addValue("filename", (Object)filename).addValue("contentType", (Object)contentType), () -> this.mailMessage.addAttachment(filename, contents, contentType), (Object)this, this.testContext);
    }

    public MailMessageBuilder<R> withAttachment(String filename, File contents, String contentType) {
        return (MailMessageBuilder)this.getEvaluator().testRun("Build", "add attachment", op -> op.addValue("value", (Object)contents.getAbsolutePath()).addValue("filename", (Object)filename).addValue("contentType", (Object)contentType), () -> this.mailMessage.addAttachment(filename, contents, contentType), (Object)this, this.testContext);
    }

    public MailMessageBuilder<R> withAttachment(String filename, byte[] contents, String contentType) {
        return (MailMessageBuilder)this.getEvaluator().testRun("Build", "add attachment", op -> op.addValue("value", (Object)("contentSize: " + contents.length)).addValue("filename", (Object)filename).addValue("contentType", (Object)contentType), () -> this.mailMessage.addAttachment(filename, contents, contentType), (Object)this, this.testContext);
    }

    public MailMessageBuilder<R> withAttachment() {
        String ts = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").format(new Date());
        return this.withAttachment("file-" + Unique.shortString() + ".txt", "Body: " + ts + ", msg-" + Unique.shortString());
    }

    public MailMessageBuilder<R> withAttachment(String filename, String contents) {
        return this.withAttachment(filename, contents, "text/plain");
    }
}

