/*
 * Decompiled with CFR 0.152.
 */
package org.pagemodel.mail;

import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.Callable;
import org.pagemodel.core.TestContext;
import org.pagemodel.core.testers.ComparableTester;
import org.pagemodel.core.testers.StringListTester;
import org.pagemodel.core.testers.StringTester;
import org.pagemodel.core.testers.TestEvaluator;
import org.pagemodel.core.utils.ThrowingConsumer;
import org.pagemodel.mail.Attachment;
import org.pagemodel.mail.AttachmentTester;
import org.pagemodel.mail.MailMessage;

public class MailMessageTester<R> {
    protected R returnObj;
    protected final Callable<MailMessage> ref;
    protected final TestContext testContext;
    private TestEvaluator testEvaluator;

    public MailMessageTester(Callable<MailMessage> ref, R returnObj, TestContext testContext, TestEvaluator testEvaluator) {
        this.ref = ref;
        this.returnObj = returnObj;
        this.testContext = testContext;
        this.testEvaluator = testEvaluator;
    }

    protected MailMessage callRef() {
        try {
            return this.ref.call();
        }
        catch (Throwable t) {
            return null;
        }
    }

    protected TestEvaluator getEvaluator() {
        return this.testEvaluator;
    }

    public R closeMail() {
        return this.returnObj;
    }

    public StringTester<MailMessageTester<R>> testSender() {
        this.getEvaluator().setSourceFindEvent("sender", op -> op.addValue("mail", this.getMessageJson()));
        return new StringTester(() -> this.callRef().getSender(), (Object)this, this.testContext, this.getEvaluator());
    }

    public StringListTester<MailMessageTester<R>> testRecipientsTo() {
        this.getEvaluator().setSourceFindEvent("recipients To", op -> op.addValue("mail", this.getMessageJson()));
        return new StringListTester(() -> this.callRef().getRecipientsTo(), (Object)this, this.testContext, this.getEvaluator());
    }

    public StringListTester<MailMessageTester<R>> testRecipientsCc() {
        this.getEvaluator().setSourceFindEvent("recipients CC", op -> op.addValue("mail", this.getMessageJson()));
        return new StringListTester(() -> this.callRef().getRecipientsCc(), (Object)this, this.testContext, this.getEvaluator());
    }

    public StringListTester<MailMessageTester<R>> testRecipientsBcc() {
        this.getEvaluator().setSourceFindEvent("recipients BCC", op -> op.addValue("mail", this.getMessageJson()));
        return new StringListTester(() -> this.callRef().getRecipientsBcc(), (Object)this, this.testContext, this.getEvaluator());
    }

    public StringListTester<MailMessageTester<R>> testRecipientsAll() {
        this.getEvaluator().setSourceFindEvent("all recipients", op -> op.addValue("mail", this.getMessageJson()));
        return new StringListTester(() -> {
            ArrayList<String> recipients = new ArrayList<String>(this.callRef().getRecipientsTo());
            recipients.addAll(this.callRef().getRecipientsCc());
            recipients.addAll(this.callRef().getRecipientsBcc());
            return recipients;
        }, (Object)this, this.testContext, this.getEvaluator());
    }

    public StringTester<MailMessageTester<R>> testSubject() {
        this.getEvaluator().setSourceFindEvent("subject", op -> op.addValue("mail", this.getMessageJson()));
        return new StringTester(() -> this.callRef().getSubject(), (Object)this, this.testContext, this.getEvaluator());
    }

    public StringTester<MailMessageTester<R>> testTextBody() {
        this.getEvaluator().setSourceFindEvent("text body", op -> op.addValue("mail", this.getMessageJson()));
        return new StringTester(() -> this.callRef().getTextBody(), (Object)this, this.testContext, this.getEvaluator());
    }

    public StringTester<MailMessageTester<R>> testHtmlBody() {
        this.getEvaluator().setSourceFindEvent("html body", op -> op.addValue("mail", this.getMessageJson()));
        return new StringTester(() -> this.callRef().getHtmlBody(), (Object)this, this.testContext, this.getEvaluator());
    }

    public StringTester<MailMessageTester<R>> testHeader(String header) {
        this.getEvaluator().setSourceFindEvent("header", op -> op.addValue("value", (Object)header).addValue("mail", this.getMessageJson()));
        return new StringTester(() -> this.callRef().getHeader(header), (Object)this, this.testContext, this.getEvaluator());
    }

    public StringListTester<MailMessageTester<R>> testHeaderList(String header) {
        this.getEvaluator().setSourceFindEvent("header", op -> op.addValue("value", (Object)header).addValue("mail", this.getMessageJson()));
        return new StringListTester(() -> this.callRef().getHeaderList(header), (Object)this, this.testContext, this.getEvaluator());
    }

    public ComparableTester<Date, MailMessageTester<R>> testSentDate() {
        this.getEvaluator().setSourceFindEvent("sent date", op -> op.addValue("mail", this.getMessageJson()));
        return new ComparableTester(() -> this.callRef().getSentDate(), (Object)this, this.testContext, this.getEvaluator());
    }

    public AttachmentTester<MailMessageTester<R>> testAttachment(String filename) {
        this.getEvaluator().setSourceFindEvent("attachment", op -> op.addValue("value", (Object)filename).addValue("mail", this.getMessageJson()));
        return new AttachmentTester<MailMessageTester<R>>(() -> this.getAttachmentByFilename(filename), this, this.testContext, this.getEvaluator());
    }

    public AttachmentTester<MailMessageTester<R>> testAttachment(int i) {
        this.getEvaluator().setSourceFindEvent("attachment", op -> op.addValue("value", (Object)i).addValue("mail", this.getMessageJson()));
        return new AttachmentTester<MailMessageTester<R>>(() -> this.getAttachmentByIndex(i), this, this.testContext, this.getEvaluator());
    }

    public ComparableTester<Integer, MailMessageTester<R>> testAttachmentCount() {
        this.getEvaluator().setSourceFindEvent("attachment count", op -> op.addValue("mail", this.getMessageJson()));
        return new ComparableTester(() -> this.callRef().getAttachments().size(), (Object)this, this.testContext, this.getEvaluator());
    }

    protected Attachment getAttachmentByFilename(String filename) {
        MailMessage mailMessage = this.callRef();
        if (mailMessage == null) {
            return null;
        }
        for (Attachment attachment : mailMessage.getAttachments()) {
            if (!attachment.getFilename().equals(filename)) continue;
            return attachment;
        }
        return null;
    }

    public MailMessageTester<R> doAction(ThrowingConsumer<MailMessageTester<R>, ?> action) {
        ThrowingConsumer.unchecked(action).accept(this);
        return this;
    }

    public MailMessage getMailMessage() {
        return this.callRef();
    }

    protected Attachment getAttachmentByIndex(int i) {
        MailMessage mailMessage = this.callRef();
        if (mailMessage == null) {
            return null;
        }
        if (mailMessage.getAttachments().size() <= i) {
            return null;
        }
        return mailMessage.getAttachments().get(i);
    }

    protected String getMessageDisplay() {
        MailMessage message = this.callRef();
        return message == null ? null : message.toString();
    }

    protected Map<String, Object> getMessageJson() {
        MailMessage message = this.callRef();
        return message == null ? null : message.toJson();
    }
}

