/*
 * Decompiled with CFR 0.152.
 */
package org.pagemodel.mail;

import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.pagemodel.core.utils.Unique;
import org.pagemodel.mail.MailAuthenticator;

public class MailServer {
    private String domain;
    private String host;
    private String username;
    private String password;
    private Boolean useTls;
    private Boolean allowInsecure;

    public MailServer(MailAuthenticator mailAuthenticator) {
        this(mailAuthenticator.getDomain(), mailAuthenticator.getHost(), mailAuthenticator.getUsername(), mailAuthenticator.getPassword(), mailAuthenticator.getUseTls(), mailAuthenticator.getAllowInsecure());
    }

    public MailServer(String domain, String host, String username, String password, boolean useTls, boolean allowInsecure) {
        this(domain, host, username, password, useTls);
        this.allowInsecure = allowInsecure;
    }

    public MailServer(String domain, String host, String username, String password, boolean useTls) {
        this.domain = domain;
        this.host = host;
        this.username = username;
        this.password = password;
        this.useTls = useTls;
    }

    public boolean getAllowInsecure() {
        return this.allowInsecure;
    }

    public void setAllowInsecure(boolean allowInsecure) {
        this.allowInsecure = allowInsecure;
    }

    public boolean getUseTls() {
        return this.useTls;
    }

    public void setUseTls(boolean useTls) {
        this.useTls = useTls;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getHost() {
        return this.host;
    }

    protected void setHost(String host) {
        this.host = host;
    }

    public String getUsername() {
        return this.username;
    }

    protected void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    protected void setPassword(String password) {
        this.password = password;
    }

    public String generateRandomEmailAddress() {
        return this.createAddress(Unique.shortString());
    }

    public String createAddress(String localPart) {
        if (this.getDomain() == null) {
            throw new NullPointerException("Null mail domain for " + this.getHost());
        }
        String email = localPart + "@" + this.getDomain();
        try {
            return new InternetAddress(email).toString();
        }
        catch (AddressException e) {
            throw new RuntimeException(e);
        }
    }
}

