/*
 * Decompiled with CFR 0.152.
 */
package org.pagemodel.mail;

import java.util.Arrays;
import java.util.concurrent.Callable;
import org.pagemodel.core.TestContext;
import org.pagemodel.core.testers.TestEvaluator;
import org.pagemodel.core.utils.ThrowingCallable;
import org.pagemodel.core.utils.ThrowingConsumer;
import org.pagemodel.mail.MailMessage;
import org.pagemodel.mail.MailMessageBuilder;
import org.pagemodel.mail.MailMessageTester;
import org.pagemodel.mail.PopServer;

public class MailTester<R> {
    protected TestContext testContext;
    protected R returnObj;
    private TestEvaluator testEvaluator;

    public MailTester(TestContext testContext, R returnObj, TestEvaluator testEvaluator) {
        this.testContext = testContext;
        this.returnObj = returnObj;
        this.testEvaluator = testEvaluator;
    }

    protected TestEvaluator getEvaluator() {
        return this.testEvaluator;
    }

    public MailMessageBuilder<R> composeMail() {
        this.getEvaluator().logEvent("Execute", "compose mail", null);
        return new MailMessageBuilder<R>(this.returnObj, this.testContext, this.getEvaluator());
    }

    public R closeMail() {
        return this.returnObj;
    }

    public MailMessageTester<R> test(MailMessage mailMessage) {
        return new MailMessageTester<R>(() -> mailMessage, this.returnObj, this.testContext, (TestEvaluator)new TestEvaluator.Now());
    }

    public MailMessageTester<R> fetchMail(PopServer popServer, int timeoutSec, ThrowingConsumer<MailMessageTester<?>, ?> mailPredicate) {
        MailMessage mailMessage = popServer.waitForMail(this.testContext, mailPredicate, timeoutSec);
        return new MailMessageTester<R>(() -> mailMessage, this.returnObj, this.testContext, (TestEvaluator)new TestEvaluator.Now());
    }

    public MailMessageTester<R> fetchMail(PopServer popServer, int timeoutSec, String subject, String recipient) {
        return this.fetchMail(popServer, timeoutSec, mail -> {
            MailMessageTester cfr_ignored_0 = (MailMessageTester)((MailMessageTester)mail.testSubject().equals(subject)).testRecipientsAll().contains(recipient);
        });
    }

    public MailMessageTester<R> fetchMail(PopServer popServer, int timeoutSec, String subject) {
        return this.fetchMail(popServer, timeoutSec, mail -> {
            MailMessageTester cfr_ignored_0 = (MailMessageTester)mail.testSubject().equals(subject);
        });
    }

    public R mailNotFound(PopServer popServer, int timeoutSec, ThrowingConsumer<MailMessageTester<?>, ?> mailPredicate) {
        popServer.waitForMailNotFound(this.testContext, mailPredicate, timeoutSec);
        return this.returnObj;
    }

    public R mailNotFound(PopServer popServer, int timeoutSec, String subject, String recipient) {
        return this.mailNotFound(popServer, timeoutSec, mail -> {
            MailMessageTester cfr_ignored_0 = (MailMessageTester)((MailMessageTester)mail.testSubject().equals(subject)).testRecipientsAll().contains(recipient);
        });
    }

    public R mailNotFound(PopServer popServer, int timeoutSec, String subject) {
        return this.mailNotFound(popServer, timeoutSec, mail -> {
            MailMessageTester cfr_ignored_0 = (MailMessageTester)mail.testSubject().equals(subject);
        });
    }

    @FunctionalInterface
    public static interface SentMailFilter {
        public void filter(MailMessage var1, MailMessageTester<?> var2);
    }

    public static class SentMailTester<R>
    extends MailTester<R> {
        private Callable<MailMessage> sentMailRef;

        public SentMailTester(Callable<MailMessage> sentMailRef, R returnObj, TestContext testContext, TestEvaluator testEvaluator) {
            super(testContext, returnObj, testEvaluator);
            this.sentMailRef = sentMailRef;
        }

        public MailMessageTester<R> fetchSent(PopServer popServer, int timeoutSec, SentMailFilter mailPredicate) {
            MailMessage mailMessage = popServer.waitForMail(this.testContext, this.sentMailRef, mailPredicate, timeoutSec);
            return new MailMessageTester<Object>(() -> mailMessage, this.returnObj, this.testContext, (TestEvaluator)new TestEvaluator.Now());
        }

        public MailMessageTester<R> fetchSentBySubject(PopServer popServer, int timeoutSec) {
            return this.fetchSent(popServer, timeoutSec, (sent, filter) -> {
                MailMessageTester cfr_ignored_0 = (MailMessageTester)filter.testSubject().equals(sent.getSubject());
            });
        }

        public MailMessageTester<R> fetchSentBySubjectAndRecipient(PopServer popServer, int timeoutSec, String recipient) {
            return this.fetchSent(popServer, timeoutSec, (sent, filter) -> {
                MailMessageTester cfr_ignored_0 = (MailMessageTester)((MailMessageTester)filter.testSubject().equals(sent.getSubject())).testRecipientsAll().contains(recipient);
            });
        }

        public MailMessage getMailMessage() {
            return (MailMessage)ThrowingCallable.unchecked(this.sentMailRef).call();
        }

        public R store(String key) {
            try {
                this.testContext.store(key, (Object)this.getMailMessage());
                return (R)this.returnObj;
            }
            catch (Exception ex) {
                throw new RuntimeException("Error: unable to store email [" + this.getMailMessage().getSubject() + "], from:[" + this.getMailMessage().getSender() + "], to:" + Arrays.toString(this.getMailMessage().getRecipientsTo().toArray(new String[0])));
            }
        }

        @Override
        public R closeMail() {
            return (R)this.returnObj;
        }
    }
}

