/*
 * Decompiled with CFR 0.152.
 */
package org.pagemodel.mail;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.pagemodel.mail.Attachment;
import org.pagemodel.mail.MailMessage;

public class MimeMailAdapter {
    public static MailMessage readMessage(Message message) throws MessagingException, IOException {
        if (message == null) {
            throw new NullPointerException("Error: MimeMessage is null");
        }
        MailMessage mailMessage = new MailMessage();
        mailMessage.setSender(message.getFrom().toString());
        for (Address address : MimeMailAdapter.getRecipients(message, Message.RecipientType.TO)) {
            mailMessage.addRecipientsTo(address.toString());
        }
        for (Address address : MimeMailAdapter.getRecipients(message, Message.RecipientType.CC)) {
            mailMessage.addRecipientsCc(address.toString());
        }
        for (Address address : MimeMailAdapter.getRecipients(message, Message.RecipientType.BCC)) {
            mailMessage.addRecipientsBcc(address.toString());
        }
        mailMessage.setSubject(message.getSubject());
        MimeMailAdapter.readHeaders(message, mailMessage);
        MimeMailAdapter.readBody(message.getContent(), mailMessage);
        MimeMailAdapter.readAttachments((Part)message, mailMessage);
        mailMessage.setSentDate(message.getSentDate());
        MimeMessage messageCopy = new MimeMessage((MimeMessage)message);
        mailMessage.setMessage((Message)messageCopy);
        return mailMessage;
    }

    protected static void readHeaders(Message message, MailMessage mailMessage) throws MessagingException {
        Enumeration headers = message.getAllHeaders();
        while (headers.hasMoreElements()) {
            Header header = (Header)headers.nextElement();
            if (header == null || header.getName() == null) continue;
            mailMessage.setHeader(header.getName(), header.getValue());
        }
    }

    protected static void readAttachments(Part message, MailMessage mailMessage) throws MessagingException, IOException {
        if (message.getContentType().contains("multipart")) {
            MimeMultipart mp = (MimeMultipart)message.getContent();
            for (int i = 0; i < mp.getCount(); ++i) {
                BodyPart bp = mp.getBodyPart(i);
                String filename = bp.getFileName();
                Object content = bp.getContent();
                String contentType = bp.getContentType();
                if (filename == null || content == null || contentType == null) continue;
                if (bp.getContentType().equals("text/plain")) {
                    mailMessage.addAttachment(new Attachment.TextAttachment(filename, content.toString(), contentType));
                    continue;
                }
                if (bp.getContentType().contains("multipart")) {
                    MimeMailAdapter.readAttachments((Part)bp, mailMessage);
                    continue;
                }
                byte[] bytes = MimeMailAdapter.getStreamBytes(bp.getDataHandler().getInputStream());
                mailMessage.addAttachment(new Attachment(filename, bytes, contentType));
            }
        }
    }

    private static byte[] getStreamBytes(InputStream in) {
        try {
            int nRead;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[16384];
            while ((nRead = in.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            return buffer.toByteArray();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected static Address[] getRecipients(Message message, Message.RecipientType recipientType) throws MessagingException {
        Address[] addresses = message.getRecipients(recipientType);
        if (addresses == null) {
            return new Address[0];
        }
        return addresses;
    }

    protected static void readBody(Object content, MailMessage mailMessage) throws IOException, MessagingException {
        if (content == null) {
            mailMessage.setTextBody("");
            mailMessage.setHtmlBody("");
        } else if (Multipart.class.isAssignableFrom(content.getClass())) {
            Multipart mp = (Multipart)content;
            for (int i = 0; i < mp.getCount(); ++i) {
                MimeMailAdapter.readBody(mp.getBodyPart(i), mailMessage);
            }
        } else if (BodyPart.class.isAssignableFrom(content.getClass())) {
            BodyPart bp = (BodyPart)content;
            if (bp.getContentType().contains("multipart")) {
                MimeMailAdapter.readBody(bp.getContent(), mailMessage);
            } else {
                if (bp.getDisposition() != null && bp.getDisposition().contains("attachment")) {
                    return;
                }
                if (bp.getContentType().toLowerCase().contains("text/plain")) {
                    mailMessage.setTextBody(bp.getContent().toString());
                } else if (bp.getContentType().toLowerCase().contains("text/html")) {
                    mailMessage.setHtmlBody(bp.getContent().toString());
                }
            }
        } else {
            mailMessage.setTextBody(content.toString());
            mailMessage.setHtmlBody(content.toString());
        }
    }

    public static MimeMessage createMimeMessage(MailMessage mailMessage, Session session) throws MessagingException, IOException {
        if (mailMessage == null) {
            throw new NullPointerException("Error: MailMessage is null");
        }
        MimeMessage mime = new MimeMessage(session);
        mime.setFrom((Address)new InternetAddress(mailMessage.getSender()));
        for (String string : mailMessage.getRecipientsTo()) {
            mime.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(string));
        }
        for (String string : mailMessage.getRecipientsCc()) {
            mime.addRecipient(Message.RecipientType.CC, (Address)new InternetAddress(string));
        }
        for (String string : mailMessage.getRecipientsBcc()) {
            mime.addRecipient(Message.RecipientType.BCC, (Address)new InternetAddress(string));
        }
        mime.setSubject(mailMessage.getSubject());
        Set<String> headers = mailMessage.getHeaders().keySet();
        for (String s : headers) {
            for (String val : mailMessage.getHeaderList(s)) {
                mime.addHeader(s, val);
            }
        }
        MimeMultipart mimeMultipart = MimeMailAdapter.buildMultipart(mailMessage);
        mime.setContent((Multipart)mimeMultipart);
        if (mailMessage.getSentDate() != null) {
            mime.setSentDate(mailMessage.getSentDate());
        } else {
            mime.setSentDate(new Date());
        }
        return mime;
    }

    public static void simulateThunderbirdSubjectMime(MimeMessage mime) throws MessagingException {
        Pattern p = Pattern.compile("(=[0-9A-Fa-f][0-9A-Fa-f])");
        for (String s : mime.getHeader("Subject")) {
            Matcher m = p.matcher(s);
            StringBuffer sb = new StringBuffer();
            while (m.find()) {
                m.appendReplacement(sb, m.group(1).toLowerCase());
            }
            m.appendTail(sb);
            mime.setHeader("Subject", sb.toString());
        }
    }

    private static MimeMultipart buildMultipart(MailMessage mailMessage) throws MessagingException, IOException {
        MimeMultipart mp = new MimeMultipart("alternative");
        MimeBodyPart textPart = new MimeBodyPart();
        textPart.setText(MimeMailAdapter.fixBodyPart(mailMessage.getTextBody()), "us-ascii", "plain");
        MimeBodyPart htmlPart = new MimeBodyPart();
        htmlPart.setText(MimeMailAdapter.fixBodyPart(mailMessage.getHtmlBody()), "us-ascii", "html");
        mp.addBodyPart((BodyPart)textPart);
        mp.addBodyPart((BodyPart)htmlPart);
        List<Attachment> atts = mailMessage.getAttachments();
        if (atts == null || atts.size() == 0) {
            return mp;
        }
        MimeMultipart mp2 = new MimeMultipart("mixed");
        MimeBodyPart body = new MimeBodyPart();
        body.setContent((Multipart)mp);
        mp2.addBodyPart((BodyPart)body);
        for (Attachment a : atts) {
            mp2.addBodyPart(MimeMailAdapter.createBodyPart(a));
        }
        return mp2;
    }

    private static BodyPart createBodyPart(Attachment attachment) throws MessagingException {
        MimeBodyPart bodyPart = new MimeBodyPart();
        bodyPart.setFileName(attachment.getFilename());
        if (Attachment.TextAttachment.class.isAssignableFrom(attachment.getClass()) || attachment.getContentType().equals("text/plain")) {
            bodyPart.setContent((Object)((Attachment.TextAttachment)attachment).getTextContent(), attachment.getContentType());
        } else {
            bodyPart.setContent((Object)attachment.getByteContent(), attachment.getContentType());
        }
        return bodyPart;
    }

    private static String fixBodyPart(String textBody) {
        if (textBody.endsWith("\n\n")) {
            return textBody;
        }
        return textBody + "\n";
    }
}

