/*
 * Decompiled with CFR 0.152.
 */
package org.pagemodel.mail;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import org.pagemodel.core.TestContext;
import org.pagemodel.core.testers.TestEvaluator;
import org.pagemodel.core.utils.ThrowingConsumer;
import org.pagemodel.core.utils.json.JsonBuilder;
import org.pagemodel.core.utils.json.JsonObjectBuilder;
import org.pagemodel.mail.LazyMailMessage;
import org.pagemodel.mail.MailAuthenticator;
import org.pagemodel.mail.MailMessage;
import org.pagemodel.mail.MailMessageTester;
import org.pagemodel.mail.MailServer;
import org.pagemodel.mail.MailTester;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PopServer
extends MailServer {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private TestEvaluator evalLog = new TestEvaluator.Now();
    private int popPort = -1;

    public PopServer(MailAuthenticator mailAuthenticator) {
        super(mailAuthenticator);
        this.popPort = mailAuthenticator.getPopPort();
    }

    public PopServer(String domain, String ip, String user, String password) {
        this(domain, ip, user, password, -1, false, false);
    }

    public PopServer(String domain, String ip, String user, String password, int popPort) {
        this(domain, ip, user, password, popPort, false, false);
    }

    public PopServer(String domain, String ip, String user, String password, boolean useTls) {
        this(domain, ip, user, password, -1, useTls, false);
    }

    public PopServer(String domain, String ip, String user, String password, int popPort, boolean useTls, boolean allowInsecure) {
        super(domain, ip, user, password, useTls, allowInsecure);
        this.popPort = popPort;
    }

    public Integer getPopPort() {
        return this.popPort;
    }

    public void setPopPort(Integer popPort) {
        this.popPort = popPort;
    }

    public MailMessage waitForMail(TestContext testContext, ThrowingConsumer<MailMessageTester<?>, ?> mailPredicate, int timeoutSeconds) {
        return this.waitForMail(testContext, mailPredicate, 1, 1, timeoutSeconds).get(0);
    }

    public MailMessage waitForMail(TestContext testContext, Callable<MailMessage> sentMailRef, MailTester.SentMailFilter sentMailFilter, int timeoutSeconds) {
        return this.waitForMail(testContext, mp -> sentMailFilter.filter((MailMessage)sentMailRef.call(), (MailMessageTester<?>)mp), 1, 1, timeoutSeconds).get(0);
    }

    public List<MailMessage> waitForMail(TestContext testContext, Callable<MailMessage> sentMailRef, MailTester.SentMailFilter sentMailFilter, int minMailLimit, int maxMailLimit, int timeoutSeconds) {
        return this.waitForMail(testContext, mp -> sentMailFilter.filter((MailMessage)sentMailRef.call(), (MailMessageTester<?>)mp), minMailLimit, maxMailLimit, timeoutSeconds);
    }

    public List<MailMessage> waitForMail(TestContext testContext, ThrowingConsumer<MailMessageTester<?>, ?> mailPredicate, int minMailLimit, int maxMailLimit, int timeoutSeconds) {
        ArrayList<MailMessage> results = new ArrayList<MailMessage>();
        HashSet<Integer> checkedMessageIds = new HashSet<Integer>();
        long start = System.currentTimeMillis();
        long end = start + (long)(timeoutSeconds * 1000);
        this.evalLog.logEvent("Execute", "fetch mail", op -> op.addValue("timeout", (Object)timeoutSeconds).doAdd(o -> {
            if (minMailLimit != 1) {
                o.addValue("min count", (Object)minMailLimit);
            }
            if (maxMailLimit != 1) {
                o.addValue("max count", (Object)maxMailLimit);
            }
        }), this.logMailPredicate(testContext, mailPredicate));
        int batchSize = Math.min(Math.max(20, maxMailLimit * 4), 80);
        while (results.size() < minMailLimit && System.currentTimeMillis() < end) {
            try {
                List<MailMessage> found = this.getAllMail(testContext, mailPredicate, maxMailLimit - results.size(), batchSize, checkedMessageIds);
                for (MailMessage mailMessage : found) {
                    if (results.contains(mailMessage)) continue;
                    results.add(mailMessage);
                }
                if (results.size() >= minMailLimit) {
                    return results.subList(0, Math.min(results.size(), maxMailLimit));
                }
            }
            catch (Exception ex) {
                log.info("Error: exception caught while fetching mail.", (Throwable)ex);
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Error: Mail fetch interrupted.", ex);
            }
            long elapsed = (System.currentTimeMillis() - start) / 1000L;
            log.info("Waiting for mail with timeout: [" + timeoutSeconds + "], elapsed: [" + elapsed + "]");
        }
        throw testContext.createException(JsonBuilder.object().doAdd(this.evalLog.getEventJson("Execute", "fetch mail", op -> op.addValue("timeout", (Object)timeoutSeconds).doAdd(o -> {
            if (minMailLimit != 1) {
                o.addValue("min count", (Object)minMailLimit);
            }
            if (maxMailLimit != 1) {
                o.addValue("max count", (Object)maxMailLimit);
            }
        }).addValue("found", (Object)results.size()), this.logMailPredicate(testContext, mailPredicate))).toMap());
    }

    public List<MailMessage> waitForMailNotFound(TestContext testContext, ThrowingConsumer<MailMessageTester<?>, ?> mailPredicate, int timeoutSeconds) {
        return this.waitForMailNotFound(testContext, mailPredicate, 0, timeoutSeconds);
    }

    public List<MailMessage> waitForMailNotFound(TestContext testContext, ThrowingConsumer<MailMessageTester<?>, ?> mailPredicate, int foundMailLimit, int timeoutSeconds) {
        ArrayList<MailMessage> results = new ArrayList<MailMessage>();
        HashSet<Integer> checkedMessageIds = new HashSet<Integer>();
        long start = System.currentTimeMillis();
        long end = start + (long)(timeoutSeconds * 1000);
        this.evalLog.logEvent("Execute", "mail not found", op -> op.addValue("timeout", (Object)timeoutSeconds).addValue("found limit", (Object)foundMailLimit), this.logMailPredicate(testContext, mailPredicate));
        int batchSize = Math.min(Math.max(20, foundMailLimit * 4), 80);
        while (results.size() <= foundMailLimit && System.currentTimeMillis() < end) {
            try {
                List<MailMessage> found = this.getAllMail(testContext, mailPredicate, foundMailLimit - results.size(), batchSize, checkedMessageIds);
                for (MailMessage mailMessage : found) {
                    if (results.contains(mailMessage)) continue;
                    results.add(mailMessage);
                    if (results.size() <= foundMailLimit) continue;
                    break;
                }
            }
            catch (Exception ex) {
                log.info("Error: exception caught while fetching mail.", (Throwable)ex);
            }
            if (results.size() > foundMailLimit) {
                throw new RuntimeException("Error: Expected to find at most [" + foundMailLimit + "] messages.  Found [" + results.size() + "] matching:\n" + this.logMailPredicate(testContext, mailPredicate));
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Error: Mail fetch interrupted.", ex);
            }
            long elapsed = (System.currentTimeMillis() - start) / 1000L;
            log.info("Waiting for mail with timeout: [" + timeoutSeconds + "], elapsed: [" + elapsed + "]");
        }
        return results;
    }

    private List<Consumer<JsonObjectBuilder>> logMailPredicate(TestContext testContext, ThrowingConsumer<MailMessageTester<?>, ?> mailPredicate) {
        TestEvaluator.LogTests testEvaluator = new TestEvaluator.LogTests((TestEvaluator)new TestEvaluator.Now()){

            protected <T> T doTest(String testType, String actionDisplay, Consumer<JsonObjectBuilder> jsonEvent, Callable<Boolean> test, T returnObj, TestContext testContext) {
                this.setTestEventRef(testType, actionDisplay, jsonEvent);
                Map event = JsonBuilder.toMap((Consumer)this.getAssertEvent(actionDisplay, this.getEventParams(), this.getSourceEvents()));
                this.logMessages.add(obj -> obj.merge(event));
                this.clearSourceEvents();
                return returnObj;
            }
        };
        MailMessageTester<Object> tester = new MailMessageTester<Object>(() -> null, null, testContext, (TestEvaluator)testEvaluator);
        tester.returnObj = tester;
        try {
            mailPredicate.accept(tester);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return testEvaluator.getTestLog();
    }

    private List<MailMessage> getAllMail(TestContext testContext, ThrowingConsumer<MailMessageTester<?>, ?> mailPredicate, int maxMailLimit, int batchSize, Set<Integer> checkedMessageIds) throws MessagingException {
        return this.getReceivedMail(testContext, () -> null, (sent, filter) -> ThrowingConsumer.unchecked((ThrowingConsumer)mailPredicate).accept(filter), maxMailLimit, batchSize, checkedMessageIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MailMessage> getReceivedMail(TestContext testContext, Callable<MailMessage> sentMailRef, MailTester.SentMailFilter mailPredicate, int maxMailLimit, int batchSize, Set<Integer> checkedMessageIds) throws MessagingException {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)System.getProperties());
        if (this.getUseTls()) {
            properties.setProperty("mail.pop3.ssl.enable", "true");
            properties.setProperty("mail.pop3s.ssl.enable", "true");
        }
        if (this.getAllowInsecure()) {
            properties.setProperty("mail.pop3.ssl.trust", "*");
            properties.setProperty("mail.pop3s.ssl.trust", "*");
            properties.setProperty("mail.pop3.ssl.checkserveridentity", "false");
            properties.setProperty("mail.pop3s.ssl.checkserveridentity", "false");
        }
        Session session = Session.getInstance((Properties)properties);
        Store store = session.getStore("pop3");
        store.connect(this.getHost(), this.getPopPort().intValue(), this.getUsername(), this.getPassword());
        Folder inbox = store.getFolder("Inbox");
        inbox.open(2);
        try {
            ArrayList<MailMessage> found = new ArrayList<MailMessage>();
            int checkCount = 0;
            for (int i = inbox.getMessageCount(); i > 0 && checkCount < batchSize; --i) {
                if (checkedMessageIds != null && checkedMessageIds.contains(i)) continue;
                ++checkCount;
                Message message = inbox.getMessage(i);
                LazyMailMessage mailMessage = new LazyMailMessage(message);
                TestEvaluator contextEvaluator = testContext.getEvaluator();
                TestEvaluator.NoException testEvaluator = new TestEvaluator.NoException((TestEvaluator)new TestEvaluator.Now());
                MailMessageTester<Object> tester = new MailMessageTester<Object>(() -> mailMessage, null, testContext, (TestEvaluator)testEvaluator);
                tester.returnObj = tester;
                try {
                    testContext.setEvaluator((TestEvaluator)testEvaluator);
                    mailPredicate.filter(sentMailRef.call(), tester);
                    if (checkedMessageIds != null) {
                        checkedMessageIds.add(i);
                    }
                    if (!testEvaluator.getTestStatus()) {
                        continue;
                    }
                }
                catch (Exception ex) {
                    continue;
                }
                finally {
                    testContext.setEvaluator(contextEvaluator);
                }
                mailMessage.loadAll();
                found.add(mailMessage);
                if (maxMailLimit <= 0 || found.size() != maxMailLimit) continue;
                ArrayList<MailMessage> arrayList = found;
                return arrayList;
            }
            ArrayList<MailMessage> arrayList = found;
            return arrayList;
        }
        finally {
            inbox.close(false);
            store.close();
        }
    }
}

