/*
 * Decompiled with CFR 0.152.
 */
package org.pagemodel.mail;

import com.sun.mail.smtp.SMTPTransport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.pagemodel.mail.MailAuthenticator;
import org.pagemodel.mail.MailMessage;
import org.pagemodel.mail.MailServer;
import org.pagemodel.mail.MimeMailAdapter;

public class SmtpServer
extends MailServer {
    private int smtpPort = 25;

    public SmtpServer(MailAuthenticator mailAuthenticator) {
        super(mailAuthenticator);
        this.smtpPort = mailAuthenticator.getSmtpPort();
    }

    public SmtpServer(String domain, String ip, String user, String password) {
        super(domain, ip, user, password, false);
    }

    public SmtpServer(String domain, String ip, String user, String password, int smtpPort) {
        super(domain, ip, user, password, false);
        this.smtpPort = smtpPort;
    }

    public SmtpServer(String domain, String ip, String user, String password, int smtpPort, boolean useTls) {
        super(domain, ip, user, password, useTls);
        this.smtpPort = smtpPort;
    }

    public Integer getSmtpPort() {
        return this.smtpPort;
    }

    public void setSmtpPort(Integer smtpPort) {
        this.smtpPort = smtpPort;
    }

    public MailMessage send(MailMessage mailMessage) throws MessagingException, IOException {
        Properties props = System.getProperties();
        props.put("mail.transport.protocol", "smtp");
        props.put("mail.smtp.host", this.getHost());
        props.put("mail.smtp.port", this.getSmtpPort());
        props.put("mail.smtp.from", mailMessage.getSender());
        props.put("mail.smtp.starttls.enable", (Object)this.getUseTls());
        Authenticator authenticator = null;
        if (this.getUsername() != null && !this.getUsername().isEmpty() && this.getPassword() != null && !this.getPassword().isEmpty()) {
            props.put("mail.smtp.auth", "true");
            props.put("mail.smtp.user", this.getUsername());
            props.put("mail.smtp.password", this.getPassword());
            authenticator = new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(SmtpServer.this.getUsername(), SmtpServer.this.getPassword());
                }
            };
        }
        Session session = Session.getInstance((Properties)props, authenticator);
        SMTPTransport transport = (SMTPTransport)session.getTransport("smtp");
        transport.connect();
        ArrayList<InternetAddress> recipients = new ArrayList<InternetAddress>();
        for (String r : mailMessage.getRecipientsTo()) {
            recipients.add(new InternetAddress(r));
        }
        for (String r : mailMessage.getRecipientsCc()) {
            recipients.add(new InternetAddress(r));
        }
        for (String r : mailMessage.getRecipientsBcc()) {
            recipients.add(new InternetAddress(r));
        }
        MimeMessage mimeMessage = MimeMailAdapter.createMimeMessage(mailMessage, session);
        transport.sendMessage((Message)mimeMessage, recipients.toArray(new Address[0]));
        transport.close();
        mailMessage.setSentDate(new Date());
        return mailMessage;
    }
}

