/*
 * Decompiled with CFR 0.152.
 */
package org.pagemodel.ssh;

import java.io.File;
import java.io.IOException;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import net.schmizz.sshj.transport.verification.PromiscuousVerifier;
import net.schmizz.sshj.userauth.keyprovider.KeyProvider;

public class SSHAuthenticator {
    private String ipAddress;
    private String username;
    private String password;
    private String keyFilePath;
    private String keyFilePassword;
    private String sudoPassword;

    public static SSHAuthenticator passwordAuth(String ipAddress, String username, String password, String sudoPassword) {
        return new SSHAuthenticator(ipAddress, username, password, null, null, sudoPassword);
    }

    public static SSHAuthenticator keyAuth(String ipAddress, String username, String keyFilePath, String keyFilePassword, String sudoPassword) {
        return new SSHAuthenticator(ipAddress, username, null, keyFilePath, keyFilePassword, sudoPassword);
    }

    public SSHAuthenticator(String ipAddress, String username, String password, String keyFilePath, String keyFilePassword, String sudoPassword) {
        this.ipAddress = ipAddress;
        this.username = username;
        this.password = password;
        this.keyFilePath = keyFilePath;
        this.keyFilePassword = keyFilePassword;
        this.sudoPassword = sudoPassword;
    }

    public SSHClient connectAndAuthenticate() throws IOException {
        if (this.keyFilePath != null && new File(this.keyFilePath).exists()) {
            return this.connectAndAuthenticateKeyFile();
        }
        return this.connectAndAuthenticatePassword();
    }

    public SSHClient connectAndAuthenticatePassword() throws IOException {
        SSHClient ssh = new SSHClient();
        ssh.addHostKeyVerifier((HostKeyVerifier)new PromiscuousVerifier());
        ssh.connect(this.ipAddress);
        ssh.authPassword(this.username, this.password);
        return ssh;
    }

    public SSHClient connectAndAuthenticateKeyFile() throws IOException {
        SSHClient ssh = new SSHClient();
        ssh.addHostKeyVerifier((HostKeyVerifier)new PromiscuousVerifier());
        ssh.connect(this.ipAddress);
        KeyProvider kp = this.keyFilePassword == null ? ssh.loadKeys(this.keyFilePath) : ssh.loadKeys(this.keyFilePath, this.keyFilePassword);
        ssh.authPublickey(this.username, new KeyProvider[]{kp});
        return ssh;
    }

    public String getHost() {
        return this.ipAddress;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getSudoPassword() {
        return this.sudoPassword;
    }
}

