/*
 * Decompiled with CFR 0.152.
 */
package org.pagemodel.ssh;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.connection.ConnectionException;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.transport.TransportException;
import net.schmizz.sshj.userauth.UserAuthException;
import net.sf.expectit.Expect;
import net.sf.expectit.ExpectBuilder;
import net.sf.expectit.Result;
import net.sf.expectit.filter.Filter;
import net.sf.expectit.filter.Filters;
import net.sf.expectit.matcher.Matcher;
import net.sf.expectit.matcher.Matchers;
import org.pagemodel.ssh.SSHAuthenticator;

public class SSHSession {
    private static final String sudoCommand = "sudo -i";
    private static final String sudoPasswordPrompt = "[sudo] password for ";
    private static final String defaultPromptRegex = "\r\n(-?bash-[^ ]*|\\[[^\\]]*\\])(\\$|\\#) $";
    private Expect commandLine;
    private SSHClient client;
    private Session session;
    private Session.Shell shell;
    private SSHAuthenticator authenticator;
    private boolean sudoed;
    private String promptRegex;

    public SSHSession(SSHAuthenticator authenticator) {
        this(authenticator, defaultPromptRegex);
    }

    public SSHSession(SSHAuthenticator authenticator, String promptRegex) {
        this.authenticator = authenticator;
        this.sudoed = false;
        this.promptRegex = promptRegex;
    }

    public String runCommandAndGetOutput(String command, int timeoutInSeconds) throws IOException {
        this.commandLine.sendLine(command);
        try {
            String output = this.waitForPrompt(timeoutInSeconds).getBefore().trim();
            String unwrappedOutput = this.undoLineWrapping(command, output);
            return unwrappedOutput.substring(command.length()).trim();
        }
        catch (IOException ex) {
            this.commandLine.sendBytes(new byte[]{3});
            this.commandLine.sendLine("kill 0");
            this.close();
            throw new RuntimeException("Command [" + command + "] failed to exit after [" + timeoutInSeconds + "] seconds.");
        }
    }

    public void sendInput(String input) throws IOException {
        this.commandLine.send(input);
    }

    public void sudoToRoot(String rootPassword, String sudoOptions) throws IOException {
        String cmd = sudoCommand;
        if (sudoOptions != null && !sudoOptions.isEmpty()) {
            cmd = cmd + " " + sudoOptions;
        }
        this.sendLineAndExpectOutput(cmd, (Matcher<Result>)Matchers.contains((String)sudoPasswordPrompt));
        this.sendLineAndExpectOutput(rootPassword, (Matcher<Result>)Matchers.regexp((String)this.promptRegex));
        this.sudoed = true;
    }

    public void exitRoot() throws IOException {
        if (this.sudoed) {
            this.sendLineAndExpectOutput("exit", (Matcher<Result>)Matchers.regexp((String)this.promptRegex));
            this.sudoed = false;
        }
    }

    public void close() throws IOException {
        this.client.disconnect();
    }

    public void connect() throws IOException, UserAuthException, TransportException, ConnectionException {
        this.client = this.authenticator.connectAndAuthenticate();
        this.session = this.client.startSession();
        this.session.allocateDefaultPTY();
        this.shell = this.session.startShell();
        this.commandLine = new ExpectBuilder().withOutput(this.shell.getOutputStream()).withInputs(new InputStream[]{this.shell.getInputStream(), this.shell.getErrorStream()}).withEchoInput((Appendable)System.out, new Appendable[0]).withInputFilters(Filters.removeColors(), new Filter[]{Filters.removeNonPrintable()}).withExceptionOnFailure().withTimeout(5L, TimeUnit.SECONDS).build();
        this.commandLine.expect(Matchers.times((int)1, (Matcher)Matchers.regexp((String)this.promptRegex)));
    }

    private void sendLineAndExpectOutput(String lineString, Matcher<Result> expectedOutput) throws IOException {
        this.commandLine.sendLine(lineString);
        this.commandLine.expect(expectedOutput);
    }

    private Result waitForPrompt(int timeoutInSeconds) throws IOException {
        int timeoutInMs = timeoutInSeconds * 1000;
        return this.commandLine.withTimeout((long)timeoutInMs, TimeUnit.MILLISECONDS).expect(Matchers.regexp((String)this.promptRegex));
    }

    private String undoLineWrapping(String command, String output) {
        String cmdFromOutput = output.substring(0, command.length());
        while (!cmdFromOutput.equals(command)) {
            output = output.replaceFirst(" \r", "");
            cmdFromOutput = output.substring(0, command.length());
        }
        return output;
    }

    public void sendCtrlC() throws IOException {
        this.commandLine.sendBytes(new byte[]{3});
        this.waitForPrompt(10);
    }
}

