/*
 * Decompiled with CFR 0.152.
 */
package org.pagemodel.ssh;

import java.io.File;
import java.net.URI;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.xfer.FileSystemFile;
import net.schmizz.sshj.xfer.LocalSourceFile;
import org.pagemodel.core.TestContext;
import org.pagemodel.core.testers.TestEvaluator;
import org.pagemodel.core.utils.ThrowingFunction;
import org.pagemodel.ssh.SSHAuthenticator;
import org.pagemodel.ssh.SSHTestContext;
import org.pagemodel.ssh.SSHTester;

public class SSHConnectionTester<R> {
    protected SSHTester<R> sshTester;
    private TestEvaluator testEvaluator;

    public SSHConnectionTester(R returnObj, SSHTestContext testContext, TestEvaluator testEvaluator) {
        this.sshTester = new SSHTester<R>(returnObj, testContext, testEvaluator);
        this.testEvaluator = testEvaluator;
    }

    public SSHTestContext getContext() {
        return this.sshTester.testContext;
    }

    protected TestEvaluator getEvaluator() {
        return this.testEvaluator;
    }

    public SSHTester<R> connect() {
        return this.sshTester.connect();
    }

    public SSHTester<R> connect(SSHAuthenticator authenticator) {
        return this.sshTester.connect(authenticator);
    }

    public SSHTester<R> connect(String ipAddress, String username, String password, String sudoPassword) {
        return this.sshTester.connect(SSHAuthenticator.passwordAuth(ipAddress, username, password, sudoPassword));
    }

    public R testConnectionFails() {
        return this.sshTester.testConnectionFails();
    }

    public R testConnectionFails(String ipAddress, String username, String password) {
        return this.sshTester.testConnectionFails(SSHAuthenticator.passwordAuth(ipAddress, username, password, password));
    }

    public R testConnectionFails(SSHAuthenticator authenticator) {
        return this.sshTester.testConnectionFails(authenticator);
    }

    public SSHConnectionTester<R> scpFileUpload(String resourceFile, String remotePath) {
        return this.scpFileUpload(this.sshTester.getAuthenticator(), resourceFile, remotePath);
    }

    public SSHConnectionTester<R> scpFileDownload(String remotePath, String localPath) {
        return this.scpFileDownload(this.sshTester.getAuthenticator(), remotePath, localPath);
    }

    public SSHConnectionTester<R> scpFileUpload(SSHAuthenticator authenticator, String resourceFilePath, String remotePath) {
        return (SSHConnectionTester)this.getEvaluator().testExecute("scp upload", op -> op.addValue("local", (Object)resourceFilePath).addValue("remote", (Object)remotePath).addValue("server", (Object)authenticator.getHost()).addValue("user", (Object)authenticator.getUsername()), () -> {
            SSHClient ssh = authenticator.connectAndAuthenticate();
            URI uri = this.getClass().getResource(resourceFilePath).toURI();
            FileSystemFile file = new FileSystemFile(new File(uri));
            ssh.newSCPFileTransfer().upload((LocalSourceFile)file, remotePath);
            ssh.disconnect();
        }, (Object)this, (TestContext)this.getContext());
    }

    public SSHConnectionTester<R> scpFileDownload(SSHAuthenticator authenticator, String remotePath, String localPath) {
        return (SSHConnectionTester)this.getEvaluator().testExecute("scp download", op -> op.addValue("remote", (Object)remotePath).addValue("local", (Object)localPath).addValue("server", (Object)authenticator.getHost()).addValue("user", (Object)authenticator.getUsername()), () -> {
            SSHClient ssh = authenticator.connectAndAuthenticate();
            ssh.newSCPFileTransfer().download(remotePath, localPath);
            ssh.disconnect();
        }, (Object)this, (TestContext)this.getContext());
    }

    public R doAction(ThrowingFunction<? super SSHConnectionTester<R>, R, ?> sshAction) {
        return ThrowingFunction.unchecked(sshAction).apply(this);
    }
}

