/*
 * Decompiled with CFR 0.152.
 */
package org.pagemodel.ssh;

import java.io.IOException;
import org.pagemodel.core.TestContext;
import org.pagemodel.core.testers.TestEvaluator;
import org.pagemodel.ssh.SSHAuthenticator;
import org.pagemodel.ssh.SSHCommandTester;
import org.pagemodel.ssh.SSHSession;
import org.pagemodel.ssh.SSHTestContext;

public class SSHTester<R> {
    public static final int DEFAULT_SSH_CMD_TIMEOUT = 20;
    private final R returnObj;
    protected final SSHTestContext testContext;
    private SSHSession sshSession;
    private boolean connected = false;
    private SSHAuthenticator authenticator;
    private TestEvaluator testEvaluator;

    public SSHTester(R returnObj, SSHTestContext testContext, TestEvaluator testEvaluator) {
        this.returnObj = returnObj;
        this.testContext = testContext;
        this.authenticator = testContext.getSshAuthenticator();
        this.testEvaluator = testEvaluator;
    }

    protected TestEvaluator getEvaluator() {
        return this.testEvaluator;
    }

    public SSHCommandTester<R> runCommand(String command, Integer timeoutSec) {
        this.startSession();
        return new SSHCommandTester<R>(command, timeoutSec, this, this.returnObj, this.testContext, this.getEvaluator());
    }

    public SSHCommandTester<R> runCommand(String command) {
        return this.runCommand(command, 20);
    }

    public SSHCommandTester<R> sudoToRoot() {
        return this.sudoToRoot("");
    }

    public SSHCommandTester<R> sudoToRoot(String sudoOpts) {
        return this.runCommand("sudo-root:" + sudoOpts + ":" + this.getAuthenticator().getSudoPassword());
    }

    public SSHCommandTester<R> exitSudo() {
        return this.runCommand("exit-sudo");
    }

    protected SSHTester<R> connect() {
        return this.connect(this.testContext.getSshAuthenticator());
    }

    protected SSHTester<R> connect(SSHAuthenticator authenticator) {
        return (SSHTester)this.getEvaluator().testExecute("ssh connect", op -> op.addValue("server", (Object)authenticator.getHost()).addValue("user", (Object)authenticator.getUsername()), () -> {
            this.authenticator = authenticator;
            this.startSession();
            assert (this.connected);
        }, (Object)this, (TestContext)this.testContext);
    }

    protected R testConnectionFails() {
        return this.testConnectionFails(this.testContext.getSshAuthenticator());
    }

    protected R testConnectionFails(SSHAuthenticator authenticator) {
        return (R)this.getEvaluator().testCondition("ssh fails", op -> op.addValue("server", (Object)authenticator.getHost()).addValue("user", (Object)authenticator.getUsername()), () -> {
            this.authenticator = authenticator;
            try {
                this.startSession();
            }
            catch (RuntimeException ex) {
                return true;
            }
            return false;
        }, this.returnObj, (TestContext)this.testContext);
    }

    public R disconnect() {
        return (R)this.getEvaluator().testExecute("ssh disconnect", op -> op.addValue("server", (Object)this.authenticator.getHost()).addValue("user", (Object)this.authenticator.getUsername()), () -> {
            if (!this.connected) {
                return;
            }
            try {
                this.sshSession.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.connected = false;
            this.sshSession = null;
        }, this.returnObj, (TestContext)this.testContext);
    }

    private void startSession() {
        if (this.connected) {
            return;
        }
        if (this.sshSession == null) {
            this.sshSession = new SSHSession(this.authenticator);
        }
        try {
            this.sshSession.connect();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        this.connected = true;
    }

    protected R getReturnObj() {
        return this.returnObj;
    }

    protected SSHSession getSshSession() {
        return this.sshSession;
    }

    protected SSHAuthenticator getAuthenticator() {
        return this.authenticator;
    }
}

