/*
 * Decompiled with CFR 0.152.
 */
package org.pagemodel.ssh;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import net.schmizz.sshj.transport.verification.PromiscuousVerifier;
import net.schmizz.sshj.userauth.keyprovider.KeyProvider;

public class SSHAuthenticator {
    @Deprecated
    private String ipAddress;
    private String host;
    private Integer port;
    private LocalAddress localAddress;
    private String username;
    private String password;
    private String keyFilePath;
    private String keyFilePassword;
    private String sudoPassword;
    private String promptRegex;

    public static SSHAuthenticator passwordAuth(String ipAddress, String username, String password, String sudoPassword) {
        return new SSHAuthenticator(ipAddress, username, password, null, null, sudoPassword);
    }

    public static SSHAuthenticator keyAuth(String ipAddress, String username, String keyFilePath, String keyFilePassword, String sudoPassword) {
        return new SSHAuthenticator(ipAddress, username, null, keyFilePath, keyFilePassword, sudoPassword);
    }

    public SSHAuthenticator(String host, String username, String password, String keyFilePath, String keyFilePassword, String sudoPassword) {
        this.host = host;
        this.username = username;
        this.password = password;
        this.keyFilePath = keyFilePath;
        this.keyFilePassword = keyFilePassword;
        this.sudoPassword = sudoPassword;
    }

    public SSHClient connectAndAuthenticate() throws IOException {
        if (this.keyFilePath != null && new File(this.keyFilePath).exists()) {
            return this.connectAndAuthenticateKeyFile();
        }
        return this.connectAndAuthenticatePassword();
    }

    public SSHClient connectAndAuthenticatePassword() throws IOException {
        SSHClient ssh = this.initClient();
        ssh.authPassword(this.username, this.password);
        return ssh;
    }

    public SSHClient connectAndAuthenticateKeyFile() throws IOException {
        SSHClient ssh = this.initClient();
        KeyProvider kp = this.keyFilePassword == null ? ssh.loadKeys(this.keyFilePath) : ssh.loadKeys(this.keyFilePath, this.keyFilePassword);
        ssh.authPublickey(this.username, new KeyProvider[]{kp});
        return ssh;
    }

    private SSHClient initClient() throws IOException {
        int connectPort;
        SSHClient ssh = new SSHClient();
        ssh.addHostKeyVerifier((HostKeyVerifier)new PromiscuousVerifier());
        int n = connectPort = this.port == null ? 22 : this.port;
        if (this.localAddress != null) {
            ssh.connect(this.host, connectPort, this.localAddress.getAddress(), this.localAddress.getPort());
        } else {
            ssh.connect(this.host, connectPort);
        }
        return ssh;
    }

    public String getHost() {
        if (this.host != null) {
            return this.host;
        }
        if (this.ipAddress != null) {
            this.host = this.ipAddress;
            return this.host;
        }
        return null;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public LocalAddress getLocalAddress() {
        return this.localAddress;
    }

    public void setLocalAddress(LocalAddress localAddress) {
        this.localAddress = localAddress;
    }

    public void setLocalAddress(InetAddress inetAddress, int port) {
        this.localAddress = new LocalAddress(inetAddress, port);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getKeyFilePath() {
        return this.keyFilePath;
    }

    public void setKeyFilePath(String keyFilePath) {
        this.keyFilePath = keyFilePath;
    }

    public String getKeyFilePassword() {
        return this.keyFilePassword;
    }

    public void setKeyFilePassword(String keyFilePassword) {
        this.keyFilePassword = keyFilePassword;
    }

    public String getSudoPassword() {
        return this.sudoPassword;
    }

    public void setSudoPassword(String sudoPassword) {
        this.sudoPassword = sudoPassword;
    }

    public String getPromptRegex() {
        return this.promptRegex;
    }

    public void setPromptRegex(String promptRegex) {
        this.promptRegex = promptRegex;
    }

    public static class LocalAddress {
        private String host;
        private transient InetAddress address;
        private int port;

        public LocalAddress(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public LocalAddress(InetAddress address, int port) {
            this.address = address;
            this.port = port;
        }

        public InetAddress getAddress() throws UnknownHostException {
            if (this.address != null) {
                return this.address;
            }
            if (this.host != null) {
                this.address = InetAddress.getByName(this.host);
                return this.address;
            }
            return null;
        }

        public int getPort() {
            return this.port;
        }
    }
}

