/*
 * Decompiled with CFR 0.152.
 */
package org.pagemodel.ssh;

import org.pagemodel.core.TestContext;
import org.pagemodel.core.testers.ComparableTester;
import org.pagemodel.core.testers.StringTester;
import org.pagemodel.core.testers.TestEvaluator;
import org.pagemodel.ssh.SSHTestContext;
import org.pagemodel.ssh.SSHTester;

public class SSHCommandTester<R> {
    private final String command;
    private Integer timeoutSec;
    private final SSHTester<?> parent;
    private String output;
    private Integer returnCode;
    protected R returnObj;
    protected final SSHTestContext testContext;
    private TestEvaluator testEvaluator;
    private boolean executed = false;

    public SSHCommandTester(String command, Integer timeoutSec, SSHTester<?> parent, R returnObj, SSHTestContext testContext, TestEvaluator testEvaluator) {
        this.command = command;
        this.timeoutSec = timeoutSec;
        this.parent = parent;
        this.returnObj = returnObj;
        this.testContext = testContext;
        this.testEvaluator = testEvaluator;
    }

    protected TestEvaluator getEvaluator() {
        return this.testEvaluator;
    }

    public ComparableTester<Integer, SSHCommandTester<R>> testReturnCode() {
        if (!this.executed) {
            this.executeCommand();
        }
        if (this.returnCode == null) {
            SSHCommandTester<R> returnCodeCmd = new SSHCommandTester<R>("echo $?", this.timeoutSec, this.parent, this.returnObj, this.testContext, this.getEvaluator());
            super.executeCommand();
            String rcString = returnCodeCmd.output;
            this.returnCode = Integer.valueOf(rcString);
        }
        return new ComparableTester(() -> this.returnCode, (Object)this, (TestContext)this.testContext, this.getEvaluator());
    }

    public StringTester<SSHCommandTester<R>> testOutput() {
        if (!this.executed) {
            this.executeCommand();
        }
        return new StringTester(() -> this.output, (Object)this, (TestContext)this.testContext, this.getEvaluator());
    }

    public SSHCommandTester<R> runCommand(String command, int timeoutSec) {
        if (!this.executed) {
            this.executeCommand();
        }
        return new SSHCommandTester<R>(command, timeoutSec, this.parent, this.returnObj, this.testContext, this.getEvaluator());
    }

    public SSHCommandTester<R> runCommand(String command) {
        if (!this.executed) {
            this.executeCommand();
        }
        return new SSHCommandTester<R>(command, 20, this.parent, this.returnObj, this.testContext, this.getEvaluator());
    }

    public SSHCommandTester<R> sudoToRoot() {
        return this.sudoToRoot("");
    }

    public SSHCommandTester<R> sudoToRoot(String sudoOpts) {
        if (!this.executed) {
            this.executeCommand();
        }
        return new SSHCommandTester<R>("sudo-root:" + sudoOpts + ":" + this.parent.getAuthenticator().getSudoPassword(), 20, this.parent, this.returnObj, this.testContext, this.getEvaluator());
    }

    public SSHCommandTester<R> exitSudo() {
        if (!this.executed) {
            this.executeCommand();
        }
        return new SSHCommandTester<R>("exit-sudo", 20, this.parent, this.returnObj, this.testContext, this.getEvaluator());
    }

    public R disconnect() {
        if (!this.executed) {
            this.executeCommand();
        }
        this.parent.disconnect();
        return this.returnObj;
    }

    private void executeCommand() {
        if (this.command.startsWith("sudo-root")) {
            this.getEvaluator().testExecute("ssh sudo", op -> op.addValue("server", (Object)this.parent.getAuthenticator().getHost()), () -> {
                String cmdLine = this.command.substring(10);
                int split = cmdLine.indexOf(58);
                String opts = cmdLine.substring(0, split);
                String password = cmdLine.substring(split + 1);
                this.parent.getSshSession().sudoToRoot(password, opts);
                this.output = "";
            }, null, (TestContext)this.testContext);
        } else if (this.command.startsWith("exit-sudo")) {
            this.getEvaluator().testExecute("ssh exit sudo", op -> op.addValue("server", (Object)this.parent.getAuthenticator().getHost()), () -> {
                this.parent.getSshSession().exitRoot();
                this.output = "";
            }, null, (TestContext)this.testContext);
        } else {
            this.getEvaluator().testExecute("ssh command", op -> op.addValue("command", (Object)this.command).addValue("server", (Object)this.parent.getAuthenticator().getHost()), () -> {
                this.output = this.parent.getSshSession().runCommandAndGetOutput(this.command, this.timeoutSec);
            }, null, (TestContext)this.testContext);
        }
        this.executed = true;
    }
}

