/*
 * Decompiled with CFR 0.152.
 */
package org.pagemodel.tests.myapp.pages;

import java.util.function.Consumer;
import org.openqa.selenium.By;
import org.pagemodel.core.testers.TestEvaluator;
import org.pagemodel.tests.myapp.pages.MyAppInternalPage;
import org.pagemodel.tools.ExtendedSectionModel;
import org.pagemodel.tools.ExtendedTestContext;
import org.pagemodel.web.ComponentModel;
import org.pagemodel.web.LocatedWebElement;
import org.pagemodel.web.PageModel;
import org.pagemodel.web.testers.CheckboxTester;
import org.pagemodel.web.testers.ClickAction;
import org.pagemodel.web.testers.WebElementTester;

public class ManageUsersPage
extends MyAppInternalPage<ManageUsersPage> {
    public ManageUsersPage(ExtendedTestContext testContext) {
        super(testContext);
    }

    @Override
    protected Consumer<ManageUsersPage> testModelDisplayed() {
        return super.testModelDisplayed().andThen(page -> {
            ManageUsersPage cfr_ignored_0 = (ManageUsersPage)((Object)((Object)((ManageUsersPage)((Object)((Object)page.testHeaderDisplay().text().equals("MyApp Manage Users")))).testAddUserButton().isDisplayed()));
        });
    }

    protected LocatedWebElement getHeaderDisplay() {
        return this.findPageElement("HeaderDisplay", By.xpath((String)"//h1[1]"));
    }

    protected LocatedWebElement getAddUserButton() {
        return this.findPageElement("AddUserButton", By.id((String)"addUser"));
    }

    protected LocatedWebElement getUserRow(String username) {
        return this.findPageElement("UserRow", By.xpath((String)("//table[@id='userTable']/tbody/tr/td[contains(@class,'username') and text()='" + username + "']//parent::tr")));
    }

    protected LocatedWebElement getAddUserDialog() {
        return this.findPageElement("AddUserDialog", By.id((String)"addUserDialog"));
    }

    public WebElementTester<ManageUsersPage, ManageUsersPage> testHeaderDisplay() {
        return new WebElementTester(ClickAction.make(this::getHeaderDisplay, (PageModel)this, (TestEvaluator)this.getEvaluator()), this.getEvaluator());
    }

    public WebElementTester<ManageUsersPage, AddUserSection> testAddUserButton() {
        return new WebElementTester(ClickAction.makeNav(this::getAddUserButton, (PageModel)this, (PageModel)this.testAddUserDialog(), (TestEvaluator)this.getEvaluator()), this.getEvaluator());
    }

    public UserRow<ManageUsersPage> testUserRow(String username) {
        return new UserRow<ManageUsersPage>(ClickAction.make(() -> this.getUserRow(username), (PageModel)this, (TestEvaluator)this.getEvaluator()), this.getEvaluator());
    }

    public AddUserSection testAddUserDialog() {
        return new AddUserSection((ClickAction<ManageUsersPage, ManageUsersPage>)ClickAction.make(this::getAddUserDialog, (PageModel)this, (TestEvaluator)this.getEvaluator()), this.getEvaluator());
    }

    public class AddUserSection
    extends ExtendedSectionModel<AddUserSection, ManageUsersPage, AddUserSection> {
        public AddUserSection(ClickAction<ManageUsersPage, ManageUsersPage> clickAction, TestEvaluator testEvaluator) {
            super(clickAction, testEvaluator);
        }

        protected LocatedWebElement getUsernameField() {
            return this.findComponentElement("UsernameField", By.id((String)"newUserName"));
        }

        protected LocatedWebElement getEmailField() {
            return this.findComponentElement("EmailField", By.id((String)"newUserEmail"));
        }

        protected LocatedWebElement getAdminCheckbox() {
            return this.findComponentElement("AdminCheckbox", By.id((String)"newUserAdmin"));
        }

        protected LocatedWebElement getPasswordField() {
            return this.findComponentElement("PasswordField", By.id((String)"newUserPassword"));
        }

        protected LocatedWebElement getPasswordConfirmField() {
            return this.findComponentElement("PasswordConfirmField", By.id((String)"newUserPasswordConfirm"));
        }

        protected LocatedWebElement getCancelButton() {
            return this.findComponentElement("CancelButton", By.id((String)"newUserCancel"));
        }

        protected LocatedWebElement getSaveButton() {
            return this.findComponentElement("SaveButton", By.id((String)"newUserSave"));
        }

        public WebElementTester<AddUserSection, AddUserSection> testUsernameField() {
            return new WebElementTester(ClickAction.make(this::getUsernameField, (PageModel)this, (TestEvaluator)this.getEvaluator()), this.getEvaluator());
        }

        public WebElementTester<AddUserSection, AddUserSection> testEmailField() {
            return new WebElementTester(ClickAction.make(this::getEmailField, (PageModel)this, (TestEvaluator)this.getEvaluator()), this.getEvaluator());
        }

        public CheckboxTester<AddUserSection, AddUserSection> testAdminCheckbox() {
            return new CheckboxTester(ClickAction.make(this::getAdminCheckbox, (PageModel)this, (TestEvaluator)this.getEvaluator()), this.getEvaluator());
        }

        public WebElementTester<AddUserSection, AddUserSection> testPasswordField() {
            return new WebElementTester(ClickAction.make(this::getPasswordField, (PageModel)this, (TestEvaluator)this.getEvaluator()), this.getEvaluator());
        }

        public WebElementTester<AddUserSection, AddUserSection> testPasswordConfirmField() {
            return new WebElementTester(ClickAction.make(this::getPasswordConfirmField, (PageModel)this, (TestEvaluator)this.getEvaluator()), this.getEvaluator());
        }

        public WebElementTester<AddUserSection, ManageUsersPage> testCancelButton() {
            return new WebElementTester(ClickAction.makeNav(this::getCancelButton, (PageModel)this, ManageUsersPage.class, (TestEvaluator)this.getEvaluator()), this.getEvaluator());
        }

        public WebElementTester<AddUserSection, ManageUsersPage> testSaveButton() {
            return new WebElementTester(ClickAction.makeNav(this::getSaveButton, (PageModel)this, ManageUsersPage.class, (TestEvaluator)this.getEvaluator()), this.getEvaluator());
        }
    }

    public class UserRow<R>
    extends ComponentModel<R, ManageUsersPage, UserRow<R>> {
        public UserRow(ClickAction<?, ManageUsersPage> clickAction, TestEvaluator testEvaluator) {
            super(clickAction, testEvaluator);
        }

        public UserRow(R returnObj, ClickAction<?, ManageUsersPage> clickAction, TestEvaluator testEvaluator) {
            super(returnObj, clickAction, testEvaluator);
        }

        public UserRow_section asSection() {
            return new UserRow_section(this.clickAction, this.getEvaluator());
        }

        protected LocatedWebElement getUsernameDisplay() {
            return this.findComponentElement("UsernameDisplay", By.cssSelector((String)"td.username"));
        }

        protected LocatedWebElement getEmailDisplay() {
            return this.findComponentElement("EmailDisplay", By.cssSelector((String)"td.emailAddress"));
        }

        protected LocatedWebElement getRoleDisplay() {
            return this.findComponentElement("RoleDisplay", By.cssSelector((String)"td.role"));
        }

        protected LocatedWebElement getDeleteButton() {
            return this.findComponentElement("DeleteButton", By.cssSelector((String)"td.delete > input"));
        }

        public WebElementTester<R, ManageUsersPage> testUsernameDisplay() {
            return new WebElementTester(this.getReturnObj(), ClickAction.make(this::getUsernameDisplay, (PageModel)((ManageUsersPage)this.page), (TestEvaluator)this.getEvaluator()), this.getEvaluator());
        }

        public WebElementTester<R, ManageUsersPage> testEmailDisplay() {
            return new WebElementTester(this.getReturnObj(), ClickAction.make(this::getEmailDisplay, (PageModel)((ManageUsersPage)this.page), (TestEvaluator)this.getEvaluator()), this.getEvaluator());
        }

        public WebElementTester<R, ManageUsersPage> testRoleDisplay() {
            return new WebElementTester(this.getReturnObj(), ClickAction.make(this::getRoleDisplay, (PageModel)((ManageUsersPage)this.page), (TestEvaluator)this.getEvaluator()), this.getEvaluator());
        }

        public WebElementTester<R, ManageUsersPage> testDeleteButton() {
            return new WebElementTester(this.getReturnObj(), ClickAction.make(this::getDeleteButton, (PageModel)((ManageUsersPage)this.page), (TestEvaluator)this.getEvaluator()).withAlertAccept(), this.getEvaluator());
        }

        public class UserRow_section
        extends UserRow<UserRow_section> {
            public UserRow_section(ClickAction<?, ManageUsersPage> clickAction, TestEvaluator testEvaluator) {
                super(clickAction, testEvaluator);
                this.setReturnObj((Object)this);
            }

            public ManageUsersPage testSectionParent() {
                return (ManageUsersPage)this.page;
            }
        }
    }
}

