/*
 * Decompiled with CFR 0.152.
 */
package org.pagemodel.tests.myapp.tools;

import java.io.File;
import org.pagemodel.tests.myapp.pages.LoginPage;
import org.pagemodel.tests.myapp.tools.MyAppConfig;
import org.pagemodel.tools.ExtendedTestContext;
import org.pagemodel.tools.WebDriverConfig;
import org.pagemodel.web.PageUtils;
import org.pagemodel.web.WebTestContext;

public class MyAppTestContext
extends ExtendedTestContext {
    private MyAppConfig myAppConfig;

    public MyAppTestContext(MyAppConfig myAppConfig, WebDriverConfig webDriverConfig) {
        super(null, myAppConfig.getSshAuth(), webDriverConfig);
        this.myAppConfig = myAppConfig;
    }

    public LoginPage getLoginPage() {
        this.openPage(this.getApplicationUrl("/login.html"));
        return (LoginPage)PageUtils.waitForNavigateToPage(LoginPage.class, (WebTestContext)this);
    }

    public MyAppConfig getMyAppConfig() {
        return this.myAppConfig;
    }

    private String getApplicationUrl(String urlPath) {
        String port = this.myAppConfig.getPort();
        port = port == null || port.isEmpty() ? "" : ":" + port;
        String hostPath = this.myAppConfig.getProtocol().equals("file") ? new File(this.myAppConfig.getHostname()).getAbsolutePath() : this.myAppConfig.getHostname();
        return String.format("%s://%s%s%s", this.myAppConfig.getProtocol(), hostPath, port, urlPath);
    }
}

