package org.pagemodel.tests.myapp.pages;

import org.pagemodel.web.*;
import org.pagemodel.web.testers.*;
import org.pagemodel.core.testers.*;
import org.pagemodel.tools.*;
import java.util.function.Consumer;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public abstract class MyAppInternalPage<P extends MyAppInternalPage<? super P>> extends ExtendedPageModel<P> {
	public MyAppInternalPage(ExtendedTestContext testContext) {
		super(testContext);
	}

	@Override
	protected Consumer<P> testModelDisplayed() {
		return super.testModelDisplayed().andThen(page -> page
				.testTopNav().isDisplayed());
	}

	// ================ begin protected web elements ==============
	protected LocatedWebElement getTopNav() {
		return findPageElement("TopNav", By.id("topNav"));
	}
	// ================ end protected web elements ================

	// ================ begin public testers ======================
	public MyAppTopNav<P> testTopNav() {
		return new MyAppTopNav<>(ClickAction.make(this::getTopNav, (P)this, getEvaluator()), getEvaluator());
	}
	// ================ end public testers ========================


	public class MyAppTopNav<R> extends ComponentModel<R,P,MyAppTopNav<R>> {
		public MyAppTopNav(ClickAction<?, P> clickAction, TestEvaluator testEvaluator) {
			super(clickAction, testEvaluator);
		}

		public MyAppTopNav(R returnObj, ClickAction<?, P> clickAction, TestEvaluator testEvaluator) {
			super(returnObj, clickAction, testEvaluator);
		}

		public class MyAppTopNav_section extends MyAppTopNav<MyAppTopNav_section> {
			public MyAppTopNav_section(ClickAction<?, P> clickAction, TestEvaluator testEvaluator) {
				super(clickAction, testEvaluator);
				setReturnObj(this);
			}

			public P testSectionParent() {
				return (P)page;
			}
		}

		public MyAppTopNav_section asSection(){
			return new MyAppTopNav_section(clickAction, getEvaluator());
		}

		@Override
		protected Consumer<MyAppTopNav_section> testModelDisplayed() {
			return page -> page
					.testUserInfoDisplay().isDisplayed()
					.testHomeLink().isDisplayed()
					.testSignOutLink().isDisplayed();
		}

		// ================ begin protected web elements ==============
		protected LocatedWebElement getUserInfoDisplay() {
			return findPageElement("UserInfoDisplay", By.id("userInfo"));
		}

		protected LocatedWebElement getHomeLink() {
			return findComponentElement("HomeLink", By.id("navHome"));
		}

		protected LocatedWebElement getManageUsersLink() {
			return findComponentElement("ManageUsersLink", By.id("navManageUsers"));
		}

		protected LocatedWebElement getSignOutLink() {
			return findComponentElement("SignOutLink", By.id("navSignOut"));
		}
		// ================ end protected web elements ================

		// ================ begin public testers ======================
		public WebElementTester<R, P> testUserInfoDisplay() {
			return new WebElementTester<>(getReturnObj(), ClickAction.make(this::getUserInfoDisplay, (P)page, getEvaluator()), getEvaluator());
		}

		public WebElementTester<R, HomePage> testHomeLink() {
			return new WebElementTester<>(getReturnObj(), ClickAction.makeNav(this::getHomeLink, (P)page, HomePage.class, getEvaluator()), getEvaluator());
		}

		public WebElementTester<R, ManageUsersPage> testManageUsersLink() {
			return new WebElementTester<>(getReturnObj(), ClickAction.makeNav(this::getManageUsersLink, (P)page, ManageUsersPage.class, getEvaluator()), getEvaluator());
		}

		public WebElementTester<R, LoginPage> testSignOutLink() {
			return new WebElementTester<>(getReturnObj(), ClickAction.makeNav(this::getSignOutLink, (P)page, LoginPage.class, getEvaluator()), getEvaluator());
		}
		// ================ end public testers ========================
	}
}
