/*
 * Decompiled with CFR 0.152.
 */
package org.pagemodel.tests.myapp.tools;

import org.pagemodel.tests.myapp.pages.HomePage;
import org.pagemodel.tests.myapp.pages.LoginPage;
import org.pagemodel.tests.myapp.tools.MyAppTestContext;
import org.pagemodel.tests.myapp.tools.MyAppUserDetails;
import org.pagemodel.web.PageModel;

public class MyAppUser {
    private MyAppUserDetails userDetails;
    private MyAppTestContext testContext;
    private boolean accountCreated;
    private boolean accountRegistered;

    public static MyAppUser admin(MyAppTestContext testContext) {
        MyAppUser admin = new MyAppUser(testContext.getMyAppConfig().getAdminDetails(), testContext);
        admin.accountCreated = true;
        admin.accountRegistered = true;
        return admin;
    }

    public static MyAppUser generateUser(MyAppTestContext testContext, String userRole) {
        return new MyAppUser(MyAppUserDetails.generate(userRole), testContext);
    }

    public MyAppUser(MyAppUserDetails userDetails, MyAppTestContext testContext) {
        this.userDetails = userDetails;
        this.accountCreated = false;
        this.accountRegistered = false;
        this.testContext = testContext;
    }

    public String getUsername() {
        return this.userDetails.getUsername();
    }

    public void setUsername(String username) {
        this.userDetails.setUsername(username);
    }

    public String getPassword() {
        return this.userDetails.getPassword();
    }

    public void setPassword(String password) {
        this.userDetails.setPassword(password);
    }

    public String getEmail() {
        return this.userDetails.getEmail();
    }

    public void setEmail(String email) {
        this.userDetails.setEmail(email);
    }

    public String getUserRole() {
        return this.userDetails.getUserRole();
    }

    public void setUserRole(String userRole) {
        this.userDetails.setUserRole(userRole);
    }

    public MyAppTestContext getTestContext() {
        return this.testContext;
    }

    public void setAccountCreated(boolean accountCreated) {
        this.accountCreated = accountCreated;
    }

    public void setAccountRegistered(boolean accountRegistered) {
        this.accountRegistered = accountRegistered;
    }

    public LoginPage getLoginPage() {
        return this.testContext.getLoginPage();
    }

    public HomePage loginToMainPage() {
        if (!this.accountCreated) {
            this.createAccount();
        }
        if (!this.accountRegistered) {
            this.verifyAccount();
        }
        return (HomePage)((LoginPage)((Object)((LoginPage)((Object)this.getLoginPage().testUsernameField().sendKeys(new CharSequence[]{this.userDetails.getUsername()}))).testPasswordField().sendKeys(new CharSequence[]{this.userDetails.getPassword()}))).testSignInButton().click();
    }

    public <T extends PageModel<? super T>> T loginExpecting(Class<T> pageModel) {
        if (!this.accountCreated) {
            this.createAccount();
        }
        return (T)((LoginPage)((Object)((LoginPage)((Object)this.getLoginPage().testUsernameField().sendKeys(new CharSequence[]{this.userDetails.getUsername()}))).testPasswordField().sendKeys(new CharSequence[]{this.userDetails.getPassword()}))).testSignInButton().clickAnd().expectRedirect(pageModel);
    }

    public MyAppUser createAccount() {
        if (this.accountCreated) {
            return this;
        }
        this.accountCreated = true;
        return this;
    }

    public MyAppUser verifyAccount() {
        if (!this.accountCreated) {
            this.createAccount();
        }
        if (this.accountRegistered) {
            return this;
        }
        this.accountRegistered = true;
        return this;
    }
}

