package org.pagemodel.tests.myapp.pages;

import org.pagemodel.web.*;
import org.pagemodel.web.testers.*;
import org.pagemodel.core.testers.*;
import org.pagemodel.tools.*;
import java.util.function.Consumer;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public class HomePage extends MyAppInternalPage<HomePage> {
	public HomePage(ExtendedTestContext testContext) {
		super(testContext);
	}

	@Override
	protected Consumer<HomePage> testModelDisplayed() {
		return super.testModelDisplayed().andThen(page -> page
				.testHeaderDisplay().text().equals("MyApp Home")
				.testSiteStatusDisplay().isDisplayed()
				.testSiteVersionDisplay().isDisplayed()
				.testStatusDateDisplay().isDisplayed()
				.testUpdateStatusButton().isDisplayed());
	}

	// ================ begin protected web elements ==============
	protected LocatedWebElement getHeaderDisplay() {
		return findPageElement("HeaderDisplay", By.xpath("//h1[1]"));
	}

	protected LocatedWebElement getSiteStatusDisplay() {
		return findPageElement("SiteStatusDisplay", By.id("siteStatus"));
	}

	protected LocatedWebElement getSiteVersionDisplay() {
		return findPageElement("SiteVersionDisplay", By.id("siteVersion"));
	}

	protected LocatedWebElement getStatusDateDisplay() {
		return findPageElement("StatusDateDisplay", By.id("statusDate"));
	}

	protected LocatedWebElement getUpdateStatusButton() {
		return findPageElement("UpdateStatusButton", By.id("updateStatus"));
	}

	protected LocatedWebElement getNotificationDisplay(int notificationNum) {
		return findPageElement("NotificationDisplay", By.xpath("//div[@id='notifications']/div[" + notificationNum + "]"));
	}

	protected LocatedWebElement getNotificationDisplay(String title) {
		return findPageElement("NotificationDisplay", By.xpath("//div[@id='notifications']/div/div[1][text()='" + title + "']//parent::div"));
	}

	protected LocatedWebElement getItemReviewRow(String itemName) {
		return findPageElement("ItemReviewRow", By.xpath("//table[@id='itemReviewTable']/tbody/tr/td[1][text()='" + itemName + "']//parent::tr"));
	}
	// ================ end protected web elements ================

	// ================ begin public testers ======================
	public WebElementTester<HomePage, HomePage> testHeaderDisplay() {
		return new WebElementTester<>(ClickAction.make(this::getHeaderDisplay, this, getEvaluator()), getEvaluator());
	}

	public WebElementTester<HomePage, HomePage> testSiteStatusDisplay() {
		return new WebElementTester<>(ClickAction.make(this::getSiteStatusDisplay, this, getEvaluator()), getEvaluator());
	}

	public WebElementTester<HomePage, HomePage> testSiteVersionDisplay() {
		return new WebElementTester<>(ClickAction.make(this::getSiteVersionDisplay, this, getEvaluator()), getEvaluator());
	}

	public WebElementTester<HomePage, HomePage> testStatusDateDisplay() {
		return new WebElementTester<>(ClickAction.make(this::getStatusDateDisplay, this, getEvaluator()), getEvaluator());
	}

	public WebElementTester<HomePage, HomePage> testUpdateStatusButton() {
		return new WebElementTester<>(ClickAction.make(this::getUpdateStatusButton, this, getEvaluator()), getEvaluator());
	}

	public NotificationDialog<HomePage> testNotificationDisplay(int notificationNum) {
		return new NotificationDialog<>(ClickAction.make(() -> getNotificationDisplay(notificationNum), this, getEvaluator()), getEvaluator());
	}

	public NotificationDialog<HomePage> testNotificationDisplay(String title) {
		return new NotificationDialog<>(ClickAction.make(() -> getNotificationDisplay(title), this, getEvaluator()), getEvaluator());
	}

	public ItemReviewRow<HomePage> testItemReviewRow(String itemName) {
		return new ItemReviewRow<>(ClickAction.make(() -> getItemReviewRow(itemName), this, getEvaluator()), getEvaluator());
	}
	// ================ end public testers ========================


	public class NotificationDialog<R> extends ComponentModel<R,HomePage,NotificationDialog<R>> {
		public NotificationDialog(ClickAction<?, HomePage> clickAction, TestEvaluator testEvaluator) {
			super(clickAction, testEvaluator);
		}

		public NotificationDialog(R returnObj, ClickAction<?, HomePage> clickAction, TestEvaluator testEvaluator) {
			super(returnObj, clickAction, testEvaluator);
		}

		public class NotificationDialog_section extends NotificationDialog<NotificationDialog_section> {
			public NotificationDialog_section(ClickAction<?, HomePage> clickAction, TestEvaluator testEvaluator) {
				super(clickAction, testEvaluator);
				setReturnObj(this);
			}

			public HomePage testSectionParent() {
				return (HomePage)page;
			}
		}

		public NotificationDialog_section asSection(){
			return new NotificationDialog_section(clickAction, getEvaluator());
		}

		// ================ begin protected web elements ==============
		protected LocatedWebElement getTitleDisplay() {
			return findComponentElement("TitleDisplay", By.cssSelector("div:nth-child(1)"));
		}

		protected LocatedWebElement getMessageDisplay() {
			return findComponentElement("MessageDisplay", By.cssSelector("div:nth-child(2)"));
		}

		protected LocatedWebElement getDismissLink() {
			return findComponentElement("DismissLink", By.cssSelector("a.notif-dismiss"));
		}
		// ================ end protected web elements ================

		// ================ begin public testers ======================
		public WebElementTester<R, HomePage> testTitleDisplay() {
			return new WebElementTester<>(getReturnObj(), ClickAction.make(this::getTitleDisplay, (HomePage)page, getEvaluator()), getEvaluator());
		}

		public WebElementTester<R, HomePage> testMessageDisplay() {
			return new WebElementTester<>(getReturnObj(), ClickAction.make(this::getMessageDisplay, (HomePage)page, getEvaluator()), getEvaluator());
		}

		public WebElementTester<R, HomePage> testDismissLink() {
			return new WebElementTester<>(getReturnObj(), ClickAction.make(this::getDismissLink, (HomePage)page, getEvaluator()), getEvaluator());
		}
		// ================ end public testers ========================
	}


	public class ItemReviewRow<R> extends ComponentModel<R,HomePage,ItemReviewRow<R>> {
		public ItemReviewRow(ClickAction<?, HomePage> clickAction, TestEvaluator testEvaluator) {
			super(clickAction, testEvaluator);
		}

		public ItemReviewRow(R returnObj, ClickAction<?, HomePage> clickAction, TestEvaluator testEvaluator) {
			super(returnObj, clickAction, testEvaluator);
		}

		public class ItemReviewRow_section extends ItemReviewRow<ItemReviewRow_section> {
			public ItemReviewRow_section(ClickAction<?, HomePage> clickAction, TestEvaluator testEvaluator) {
				super(clickAction, testEvaluator);
				setReturnObj(this);
			}

			public HomePage testSectionParent() {
				return (HomePage)page;
			}
		}

		public ItemReviewRow_section asSection(){
			return new ItemReviewRow_section(clickAction, getEvaluator());
		}

		// ================ begin protected web elements ==============
		protected LocatedWebElement getNameDisplay() {
			return findComponentElement("NameDisplay", By.cssSelector("td:nth-child(1)"));
		}

		protected LocatedWebElement getStatusDropDown() {
			return findComponentElement("StatusDropDown", By.cssSelector("td:nth-child(2) > select"));
		}

		protected LocatedWebElement getRoutingDisplay() {
			return findComponentElement("RoutingDisplay", By.cssSelector("td:nth-child(3)"));
		}

		protected LocatedWebElement getUserDisplay() {
			return findComponentElement("UserDisplay", By.cssSelector("td:nth-child(4)"));
		}

		protected LocatedWebElement getSaveLink() {
			return findComponentElement("SaveLink", By.cssSelector("td:nth-child(5) > a"));
		}

		protected LocatedWebElement getDeleteLink() {
			return findComponentElement("DeleteLink", By.cssSelector("td:nth-child(6) > a"));
		}
		// ================ end protected web elements ================

		// ================ begin public testers ======================
		public WebElementTester<R, HomePage> testNameDisplay() {
			return new WebElementTester<>(getReturnObj(), ClickAction.make(this::getNameDisplay, (HomePage)page, getEvaluator()), getEvaluator());
		}

		public DropDownTester<R, HomePage> testStatusDropDown() {
			return new DropDownTester<>(getReturnObj(), ClickAction.make(this::getStatusDropDown, (HomePage)page, getEvaluator()), getEvaluator());
		}

		public WebElementTester<R, HomePage> testRoutingDisplay() {
			return new WebElementTester<>(getReturnObj(), ClickAction.make(this::getRoutingDisplay, (HomePage)page, getEvaluator()), getEvaluator());
		}

		public WebElementTester<R, HomePage> testUserDisplay() {
			return new WebElementTester<>(getReturnObj(), ClickAction.make(this::getUserDisplay, (HomePage)page, getEvaluator()), getEvaluator());
		}

		public WebElementTester<R, HomePage> testSaveLink() {
			return new WebElementTester<>(getReturnObj(), ClickAction.make(this::getSaveLink, (HomePage)page, getEvaluator()), getEvaluator());
		}

		public WebElementTester<R, HomePage> testDeleteLink() {
			return new WebElementTester<>(getReturnObj(), ClickAction.make(this::getDeleteLink, (HomePage)page, getEvaluator()), getEvaluator());
		}
		// ================ end public testers ========================
	}
}
