package org.pagemodel.tests.myapp.pages;

import org.pagemodel.web.*;
import org.pagemodel.web.testers.*;
import org.pagemodel.core.testers.*;
import org.pagemodel.tools.*;
import java.util.function.Consumer;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public class LoginPage extends ExtendedPageModel<LoginPage> {
	public LoginPage(ExtendedTestContext testContext) {
		super(testContext);
	}

	@Override
	protected Consumer<LoginPage> testModelDisplayed() {
		return super.testModelDisplayed().andThen(page -> page
				.testHeaderDisplay().text().equals("MyApp Login")
				.testUsernameField().isDisplayed()
				.testPasswordField().isDisplayed()
				.testSignInButton().isDisplayed());
	}

	// ================ begin protected web elements ==============
	protected LocatedWebElement getHeaderDisplay() {
		return findPageElement("HeaderDisplay", By.xpath("//h1[1]"));
	}

	protected LocatedWebElement getErrorDisplay() {
		return findPageElement("ErrorDisplay", By.id("errorMsgs"));
	}

	protected LocatedWebElement getUsernameField() {
		return findPageElement("UsernameField", By.id("username"));
	}

	protected LocatedWebElement getPasswordField() {
		return findPageElement("PasswordField", By.id("password"));
	}

	protected LocatedWebElement getSignInButton() {
		return findPageElement("SignInButton", By.id("signInButton"));
	}
	// ================ end protected web elements ================

	// ================ begin public testers ======================
	public WebElementTester<LoginPage, LoginPage> testHeaderDisplay() {
		return new WebElementTester<>(ClickAction.make(this::getHeaderDisplay, this, getEvaluator()), getEvaluator());
	}

	public WebElementTester<LoginPage, LoginPage> testErrorDisplay() {
		return new WebElementTester<>(ClickAction.make(this::getErrorDisplay, this, getEvaluator()), getEvaluator());
	}

	public WebElementTester<LoginPage, LoginPage> testUsernameField() {
		return new WebElementTester<>(ClickAction.make(this::getUsernameField, this, getEvaluator()), getEvaluator());
	}

	public WebElementTester<LoginPage, LoginPage> testPasswordField() {
		return new WebElementTester<>(ClickAction.make(this::getPasswordField, this, getEvaluator()), getEvaluator());
	}

	public WebElementTester<LoginPage, HomePage> testSignInButton() {
		return new WebElementTester<>(ClickAction.makeNav(this::getSignInButton, this, HomePage.class, getEvaluator()), getEvaluator());
	}
	// ================ end public testers ========================
}
