package org.pagemodel.tests.myapp.pages;

import org.pagemodel.web.*;
import org.pagemodel.web.testers.*;
import org.pagemodel.core.testers.*;
import org.pagemodel.tools.*;
import java.util.function.Consumer;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public class ManageUsersPage extends MyAppInternalPage<ManageUsersPage> {
	public ManageUsersPage(ExtendedTestContext testContext) {
		super(testContext);
	}

	@Override
	protected Consumer<ManageUsersPage> testModelDisplayed() {
		return super.testModelDisplayed().andThen(page -> page
				.testHeaderDisplay().text().equals("MyApp Manage Users")
				.testAddUserButton().isDisplayed());
	}

	// ================ begin protected web elements ==============
	protected LocatedWebElement getHeaderDisplay() {
		return findPageElement("HeaderDisplay", By.xpath("//h1[1]"));
	}

	protected LocatedWebElement getAddUserButton() {
		return findPageElement("AddUserButton", By.id("addUser"));
	}

	protected LocatedWebElement getUserRow(String username) {
		return findPageElement("UserRow", By.xpath("//table[@id='userTable']/tbody/tr/td[contains(@class,'username') and text()='" + username + "']//parent::tr"));
	}

	protected LocatedWebElement getAddUserDialog() {
		return findPageElement("AddUserDialog", By.id("addUserDialog"));
	}
	// ================ end protected web elements ================

	// ================ begin public testers ======================
	public WebElementTester<ManageUsersPage, ManageUsersPage> testHeaderDisplay() {
		return new WebElementTester<>(ClickAction.make(this::getHeaderDisplay, this, getEvaluator()), getEvaluator());
	}

	public WebElementTester<ManageUsersPage, AddUserSection> testAddUserButton() {
		return new WebElementTester<>(ClickAction.makeNav(this::getAddUserButton, this, testAddUserDialog(), getEvaluator()), getEvaluator());
	}

	public UserRow<ManageUsersPage> testUserRow(String username) {
		return new UserRow<>(ClickAction.make(() -> getUserRow(username), this, getEvaluator()), getEvaluator());
	}

	public AddUserSection testAddUserDialog() {
		return new AddUserSection(ClickAction.make(this::getAddUserDialog, this, getEvaluator()), getEvaluator());
	}
	// ================ end public testers ========================


	public class UserRow<R> extends ComponentModel<R,ManageUsersPage,UserRow<R>> {
		public UserRow(ClickAction<?, ManageUsersPage> clickAction, TestEvaluator testEvaluator) {
			super(clickAction, testEvaluator);
		}

		public UserRow(R returnObj, ClickAction<?, ManageUsersPage> clickAction, TestEvaluator testEvaluator) {
			super(returnObj, clickAction, testEvaluator);
		}

		public class UserRow_section extends UserRow<UserRow_section> {
			public UserRow_section(ClickAction<?, ManageUsersPage> clickAction, TestEvaluator testEvaluator) {
				super(clickAction, testEvaluator);
				setReturnObj(this);
			}

			public ManageUsersPage testSectionParent() {
				return (ManageUsersPage)page;
			}
		}

		public UserRow_section asSection(){
			return new UserRow_section(clickAction, getEvaluator());
		}

		// ================ begin protected web elements ==============
		protected LocatedWebElement getUsernameDisplay() {
			return findComponentElement("UsernameDisplay", By.cssSelector("td.username"));
		}

		protected LocatedWebElement getEmailDisplay() {
			return findComponentElement("EmailDisplay", By.cssSelector("td.emailAddress"));
		}

		protected LocatedWebElement getRoleDisplay() {
			return findComponentElement("RoleDisplay", By.cssSelector("td.role"));
		}

		protected LocatedWebElement getDeleteButton() {
			return findComponentElement("DeleteButton", By.cssSelector("td.delete > input"));
		}
		// ================ end protected web elements ================

		// ================ begin public testers ======================
		public WebElementTester<R, ManageUsersPage> testUsernameDisplay() {
			return new WebElementTester<>(getReturnObj(), ClickAction.make(this::getUsernameDisplay, (ManageUsersPage)page, getEvaluator()), getEvaluator());
		}

		public WebElementTester<R, ManageUsersPage> testEmailDisplay() {
			return new WebElementTester<>(getReturnObj(), ClickAction.make(this::getEmailDisplay, (ManageUsersPage)page, getEvaluator()), getEvaluator());
		}

		public WebElementTester<R, ManageUsersPage> testRoleDisplay() {
			return new WebElementTester<>(getReturnObj(), ClickAction.make(this::getRoleDisplay, (ManageUsersPage)page, getEvaluator()), getEvaluator());
		}

		public WebElementTester<R, ManageUsersPage> testDeleteButton() {
			return new WebElementTester<>(getReturnObj(), ClickAction.make(this::getDeleteButton, (ManageUsersPage)page, getEvaluator())
					.withAlertAccept(), getEvaluator());
		}
		// ================ end public testers ========================
	}


	public class AddUserSection extends ExtendedSectionModel<AddUserSection, ManageUsersPage ,AddUserSection> {
		public AddUserSection(ClickAction<ManageUsersPage, ManageUsersPage> clickAction, TestEvaluator testEvaluator) {
			super(clickAction, testEvaluator);
		}

		// ================ begin protected web elements ==============
		protected LocatedWebElement getUsernameField() {
			return findComponentElement("UsernameField", By.id("newUserName"));
		}

		protected LocatedWebElement getEmailField() {
			return findComponentElement("EmailField", By.id("newUserEmail"));
		}

		protected LocatedWebElement getAdminCheckbox() {
			return findComponentElement("AdminCheckbox", By.id("newUserAdmin"));
		}

		protected LocatedWebElement getPasswordField() {
			return findComponentElement("PasswordField", By.id("newUserPassword"));
		}

		protected LocatedWebElement getPasswordConfirmField() {
			return findComponentElement("PasswordConfirmField", By.id("newUserPasswordConfirm"));
		}

		protected LocatedWebElement getCancelButton() {
			return findComponentElement("CancelButton", By.id("newUserCancel"));
		}

		protected LocatedWebElement getSaveButton() {
			return findComponentElement("SaveButton", By.id("newUserSave"));
		}
		// ================ end protected web elements ================

		// ================ begin public testers ======================
		public WebElementTester<AddUserSection, AddUserSection> testUsernameField() {
			return new WebElementTester<>(ClickAction.make(this::getUsernameField, this, getEvaluator()), getEvaluator());
		}

		public WebElementTester<AddUserSection, AddUserSection> testEmailField() {
			return new WebElementTester<>(ClickAction.make(this::getEmailField, this, getEvaluator()), getEvaluator());
		}

		public CheckboxTester<AddUserSection, AddUserSection> testAdminCheckbox() {
			return new CheckboxTester<>(ClickAction.make(this::getAdminCheckbox, this, getEvaluator()), getEvaluator());
		}

		public WebElementTester<AddUserSection, AddUserSection> testPasswordField() {
			return new WebElementTester<>(ClickAction.make(this::getPasswordField, this, getEvaluator()), getEvaluator());
		}

		public WebElementTester<AddUserSection, AddUserSection> testPasswordConfirmField() {
			return new WebElementTester<>(ClickAction.make(this::getPasswordConfirmField, this, getEvaluator()), getEvaluator());
		}

		public WebElementTester<AddUserSection, ManageUsersPage> testCancelButton() {
			return new WebElementTester<>(ClickAction.makeNav(this::getCancelButton, this, ManageUsersPage.class, getEvaluator()), getEvaluator());
		}

		public WebElementTester<AddUserSection, ManageUsersPage> testSaveButton() {
			return new WebElementTester<>(ClickAction.makeNav(this::getSaveButton, this, ManageUsersPage.class, getEvaluator()), getEvaluator());
		}
		// ================ end public testers ========================
	}
}
