/*
 * Decompiled with CFR 0.152.
 */
package org.pagemodel.tools;

import java.util.function.Consumer;
import org.pagemodel.core.TestContext;
import org.pagemodel.core.testers.TestEvaluator;
import org.pagemodel.core.utils.ThrowingFunction;
import org.pagemodel.core.utils.json.JsonObjectBuilder;
import org.pagemodel.mail.MailTester;
import org.pagemodel.ssh.SSHConnectionTester;
import org.pagemodel.ssh.SSHTestContext;
import org.pagemodel.tools.Experimental;
import org.pagemodel.tools.ExtendedPageTester;
import org.pagemodel.tools.ExtendedTestContext;
import org.pagemodel.web.PageModel;

public interface ExtendedModelBase<P extends ExtendedModelBase<? super P>>
extends PageModel<P> {
    public ExtendedTestContext getContext();

    default public MailTester<P> testMail() {
        return new MailTester((TestContext)this.getContext(), (Object)this, (TestEvaluator)new TestEvaluator.Now());
    }

    default public SSHConnectionTester<P> testSSH() {
        return new SSHConnectionTester((Object)this, (SSHTestContext)this.getContext(), this.getEvaluator());
    }

    default public P testSSH(ThrowingFunction<? super SSHConnectionTester<P>, P, ?> sshAction) {
        return (P)((ExtendedModelBase)new SSHConnectionTester((Object)this, (SSHTestContext)this.getContext(), this.getEvaluator()).doAction(sshAction));
    }

    public ExtendedPageTester<P> testPage();

    @Experimental
    default public P log(String message) {
        this.getEvaluator().logMessage(message);
        return (P)this;
    }

    @Experimental
    default public P log(String action, Consumer<JsonObjectBuilder> eventParams) {
        this.getEvaluator().logEvent("Log", action, eventParams);
        return (P)this;
    }
}

