/*
 * Decompiled with CFR 0.152.
 */
package org.pagemodel.tools;

import java.util.function.Consumer;
import org.openqa.selenium.WebDriver;
import org.pagemodel.core.TestContext;
import org.pagemodel.core.testers.ComparableTester;
import org.pagemodel.core.testers.StringTester;
import org.pagemodel.core.testers.TesterHelper;
import org.pagemodel.core.utils.TestRuntimeException;
import org.pagemodel.core.utils.json.JsonObjectBuilder;
import org.pagemodel.mail.MailTestContext;
import org.pagemodel.ssh.SSHAuthenticator;
import org.pagemodel.ssh.SSHTestContext;
import org.pagemodel.tools.Experimental;
import org.pagemodel.tools.WebDriverConfig;
import org.pagemodel.tools.WebDriverFactory;
import org.pagemodel.web.DefaultWebTestContext;
import org.pagemodel.web.utils.PageException;

public class ExtendedTestContext
extends DefaultWebTestContext
implements SSHTestContext,
MailTestContext {
    public static String DEFAULT_BROWSER = "headless";
    private WebDriverConfig webDriverConfig;
    protected SSHAuthenticator sshAuthenticator;

    public ExtendedTestContext(WebDriver driver, SSHAuthenticator sshAuthenticator, WebDriverConfig webDriverConfig) {
        super(driver);
        this.sshAuthenticator = sshAuthenticator;
        if (webDriverConfig == null) {
            webDriverConfig = WebDriverConfig.local(DEFAULT_BROWSER);
        }
        this.webDriverConfig = webDriverConfig;
    }

    private void openBrowser(String url) {
        if (this.getDriver() != null) {
            this.quit();
        }
        this.setDriver(WebDriverFactory.create(this.webDriverConfig, url));
    }

    protected void openPage(String url) {
        this.openBrowser(url);
    }

    protected void openPageRetry(String url, int retries) {
        while (retries > 0) {
            try {
                this.openBrowser(url);
                return;
            }
            catch (Throwable t) {
                if (retries <= 0) {
                    throw t;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ex) {
                    throw new TestRuntimeException((TestContext)this, (Throwable)ex);
                }
                --retries;
            }
        }
    }

    public SSHAuthenticator getSshAuthenticator() {
        return this.sshAuthenticator;
    }

    public void setSshAuthenticator(SSHAuthenticator sshAuthenticator) {
        this.sshAuthenticator = sshAuthenticator;
    }

    public PageException createException(String message, Throwable cause) {
        return this.createException(this.getLogExceptions(), message, cause);
    }

    @Experimental
    public <T extends StringTester<T>> T testString(String string) {
        StringTester tester = new StringTester(() -> string, (Object)null, (TestContext)this, this.getEvaluator());
        TesterHelper.setReturn((StringTester)tester, (Object)tester);
        return (T)tester;
    }

    @Experimental
    public <T extends StringTester<T>> T testStoredString(String key) {
        return this.testString((String)this.load(key));
    }

    @Experimental
    public <T extends ComparableTester<C, T>, C extends Comparable<C>> T testComparable(C value) {
        ComparableTester tester = new ComparableTester(() -> value, (Object)null, (TestContext)this, this.getEvaluator());
        TesterHelper.setReturn((ComparableTester)tester, (Object)tester);
        return (T)tester;
    }

    @Experimental
    public <T extends ComparableTester<C, T>, C extends Comparable<C>> T testStoredComparable(Class<C> clazz, String key) {
        return this.testComparable((Comparable)this.load(clazz, key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Experimental
    public boolean ignoreException(Runnable action) {
        boolean logExceptions = this.getLogExceptions();
        this.setLogExceptions(false);
        try {
            action.run();
            boolean bl = true;
            return bl;
        }
        catch (Throwable throwable) {
        }
        finally {
            this.setLogExceptions(logExceptions);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Experimental
    public Throwable catchException(Runnable action) {
        boolean logExceptions = this.getLogExceptions();
        this.setLogExceptions(false);
        try {
            action.run();
        }
        catch (Throwable t) {
            Throwable throwable = t;
            return throwable;
        }
        finally {
            this.setLogExceptions(logExceptions);
        }
        return null;
    }

    @Experimental
    public void log(String message) {
        this.getEvaluator().logMessage(message);
    }

    @Experimental
    public void log(String message, Throwable t) {
        this.getEvaluator().logException(message, t);
    }

    @Experimental
    public void log(String action, Consumer<JsonObjectBuilder> eventParams) {
        this.getEvaluator().logEvent("Log", action, eventParams);
    }
}

