/*
 * Decompiled with CFR 0.152.
 */
package org.pagemodel.tools;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileMap<T> {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static Map<Class<?>, Map<String, ?>> profileDefaults = new HashMap();
    protected Class<T> type;
    protected Map<String, T> profileMap;

    public static <T> void addDefaults(Class<T> clazz, Map<String, T> defaults) {
        if (defaults == null) {
            profileDefaults.remove(clazz);
        }
        if (!profileDefaults.containsKey(clazz)) {
            profileDefaults.put(clazz, defaults);
        } else {
            profileDefaults.get(clazz).putAll(defaults);
        }
    }

    public static <T> ProfileMap<T> loadFile(Class<T> type, String filePath) {
        try {
            ProfileMap<T> profileMap = new ProfileMap<T>(type);
            profileMap.profileMap.putAll(profileMap.loadConfigMapFile(filePath));
            return profileMap;
        }
        catch (IOException ex) {
            throw new RuntimeException("Error: unable to load profiles.", ex);
        }
    }

    public static <T> ProfileMap<T> loadStream(Class<T> type, InputStream input) {
        ProfileMap<T> profileMap = new ProfileMap<T>(type);
        profileMap.profileMap.putAll(profileMap.loadConfigMapStream(input));
        return profileMap;
    }

    private static <T> void registerDefaultProfiles(Class<T> type) {
        if (profileDefaults.containsKey(type)) {
            return;
        }
        try {
            type.getMethod("registerDefaultProfiles", new Class[0]).invoke(type, new Object[0]);
        }
        catch (NoSuchMethodException ex) {
            profileDefaults.put(type, new HashMap());
        }
        catch (Exception ex) {
            profileDefaults.put(type, new HashMap());
            log.info("Exception registering default profiles for type [" + type.getName() + "]", (Throwable)ex);
        }
    }

    public static <T> ProfileMap<T> loadUrl(Class<T> type, String url) {
        try {
            ProfileMap<T> profileMap = new ProfileMap<T>(type);
            profileMap.profileMap.putAll(profileMap.loadConfigMapUrl(url));
            return profileMap;
        }
        catch (IOException ex) {
            throw new RuntimeException("Error: unable to load profiles.", ex);
        }
    }

    protected ProfileMap(Class<T> type) {
        this.type = type;
        this.profileMap = new HashMap<String, T>();
        ProfileMap.registerDefaultProfiles(type);
        if (profileDefaults.containsKey(type)) {
            this.profileMap.putAll(profileDefaults.get(type));
        }
    }

    public T getProfile(String profile) {
        return this.profileMap.get(profile);
    }

    public Map<String, T> getProfileMap() {
        return this.profileMap;
    }

    protected T loadJsonFile(String configPath) throws FileNotFoundException {
        FileReader reader = new FileReader(configPath);
        return (T)new Gson().fromJson((Reader)reader, this.type);
    }

    protected T loadJsonURL(String urlStr) throws IOException {
        InputStreamReader reader = new InputStreamReader(new URL(urlStr).openStream());
        return (T)new Gson().fromJson((Reader)reader, this.type);
    }

    protected Map<String, T> loadConfigMapFile(String configPath) throws FileNotFoundException {
        return this.loadConfigMapFromReader(new FileReader(configPath));
    }

    protected Map<String, T> loadConfigMapStream(InputStream input) {
        return this.loadConfigMapFromReader(new InputStreamReader(input));
    }

    protected Map<String, T> loadConfigMapUrl(String urlStr) throws IOException {
        return this.loadConfigMapFromReader(new InputStreamReader(new URL(urlStr).openStream()));
    }

    private Map<String, T> loadConfigMapFromReader(Reader reader) {
        Type typeOfHashMap = TypeToken.getParameterized(Map.class, (Type[])new Type[]{String.class, this.type}).getType();
        return (Map)new Gson().fromJson(reader, typeOfHashMap);
    }
}

