/*
 * Decompiled with CFR 0.152.
 */
package org.pagemodel.tools.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.net.ssl.HttpsURLConnection;
import org.pagemodel.core.TestContext;
import org.pagemodel.core.testers.ComparableTester;
import org.pagemodel.core.testers.StringTester;
import org.pagemodel.core.testers.TestEvaluator;
import org.pagemodel.tools.http.HttpTester;

public class HttpResponseTester<R> {
    private final TestContext testContext;
    private HttpsURLConnection connection;
    private HttpTester<?> parent;
    private TestEvaluator testEvaluator;

    public HttpResponseTester(HttpsURLConnection connection, HttpTester<?> parent, TestContext testContext, TestEvaluator testEvaluator) {
        this.connection = connection;
        this.testContext = testContext;
        this.parent = parent;
        this.testEvaluator = testEvaluator;
    }

    protected TestEvaluator getEvaluator() {
        return this.testEvaluator;
    }

    public ComparableTester<Integer, HttpResponseTester<R>> testResponseCode() {
        return new ComparableTester(() -> this.connection.getResponseCode(), (Object)this, this.testContext, this.getEvaluator());
    }

    public StringTester<HttpResponseTester<R>> testResponseBody() {
        StringBuilder builder = new StringBuilder();
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(this.connection.getInputStream()));
            String aux = "";
            while ((aux = br.readLine()) != null) {
                builder.append(aux);
            }
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String body = builder.toString();
        return new StringTester(() -> body, (Object)this, this.testContext, this.getEvaluator());
    }

    public R disconnect() {
        return (R)this.parent.disconnect();
    }
}

