/*
 * Decompiled with CFR 0.152.
 */
package org.pagemodel.tools;

import org.pagemodel.core.TestContext;
import org.pagemodel.core.testers.StringTester;
import org.pagemodel.core.testers.TestEvaluator;
import org.pagemodel.tools.accessibility.AXEScanner;
import org.pagemodel.web.PageModel;
import org.pagemodel.web.WebTestContext;
import org.pagemodel.web.testers.DimensionTester;
import org.pagemodel.web.testers.PageTester;
import org.pagemodel.web.testers.PageTesterBase;
import org.pagemodel.web.testers.PointTester;
import org.pagemodel.web.testers.WebElementTester;

public class ExtendedPageTester<P extends PageModel<? super P>>
extends PageTester<P> {
    public ExtendedPageTester(P page, WebTestContext testContext, TestEvaluator testEvaluator) {
        super(page, testContext, testEvaluator);
    }

    public WebElementTester<P, P> testFocusedElement() {
        return super.testFocusedElement();
    }

    public WebElementTester<P, P> testHTMLElement() {
        return super.testHTMLElement();
    }

    public WebElementTester<P, P> testBodyElement() {
        return super.testBodyElement();
    }

    public PageTesterBase.PageWait<P> waitFor() {
        return super.waitFor();
    }

    public PageTesterBase<P> waitAndRefreshFor() {
        return super.waitAndRefreshFor();
    }

    public P setWindowSize(int width, int height) {
        return (P)super.setWindowSize(width, height);
    }

    public P maximizeWindow() {
        return (P)super.maximizeWindow();
    }

    public P fullscreenWindow() {
        return (P)super.fullscreenWindow();
    }

    public P setWindowPosition(int x, int y) {
        return (P)super.setWindowPosition(x, y);
    }

    public P moveWindowPositionByOffset(int offsetX, int offsetY) {
        return (P)super.moveWindowPositionByOffset(offsetX, offsetY);
    }

    public P takeScreenshot(String filePrefix) {
        return (P)super.takeScreenshot(filePrefix);
    }

    public <T extends PageModel<? super T>> T testPageModel(Class<T> clazz) {
        return (T)super.testPageModel(clazz);
    }

    public <T extends PageModel<? super T>> T navigateTo(String url, Class<T> clazz) {
        return (T)super.navigateTo(url, clazz);
    }

    public StringTester<P> title() {
        return super.title();
    }

    public StringTester<P> url() {
        return super.url();
    }

    public StringTester<P> pageSource() {
        return super.pageSource();
    }

    public DimensionTester<P> windowSize() {
        return super.windowSize();
    }

    public PointTester<P> windowPosition() {
        return super.windowPosition();
    }

    public P testAccessibility() {
        return this.testAccessibility(30);
    }

    public P testAccessibility(int timeoutSec) {
        return (P)((PageModel)this.getEvaluator().testCondition("accessibility", op -> op.addValue("model", (Object)this.page.getClass().getSimpleName()), () -> new AXEScanner().analyzeAccessibility(this.testContext, this.page.getClass().getSimpleName(), timeoutSec), (Object)this.page, (TestContext)this.testContext));
    }

    public P testAccessibility(String ... expectedViolations) {
        return this.testAccessibility(30, expectedViolations);
    }

    public P testAccessibility(int timeoutSec, String ... expectedViolations) {
        return (P)((PageModel)this.getEvaluator().testCondition("accessibility", op -> op.addValue("expectedViolations", (Object)String.join((CharSequence)", ", expectedViolations)).addValue("model", (Object)this.page.getClass().getSimpleName()), () -> {
            AXEScanner scanner = new AXEScanner();
            scanner.setExpectedViolations(expectedViolations);
            return scanner.analyzeAccessibility(this.testContext, this.page.getClass().getSimpleName(), timeoutSec);
        }, (Object)this.page, (TestContext)this.testContext));
    }
}

