/*
 * Decompiled with CFR 0.152.
 */
package org.pagemodel.tools;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.chrome.ChromeOptions;
import org.pagemodel.core.utils.json.JsonBuilder;
import org.pagemodel.core.utils.json.JsonObjectBuilder;
import org.pagemodel.tools.ProfileMap;

public class WebDriverConfig {
    private String remoteUrl;
    private Map<String, Object> capabilities;
    private transient MutableCapabilities caps;

    public static void registerDefaultProfiles() {
        HashMap<String, WebDriverConfig> defaultProfile = new HashMap<String, WebDriverConfig>();
        ChromeOptions chromeOpts = new ChromeOptions();
        chromeOpts.addArguments(new String[]{"--ignore-certificate-errors", "--disable-dev-shm-usage", "--silent", "--log-level=3"});
        defaultProfile.put("chrome", WebDriverConfig.local("chrome", chromeOpts.asMap()));
        ChromeOptions chromeHeadlessOpts = new ChromeOptions();
        chromeHeadlessOpts.addArguments(new String[]{"--ignore-certificate-errors", "--disable-dev-shm-usage", "--silent", "--log-level=3", "--headless", "--disable-gpu", "--window-size=1920,1080"});
        defaultProfile.put("headless", WebDriverConfig.local("chrome", chromeHeadlessOpts.asMap()));
        defaultProfile.put("firefox", WebDriverConfig.local("firefox"));
        defaultProfile.put("edge", WebDriverConfig.local("edge"));
        defaultProfile.put("ie", WebDriverConfig.local("ie"));
        defaultProfile.put("safari", WebDriverConfig.local("safari"));
        defaultProfile.put("opera", WebDriverConfig.local("opera"));
        defaultProfile.put("operablink", WebDriverConfig.local("operablink"));
        defaultProfile.put("htmlunit", WebDriverConfig.local("htmlunit"));
        ProfileMap.addDefaults(WebDriverConfig.class, defaultProfile);
    }

    public static WebDriverConfig local(String browser) {
        WebDriverConfig webDriverConfig = new WebDriverConfig();
        webDriverConfig.caps = new MutableCapabilities();
        webDriverConfig.caps.setCapability("browserName", browser);
        webDriverConfig.capabilities = new TreeMap<String, Object>(webDriverConfig.caps.asMap());
        return webDriverConfig;
    }

    public static WebDriverConfig local(String browser, Map<String, Object> capabilities) {
        WebDriverConfig webDriverConfig = new WebDriverConfig();
        webDriverConfig.caps = new MutableCapabilities();
        webDriverConfig.caps.setCapability("browserName", browser);
        for (Map.Entry<String, Object> entry : capabilities.entrySet()) {
            webDriverConfig.caps.setCapability(entry.getKey(), entry.getValue());
        }
        webDriverConfig.capabilities = new TreeMap<String, Object>(webDriverConfig.caps.asMap());
        return webDriverConfig;
    }

    public String getRemoteUrl() {
        return this.remoteUrl;
    }

    public void setRemoteUrl(String remoteUrl) {
        this.remoteUrl = remoteUrl;
    }

    public MutableCapabilities getCapabilities() {
        if (this.caps == null) {
            this.caps = new MutableCapabilities(this.capabilities);
        }
        return this.caps;
    }

    public void setCapabilities(MutableCapabilities capabilities) {
        this.capabilities = capabilities.asMap();
        this.caps = capabilities;
    }

    public void updateField(String field, Consumer<JsonObjectBuilder> objUpdate) {
        this.caps = null;
        JsonBuilder.object(this.capabilities).updateObject(field, objUpdate);
    }

    public void setField(String field, Object value) {
        this.caps = null;
        this.capabilities.put(field, value);
    }

    public JsonObjectBuilder modify() {
        this.caps = null;
        return JsonBuilder.object(this.capabilities);
    }
}

