/*
 * Decompiled with CFR 0.152.
 */
package org.pagemodel.tools;

import com.google.gson.Gson;
import io.github.bonigarcia.wdm.WebDriverManager;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.openqa.selenium.By;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeDriverService;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.edge.EdgeDriver;
import org.openqa.selenium.edge.EdgeOptions;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.ie.InternetExplorerOptions;
import org.openqa.selenium.opera.OperaDriver;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.LocalFileDetector;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.safari.SafariDriver;
import org.openqa.selenium.safari.SafariOptions;
import org.pagemodel.core.TestContext;
import org.pagemodel.core.testers.TestEvaluator;
import org.pagemodel.core.utils.json.JsonLogConsoleOut;
import org.pagemodel.tools.WebDriverConfig;
import org.pagemodel.web.DefaultWebTestContext;
import org.pagemodel.web.utils.PageException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WebDriverFactory {
    private static final Logger log = LoggerFactory.getLogger(WebDriverFactory.class);
    public static final int DEFAULT_PAGE_LOAD_TIMEOUT_SECONDS = 20;
    public static final int DEFAULT_IMPLICITLY_WAIT_MILLISECONDS = 0;
    public static final int DEFAULT_SCRIPT_TIMEOUT_SECONDS = 20;
    public static final String DOWNLOAD_DIRECTORY;
    private static final Map<String, Function<MutableCapabilities, WebDriver>> browserFactoryMap;

    @Deprecated
    public static WebDriver open(String browser, String url) {
        WebDriverConfig webDriverConfig = WebDriverConfig.local(browser);
        return WebDriverFactory.create(webDriverConfig, url);
    }

    public static WebDriver create(WebDriverConfig config, String url) {
        WebDriver driver;
        Consumer event;
        TestEvaluator.Now eval = new TestEvaluator.Now();
        if (config.getRemoteUrl() != null) {
            event = eval.getExecuteEvent("open url", op -> op.addValue("value", (Object)url).addValue("remoteUrl", (Object)config.getRemoteUrl()).addValue("capabilities", (Object)config.getCapabilities().toJson()));
            eval.logEvent(event);
            driver = WebDriverFactory.getRemoteWebDriver(config.getRemoteUrl(), (Capabilities)config.getCapabilities());
        } else {
            event = eval.getEventJson("Execute", "open url", op -> op.addValue("value", (Object)url).addValue("capabilities", (Object)config.getCapabilities().toJson()));
            eval.logEvent(event);
            driver = WebDriverFactory.getWebDriver(config.getCapabilities());
        }
        try {
            driver.get(url);
            WebDriverFactory.clickThroughCertErrorPage(driver);
        }
        catch (Throwable e) {
            WebDriverFactory.close(driver);
            throw new PageException((TestContext)new DefaultWebTestContext(driver), JsonLogConsoleOut.formatEvent((Consumer)event));
        }
        return driver;
    }

    public static void close(WebDriver driver) {
        if (driver == null) {
            return;
        }
        TestEvaluator.Now eval = new TestEvaluator.Now();
        eval.logEvent("Execute", "close driver", op -> op.addValue("url", (Object)driver.getCurrentUrl()));
        try {
            driver.close();
            driver.quit();
        }
        catch (Throwable e) {
            log.trace("Exception caught closing WebDriver.", e);
        }
    }

    private static void clickThroughCertErrorPage(WebDriver driver) {
        if (driver.getPageSource().contains("overridelink")) {
            driver.findElement(By.id((String)"overridelink")).click();
        }
    }

    public static WebDriver getWebDriver(MutableCapabilities capabilities) {
        String browser = capabilities.getBrowserName();
        if (!browserFactoryMap.containsKey(browser)) {
            throw new RuntimeException("Error: Unknown browser type [" + browser + "].  Available browser types are: " + Arrays.toString(browserFactoryMap.keySet().toArray(new String[0])));
        }
        try {
            WebDriver driver = browserFactoryMap.get(browser).apply(capabilities);
            driver.manage().timeouts().pageLoadTimeout(20L, TimeUnit.SECONDS);
            driver.manage().timeouts().implicitlyWait(0L, TimeUnit.MILLISECONDS);
            driver.manage().timeouts().setScriptTimeout(20L, TimeUnit.SECONDS);
            return driver;
        }
        catch (Exception ex) {
            throw new RuntimeException("Error: Unable to open browser with type [" + browser + "]", ex);
        }
    }

    public static RemoteWebDriver getRemoteWebDriver(String remoteURL, Capabilities caps) {
        try {
            RemoteWebDriver driver = new RemoteWebDriver(new URL(remoteURL), caps);
            driver.setFileDetector((FileDetector)new LocalFileDetector());
            return driver;
        }
        catch (MalformedURLException e) {
            log.error("Could not open web driver to remote URL: " + remoteURL, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static WebDriver openChrome(MutableCapabilities capabilities) {
        WebDriverManager.chromedriver().setup();
        ChromeOptions options = WebDriverFactory.loadChromeOptions((Capabilities)capabilities);
        ChromeDriverService driverService = ChromeDriverService.createDefaultService();
        ChromeDriver driver = new ChromeDriver(driverService, options);
        if (new Gson().toJson((Object)capabilities.toJson()).contains("--headless")) {
            String command = "{" + "\"cmd\":\"Page.setDownloadBehavior\"" + "," + "\"params\":{" + ("\"downloadPath\":\"" + DOWNLOAD_DIRECTORY + "\"") + "," + "\"behavior\":\"allow\"" + "}" + "}";
            CloseableHttpClient httpClient = HttpClientBuilder.create().build();
            try {
                String u = driverService.getUrl().toString() + "/session/" + driver.getSessionId() + "/chromium/send_command";
                HttpPost request = new HttpPost(u);
                request.addHeader("content-type", "application/json");
                request.setEntity((HttpEntity)new StringEntity(command));
                httpClient.execute((HttpUriRequest)request);
            }
            catch (Exception ex) {
                log.error("Error starting chrome headless", (Throwable)ex);
                throw new RuntimeException(ex);
            }
        }
        return driver;
    }

    protected static ChromeOptions loadChromeOptions(Capabilities capabilities) {
        Object chromeOptObj;
        if (ChromeOptions.class.isAssignableFrom(capabilities.getClass())) {
            return (ChromeOptions)capabilities;
        }
        ChromeOptions options = new ChromeOptions().merge(capabilities);
        Map capMap = capabilities.asMap();
        if (capMap.containsKey("goog:chromeOptions") && Map.class.isAssignableFrom((chromeOptObj = capMap.get("goog:chromeOptions")).getClass())) {
            Map chromeOptMap = (Map)chromeOptObj;
            for (Map.Entry entry : chromeOptMap.entrySet()) {
                if (entry.getKey().equals("args")) {
                    Object args;
                    if (String[].class.isAssignableFrom(entry.getValue().getClass())) {
                        args = (String[])entry.getValue();
                        options.addArguments(args);
                        continue;
                    }
                    if (!List.class.isAssignableFrom(entry.getValue().getClass())) continue;
                    args = (List)entry.getValue();
                    options.addArguments((List)args);
                    continue;
                }
                if (entry.getKey().equals("binary")) {
                    if (!String.class.isAssignableFrom(entry.getValue().getClass())) continue;
                    String binary = (String)entry.getValue();
                    options.setBinary(binary);
                    continue;
                }
                if (entry.getKey().equals("extensions")) {
                    Object extensions;
                    if (String[].class.isAssignableFrom(entry.getValue().getClass())) {
                        extensions = (String[])entry.getValue();
                        options.addEncodedExtensions(extensions);
                        continue;
                    }
                    if (!List.class.isAssignableFrom(entry.getValue().getClass())) continue;
                    extensions = (List)entry.getValue();
                    options.addEncodedExtensions((List)extensions);
                    continue;
                }
                if (!String.class.isAssignableFrom(entry.getKey().getClass())) continue;
                options.setExperimentalOption((String)entry.getKey(), entry.getValue());
            }
        }
        options.setCapability("browserName", "chrome");
        return options;
    }

    private static WebDriver openChromeHeadless(Capabilities capabilities) {
        ChromeOptions options = WebDriverFactory.loadChromeOptions(capabilities);
        options.setHeadless(true);
        return WebDriverFactory.openChrome((MutableCapabilities)options);
    }

    private static WebDriver openFirefox(Capabilities capabilities) {
        WebDriverManager.firefoxdriver().setup();
        FirefoxOptions options = new FirefoxOptions(capabilities);
        return new FirefoxDriver(options);
    }

    private static WebDriver openInternetExplorer(Capabilities capabilities) {
        WebDriverManager.iedriver().setup();
        InternetExplorerOptions options = new InternetExplorerOptions(capabilities);
        return new InternetExplorerDriver(options);
    }

    private static WebDriver openEdge(Capabilities capabilities) {
        WebDriverManager.edgedriver().setup();
        return new EdgeDriver(new EdgeOptions().merge(capabilities));
    }

    private static WebDriver openOpera(Capabilities capabilities) {
        WebDriverManager.operadriver().setup();
        return new OperaDriver(capabilities);
    }

    private static WebDriver openSafari(Capabilities capabilities) {
        SafariOptions options = new SafariOptions(capabilities);
        return new SafariDriver(options);
    }

    private static WebDriver openHtmlUnit(Capabilities capabilities) {
        return new HtmlUnitDriver(true);
    }

    static {
        browserFactoryMap = new HashMap<String, Function<MutableCapabilities, WebDriver>>();
        String home = System.getProperty("user.home");
        DOWNLOAD_DIRECTORY = home + "/Downloads";
        System.setProperty("webdriver.chrome.silentOutput", "true");
        browserFactoryMap.put("chrome", WebDriverFactory::openChrome);
        browserFactoryMap.put("headless", WebDriverFactory::openChromeHeadless);
        browserFactoryMap.put("firefox", WebDriverFactory::openFirefox);
        browserFactoryMap.put("ie", WebDriverFactory::openInternetExplorer);
        browserFactoryMap.put("edge", WebDriverFactory::openEdge);
        browserFactoryMap.put("safari", WebDriverFactory::openSafari);
        browserFactoryMap.put("opera", WebDriverFactory::openOpera);
        browserFactoryMap.put("operablink", WebDriverFactory::openOpera);
        browserFactoryMap.put("htmlunit", WebDriverFactory::openHtmlUnit);
    }
}

