/*
 * Decompiled with CFR 0.152.
 */
package org.pagemodel.tools.accessibility;

import com.deque.axe.AXE;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONObject;
import org.pagemodel.core.testers.TestEvaluator;
import org.pagemodel.web.WebTestContext;
import org.pagemodel.web.utils.Screenshot;

public class AXEScanner {
    protected static final URL SCRIPT_URL = AXEScanner.class.getClassLoader().getResource("axe.min.js");
    public static final int DEFAULT_TIMEOUT = 30;
    public static final String LOG_DIR = "build/accessibility/";
    private static boolean SCREENSHOT_FLAG = true;
    private List<String> expectedViolations = Collections.EMPTY_LIST;

    public void setExpectedViolations(String ... expectedViolations) {
        this.expectedViolations = Arrays.asList(expectedViolations);
    }

    public void clearExpectedViolations() {
        this.setExpectedViolations(new String[0]);
    }

    public static void setScreenshotFlag(boolean val) {
        SCREENSHOT_FLAG = val;
    }

    public static boolean getScreenshotFlag() {
        return SCREENSHOT_FLAG;
    }

    public <T> boolean analyzeAccessibility(WebTestContext testContext, String testName) {
        return this.analyzeAccessibility(testContext, testName, LOG_DIR, 30);
    }

    public <T> boolean analyzeAccessibility(WebTestContext testContext, String testName, int timeoutSec) {
        return this.analyzeAccessibility(testContext, testName, LOG_DIR, timeoutSec);
    }

    public <T> boolean analyzeAccessibility(WebTestContext testContext, String testName, String logDir, int timeoutSec) {
        File destFolder = new File(logDir);
        if (!destFolder.exists()) {
            destFolder.mkdirs();
        }
        String outFileName = this.convertTestNameToFileName(testName);
        if (AXEScanner.getScreenshotFlag()) {
            Screenshot.takeScreenshot((WebTestContext)testContext, (String)outFileName);
        }
        testContext.getDriver().manage().timeouts().implicitlyWait(0L, TimeUnit.SECONDS);
        JSONObject responseJSON = new AXE.Builder(testContext.getDriver(), SCRIPT_URL).setTimeout(timeoutSec).analyze();
        JSONArray violation = responseJSON.getJSONArray("violations");
        ArrayList<String> foundExpectedViolations = new ArrayList<String>();
        ArrayList<String> foundViolations = new ArrayList<String>();
        if (violation.length() != 0) {
            boolean passScan = true;
            for (int i = 0; i < violation.length(); ++i) {
                String violationName = violation.getJSONObject(i).getString("help");
                if (!this.expectedViolations.contains(violationName)) {
                    passScan = false;
                    foundViolations.add(violationName);
                    continue;
                }
                foundExpectedViolations.add(violationName);
            }
            TestEvaluator eval = testContext.getEvaluator();
            if (!foundExpectedViolations.isEmpty()) {
                eval.logEvent("Assert", "ignore expected violations", obj -> obj.addValue("value", (Object)String.join((CharSequence)", ", foundExpectedViolations)));
            }
            if (!foundViolations.isEmpty()) {
                eval.logEvent("Error", "accessibility violations", obj -> obj.addValue("value", (Object)String.join((CharSequence)", ", foundViolations)));
            }
            if (!passScan) {
                AXE.writeResults((String)(logDir + "/" + outFileName + "_" + System.currentTimeMillis()), (Object)violation);
                return false;
            }
        }
        return true;
    }

    private String convertTestNameToFileName(String testName) {
        return testName.replaceAll("[^a-zA-Z0-9]+", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAXEVersion() {
        BufferedReader reader = null;
        try {
            String line;
            URLConnection connection = SCRIPT_URL.openConnection();
            reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while ((line = reader.readLine()) != null) {
                if (!line.matches(".*aXe v([0-9]\\.?)+.*")) continue;
                String string = line.substring(line.indexOf("aXe v")).trim();
                return string;
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return "unknown";
    }
}

