/*
 * Decompiled with CFR 0.152.
 */
package org.pagemodel.tools.http;

import java.lang.invoke.MethodHandles;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;
import org.pagemodel.core.TestContext;
import org.pagemodel.core.testers.TestEvaluator;
import org.pagemodel.tools.http.HttpResponseTester;
import org.pagemodel.tools.http.TrustModifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpTester<R> {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected HttpResponseTester<R> responseTester;
    protected R returnObj;
    private final TestContext testContext;
    private HttpsURLConnection con;
    private TestEvaluator testEvaluator;

    public HttpTester(R returnObj, TestContext testContext, TestEvaluator testEvaluator) {
        this.testContext = testContext;
        this.returnObj = returnObj;
        this.con = null;
        this.testEvaluator = testEvaluator;
    }

    protected TestEvaluator getEvaluator() {
        return this.testEvaluator;
    }

    public HttpResponseTester<HttpTester<R>> testSend(String fullUrl) {
        log.info("Calling api at " + fullUrl);
        try {
            URL url = new URL(fullUrl);
            this.con = (HttpsURLConnection)url.openConnection();
            TrustModifier.relaxHostChecking(this.con);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new HttpResponseTester<HttpTester<R>>(this.con, this, this.testContext, this.getEvaluator());
    }

    public R disconnect() {
        this.con.disconnect();
        return this.returnObj;
    }
}

