/*
 * Decompiled with CFR 0.152.
 */
package pd;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.NoSuchElementException;
import pd.DataFrame$;
import pd.DataMap;
import pd.DataMap$;
import pd.Order;
import pd.Order$;
import pd.Series;
import pd.Series$;
import pd.Settings$;
import pd.exception.ColumnNotFoundException$;
import pd.exception.IllegalOperation$;
import pd.exception.IndexBoundsException$;
import pd.exception.MergeIndexException$;
import pd.exception.Requirement;
import pd.exception.Requirement$;
import pd.implicits.SeriesString$DefaultOrder$;
import pd.internal.index.BaseIndex;
import pd.internal.index.ColIndex$package$ColIndex$;
import pd.internal.index.IndexOps;
import pd.internal.index.UniformIndex;
import pd.internal.index.sort.Sorting;
import pd.internal.index.sort.Sorting$;
import pd.internal.series.SeriesData;
import pd.internal.utils.ConstantIterator;
import pd.internal.utils.RequireType;
import pd.internal.utils.StringUtils$;
import pd.io.WriteAdapter;
import pd.plot.Plot;
import pd.plot.Plot$;
import scala.Dynamic;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.MapOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq;
import scala.collection.immutable.SeqMap;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.TypeTest;
import scala.reflect.TypeTest$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class DataFrame
implements IndexOps<DataFrame>,
Dynamic {
    private final SeqMap colIndex;
    private final BaseIndex index;

    public static DataFrame applyDynamic(String string, Seq<Object> seq) {
        return DataFrame$.MODULE$.applyDynamic(string, seq);
    }

    public static DataFrame applyDynamicNamed(String string, Seq<Tuple2<String, Series<?>>> seq) {
        return DataFrame$.MODULE$.applyDynamicNamed(string, seq);
    }

    public static DataFrame create(SeqMap seqMap, BaseIndex baseIndex) {
        return DataFrame$.MODULE$.create(seqMap, baseIndex);
    }

    public static DataFrame empty() {
        return DataFrame$.MODULE$.empty();
    }

    public static DataFrame fromSeries(Seq<Series<?>> seq, boolean bl) {
        return DataFrame$.MODULE$.fromSeries(seq, bl);
    }

    public static DataFrame fromSeries(Series<?> series) {
        return DataFrame$.MODULE$.fromSeries(series);
    }

    public DataFrame(SeqMap colIndex, BaseIndex index) {
        this.colIndex = colIndex;
        this.index = index;
    }

    public SeqMap colIndex() {
        return this.colIndex;
    }

    @Override
    public BaseIndex index() {
        return this.index;
    }

    public <T> DataFrame concat(Series<T> series) {
        DataFrame dataFrame;
        if (this.index() == series.index()) {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)series.name());
            DataFrame dataFrame2 = new DataFrame((SeqMap)this.colIndex().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, series.data())), this.index());
            dataFrame = dataFrame2;
        } else {
            int n = this.index().includes(series.index());
            switch (n) {
                case 0: {
                    String string = (String)Predef$.MODULE$.ArrowAssoc((Object)series.name());
                    DataFrame dataFrame3 = new DataFrame((SeqMap)this.colIndex().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, series.data())), this.index());
                    dataFrame = dataFrame3;
                    break;
                }
                case 1: {
                    String string = (String)Predef$.MODULE$.ArrowAssoc((Object)series.name());
                    DataFrame dataFrame4 = new DataFrame((SeqMap)this.colIndex().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, series.data().maskIndex(series.index()))), this.index());
                    dataFrame = dataFrame4;
                    break;
                }
                case -1: {
                    throw MergeIndexException$.MODULE$.apply(series);
                }
                default: {
                    throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
                }
            }
        }
        return dataFrame;
    }

    public <T> DataFrame concat(Tuple2<String, Series<T>> namedSeries) {
        return this.concat(((Series)namedSeries._2()).as((String)namedSeries._1()));
    }

    public DataFrame concat(DataFrame df) {
        DataFrame dataFrame;
        if (this.index() == df.index()) {
            dataFrame = new DataFrame((SeqMap)this.colIndex().$plus$plus((IterableOnce)df.colIndex()), this.index());
        } else {
            int n = this.index().includes(df.index());
            switch (n) {
                case 0: {
                    dataFrame = new DataFrame((SeqMap)this.colIndex().$plus$plus((IterableOnce)df.colIndex()), this.index());
                    break;
                }
                case 1: {
                    dataFrame = new DataFrame((SeqMap)this.colIndex().$plus$plus((IterableOnce)df.colIndex().map((Function1 & Serializable)x$1 -> {
                        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)DataFrame._$1$1(x$1));
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, DataFrame._$2$1(x$1).maskIndex(df.index()));
                    })), this.index());
                    break;
                }
                case -1: {
                    throw MergeIndexException$.MODULE$.apply(df);
                }
                default: {
                    throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
                }
            }
        }
        return dataFrame;
    }

    public <T> DataFrame prepend(Series<T> series) {
        DataFrame dataFrame;
        if (this.index() == series.index()) {
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)series.name());
            DataFrame dataFrame2 = new DataFrame(ColIndex$package$ColIndex$.MODULE$.ColMapOps(this.colIndex()).prepend(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, series.data())), this.index());
            dataFrame = dataFrame2;
        } else {
            int n = this.index().includes(series.index());
            switch (n) {
                case 0: {
                    String string = (String)Predef$.MODULE$.ArrowAssoc((Object)series.name());
                    DataFrame dataFrame3 = new DataFrame(ColIndex$package$ColIndex$.MODULE$.ColMapOps(this.colIndex()).prepend(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, series.data())), this.index());
                    dataFrame = dataFrame3;
                    break;
                }
                case 1: {
                    String string = (String)Predef$.MODULE$.ArrowAssoc((Object)series.name());
                    DataFrame dataFrame4 = new DataFrame(ColIndex$package$ColIndex$.MODULE$.ColMapOps(this.colIndex()).prepend(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, series.data().maskIndex(series.index()))), this.index());
                    dataFrame = dataFrame4;
                    break;
                }
                case -1: {
                    throw MergeIndexException$.MODULE$.apply(series);
                }
                default: {
                    throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
                }
            }
        }
        return dataFrame;
    }

    public DataFrame prepend(DataFrame df) {
        DataFrame dataFrame;
        if (this.index() == df.index()) {
            dataFrame = new DataFrame((SeqMap)df.colIndex().$plus$plus((IterableOnce)this.colIndex()), this.index());
        } else {
            int n = this.index().includes(df.index());
            switch (n) {
                case 0: {
                    dataFrame = new DataFrame((SeqMap)df.colIndex().$plus$plus((IterableOnce)this.colIndex()), this.index());
                    break;
                }
                case 1: {
                    dataFrame = new DataFrame((SeqMap)((MapOps)df.colIndex().map((Function1 & Serializable)x$1 -> {
                        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)DataFrame._$3$1(x$1));
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, DataFrame._$4$1(x$1).maskIndex(df.index()));
                    })).$plus$plus((IterableOnce)this.colIndex()), this.index());
                    break;
                }
                case -1: {
                    throw MergeIndexException$.MODULE$.apply(this);
                }
                default: {
                    throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
                }
            }
        }
        return dataFrame;
    }

    public <T> DataFrame update(Tuple2<String, Series<T>> namedSeries) {
        return this.updateOperator(((Series)namedSeries._2()).as((String)namedSeries._1()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> DataFrame updateOperator(Series<T> series) {
        DataFrame dataFrame;
        if (this.contains(series.name())) {
            if (this.index() != series.index() && this.index().includes(series.index()) == -1) throw MergeIndexException$.MODULE$.apply(series);
            dataFrame = this.concat(this.apply(series.name()).update(series.toAny()));
            return dataFrame;
        } else {
            dataFrame = this.concat(series);
        }
        return dataFrame;
    }

    public <T> DataFrame append(String name, Series<T> series) {
        return this.contains(name) ? this : this.concat(series.as(name));
    }

    public DataFrame append(Seq<Series<?>> series) {
        return this.cols().applyDynamic("apply", (Seq<Object>)((Seq)series.filterNot((Function1 & Serializable)s -> this.contains(s.name()))));
    }

    public Series<Object> apply(String col) {
        return Series$.MODULE$.apply((SeriesData)this.inline$colIndex().getOrElse((Object)col, () -> this.apply$$anonfun$1(col)), this.index(), col);
    }

    public <T> Option<T> apply(int row, String col, RequireType<T> evidence$1, TypeTest<Object, T> evidence$2, ClassTag<T> evidence$3) {
        return this.apply(col).as(evidence$2, evidence$3).apply(row);
    }

    public <T> Option<T> apply(Option<Object> row, String col, RequireType<T> evidence$4, TypeTest<Object, T> evidence$5, ClassTag<T> evidence$6) {
        return this.apply(col).as(evidence$5, evidence$6).apply(row);
    }

    public <T> T apply(int row, String col, Function0<T> function0, TypeTest<Object, T> evidence$7, ClassTag<T> evidence$8) {
        Object object;
        Series<T> Series_this = this.apply(col).as(evidence$7, evidence$8);
        BaseIndex BaseIndex_this = Series_this.inline$index();
        if (row < 0 || row >= BaseIndex_this.base().length()) {
            throw IndexBoundsException$.MODULE$.apply(row, BaseIndex_this.base().length());
        }
        if (BaseIndex_this.isContained(row)) {
            SeriesData<T> SeriesData_this = Series_this.inline$data();
            if (SeriesData_this.inline$mask() == null || SeriesData_this.inline$mask()[row]) {
                SeriesData<T> SeriesData_this2 = Series_this.inline$data();
                object = ScalaRunTime$.MODULE$.array_apply(SeriesData_this2.inline$vector(), row);
            } else {
                object = DataFrame.default$proxy1$1(function0);
            }
        } else {
            object = DataFrame.default$proxy1$1(function0);
        }
        return (T)object;
    }

    /*
     * Enabled aggressive block sorting
     */
    public <T> T apply(Option<Object> row, String col, Function0<T> function0, TypeTest<Object, T> evidence$9, ClassTag<T> evidence$10) {
        Object object;
        Series<T> Series_this = this.apply(col).as(evidence$9, evidence$10);
        if (row.isDefined()) {
            int ix$proxy1 = BoxesRunTime.unboxToInt((Object)row.get());
            BaseIndex BaseIndex_this = Series_this.inline$index();
            if (ix$proxy1 < 0) throw IndexBoundsException$.MODULE$.apply(ix$proxy1, BaseIndex_this.base().length());
            if (ix$proxy1 >= BaseIndex_this.base().length()) throw IndexBoundsException$.MODULE$.apply(ix$proxy1, BaseIndex_this.base().length());
            if (BaseIndex_this.isContained(ix$proxy1)) {
                int i = BoxesRunTime.unboxToInt((Object)row.get());
                SeriesData<T> SeriesData_this = Series_this.inline$data();
                if (SeriesData_this.inline$mask() == null || SeriesData_this.inline$mask()[i]) {
                    SeriesData<T> SeriesData_this2 = Series_this.inline$data();
                    object = ScalaRunTime$.MODULE$.array_apply(SeriesData_this2.inline$vector(), i);
                    return (T)object;
                }
                object = DataFrame.default$proxy2$1(function0);
                return (T)object;
            }
        }
        object = DataFrame.default$proxy2$1(function0);
        return (T)object;
    }

    public Series<Object> apply(Range range, String col) {
        return (Series)this.apply(col).apply(range);
    }

    public Series<Object> apply(Seq<Object> seq, String col) {
        return (Series)this.apply(col).apply((Seq)seq);
    }

    public Series<Object> apply(int[] array, String col) {
        return (Series)this.apply(col).apply(array);
    }

    public Series<Object> apply(Series<Object> series, String col) {
        return (Series)this.apply(col).apply((Series)series);
    }

    public DataFrame applyCols(Seq<String> cols) {
        if (!cols.forall((Function1 & Serializable)col -> this.contains((String)col))) {
            throw ColumnNotFoundException$.MODULE$.apply(this, (Seq<String>)((Seq)cols.filterNot((Function1 & Serializable)col -> this.contains((String)col))));
        }
        return new DataFrame(ColIndex$package$ColIndex$.MODULE$.toMap((Seq)cols.map((Function1 & Serializable)c -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc(c);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, this.colIndex().apply(c));
        })), this.index());
    }

    public <T> DataFrame col(Series<T> series) {
        return this.concat(series);
    }

    public <T> DataFrame col(String col, Series<T> series) {
        return this.concat(series.as(col));
    }

    public Series<Object>[] columnArray() {
        return (Series[])this.columnIterator().toArray(ClassTag$.MODULE$.apply(Series.class));
    }

    public Iterable<Series<Object>> columnIterator() {
        return (Iterable)this.colIndex().map((Function1 & Serializable)c -> Series$.MODULE$.apply((SeriesData)c._2(), this.index(), (String)c._1()));
    }

    public Seq<String> columns() {
        return this.colIndex().keys().toSeq();
    }

    public DataFrameAppender cols() {
        return new DataFrameAppender(this);
    }

    public boolean contains(String col) {
        return this.colIndex().contains((Object)col);
    }

    public boolean canEqual(Object a) {
        return a instanceof DataFrame;
    }

    public void display(int n, int width, int colWidth) {
        Predef$.MODULE$.println((Object)this.toString(n, width, this.toString$default$3(), this.toString$default$4(), colWidth, this.toString$default$6()));
    }

    public int display$default$1() {
        return Settings$.MODULE$.printRowLength();
    }

    public int display$default$2() {
        return Settings$.MODULE$.printWidth();
    }

    public int display$default$3() {
        return Settings$.MODULE$.printColWidth();
    }

    public DataFrame dropUndefined() {
        return this.dropUndefined(this.columns());
    }

    public DataFrame dropUndefined(Seq<String> cols) {
        return cols.isEmpty() ? this : this.withIndex((BaseIndex)((IterableOnceOps)cols.tail()).foldLeft((Object)this.apply((String)cols.head()).defined().index(), (Function2 & Serializable)(idx, col) -> Series$.MODULE$.apply((SeriesData)this.inline$colIndex().getOrElse(col, () -> this.dropUndefined$$anonfun$2$$anonfun$1(col)), (BaseIndex)idx, (String)col).defined().index()));
    }

    public boolean equals(Object df) {
        DataFrame df2;
        Object object = df;
        return object instanceof DataFrame ? (df2 = (DataFrame)object).canEqual(this) && this.index().equals(df2.index()) && this.colIndex().size() == df2.colIndex().size() && this.columns().forall((Function1 & Serializable)c -> df2.contains((String)c) && this.apply((String)c).equals(df2.apply((String)c))) : false;
    }

    public <T> T get(int row, String col, RequireType<T> evidence$11, TypeTest<Object, T> evidence$12, ClassTag<T> evidence$13) {
        Object object;
        Series<T> Series_this = this.apply(col).as(evidence$12, evidence$13);
        try {
            BaseIndex BaseIndex_this = Series_this.inline$index();
            if (row < 0 || row >= BaseIndex_this.base().length()) {
                throw IndexBoundsException$.MODULE$.apply(row, BaseIndex_this.base().length());
            }
            if (BaseIndex_this.isContained(row)) {
                SeriesData<T> SeriesData_this = Series_this.inline$data();
                if (!(SeriesData_this.inline$mask() == null || SeriesData_this.inline$mask()[row])) {
                    throw new NoSuchElementException("No value for index position " + row + ".");
                }
            } else {
                throw new NoSuchElementException("Invalid index position " + row + ".");
            }
            SeriesData<T> SeriesData_this = Series_this.inline$data();
            object = ScalaRunTime$.MODULE$.array_apply(SeriesData_this.inline$vector(), row);
        }
        catch (Throwable throwable) {
            throw new NoSuchElementException("Invalid index position " + row + ".");
        }
        return (T)object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> T get(Option<Object> row, String col, RequireType<T> evidence$14, TypeTest<Object, T> evidence$15, ClassTag<T> evidence$16) {
        Series<T> Series_this = this.apply(col).as(evidence$15, evidence$16);
        try {
            if (!row.isDefined()) throw new NoSuchElementException("Invalid index position " + row + ".");
            int ix$proxy2 = BoxesRunTime.unboxToInt((Object)row.get());
            BaseIndex BaseIndex_this = Series_this.inline$index();
            if (ix$proxy2 < 0 || ix$proxy2 >= BaseIndex_this.base().length()) {
                throw IndexBoundsException$.MODULE$.apply(ix$proxy2, BaseIndex_this.base().length());
            }
            if (!BaseIndex_this.isContained(ix$proxy2)) throw new NoSuchElementException("Invalid index position " + row + ".");
            int i = BoxesRunTime.unboxToInt((Object)row.get());
            SeriesData<T> SeriesData_this = Series_this.inline$data();
            if (!(SeriesData_this.inline$mask() == null || SeriesData_this.inline$mask()[i])) {
                throw new NoSuchElementException("No value for index position " + i + ".");
            }
            SeriesData<T> SeriesData_this2 = Series_this.inline$data();
            Object object = ScalaRunTime$.MODULE$.array_apply(SeriesData_this2.inline$vector(), i);
            return (T)object;
        }
        catch (Throwable throwable) {
            throw new NoSuchElementException("Invalid index position " + row + ".");
        }
    }

    public DataMap.Groups<Object> groupBy(String col) {
        return this.indexBy(col, TypeTest$.MODULE$.identity(), ClassTag$.MODULE$.Any()).groups();
    }

    public DataMap.Groups<Tuple2<Object, Object>> groupBy(String col1, String col2) {
        return this.indexBy(col1, col2, TypeTest$.MODULE$.identity(), ClassTag$.MODULE$.Any(), TypeTest$.MODULE$.identity(), ClassTag$.MODULE$.Any()).groups();
    }

    public DataMap.Groups<Tuple3<Object, Object, Object>> groupBy(String col1, String col2, String col3) {
        return this.indexBy(col1, col2, col3, TypeTest$.MODULE$.identity(), ClassTag$.MODULE$.Any(), TypeTest$.MODULE$.identity(), ClassTag$.MODULE$.Any(), TypeTest$.MODULE$.identity(), ClassTag$.MODULE$.Any()).groups();
    }

    public DataMap.Groups<Seq<Object>> groupBy(Seq<String> cols) {
        if (cols.isEmpty()) {
            throw IllegalOperation$.MODULE$.oneColumnGrouping();
        }
        Seq data = (Seq)cols.map((Function1 & Serializable)_$5 -> this.apply((String)_$5).data());
        return DataMap$.MODULE$.apply(this.dropUndefined(cols), (String[])cols.toArray(ClassTag$.MODULE$.apply(String.class)), (Function1 & Serializable)ix -> DataFrame.groupBy$$anonfun$2(data, BoxesRunTime.unboxToInt((Object)ix))).groups();
    }

    public <T> DataMap.Groups<T> groupByCol(String col, TypeTest<Object, T> evidence$17, ClassTag<T> evidence$18) {
        return this.indexBy(col, evidence$17, evidence$18).groups();
    }

    public <T1, T2> DataMap.Groups<Tuple2<T1, T2>> groupByCol(String col1, String col2, TypeTest<Object, T1> evidence$19, ClassTag<T1> evidence$20, TypeTest<Object, T2> evidence$21, ClassTag<T2> evidence$22) {
        return this.indexBy(col1, col2, evidence$19, evidence$20, evidence$21, evidence$22).groups();
    }

    public <T1, T2, T3> DataMap.Groups<Tuple3<T1, T2, T3>> groupByCol(String col1, String col2, String col3, TypeTest<Object, T1> evidence$23, ClassTag<T1> evidence$24, TypeTest<Object, T2> evidence$25, ClassTag<T2> evidence$26, TypeTest<Object, T3> evidence$27, ClassTag<T3> evidence$28) {
        return this.indexBy(col1, col2, col3, evidence$23, evidence$24, evidence$25, evidence$26, evidence$27, evidence$28).groups();
    }

    public <T> DataMap.Groups<Option<T>> groupByColOption(String col, TypeTest<Object, T> evidence$29, ClassTag<T> evidence$30) {
        return this.indexByOption(col, evidence$29, evidence$30).groups();
    }

    public <T1, T2> DataMap.Groups<Tuple2<Option<T1>, Option<T2>>> groupByColOption(String col1, String col2, TypeTest<Object, T1> evidence$31, ClassTag<T1> evidence$32, TypeTest<Object, T2> evidence$33, ClassTag<T2> evidence$34) {
        return this.indexByOption(col1, col2, evidence$31, evidence$32, evidence$33, evidence$34).groups();
    }

    public <T1, T2, T3> DataMap.Groups<Tuple3<Option<T1>, Option<T2>, Option<T3>>> groupByColOption(String col1, String col2, String col3, TypeTest<Object, T1> evidence$35, ClassTag<T1> evidence$36, TypeTest<Object, T2> evidence$37, ClassTag<T2> evidence$38, TypeTest<Object, T3> evidence$39, ClassTag<T3> evidence$40) {
        return this.indexByOption(col1, col2, col3, evidence$35, evidence$36, evidence$37, evidence$38, evidence$39, evidence$40).groups();
    }

    public DataMap.Groups<Option<Object>> groupByOption(String col) {
        return this.indexByOption(col, TypeTest$.MODULE$.identity(), ClassTag$.MODULE$.Any()).groups();
    }

    public DataMap.Groups<Tuple2<Option<Object>, Option<Object>>> groupByOption(String col1, String col2) {
        return this.indexByOption(col1, col2, TypeTest$.MODULE$.identity(), ClassTag$.MODULE$.Any(), TypeTest$.MODULE$.identity(), ClassTag$.MODULE$.Any()).groups();
    }

    public DataMap.Groups<Tuple3<Option<Object>, Option<Object>, Option<Object>>> groupByOption(String col1, String col2, String col3) {
        return this.indexByOption(col1, col2, col3, TypeTest$.MODULE$.identity(), ClassTag$.MODULE$.Any(), TypeTest$.MODULE$.identity(), ClassTag$.MODULE$.Any(), TypeTest$.MODULE$.identity(), ClassTag$.MODULE$.Any()).groups();
    }

    public DataMap.Groups<Seq<Option<Object>>> groupByOption(Seq<String> cols) {
        if (cols.isEmpty()) {
            throw IllegalOperation$.MODULE$.oneColumnGrouping();
        }
        Seq data = (Seq)cols.map((Function1 & Serializable)_$7 -> this.apply((String)_$7).data());
        return DataMap$.MODULE$.apply(this, (String[])cols.toArray(ClassTag$.MODULE$.apply(String.class)), (Function1 & Serializable)ix -> DataFrame.groupByOption$$anonfun$2(data, BoxesRunTime.unboxToInt((Object)ix))).groups();
    }

    public <T> DataMap<T> indexBy(String col, TypeTest<Object, T> evidence$41, ClassTag<T> evidence$42) {
        SeriesData data = this.apply(col).as(evidence$41, evidence$42).data();
        return DataMap$.MODULE$.apply(this.dropUndefined((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{col})), new String[]{col}, (Function1 & Serializable)ix -> DataFrame.indexBy$$anonfun$1(data, BoxesRunTime.unboxToInt((Object)ix)));
    }

    public <T1, T2> DataMap<Tuple2<T1, T2>> indexBy(String col1, String col2, TypeTest<Object, T1> evidence$43, ClassTag<T1> evidence$44, TypeTest<Object, T2> evidence$45, ClassTag<T2> evidence$46) {
        SeriesData data1 = this.apply(col1).as(evidence$43, evidence$44).data();
        SeriesData data2 = this.apply(col2).as(evidence$45, evidence$46).data();
        return DataMap$.MODULE$.apply(this.dropUndefined((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{col1, col2})), new String[]{col1, col2}, (Function1 & Serializable)ix -> DataFrame.indexBy$$anonfun$2(data1, data2, BoxesRunTime.unboxToInt((Object)ix)));
    }

    public <T1, T2, T3> DataMap<Tuple3<T1, T2, T3>> indexBy(String col1, String col2, String col3, TypeTest<Object, T1> evidence$47, ClassTag<T1> evidence$48, TypeTest<Object, T2> evidence$49, ClassTag<T2> evidence$50, TypeTest<Object, T3> evidence$51, ClassTag<T3> evidence$52) {
        SeriesData data1 = this.apply(col1).as(evidence$47, evidence$48).data();
        SeriesData data2 = this.apply(col2).as(evidence$49, evidence$50).data();
        SeriesData data3 = this.apply(col3).as(evidence$51, evidence$52).data();
        return DataMap$.MODULE$.apply(this.dropUndefined((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{col1, col2, col3})), new String[]{col1, col2, col3}, (Function1 & Serializable)ix -> DataFrame.indexBy$$anonfun$3(data1, data2, data3, BoxesRunTime.unboxToInt((Object)ix)));
    }

    public DataMap<Seq<Object>> indexBy(Seq<String> cols) {
        if (cols.isEmpty()) {
            throw IllegalOperation$.MODULE$.apply("Indexing, grouping or joining requires at least one column.");
        }
        Seq data = (Seq)cols.map((Function1 & Serializable)_$9 -> this.apply((String)_$9).data());
        return DataMap$.MODULE$.apply(this.dropUndefined(cols), (String[])cols.toArray(ClassTag$.MODULE$.apply(String.class)), (Function1 & Serializable)ix -> DataFrame.indexBy$$anonfun$5(data, BoxesRunTime.unboxToInt((Object)ix)));
    }

    public <T> DataMap<Option<T>> indexByOption(String col, TypeTest<Object, T> evidence$53, ClassTag<T> evidence$54) {
        SeriesData data = this.apply(col).as(evidence$53, evidence$54).data();
        return DataMap$.MODULE$.apply(this, new String[]{col}, (Function1 & Serializable)ix -> DataFrame.indexByOption$$anonfun$1(data, BoxesRunTime.unboxToInt((Object)ix)));
    }

    public <T1, T2> DataMap<Tuple2<Option<T1>, Option<T2>>> indexByOption(String col1, String col2, TypeTest<Object, T1> evidence$55, ClassTag<T1> evidence$56, TypeTest<Object, T2> evidence$57, ClassTag<T2> evidence$58) {
        SeriesData data1 = this.apply(col1).as(evidence$55, evidence$56).data();
        SeriesData data2 = this.apply(col2).as(evidence$57, evidence$58).data();
        return DataMap$.MODULE$.apply(this, new String[]{col1, col2}, (Function1 & Serializable)ix -> DataFrame.indexByOption$$anonfun$2(data1, data2, BoxesRunTime.unboxToInt((Object)ix)));
    }

    public <T1, T2, T3> DataMap<Tuple3<Option<T1>, Option<T2>, Option<T3>>> indexByOption(String col1, String col2, String col3, TypeTest<Object, T1> evidence$59, ClassTag<T1> evidence$60, TypeTest<Object, T2> evidence$61, ClassTag<T2> evidence$62, TypeTest<Object, T3> evidence$63, ClassTag<T3> evidence$64) {
        SeriesData data1 = this.apply(col1).as(evidence$59, evidence$60).data();
        SeriesData data2 = this.apply(col2).as(evidence$61, evidence$62).data();
        SeriesData data3 = this.apply(col3).as(evidence$63, evidence$64).data();
        return DataMap$.MODULE$.apply(this, new String[]{col1, col2, col3}, (Function1 & Serializable)ix -> DataFrame.indexByOption$$anonfun$3(data1, data2, data3, BoxesRunTime.unboxToInt((Object)ix)));
    }

    public Iterator<Object> indexIterator() {
        return this.index().iterator();
    }

    public String info() {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("DataFrame with columns\n       |" + ((IterableOnceOps)this.colIndex().map((Function1 & Serializable)c -> "  " + c._1() + " " + ((SeriesData)c._2()).typeDescription(((SeriesData)c._2()).typeDescription$default$1()))).mkString("\n") + "\n       |and a " + this.index().describe() + "\n       |"));
    }

    public WriteAdapter io() {
        return new WriteAdapter(this);
    }

    public DataFrame joinInner(DataFrame df, Seq<String> cols) {
        DataMap<Seq<Object>> left = this.indexBy(cols);
        DataMap<Seq<Object>> right = df.indexBy(cols);
        ArrayBuilder builderLeft = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(Integer.TYPE));
        ArrayBuilder builderRight = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(Integer.TYPE));
        DataMap$.MODULE$.join(left, right, (ArrayBuilder<Object>)builderLeft, (ArrayBuilder<Object>)builderRight, true, false);
        return DataMap$.MODULE$.buildJoin(left, right, (int[])builderLeft.result(), (int[])builderRight.result());
    }

    public DataFrame joinLeft(DataFrame df, Seq<String> cols) {
        DataMap<Seq<Object>> left = this.indexBy(cols);
        DataMap<Seq<Object>> right = df.indexBy(cols);
        ArrayBuilder builderLeft = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(Integer.TYPE));
        ArrayBuilder builderRight = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(Integer.TYPE));
        DataMap$.MODULE$.join(left, right, (ArrayBuilder<Object>)builderLeft, (ArrayBuilder<Object>)builderRight, true, true);
        int[] nullRows = this.undefinedIndices(cols);
        builderLeft.addAll((Object)nullRows);
        builderRight.addAll((IterableOnce)new ConstantIterator(-1, nullRows.length));
        return DataMap$.MODULE$.buildJoin(left, right, (int[])builderLeft.result(), (int[])builderRight.result());
    }

    public DataFrame joinOuter(DataFrame df, Seq<String> cols) {
        DataMap<Seq<Object>> left = this.indexBy(cols);
        DataMap<Seq<Object>> right = df.indexBy(cols);
        return DataFrame$.MODULE$.union((Seq<DataFrame>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DataFrame[]{this.leftJoin$1(cols, left, right), DataFrame.rightJoinWithoutInner$1(df, cols, left, right)}));
    }

    public DataFrame joinRight(DataFrame df, Seq<String> cols) {
        DataMap<Seq<Object>> left = this.indexBy(cols);
        DataMap<Seq<Object>> right = df.indexBy(cols);
        ArrayBuilder builderLeft = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(Integer.TYPE));
        ArrayBuilder builderRight = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(Integer.TYPE));
        DataMap$.MODULE$.join(right, left, (ArrayBuilder<Object>)builderRight, (ArrayBuilder<Object>)builderLeft, true, true);
        int[] nullRows = df.undefinedIndices(cols);
        builderLeft.addAll((IterableOnce)new ConstantIterator(-1, nullRows.length));
        builderRight.addAll((Object)nullRows);
        return DataMap$.MODULE$.buildRightJoin(left, right, (int[])builderLeft.result(), (int[])builderRight.result());
    }

    public DataFrame merge(DataFrame df) {
        return DataFrame$.MODULE$.applyDynamic("from", (Seq<Object>)((Seq)this.columnIterator().toSeq().$plus$plus((IterableOnce)df.columnIterator().toSeq())));
    }

    public DataFrame merge(Seq<Series<?>> series) {
        return DataFrame$.MODULE$.applyDynamic("from", (Seq<Object>)((Seq)this.columnIterator().toSeq().$plus$plus(series)));
    }

    public int numCols() {
        return this.colIndex().size();
    }

    public int numRows() {
        return this.index().length();
    }

    public int numRowsBase() {
        return this.index().base().length();
    }

    public Plot plot() {
        return Plot$.MODULE$.apply(this);
    }

    public Requirement requires() {
        return new Requirement(this, Requirement$.MODULE$.$lessinit$greater$default$2(), Requirement$.MODULE$.$lessinit$greater$default$3());
    }

    public DataFrame resetIndex() {
        DataFrame dataFrame;
        if (this.index() instanceof UniformIndex) {
            dataFrame = this;
        } else {
            int[] indices = this.index().toSeqIndex().indices();
            UniformIndex newIndex = new UniformIndex(indices.length);
            Iterable newColumns = (Iterable)this.columnIterator().map((Function1 & Serializable)v -> Tuple2$.MODULE$.apply((Object)v.name(), v.extract(indices).data()));
            dataFrame = new DataFrame(ColIndex$package$ColIndex$.MODULE$.toMap(newColumns.toSeq()), newIndex);
        }
        return dataFrame;
    }

    public DataFrame select(String[] cols) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])cols);
        return this.applyCols((Seq<String>)ArrayOps$.MODULE$.toSeq$extension(object));
    }

    public DataFrame selectSeq(Seq<String> cols) {
        return this.applyCols(cols);
    }

    public DataFrame selectCols(Seq<String> cols) {
        return this.applyCols(cols);
    }

    public Series<Object> selectDynamic(String col) {
        return this.apply(col);
    }

    public <T> DataFrame sorted(String col, Ordering<T> ordering) {
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)col);
        return this.sorted((Tuple2<String, Order>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Order$.asc), ordering);
    }

    public <T1, T2> DataFrame sorted(String col1, String col2, Ordering<T1> ordering1, Ordering<T2> ordering2) {
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)col1);
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)col2);
        return this.sorted((Tuple2<String, Order>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Order$.asc), (Tuple2<String, Order>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)Order$.asc), ordering1, ordering2);
    }

    public <T1, T2, T3> DataFrame sorted(String col1, String col2, String col3, Ordering<T1> ordering1, Ordering<T2> ordering2, Ordering<T3> ordering3) {
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)col1);
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)col2);
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)col3);
        return this.sorted((Tuple2<String, Order>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Order$.asc), (Tuple2<String, Order>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)Order$.asc), (Tuple2<String, Order>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)Order$.asc), ordering1, ordering2, ordering3);
    }

    public <T> DataFrame sorted(Tuple2<String, Order> key, Ordering<T> ordering) {
        DataFrame dataFrame;
        if (ordering instanceof Ordering.StringOrdering) {
            SeriesData seriesData = (SeriesData)Predef$.MODULE$.ArrowAssoc((Object)((SeriesData)this.inline$colIndex().getOrElse(key._1(), () -> this.sorted$$anonfun$1(key))));
            dataFrame = this.withIndex(this.index().sorted(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)seriesData, key._2()), SeriesString$DefaultOrder$.MODULE$));
        } else {
            SeriesData seriesData = (SeriesData)Predef$.MODULE$.ArrowAssoc((Object)((SeriesData)this.inline$colIndex().getOrElse(key._1(), () -> this.sorted$$anonfun$2(key))));
            dataFrame = this.withIndex(this.index().sorted(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)seriesData, key._2()), ordering));
        }
        return dataFrame;
    }

    public <T1, T2> DataFrame sorted(Tuple2<String, Order> key1, Tuple2<String, Order> key2, Ordering<T1> ordering1, Ordering<T2> ordering2) {
        Ordering o2 = ordering2 instanceof Ordering.StringOrdering ? (Ordering)SeriesString$DefaultOrder$.MODULE$ : ordering2;
        Sorting s2 = Sorting$.MODULE$.apply((SeriesData)this.inline$colIndex().getOrElse(key2._1(), () -> this.$anonfun$5(key2)), (Order)key2._2(), Sorting$.MODULE$.apply$default$3(), o2);
        Ordering o1 = ordering1 instanceof Ordering.StringOrdering ? (Ordering)SeriesString$DefaultOrder$.MODULE$ : ordering1;
        Sorting s1 = Sorting$.MODULE$.apply((SeriesData)this.inline$colIndex().getOrElse(key1._1(), () -> this.$anonfun$6(key1)), (Order)key1._2(), (Option<Sorting>)Some$.MODULE$.apply((Object)s2), o1);
        return this.withIndex(this.index().sortBy(s1.sort()));
    }

    public <T1, T2, T3> DataFrame sorted(Tuple2<String, Order> key1, Tuple2<String, Order> key2, Tuple2<String, Order> key3, Ordering<T1> ordering1, Ordering<T2> ordering2, Ordering<T3> ordering3) {
        Ordering o3 = ordering3 instanceof Ordering.StringOrdering ? (Ordering)SeriesString$DefaultOrder$.MODULE$ : ordering3;
        Sorting s3 = Sorting$.MODULE$.apply((SeriesData)this.inline$colIndex().getOrElse(key3._1(), () -> this.$anonfun$7(key3)), (Order)key3._2(), Sorting$.MODULE$.apply$default$3(), o3);
        Ordering o2 = ordering2 instanceof Ordering.StringOrdering ? (Ordering)SeriesString$DefaultOrder$.MODULE$ : ordering2;
        Sorting s2 = Sorting$.MODULE$.apply((SeriesData)this.inline$colIndex().getOrElse(key2._1(), () -> this.$anonfun$8(key2)), (Order)key2._2(), (Option<Sorting>)Some$.MODULE$.apply((Object)s3), o2);
        Ordering o1 = ordering1 instanceof Ordering.StringOrdering ? (Ordering)SeriesString$DefaultOrder$.MODULE$ : ordering1;
        Sorting s1 = Sorting$.MODULE$.apply((SeriesData)this.inline$colIndex().getOrElse(key1._1(), () -> this.$anonfun$9(key1)), (Order)key1._2(), (Option<Sorting>)Some$.MODULE$.apply((Object)s2), o1);
        return this.withIndex(this.index().sortBy(s1.sort()));
    }

    public DataFrame sortValuesCols(Seq<String> cols) {
        return this.sortValues((Seq<Tuple2<String, Order>>)((Seq)cols.map((Function1 & Serializable)_$11 -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc(_$11);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Order$.asc);
        })));
    }

    public DataFrame sortValues(Seq<Tuple2<String, Order>> keys) {
        DataFrame dataFrame;
        if (keys.isEmpty()) {
            dataFrame = this;
        } else {
            ObjectRef successor = ObjectRef.create((Object)None$.MODULE$);
            Sorting sorting = (Sorting)((IterableOps)((IterableOps)keys.reverse()).map((Function1 & Serializable)k -> {
                Sorting sorting;
                SeriesData data = (SeriesData)this.inline$colIndex().getOrElse(k._1(), () -> this.$anonfun$11(k));
                if (data.vector() instanceof boolean[]) {
                    SeriesData SeriesData_this = data;
                    sorting = Sorting$.MODULE$.apply(SeriesData_this, (Order)k._2(), (Option<Sorting>)((Option)successor$1.elem), Ordering.Boolean$.MODULE$);
                } else if (data.vector() instanceof byte[]) {
                    SeriesData SeriesData_this = data;
                    sorting = Sorting$.MODULE$.apply(SeriesData_this, (Order)k._2(), (Option<Sorting>)((Option)successor$1.elem), Ordering.Byte$.MODULE$);
                } else if (data.vector() instanceof char[]) {
                    SeriesData SeriesData_this = data;
                    sorting = Sorting$.MODULE$.apply(SeriesData_this, (Order)k._2(), (Option<Sorting>)((Option)successor$1.elem), Ordering.Char$.MODULE$);
                } else if (data.vector() instanceof double[]) {
                    SeriesData SeriesData_this = data;
                    sorting = Sorting$.MODULE$.apply(SeriesData_this, (Order)k._2(), (Option<Sorting>)((Option)successor$1.elem), Ordering.DeprecatedDoubleOrdering$.MODULE$);
                } else if (data.vector() instanceof float[]) {
                    SeriesData SeriesData_this = data;
                    sorting = Sorting$.MODULE$.apply(SeriesData_this, (Order)k._2(), (Option<Sorting>)((Option)successor$1.elem), Ordering.DeprecatedFloatOrdering$.MODULE$);
                } else if (data.vector() instanceof int[]) {
                    SeriesData SeriesData_this = data;
                    sorting = Sorting$.MODULE$.apply(SeriesData_this, (Order)k._2(), (Option<Sorting>)((Option)successor$1.elem), Ordering.Int$.MODULE$);
                } else if (data.vector() instanceof long[]) {
                    SeriesData SeriesData_this = data;
                    sorting = Sorting$.MODULE$.apply(SeriesData_this, (Order)k._2(), (Option<Sorting>)((Option)successor$1.elem), Ordering.Long$.MODULE$);
                } else if (data.vector() instanceof short[]) {
                    SeriesData SeriesData_this = data;
                    sorting = Sorting$.MODULE$.apply(SeriesData_this, (Order)k._2(), (Option<Sorting>)((Option)successor$1.elem), Ordering.Short$.MODULE$);
                } else if (data.vector() instanceof LocalDate[]) {
                    SeriesData SeriesData_this = data;
                    sorting = Sorting$.MODULE$.apply(SeriesData_this, (Order)k._2(), (Option<Sorting>)((Option)successor$1.elem), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
                } else if (data.vector() instanceof LocalDateTime[]) {
                    SeriesData SeriesData_this = data;
                    sorting = Sorting$.MODULE$.apply(SeriesData_this, (Order)k._2(), (Option<Sorting>)((Option)successor$1.elem), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
                } else if (data.vector() instanceof LocalTime[]) {
                    SeriesData SeriesData_this = data;
                    sorting = Sorting$.MODULE$.apply(SeriesData_this, (Order)k._2(), (Option<Sorting>)((Option)successor$1.elem), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
                } else if (data.vector() instanceof String[]) {
                    SeriesData SeriesData_this = data;
                    sorting = Sorting$.MODULE$.apply(SeriesData_this, (Order)k._2(), (Option<Sorting>)((Option)successor$1.elem), SeriesString$DefaultOrder$.MODULE$);
                } else if (data.vector() instanceof ZonedDateTime[]) {
                    SeriesData SeriesData_this = data;
                    sorting = Sorting$.MODULE$.apply(SeriesData_this, (Order)k._2(), (Option<Sorting>)((Option)successor$1.elem), Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
                } else {
                    throw IllegalOperation$.MODULE$.apply(this.apply((String)k._1()), "sortValues");
                }
                Sorting result = sorting;
                Some some = Some$.MODULE$.apply((Object)result);
                successor$1.elem = some;
                return result;
            })).last();
            dataFrame = this.withIndex(this.index().sortBy(sorting.sort()));
        }
        return dataFrame;
    }

    public void show(int n, int width, boolean annotateIndex, boolean annotateType, int colWidth) {
        Predef$.MODULE$.println((Object)this.toString(n, width, annotateIndex, annotateType, colWidth, this.toString$default$6()));
    }

    public int show$default$1() {
        return Settings$.MODULE$.printRowLength();
    }

    public int show$default$2() {
        return Settings$.MODULE$.printWidth();
    }

    public boolean show$default$3() {
        return false;
    }

    public boolean show$default$4() {
        return false;
    }

    public int show$default$5() {
        return Settings$.MODULE$.printColWidth();
    }

    public <T> Option<T>[] toArray(String col, RequireType<T> evidence$65, TypeTest<Object, T> evidence$66, ClassTag<T> evidence$67) {
        return this.apply(col).as(evidence$66, evidence$67).toArray();
    }

    public <T> Object toFlatArray(String col, RequireType<T> evidence$68, TypeTest<Object, T> evidence$69, ClassTag<T> evidence$70) {
        return this.apply(col).as(evidence$69, evidence$70).toFlatArray();
    }

    public <T> List<T> toFlatList(String col, RequireType<T> evidence$71, TypeTest<Object, T> evidence$72, ClassTag<T> evidence$73) {
        return this.apply(col).as(evidence$72, evidence$73).toFlatList();
    }

    public <T> Seq<T> toFlatSeq(String col, RequireType<T> evidence$74, TypeTest<Object, T> evidence$75, ClassTag<T> evidence$76) {
        return this.apply(col).as(evidence$75, evidence$76).toFlatSeq();
    }

    public <T> List<Option<T>> toList(String col, RequireType<T> evidence$77, TypeTest<Object, T> evidence$78, ClassTag<T> evidence$79) {
        return this.apply(col).as(evidence$78, evidence$79).toList();
    }

    public <T> Seq<Option<T>> toSeq(String col, RequireType<T> evidence$80, TypeTest<Object, T> evidence$81, ClassTag<T> evidence$82) {
        return this.apply(col).as(evidence$81, evidence$82).toSeq();
    }

    public String toString() {
        return "\n" + this.toString(this.toString$default$1(), this.toString$default$2(), this.toString$default$3(), this.toString$default$4(), this.toString$default$5(), this.toString$default$6());
    }

    public String toString(int n, int width, boolean annotateIndex, boolean annotateType, int colWidth, int indexWidth2) {
        return StringUtils$.MODULE$.table(this, n, width, annotateIndex, annotateType, colWidth, indexWidth2, this.indexPrintName(), (Function2<Object, Object, String>)(Function2 & Serializable)(ix, indexWidth) -> this.toString$$anonfun$1(BoxesRunTime.unboxToInt((Object)ix), BoxesRunTime.unboxToInt((Object)indexWidth)));
    }

    public int toString$default$1() {
        return Settings$.MODULE$.printRowLength();
    }

    public int toString$default$2() {
        return Settings$.MODULE$.printWidth();
    }

    public boolean toString$default$3() {
        return true;
    }

    public boolean toString$default$4() {
        return true;
    }

    public int toString$default$5() {
        return Settings$.MODULE$.printColWidth();
    }

    public int toString$default$6() {
        return this.indexPrintWidth();
    }

    public DataFrame union(Seq<DataFrame> df) {
        int cols = this.numCols();
        df.foreach((Function1)(JProcedure1 & Serializable)d -> {
            if (d.numCols() != cols) {
                throw ColumnNotFoundException$.MODULE$.apply("Number of columns does not match. Found " + cols + " and " + d.numCols() + ".");
            }
        });
        return DataFrame$.MODULE$.fromSeries(((IterableOnceOps)this.columnIterator().map((Function1 & Serializable)s -> s.union((Seq)df.map((Function1 & Serializable)_$12 -> _$12.apply(s.name()))))).toSeq(), false);
    }

    public <T> DataFrame update(String col, Series<T> series) {
        return this.update(Tuple2$.MODULE$.apply((Object)col, series));
    }

    public <T> DataFrame update(Series<T> series) {
        return this.updateOperator(series);
    }

    public DataFrame update(Seq<Series<?>> series) {
        return (DataFrame)series.foldLeft((Object)this, (Function2 & Serializable)(_$13, _$14) -> _$13.updateOperator((Series)_$14));
    }

    public DataFrame valueCounts(Seq<String> cols) {
        return this.valueCounts((Seq<String>)cols.toSeq(), this.valueCounts$default$2(), this.valueCounts$default$3(), this.valueCounts$default$4(), this.valueCounts$default$5());
    }

    public DataFrame valueCounts(Seq<String> cols, String countCol, boolean dropUndefined, Order order, boolean asFraction) {
        if (cols.isEmpty()) {
            throw IllegalOperation$.MODULE$.oneColumnGrouping();
        }
        DataMap.Groups groups = this.groups$1(cols, dropUndefined);
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)countCol);
        DataFrame df = groups.countRows(countCol, groups.countRows$default$2()).collect().sorted((Tuple2<String, Order>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)order), (Ordering)Ordering.Int$.MODULE$).resetIndex();
        return asFraction ? df.concat(Series$.MODULE$.toSeriesAny(df.apply(countCol)).div((double)this.numRows())) : df;
    }

    public String valueCounts$default$2() {
        return "count";
    }

    public boolean valueCounts$default$3() {
        return false;
    }

    public Order valueCounts$default$4() {
        return Order$.desc;
    }

    public boolean valueCounts$default$5() {
        return false;
    }

    public String indexPrintName() {
        return "Index";
    }

    public String indexPrintRepresentation(int ix, int indexWidth) {
        return StringUtils$.MODULE$.fixedString(BoxesRunTime.boxToInteger((int)ix).toString(), indexWidth, StringUtils$.MODULE$.fixedString$default$3(), StringUtils$.MODULE$.fixedString$default$4());
    }

    public int indexPrintWidth() {
        return Settings$.MODULE$.printIndexWidth();
    }

    public Throwable columnNotFound(String col) {
        return ColumnNotFoundException$.MODULE$.apply(this, col);
    }

    public int[] undefinedIndices() {
        return this.undefinedIndices(this.columns());
    }

    public int[] undefinedIndices(Seq<String> cols) {
        int[] nArray;
        if (cols.isEmpty()) {
            nArray = new int[]{};
        } else {
            String col$proxy1 = (String)cols.head();
            nArray = (int[])((IterableOnceOps)((IterableOnceOps)cols.tail()).foldLeft((Object)Predef$.MODULE$.wrapIntArray(Series$.MODULE$.apply((SeriesData)this.inline$colIndex().getOrElse((Object)col$proxy1, () -> this.undefinedIndices$$anonfun$1(col$proxy1)), this.index(), (String)cols.head()).undefinedIndices()).toSet(), (Function2 & Serializable)(set, col) -> (Set)set.$plus$plus((IterableOnce)Predef$.MODULE$.wrapIntArray(Series$.MODULE$.apply((SeriesData)this.inline$colIndex().getOrElse(col, () -> this.undefinedIndices$$anonfun$3$$anonfun$1(col)), this.index(), (String)col).undefinedIndices())))).toArray(ClassTag$.MODULE$.apply(Integer.TYPE));
        }
        return nArray;
    }

    @Override
    public DataFrame withIndex(BaseIndex index) {
        return new DataFrame(this.colIndex(), index);
    }

    public SeqMap inline$colIndex() {
        return this.colIndex();
    }

    public Throwable inline$columnNotFound(String col) {
        return this.columnNotFound(col);
    }

    private static final String _$1$1(Tuple2 x$1$1) {
        return (String)x$1$1._1();
    }

    private static final SeriesData _$2$1(Tuple2 x$1$2) {
        return (SeriesData)x$1$2._2();
    }

    private static final String _$3$1(Tuple2 x$1$3) {
        return (String)x$1$3._1();
    }

    private static final SeriesData _$4$1(Tuple2 x$1$4) {
        return (SeriesData)x$1$4._2();
    }

    private final SeriesData apply$$anonfun$1(String col$1) {
        throw this.inline$columnNotFound(col$1);
    }

    private static final Object default$proxy1$1(Function0 default$1) {
        return default$1.apply();
    }

    private static final Object default$proxy2$1(Function0 default$2) {
        return default$2.apply();
    }

    private final SeriesData dropUndefined$$anonfun$2$$anonfun$1(String col$2) {
        throw this.inline$columnNotFound(col$2);
    }

    private static final /* synthetic */ Seq groupBy$$anonfun$2(Seq data$1, int ix) {
        return (Seq)data$1.map((Function1 & Serializable)_$6 -> {
            SeriesData SeriesData_this = _$6;
            return ScalaRunTime$.MODULE$.array_apply(SeriesData_this.inline$vector(), ix);
        });
    }

    private static final /* synthetic */ Seq groupByOption$$anonfun$2(Seq data$2, int ix) {
        return (Seq)data$2.map((Function1 & Serializable)_$8 -> {
            SeriesData SeriesData_this = _$8;
            return SeriesData_this.inline$mask() == null || SeriesData_this.inline$mask()[ix] ? Some$.MODULE$.apply(ScalaRunTime$.MODULE$.array_apply(SeriesData_this.inline$vector(), ix)) : None$.MODULE$;
        });
    }

    private static final /* synthetic */ Object indexBy$$anonfun$1(SeriesData data$3, int ix) {
        SeriesData SeriesData_this = data$3;
        return ScalaRunTime$.MODULE$.array_apply(SeriesData_this.inline$vector(), ix);
    }

    private static final /* synthetic */ Tuple2 indexBy$$anonfun$2(SeriesData data1$1, SeriesData data2$1, int ix) {
        SeriesData SeriesData_this = data1$1;
        SeriesData SeriesData_this2 = data2$1;
        return Tuple2$.MODULE$.apply(ScalaRunTime$.MODULE$.array_apply(SeriesData_this.inline$vector(), ix), ScalaRunTime$.MODULE$.array_apply(SeriesData_this2.inline$vector(), ix));
    }

    private static final /* synthetic */ Tuple3 indexBy$$anonfun$3(SeriesData data1$2, SeriesData data2$2, SeriesData data3$1, int ix) {
        SeriesData SeriesData_this = data1$2;
        SeriesData SeriesData_this2 = data2$2;
        SeriesData SeriesData_this3 = data3$1;
        return Tuple3$.MODULE$.apply(ScalaRunTime$.MODULE$.array_apply(SeriesData_this.inline$vector(), ix), ScalaRunTime$.MODULE$.array_apply(SeriesData_this2.inline$vector(), ix), ScalaRunTime$.MODULE$.array_apply(SeriesData_this3.inline$vector(), ix));
    }

    private static final /* synthetic */ Seq indexBy$$anonfun$5(Seq data$4, int ix) {
        return (Seq)data$4.map((Function1 & Serializable)_$10 -> {
            SeriesData SeriesData_this = _$10;
            return ScalaRunTime$.MODULE$.array_apply(SeriesData_this.inline$vector(), ix);
        });
    }

    private static final /* synthetic */ Option indexByOption$$anonfun$1(SeriesData data$5, int ix) {
        SeriesData SeriesData_this = data$5;
        return SeriesData_this.inline$mask() == null || SeriesData_this.inline$mask()[ix] ? Some$.MODULE$.apply(ScalaRunTime$.MODULE$.array_apply(SeriesData_this.inline$vector(), ix)) : None$.MODULE$;
    }

    private static final /* synthetic */ Tuple2 indexByOption$$anonfun$2(SeriesData data1$3, SeriesData data2$3, int ix) {
        SeriesData SeriesData_this = data2$3;
        SeriesData SeriesData_this2 = data1$3;
        return Tuple2$.MODULE$.apply(SeriesData_this2.inline$mask() == null || SeriesData_this2.inline$mask()[ix] ? Some$.MODULE$.apply(ScalaRunTime$.MODULE$.array_apply(SeriesData_this2.inline$vector(), ix)) : None$.MODULE$, SeriesData_this.inline$mask() == null || SeriesData_this.inline$mask()[ix] ? Some$.MODULE$.apply(ScalaRunTime$.MODULE$.array_apply(SeriesData_this.inline$vector(), ix)) : None$.MODULE$);
    }

    private static final /* synthetic */ Tuple3 indexByOption$$anonfun$3(SeriesData data1$4, SeriesData data2$4, SeriesData data3$2, int ix) {
        SeriesData SeriesData_this = data2$4;
        SeriesData SeriesData_this2 = data3$2;
        SeriesData SeriesData_this3 = data1$4;
        return Tuple3$.MODULE$.apply(SeriesData_this3.inline$mask() == null || SeriesData_this3.inline$mask()[ix] ? Some$.MODULE$.apply(ScalaRunTime$.MODULE$.array_apply(SeriesData_this3.inline$vector(), ix)) : None$.MODULE$, SeriesData_this.inline$mask() == null || SeriesData_this.inline$mask()[ix] ? Some$.MODULE$.apply(ScalaRunTime$.MODULE$.array_apply(SeriesData_this.inline$vector(), ix)) : None$.MODULE$, SeriesData_this2.inline$mask() == null || SeriesData_this2.inline$mask()[ix] ? Some$.MODULE$.apply(ScalaRunTime$.MODULE$.array_apply(SeriesData_this2.inline$vector(), ix)) : None$.MODULE$);
    }

    private final DataFrame leftJoin$1(Seq cols$1, DataMap left$1, DataMap right$1) {
        ArrayBuilder builderLeft = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(Integer.TYPE));
        ArrayBuilder builderRight = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(Integer.TYPE));
        DataMap$.MODULE$.join(left$1, right$1, (ArrayBuilder<Object>)builderLeft, (ArrayBuilder<Object>)builderRight, true, true);
        int[] nullRows = this.undefinedIndices((Seq<String>)cols$1);
        builderLeft.addAll((Object)nullRows);
        builderRight.addAll((IterableOnce)new ConstantIterator(-1, nullRows.length));
        return DataMap$.MODULE$.buildJoin(left$1, right$1, (int[])builderLeft.result(), (int[])builderRight.result());
    }

    private static final DataFrame rightJoinWithoutInner$1(DataFrame df$4, Seq cols$2, DataMap left$2, DataMap right$2) {
        ArrayBuilder builderLeft = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(Integer.TYPE));
        ArrayBuilder builderRight = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(Integer.TYPE));
        DataMap$.MODULE$.join(right$2, left$2, (ArrayBuilder<Object>)builderRight, (ArrayBuilder<Object>)builderLeft, false, true);
        int[] nullRows = df$4.undefinedIndices((Seq<String>)cols$2);
        builderLeft.addAll((IterableOnce)new ConstantIterator(-1, nullRows.length));
        builderRight.addAll((Object)nullRows);
        return DataMap$.MODULE$.buildRightJoin(left$2, right$2, (int[])builderLeft.result(), (int[])builderRight.result());
    }

    private final SeriesData sorted$$anonfun$1(Tuple2 key$1) {
        throw this.inline$columnNotFound((String)key$1._1());
    }

    private final SeriesData sorted$$anonfun$2(Tuple2 key$2) {
        throw this.inline$columnNotFound((String)key$2._1());
    }

    private final SeriesData $anonfun$5(Tuple2 key2$1) {
        throw this.inline$columnNotFound((String)key2$1._1());
    }

    private final SeriesData $anonfun$6(Tuple2 key1$1) {
        throw this.inline$columnNotFound((String)key1$1._1());
    }

    private final SeriesData $anonfun$7(Tuple2 key3$1) {
        throw this.inline$columnNotFound((String)key3$1._1());
    }

    private final SeriesData $anonfun$8(Tuple2 key2$2) {
        throw this.inline$columnNotFound((String)key2$2._1());
    }

    private final SeriesData $anonfun$9(Tuple2 key1$2) {
        throw this.inline$columnNotFound((String)key1$2._1());
    }

    private final SeriesData $anonfun$11(Tuple2 k$1) {
        throw this.inline$columnNotFound((String)k$1._1());
    }

    private final /* synthetic */ String toString$$anonfun$1(int ix, int indexWidth) {
        return this.indexPrintRepresentation(ix, indexWidth);
    }

    private final DataMap.Groups groups$1(Seq cols$4, boolean dropUndefined$1) {
        return dropUndefined$1 ? this.groupBy((Seq<String>)cols$4) : this.groupByOption((Seq<String>)cols$4);
    }

    private final SeriesData undefinedIndices$$anonfun$1(String col$proxy1$1) {
        throw this.inline$columnNotFound(col$proxy1$1);
    }

    private final SeriesData undefinedIndices$$anonfun$3$$anonfun$1(String col$3) {
        throw this.inline$columnNotFound(col$3);
    }

    public static class DataFrameAppender
    implements Dynamic {
        private final DataFrame df;

        public DataFrameAppender(DataFrame df) {
            this.df = df;
        }

        public DataFrame applyDynamic(String method, Seq<Object> args) {
            block3: {
                block4: {
                    String string;
                    String string2;
                    block2: {
                        string2 = method;
                        string = "apply";
                        if (string2 != null) break block2;
                        if (string == null) break block3;
                        break block4;
                    }
                    if (string2.equals(string)) break block3;
                }
                throw new UnsupportedOperationException("Method `" + method + "` does not exist.");
            }
            return (DataFrame)args.foldLeft((Object)this.df, (Function2 & Serializable)(df, b) -> {
                DataFrame dataFrame;
                Object object = b;
                if (object instanceof Tuple2) {
                    Tuple2 e = (Tuple2)object;
                    dataFrame = df.col((String)e._1(), (Series)e._2());
                } else if (object instanceof Series) {
                    Series s = (Series)object;
                    dataFrame = df.concat(s);
                } else {
                    throw new MatchError(object);
                }
                return dataFrame;
            });
        }

        public DataFrame applyDynamicNamed(String method, Seq<Tuple2<String, Series<?>>> kwargs) {
            block3: {
                block4: {
                    String string;
                    String string2;
                    block2: {
                        string2 = method;
                        string = "apply";
                        if (string2 != null) break block2;
                        if (string == null) break block3;
                        break block4;
                    }
                    if (string2.equals(string)) break block3;
                }
                throw new UnsupportedOperationException("Method `" + method + "` does not exist.");
            }
            return (DataFrame)kwargs.foldLeft((Object)this.df, (Function2 & Serializable)(a, b) -> a.col((String)b._1(), (Series)b._2()));
        }
    }
}

