/*
 * Decompiled with CFR 0.152.
 */
package pd;

import java.io.Serializable;
import pd.DataFrame;
import pd.DataFrame$;
import pd.DataMap$;
import pd.DataMap$Groups$;
import pd.Order;
import pd.Series;
import pd.Series$;
import pd.Settings$;
import pd.exception.IllegalOperation;
import pd.exception.IllegalOperation$;
import pd.exception.MapToNullException;
import pd.internal.index.SeqIndex$;
import pd.internal.index.UniformIndex;
import pd.internal.series.SeriesData;
import pd.internal.utils.RequireType$RequireTypeAmbiguous$;
import pd.internal.utils.StringUtils$;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.TypeTest;
import scala.reflect.TypeTest$;
import scala.runtime.Arrays$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class DataMap<K>
extends DataFrame {
    private final DataFrame df;
    private final String[] groupCols;
    private final Map map;

    public static <K> DataFrame buildJoin(DataMap<K> dataMap, DataMap<K> dataMap2, int[] nArray, int[] nArray2) {
        return DataMap$.MODULE$.buildJoin(dataMap, dataMap2, nArray, nArray2);
    }

    public static <K> DataFrame buildRightJoin(DataMap<K> dataMap, DataMap<K> dataMap2, int[] nArray, int[] nArray2) {
        return DataMap$.MODULE$.buildRightJoin(dataMap, dataMap2, nArray, nArray2);
    }

    public static <K> void join(DataMap<K> dataMap, DataMap<K> dataMap2, ArrayBuilder<Object> arrayBuilder, ArrayBuilder<Object> arrayBuilder2, boolean bl, boolean bl2) {
        DataMap$.MODULE$.join(dataMap, dataMap2, arrayBuilder, arrayBuilder2, bl, bl2);
    }

    public DataMap(DataFrame df, String[] groupCols, Map<K, int[]> map) {
        this.df = df;
        this.groupCols = groupCols;
        this.map = map;
        super(df.colIndex(), df.index());
    }

    private DataFrame df() {
        return this.df;
    }

    public String[] pd$DataMap$$groupCols() {
        return this.groupCols;
    }

    public Map<K, int[]> pd$DataMap$$map() {
        return this.map;
    }

    public DataMap<K> dropGroupCols() {
        return DataMap$.MODULE$.apply(super.applyCols((Seq<String>)((Seq)this.columns().filterNot((Function1 & Serializable)c -> {
            Object object = Predef$.MODULE$.refArrayOps((Object[])this.pd$DataMap$$groupCols());
            return ArrayOps$.MODULE$.contains$extension(object, c);
        }))), new String[0], this.pd$DataMap$$map());
    }

    public Groups<K> groups() {
        return new Groups(this, DataMap$Groups$.MODULE$.$lessinit$greater$default$2());
    }

    public DataFrame key(K k) {
        DataFrame dataFrame;
        Option option = this.pd$DataMap$$map().get(k);
        if (option instanceof Some) {
            int[] idx = (int[])((Some)option).value();
            dataFrame = this.df().withIndex(SeqIndex$.MODULE$.unchecked(this.df().index().base(), idx));
        } else if (None$.MODULE$.equals(option)) {
            dataFrame = (DataFrame)this.df().apply(new int[0]);
        } else {
            throw new MatchError((Object)option);
        }
        return dataFrame;
    }

    public Iterable<K> keys() {
        return this.pd$DataMap$$map().keys();
    }

    public DataMap<K> sortByGroupSize() {
        ArrayBuilder builder = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(Integer.TYPE));
        builder.sizeHint(this.numRows());
        ((IterableOnceOps)this.pd$DataMap$$map().values().toSeq().sortBy((Function1 & Serializable)_$1 -> -((int[])_$1).length, (Ordering)Ordering.Int$.MODULE$)).foreach((Function1 & Serializable)_$2 -> builder.addAll(_$2));
        return new DataMap<K>(this.withIndex(SeqIndex$.MODULE$.apply(this.index().base(), (int[])builder.result())), this.pd$DataMap$$groupCols(), this.pd$DataMap$$map());
    }

    @Override
    public <T> DataMap<K> concat(Series<T> series) {
        this.checkForGroupColumn((Seq<Series<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Series[]{series}));
        return this.withDataFrame(super.concat(series));
    }

    @Override
    public <T> DataMap<K> concat(Tuple2<String, Series<T>> namedSeries) {
        this.checkForGroupColumn((Seq<Series<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Series[]{(Series)namedSeries._2()}));
        return this.withDataFrame(super.concat(namedSeries));
    }

    @Override
    public DataMap<K> concat(DataFrame df) {
        this.checkForGroupColumn(df);
        return this.withDataFrame(super.concat(df));
    }

    @Override
    public <T> DataMap<K> prepend(Series<T> series) {
        this.checkForGroupColumn((Seq<Series<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Series[]{series}));
        return this.withDataFrame(super.prepend(series));
    }

    @Override
    public DataMap<K> prepend(DataFrame df) {
        this.checkForGroupColumn(df);
        return this.withDataFrame(super.prepend(df));
    }

    @Override
    public <T> DataMap<K> update(Tuple2<String, Series<T>> namedSeries) {
        this.checkForGroupColumn((Seq<Series<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Series[]{(Series)namedSeries._2()}));
        return this.withDataFrame(super.update(namedSeries));
    }

    @Override
    public <T> DataMap<K> updateOperator(Series<T> series) {
        this.checkForGroupColumn((Seq<Series<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Series[]{series}));
        return this.withDataFrame(super.updateOperator(series));
    }

    @Override
    public DataMap<K> applyCols(Seq<String> cols) {
        return this.withDataFrame(super.applyCols(cols));
    }

    @Override
    public <T> DataMap<K> append(String name, Series<T> series) {
        this.checkForGroupColumn(name);
        return this.withDataFrame(super.append(name, series));
    }

    @Override
    public DataMap<K> append(Seq<Series<?>> series) {
        this.checkForGroupColumn(series);
        return this.withDataFrame(super.append(series));
    }

    @Override
    public <T> DataMap<K> col(Series<T> series) {
        this.checkForGroupColumn((Seq<Series<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Series[]{series}));
        return this.withDataFrame(super.col(series));
    }

    @Override
    public <T> DataMap<K> col(String col, Series<T> series) {
        this.checkForGroupColumn(col);
        return this.withDataFrame(super.col(col, series));
    }

    @Override
    public <T> DataMap<K> sorted(String col, Ordering<T> ordering) {
        return this.withDataFrame(super.sorted(col, ordering));
    }

    @Override
    public <T1, T2> DataFrame sorted(String col1, String col2, Ordering<T1> ordering1, Ordering<T2> ordering2) {
        return this.withDataFrame(super.sorted(col1, col2, ordering1, ordering2));
    }

    @Override
    public <T1, T2, T3> DataFrame sorted(String col1, String col2, String col3, Ordering<T1> ordering1, Ordering<T2> ordering2, Ordering<T3> ordering3) {
        return this.withDataFrame(super.sorted(col1, col2, col3, ordering1, ordering2, ordering3));
    }

    @Override
    public <T> DataMap<K> sorted(Tuple2<String, Order> key, Ordering<T> ordering) {
        return this.withDataFrame(super.sorted(key, ordering));
    }

    @Override
    public <T1, T2> DataFrame sorted(Tuple2<String, Order> key1, Tuple2<String, Order> key2, Ordering<T1> ordering1, Ordering<T2> ordering2) {
        return this.withDataFrame(super.sorted(key1, key2, ordering1, ordering2));
    }

    @Override
    public <T1, T2, T3> DataFrame sorted(Tuple2<String, Order> key1, Tuple2<String, Order> key2, Tuple2<String, Order> key3, Ordering<T1> ordering1, Ordering<T2> ordering2, Ordering<T3> ordering3) {
        return this.withDataFrame(super.sorted(key1, key2, key3, ordering1, ordering2, ordering3));
    }

    @Override
    public DataMap<K> sortValuesCols(Seq<String> cols) {
        return this.withDataFrame(super.sortValuesCols(cols));
    }

    @Override
    public DataMap<K> sortValues(Seq<Tuple2<String, Order>> keys) {
        return this.withDataFrame(super.sortValues(keys));
    }

    @Override
    public <T> DataMap<K> update(String col, Series<T> series) {
        this.checkForGroupColumn(col);
        return this.withDataFrame(super.update(col, series));
    }

    @Override
    public <T> DataMap<K> update(Series<T> series) {
        this.checkForGroupColumn((Seq<Series<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Series[]{series}));
        return this.withDataFrame(super.update(series));
    }

    @Override
    public DataMap<K> update(Seq<Series<?>> series) {
        this.checkForGroupColumn(series);
        return this.withDataFrame(super.update(series));
    }

    public void checkForGroupColumn(DataFrame df) {
        df.columns().foreach((Function1)(JProcedure1 & Serializable)name -> this.checkForGroupColumn((String)name));
    }

    public void checkForGroupColumn(String name) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.pd$DataMap$$groupCols());
        if (ArrayOps$.MODULE$.contains$extension(object, (Object)name)) {
            throw IllegalOperation$.MODULE$.apply("Cannot alter or replace a group column '" + name + "' in a DataMap.");
        }
    }

    public void checkForGroupColumn(Seq<Series<?>> series) {
        series.foreach((Function1)(JProcedure1 & Serializable)s -> this.checkForGroupColumn(s.name()));
    }

    @Override
    public String indexPrintName() {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.pd$DataMap$$groupCols());
        return ArrayOps$.MODULE$.isEmpty$extension(object) ? "Index: Key" : "Index";
    }

    @Override
    public String indexPrintRepresentation(int ix, int indexWidth) {
        String string;
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.pd$DataMap$$groupCols());
        if (ArrayOps$.MODULE$.isEmpty$extension(object)) {
            string = StringUtils$.MODULE$.fixedString("" + ix + ": " + this.search$1(ix), indexWidth, true, StringUtils$.MODULE$.fixedString$default$4());
        } else {
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])this.pd$DataMap$$groupCols());
            Object object3 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(object2, (Function1 & Serializable)col -> this.df().apply(ix, (String)col, RequireType$RequireTypeAmbiguous$.MODULE$, TypeTest$.MODULE$.identity(), ClassTag$.MODULE$.Any()).orElse(DataMap::indexPrintRepresentation$$anonfun$3$$anonfun$1), ClassTag$.MODULE$.apply(Option.class)));
            string = StringUtils$.MODULE$.fixedString("" + ix + ": " + Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object3, (Function1 & Serializable)_$3 -> _$3.get().toString(), ClassTag$.MODULE$.apply(String.class))).mkString("(", ",", ")"), indexWidth, true, StringUtils$.MODULE$.fixedString$default$4());
        }
        return string;
    }

    @Override
    public int indexPrintWidth() {
        return Settings$.MODULE$.printIndexWidthMapped();
    }

    public DataMap<K> withDataFrame(DataFrame df) {
        return DataMap$.MODULE$.apply(df, this.pd$DataMap$$groupCols(), this.pd$DataMap$$map());
    }

    private final String search$1(int ix) {
        Iterator it = this.pd$DataMap$$map().iterator();
        None$ found = None$.MODULE$;
        while (it.hasNext() && found.isEmpty()) {
            Tuple2 e = (Tuple2)it.next();
            Object object = Predef$.MODULE$.intArrayOps((int[])e._2());
            if (!ArrayOps$.MODULE$.contains$extension(object, (Object)BoxesRunTime.boxToInteger((int)ix))) continue;
            found = Some$.MODULE$.apply(e._1());
        }
        return found.isEmpty() ? "" : found.get().toString();
    }

    private static final Some indexPrintRepresentation$$anonfun$3$$anonfun$1() {
        return Some$.MODULE$.apply((Object)"null");
    }

    public static class Groups<K> {
        private final DataMap dm;
        private final Seq aggregates;

        public static <K> DataFrame dataMapGroupsToDataFrame(Groups<K> groups) {
            return DataMap$Groups$.MODULE$.dataMapGroupsToDataFrame(groups);
        }

        public static <K> Seq<Series<Object>> $lessinit$greater$default$2() {
            return DataMap$Groups$.MODULE$.$lessinit$greater$default$2();
        }

        public Groups(DataMap<K> dm, Seq<Series<Object>> aggregates) {
            this.dm = dm;
            this.aggregates = aggregates;
        }

        private DataMap<K> dm() {
            return this.dm;
        }

        private Seq<Series<Object>> aggregates() {
            return this.aggregates;
        }

        public <T, R> Groups<K> agg(String col, Function1<Series<T>, R> op, String newCol, TypeTest<Object, T> evidence$1, ClassTag<T> evidence$2, ClassTag<R> evidence$3) {
            return this.agg(this.dm().apply(col).as(evidence$1, evidence$2), op, newCol, evidence$3);
        }

        public <T, R> String agg$default$3() {
            return "";
        }

        public <T1, T2, R> Groups<K> agg(String col1, String col2, Function2<Series<T1>, Series<T2>, R> op, String newCol, TypeTest<Object, T1> evidence$4, ClassTag<T1> evidence$5, TypeTest<Object, T2> evidence$6, ClassTag<T2> evidence$7, ClassTag<R> evidence$8) {
            return this.agg(this.dm().apply(col1).as(evidence$4, evidence$5), this.dm().apply(col2).as(evidence$6, evidence$7), op, newCol, evidence$8);
        }

        public DataFrame collect() {
            DataFrame dataFrame;
            int[] indices = this.firstIndices();
            Object object = Predef$.MODULE$.refArrayOps((Object[])this.dm().pd$DataMap$$groupCols());
            if (ArrayOps$.MODULE$.isEmpty$extension(object)) {
                dataFrame = DataFrame$.MODULE$.applyDynamic("apply", this.aggregates());
            } else {
                Object object2 = Predef$.MODULE$.refArrayOps((Object[])this.dm().pd$DataMap$$groupCols());
                Object object3 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(object2, (Function1 & Serializable)_$10 -> this.dm().apply((String)_$10).extract(indices), ClassTag$.MODULE$.apply(Series.class)));
                Seq k = ArrayOps$.MODULE$.toSeq$extension(object3);
                dataFrame = (DataFrame)this.aggregates().foldLeft((Object)DataFrame$.MODULE$.applyDynamic("apply", (Seq<Object>)k), (Function2 & Serializable)(_$11, _$12) -> _$11.concat(_$12));
            }
            return dataFrame;
        }

        public DataMap<K> collectAsMap() {
            return DataMap$.MODULE$.apply(this.collect(), this.dm().pd$DataMap$$groupCols(), ((IterableOnceOps)((IterableOps)this.dm().pd$DataMap$$map().keys().zipWithIndex()).map((Function1 & Serializable)e -> Tuple2$.MODULE$.apply(e._1(), (Object)new int[]{BoxesRunTime.unboxToInt((Object)e._2())}))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        }

        public DataMap<K> collectAsMap(boolean dropGroupCols) {
            DataMap<K> dataMap;
            if (dropGroupCols) {
                if (this.aggregates().isEmpty()) {
                    throw IllegalOperation$.MODULE$.apply("Cannot create DataMap since no aggregations are defined.");
                }
                dataMap = DataMap$.MODULE$.apply(DataFrame$.MODULE$.applyDynamic("apply", this.aggregates()), new String[0], ((IterableOnceOps)((IterableOps)this.dm().pd$DataMap$$map().keys().zipWithIndex()).map((Function1 & Serializable)e -> Tuple2$.MODULE$.apply(e._1(), (Object)new int[]{BoxesRunTime.unboxToInt((Object)e._2())}))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            } else {
                dataMap = this.collectAsMap();
            }
            return dataMap;
        }

        public boolean collectAsMap$default$1() {
            return false;
        }

        public Groups<K> count(String col, String newCol) {
            return this.agg(this.dm().apply(col), (Function1 & Serializable)_$13 -> _$13.count(), newCol, ClassTag$.MODULE$.apply(Integer.TYPE));
        }

        public String count$default$2() {
            return "";
        }

        public Groups<K> countRows() {
            return this.countRows(this.countRows$default$1(), this.countRows$default$2());
        }

        public Groups<K> countRows(String newCol, boolean asFraction) {
            Groups<K> groups;
            int i = 0;
            Iterator it = this.dm().pd$DataMap$$map().values().iterator();
            if (asFraction) {
                double[] array = new double[this.dm().pd$DataMap$$map().size()];
                double totalRows = this.dm().numRows();
                while (it.hasNext()) {
                    int[] idx = (int[])it.next();
                    array[i] = (double)idx.length / totalRows;
                    ++i;
                }
                groups = this.append(Series$.MODULE$.apply(new SeriesData(array, null), new UniformIndex(this.dm().pd$DataMap$$map().size()), newCol));
            } else {
                int[] array = new int[this.dm().pd$DataMap$$map().size()];
                while (it.hasNext()) {
                    int[] idx = (int[])it.next();
                    array[i] = idx.length;
                    ++i;
                }
                groups = this.append(Series$.MODULE$.apply(new SeriesData(array, null), new UniformIndex(this.dm().pd$DataMap$$map().size()), newCol));
            }
            return groups;
        }

        public String countRows$default$1() {
            return "count";
        }

        public boolean countRows$default$2() {
            return false;
        }

        public <T> Groups<K> first(String col, String newCol, ClassTag<T> evidence$9, TypeTest<Object, T> evidence$10) {
            return this.aggOption(this.dm().apply(col).as(evidence$10, evidence$9), (Function1 & Serializable)s -> s.headOption(), newCol, evidence$9);
        }

        public <T> String first$default$2() {
            return "";
        }

        public Groups<K> min(String col, String newCol) {
            Groups<K> groups;
            Series<Object> s = this.dm().apply(col);
            Series<Object> Series_this = s;
            if (Series_this.inline$vector$i1(Series_this.inline$data()) instanceof boolean[]) {
                groups = this.agg(Series$.MODULE$.toSeriesAny(s).asBoolean(), (Function1 & Serializable)_$14 -> Series$.MODULE$.toSeriesBoolean((Series<Object>)_$14).min(), newCol, ClassTag$.MODULE$.apply(Boolean.TYPE));
            } else {
                Series<Object> Series_this2 = s;
                if (Series_this2.inline$vector$i2(Series_this2.inline$data()) instanceof double[]) {
                    groups = this.agg(Series$.MODULE$.toSeriesAny(s).toDouble(), (Function1 & Serializable)_$15 -> Series$.MODULE$.toSeriesDouble((Series<Object>)_$15).min(), newCol, ClassTag$.MODULE$.apply(Double.TYPE));
                } else {
                    Series<Object> Series_this3 = s;
                    if (Series_this3.inline$vector$i3(Series_this3.inline$data()) instanceof int[]) {
                        groups = this.agg(Series$.MODULE$.toSeriesAny(s).toInt(), (Function1 & Serializable)_$16 -> Series$.MODULE$.toSeriesInt((Series<Object>)_$16).min(), newCol, ClassTag$.MODULE$.apply(Integer.TYPE));
                    } else {
                        throw IllegalOperation$.MODULE$.apply(s, "min");
                    }
                }
            }
            return groups;
        }

        public String min$default$2() {
            return "";
        }

        public Groups<K> max(String col, String newCol) {
            Groups<K> groups;
            Series<Object> s = this.dm().apply(col);
            Series<Object> Series_this = s;
            if (Series_this.inline$vector$i1(Series_this.inline$data()) instanceof boolean[]) {
                groups = this.agg(Series$.MODULE$.toSeriesAny(s).asBoolean(), (Function1 & Serializable)_$17 -> Series$.MODULE$.toSeriesBoolean((Series<Object>)_$17).max(), newCol, ClassTag$.MODULE$.apply(Boolean.TYPE));
            } else {
                Series<Object> Series_this2 = s;
                if (Series_this2.inline$vector$i2(Series_this2.inline$data()) instanceof double[]) {
                    groups = this.agg(Series$.MODULE$.toSeriesAny(s).toDouble(), (Function1 & Serializable)_$18 -> Series$.MODULE$.toSeriesDouble((Series<Object>)_$18).max(), newCol, ClassTag$.MODULE$.apply(Double.TYPE));
                } else {
                    Series<Object> Series_this3 = s;
                    if (Series_this3.inline$vector$i3(Series_this3.inline$data()) instanceof int[]) {
                        groups = this.agg(Series$.MODULE$.toSeriesAny(s).toInt(), (Function1 & Serializable)_$19 -> Series$.MODULE$.toSeriesInt((Series<Object>)_$19).max(), newCol, ClassTag$.MODULE$.apply(Integer.TYPE));
                    } else {
                        throw IllegalOperation$.MODULE$.apply(s, "max");
                    }
                }
            }
            return groups;
        }

        public String max$default$2() {
            return "";
        }

        public DataFrame pivot(String col, Function1<Series<Object>, Series<?>> mapping, Function2<Object, String, String> names) {
            Object[] objectArray;
            int[] firstGroupIndices = this.firstIndices();
            Object object = Predef$.MODULE$.refArrayOps((Object[])this.dm().pd$DataMap$$groupCols());
            if (!ArrayOps$.MODULE$.contains$extension(object, (Object)col)) {
                throw IllegalOperation$.MODULE$.apply("Column 'col' must be a group column.");
            }
            if (this.dm().pd$DataMap$$groupCols().length < 2) {
                throw IllegalOperation$.MODULE$.apply("Pivot requires grouping by at least two group columns.");
            }
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])this.dm().pd$DataMap$$groupCols());
            DataFrame df2 = DataFrame$.MODULE$.applyDynamic("apply", (Seq<Object>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object2, (Function1 & Serializable)_$20 -> this.dm().apply((String)_$20).extract(firstGroupIndices), ClassTag$.MODULE$.apply(Series.class))));
            Series<Object> pivotSeries = df2.apply(col);
            Series<Object> values = pivotSeries.distinct();
            try {
                objectArray = (Object[])Series$.MODULE$.toSeriesAny(values).sortValues().resetIndex().map((Function1 & Serializable)_$21 -> _$21, ClassTag$.MODULE$.Any()).data().vector();
            }
            catch (IllegalOperation illegalOperation) {
                objectArray = (Object[])values.resetIndex().data().vector();
            }
            Object[] sortedValues = objectArray;
            Object object3 = Predef$.MODULE$.genericArrayOps((Object)sortedValues);
            Tuple2[] pivotedIndices = (Tuple2[])ArrayOps$.MODULE$.map$extension(object3, (Function1 & Serializable)v -> Tuple2$.MODULE$.apply(v, pivotSeries.equalsByRow(v)), ClassTag$.MODULE$.apply(Tuple2.class));
            Seq pivotedAgg = (Seq)this.aggregates().flatMap((Function1 & Serializable)s -> {
                Object object = Predef$.MODULE$.refArrayOps((Object[])pivotedIndices);
                return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)idx -> ((Series)s.apply((Series)idx._2())).as((String)names.apply(idx._1(), (Object)s.name())), ClassTag$.MODULE$.apply(Series.class)));
            });
            DataFrame groupedDf = (DataFrame)pivotedAgg.foldLeft((Object)df2, (Function2 & Serializable)(_$22, _$23) -> _$22.concat(_$23));
            Object object4 = Predef$.MODULE$.refArrayOps((Object[])this.dm().pd$DataMap$$groupCols());
            Object[] nonPivotGroupCols = (String[])ArrayOps$.MODULE$.filterNot$extension(object4, (Function1 & Serializable)_$24 -> {
                String string = _$24;
                String string2 = col;
                return !(string != null ? !string.equals(string2) : string2 != null);
            });
            Object object5 = Predef$.MODULE$.refArrayOps(nonPivotGroupCols);
            Groups<Seq<Object>> groupedDm = groupedDf.groupBy((Seq<String>)ArrayOps$.MODULE$.toSeq$extension(object5));
            ((IterableOnceOps)pivotedAgg.filter(arg_0 -> this.pivot$$anonfun$1((String[])nonPivotGroupCols, arg_0))).foreach((Function1 & Serializable)s -> {
                throw IllegalOperation$.MODULE$.apply("Pivoted values in column `" + col + "` cannot equal a group column name. Found value: '" + s.name() + "'. " + ("Group columns: " + Predef$.MODULE$.wrapRefArray((Object[])this.dm().pd$DataMap$$groupCols()).mkString(", ") + "."));
            });
            DataFrame finalDf = ((Groups)pivotedAgg.foldLeft(groupedDm, (Function2 & Serializable)(groups, s) -> groups.sum(s.name(), groups.sum$default$2()))).collect();
            return mapping == null ? finalDf : (DataFrame)pivotedAgg.foldLeft((Object)finalDf, (Function2 & Serializable)(df, s) -> df.concat((Series)mapping.apply(df.apply(s.name()))));
        }

        public Function1<Series<Object>, Series<?>> pivot$default$2() {
            return null;
        }

        public Function2<Object, String, String> pivot$default$3() {
            return (Function2 & Serializable)(value, aggCol) -> this.aggregates().length() > 1 ? "" + value + ":" + aggCol : String.valueOf(value);
        }

        public Groups<K> sum(String col, String newCol) {
            Groups<K> groups;
            Series<Object> s = this.dm().apply(col);
            Series<Object> Series_this = s;
            if (Series_this.inline$vector$i1(Series_this.inline$data()) instanceof boolean[]) {
                groups = this.agg(Series$.MODULE$.toSeriesAny(s).asBoolean(), (Function1 & Serializable)_$25 -> Series$.MODULE$.toSeriesBoolean((Series<Object>)_$25).sum(), newCol, ClassTag$.MODULE$.apply(Integer.TYPE));
            } else {
                Series<Object> Series_this2 = s;
                if (Series_this2.inline$vector$i2(Series_this2.inline$data()) instanceof double[]) {
                    groups = this.agg(Series$.MODULE$.toSeriesAny(s).toDouble(), (Function1 & Serializable)_$26 -> Series$.MODULE$.toSeriesDouble((Series<Object>)_$26).sum(), newCol, ClassTag$.MODULE$.apply(Double.TYPE));
                } else {
                    Series<Object> Series_this3 = s;
                    if (Series_this3.inline$vector$i3(Series_this3.inline$data()) instanceof int[]) {
                        groups = this.agg(Series$.MODULE$.toSeriesAny(s).toInt(), (Function1 & Serializable)_$27 -> Series$.MODULE$.toSeriesInt((Series<Object>)_$27).sum(), newCol, ClassTag$.MODULE$.apply(Integer.TYPE));
                    } else {
                        throw IllegalOperation$.MODULE$.apply(s, "sum");
                    }
                }
            }
            return groups;
        }

        public String sum$default$2() {
            return "";
        }

        public DataFrame transform() {
            return (DataFrame)this.aggregates().foldLeft(this.dm(), (Function2 & Serializable)(_$28, _$29) -> _$28.concat(this.expand((Series)_$29, (ClassTag)ClassTag$.MODULE$.Any())));
        }

        public DataMap<K> transformAsMap() {
            return DataMap$.MODULE$.apply((DataFrame)this.aggregates().foldLeft(this.dm(), (Function2 & Serializable)(_$30, _$31) -> _$30.concat(this.expand((Series)_$31, (ClassTag)ClassTag$.MODULE$.Any()))), this.dm().pd$DataMap$$groupCols(), this.dm().pd$DataMap$$map());
        }

        public <T, R> Groups<K> agg(Series<T> series, Function1<Series<T>, R> op, String newCol, ClassTag<R> evidence$11) {
            int i = 0;
            Iterator it = this.dm().pd$DataMap$$map().values().iterator();
            Object array = Arrays$.MODULE$.newGenericArray(this.dm().pd$DataMap$$map().size(), evidence$11);
            while (it.hasNext()) {
                int[] idx = (int[])it.next();
                Object v = op.apply(series.extract(idx));
                if (v == null) {
                    throw new MapToNullException();
                }
                ScalaRunTime$.MODULE$.array_update(array, i, v);
                ++i;
            }
            return this.append(Series$.MODULE$.apply(new SeriesData(array, null), new UniformIndex(this.dm().pd$DataMap$$map().size()), newCol.isEmpty() ? series.name() : newCol));
        }

        public <T, R> Groups<K> aggOption(Series<T> series, Function1<Series<T>, Option<R>> op, String newCol, ClassTag<R> evidence$12) {
            int i = 0;
            Iterator it = this.dm().pd$DataMap$$map().values().iterator();
            Object array = Arrays$.MODULE$.newGenericArray(this.dm().pd$DataMap$$map().size(), evidence$12);
            boolean[] mask = (boolean[])Array$.MODULE$.fill(this.dm().pd$DataMap$$map().size(), this::$anonfun$9, ClassTag$.MODULE$.apply(Boolean.TYPE));
            boolean containsNull = false;
            while (it.hasNext()) {
                int[] idx = (int[])it.next();
                Option v = (Option)op.apply(series.extract(idx));
                if (v == null) {
                    throw new MapToNullException();
                }
                if (v.isDefined()) {
                    ScalaRunTime$.MODULE$.array_update(array, i, v.get());
                } else {
                    mask[i] = false;
                    containsNull = true;
                }
                ++i;
            }
            return this.append(Series$.MODULE$.apply(new SeriesData(array, containsNull ? mask : (boolean[])null), new UniformIndex(this.dm().pd$DataMap$$map().size()), newCol.isEmpty() ? series.name() : newCol));
        }

        public <T1, T2, R> Groups<K> agg(Series<T1> series1, Series<T2> series2, Function2<Series<T1>, Series<T2>, R> op, String newCol, ClassTag<R> evidence$13) {
            int i = 0;
            Iterator it = this.dm().pd$DataMap$$map().values().iterator();
            Object array = Arrays$.MODULE$.newGenericArray(this.dm().pd$DataMap$$map().size(), evidence$13);
            while (it.hasNext()) {
                int[] idx = (int[])it.next();
                Object v = op.apply(series1.extract(idx), series2.extract(idx));
                if (v == null) {
                    throw new MapToNullException();
                }
                ScalaRunTime$.MODULE$.array_update(array, i, v);
                ++i;
            }
            return this.append(Series$.MODULE$.apply(new SeriesData(array, null), new UniformIndex(this.dm().pd$DataMap$$map().size()), newCol.isEmpty() ? "" + series1.name() + "," + series2.name() : newCol));
        }

        public <T> Groups<K> append(Series<T> aggregate) {
            Object object = Predef$.MODULE$.refArrayOps((Object[])this.dm().pd$DataMap$$groupCols());
            if (ArrayOps$.MODULE$.contains$extension(object, (Object)aggregate.name())) {
                throw IllegalOperation$.MODULE$.apply("The group column '" + aggregate.name() + "' cannot be used as a result column. Group columns: " + Predef$.MODULE$.wrapRefArray((Object[])this.dm().pd$DataMap$$groupCols()).mkString(", ") + ".");
            }
            return new Groups<K>(this.dm(), (Seq<Series<Object>>)((Seq)this.aggregates().$colon$plus(aggregate.toAny())));
        }

        public <T> Series<T> expand(Series<T> series, ClassTag<T> evidence$14) {
            int i = 0;
            Iterator it = this.dm().pd$DataMap$$map().values().iterator();
            int resultSize = this.dm().index().base().length();
            Object array = series.data().createArray(resultSize);
            while (it.hasNext()) {
                int[] idx = (int[])it.next();
                Object v = ScalaRunTime$.MODULE$.array_apply(series.data().vector(), i);
                int length = idx.length;
                for (int j = 0; j < length; ++j) {
                    ScalaRunTime$.MODULE$.array_update(array, idx[j], v);
                }
                ++i;
            }
            return Series$.MODULE$.apply(series.data().create(array, series.data().create$default$2()), this.dm().index(), series.name());
        }

        /*
         * WARNING - void declaration
         */
        public int[] firstIndices() {
            void var3_3;
            int i = 0;
            Iterator it = this.dm().pd$DataMap$$map().values().iterator();
            int[] indices = new int[this.dm().pd$DataMap$$map().size()];
            while (it.hasNext()) {
                Object object = Predef$.MODULE$.intArrayOps((int[])it.next());
                indices[i] = BoxesRunTime.unboxToInt((Object)ArrayOps$.MODULE$.head$extension(object));
                ++i;
            }
            return var3_3;
        }

        private final /* synthetic */ boolean pivot$$anonfun$1(String[] nonPivotGroupCols$1, Series s) {
            Object object = Predef$.MODULE$.refArrayOps((Object[])nonPivotGroupCols$1);
            return ArrayOps$.MODULE$.contains$extension(object, (Object)s.name());
        }

        private final boolean $anonfun$9() {
            return true;
        }
    }
}

