/*
 * Decompiled with CFR 0.152.
 */
package pd;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.NoSuchElementException;
import pd.DataFrame;
import pd.DataFrame$;
import pd.MutableSeries;
import pd.Order;
import pd.Order$;
import pd.Series$;
import pd.Series$MutableSeriesBuilder$;
import pd.Settings$;
import pd.exception.BaseIndexException;
import pd.exception.IndexBoundsException$;
import pd.exception.SeriesCastException$;
import pd.exception.ValueCastException;
import pd.implicits;
import pd.implicits.SeriesAny;
import pd.implicits.SeriesAny$;
import pd.implicits.SeriesBoolean;
import pd.implicits.SeriesDouble;
import pd.implicits.SeriesDouble$;
import pd.implicits.SeriesInt;
import pd.implicits.SeriesLocalDate;
import pd.implicits.SeriesLocalDateTime;
import pd.implicits.SeriesLocalTime;
import pd.implicits.SeriesString;
import pd.implicits.SeriesString$DefaultOrder$;
import pd.implicits.SeriesZonedDateTime;
import pd.internal.index.BaseIndex;
import pd.internal.index.IndexOps;
import pd.internal.index.SeqIndex$;
import pd.internal.index.UniformIndex;
import pd.internal.series.SeriesData;
import pd.internal.series.SeriesData$;
import pd.internal.series.SeriesOps;
import pd.internal.utils.StringUtils$;
import pd.internal.utils.TypeString$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.TypeTest;
import scala.reflect.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

public class Series<T>
implements IndexOps<Series<T>> {
    private final SeriesData data;
    private final BaseIndex index;
    private final String name;

    public static <T> Series<T> arrayToSeries(Object object, ClassTag<T> classTag) {
        return Series$.MODULE$.arrayToSeries(object, classTag);
    }

    public static <T> Series<T> empty(ClassTag<T> classTag) {
        return Series$.MODULE$.empty(classTag);
    }

    public static <T> Series<T> empty(int n, ClassTag<T> classTag) {
        return Series$.MODULE$.empty(n, classTag);
    }

    public static <T> Series<T> ext(Series<T> series, char c, Series<?> series2) {
        return Series$.MODULE$.ext(series, c, series2);
    }

    public static <T> Series<T> from(Buffer<T> buffer, ClassTag<T> classTag) {
        return Series$.MODULE$.from(buffer, classTag);
    }

    public static <T> Series<T> from(Object object) {
        return Series$.MODULE$.from(object);
    }

    public static <T> Series<T> from(Seq<T> seq, ClassTag<T> classTag) {
        return Series$.MODULE$.from(seq, classTag);
    }

    public static <T> Series<T> fromOption(Option<T>[] optionArray, ClassTag<T> classTag) {
        return Series$.MODULE$.fromOption(optionArray, classTag);
    }

    public static <T> Series<T> fromOption(Seq<Option<T>> seq, ClassTag<T> classTag) {
        return Series$.MODULE$.fromOption(seq, classTag);
    }

    public static SeriesOps opsSingle() {
        return Series$.MODULE$.opsSingle();
    }

    public static void opsSingle_$eq(SeriesOps seriesOps) {
        Series$.MODULE$.opsSingle_$eq(seriesOps);
    }

    public static SeriesOps opsThreaded() {
        return Series$.MODULE$.opsThreaded();
    }

    public static void opsThreaded_$eq(SeriesOps seriesOps) {
        Series$.MODULE$.opsThreaded_$eq(seriesOps);
    }

    public static <T> Series<T> seqToSeries(Seq<T> seq, ClassTag<T> classTag) {
        return Series$.MODULE$.seqToSeries(seq, classTag);
    }

    public static SeriesAny toSeriesAny(MutableSeries<Object> mutableSeries) {
        return Series$.MODULE$.toSeriesAny(mutableSeries);
    }

    public static SeriesAny toSeriesAny(Series<Object> series) {
        return Series$.MODULE$.toSeriesAny(series);
    }

    public static SeriesBoolean toSeriesBoolean(MutableSeries<Object> mutableSeries) {
        return Series$.MODULE$.toSeriesBoolean(mutableSeries);
    }

    public static SeriesBoolean toSeriesBoolean(Series<Object> series) {
        return Series$.MODULE$.toSeriesBoolean(series);
    }

    public static SeriesDouble toSeriesDouble(MutableSeries<Object> mutableSeries) {
        return Series$.MODULE$.toSeriesDouble(mutableSeries);
    }

    public static SeriesDouble toSeriesDouble(Series<Object> series) {
        return Series$.MODULE$.toSeriesDouble(series);
    }

    public static SeriesInt toSeriesInt(MutableSeries<Object> mutableSeries) {
        return Series$.MODULE$.toSeriesInt(mutableSeries);
    }

    public static SeriesInt toSeriesInt(Series<Object> series) {
        return Series$.MODULE$.toSeriesInt(series);
    }

    public static SeriesLocalDate toSeriesLocalDate(MutableSeries<LocalDate> mutableSeries) {
        return Series$.MODULE$.toSeriesLocalDate(mutableSeries);
    }

    public static SeriesLocalDate toSeriesLocalDate(Series<LocalDate> series) {
        return Series$.MODULE$.toSeriesLocalDate(series);
    }

    public static SeriesLocalDateTime toSeriesLocalDateTime(MutableSeries<LocalDateTime> mutableSeries) {
        return Series$.MODULE$.toSeriesLocalDateTime(mutableSeries);
    }

    public static SeriesLocalDateTime toSeriesLocalDateTime(Series<LocalDateTime> series) {
        return Series$.MODULE$.toSeriesLocalDateTime(series);
    }

    public static SeriesLocalTime toSeriesLocalTime(MutableSeries<LocalTime> mutableSeries) {
        return Series$.MODULE$.toSeriesLocalTime(mutableSeries);
    }

    public static SeriesLocalTime toSeriesLocalTime(Series<LocalTime> series) {
        return Series$.MODULE$.toSeriesLocalTime(series);
    }

    public static SeriesString toSeriesString(MutableSeries<String> mutableSeries) {
        return Series$.MODULE$.toSeriesString(mutableSeries);
    }

    public static SeriesString toSeriesString(Series<String> series) {
        return Series$.MODULE$.toSeriesString(series);
    }

    public static SeriesZonedDateTime toSeriesZonedDateTime(MutableSeries<ZonedDateTime> mutableSeries) {
        return Series$.MODULE$.toSeriesZonedDateTime(mutableSeries);
    }

    public static SeriesZonedDateTime toSeriesZonedDateTime(Series<ZonedDateTime> series) {
        return Series$.MODULE$.toSeriesZonedDateTime(series);
    }

    public static <T> Series<T> wrap(Object object) {
        return Series$.MODULE$.wrap(object);
    }

    public static <T> String $lessinit$greater$default$3() {
        return Series$.MODULE$.$lessinit$greater$default$3();
    }

    public static SeriesAny$ inline$SeriesAny$i1(implicits implicits2) {
        return Series$.MODULE$.inline$SeriesAny$i1(implicits2);
    }

    public static SeriesDouble$ inline$SeriesDouble$i1(implicits implicits2) {
        return Series$.MODULE$.inline$SeriesDouble$i1(implicits2);
    }

    public static SeriesAny$ inline$SeriesAny$i2(implicits implicits2) {
        return Series$.MODULE$.inline$SeriesAny$i2(implicits2);
    }

    public static SeriesDouble$ inline$SeriesDouble$i2(implicits implicits2) {
        return Series$.MODULE$.inline$SeriesDouble$i2(implicits2);
    }

    public static SeriesAny$ inline$SeriesAny$i3(implicits implicits2) {
        return Series$.MODULE$.inline$SeriesAny$i3(implicits2);
    }

    public static SeriesDouble$ inline$SeriesDouble$i3(implicits implicits2) {
        return Series$.MODULE$.inline$SeriesDouble$i3(implicits2);
    }

    public static SeriesAny$ inline$SeriesAny$i4(implicits implicits2) {
        return Series$.MODULE$.inline$SeriesAny$i4(implicits2);
    }

    public static SeriesDouble$ inline$SeriesDouble$i4(implicits implicits2) {
        return Series$.MODULE$.inline$SeriesDouble$i4(implicits2);
    }

    public Series(SeriesData<T> data, BaseIndex index, String name) {
        this.data = data;
        this.index = index;
        this.name = name;
    }

    public SeriesData<T> data() {
        return this.data;
    }

    @Override
    public BaseIndex index() {
        return this.index;
    }

    public String name() {
        return this.name;
    }

    public DataFrame concat(DataFrame df) {
        return DataFrame$.MODULE$.fromSeries(this).concat(df);
    }

    public DataFrame concat(Series<?> series) {
        return DataFrame$.MODULE$.fromSeries(this).concat(series);
    }

    public DataFrame prepend(DataFrame df) {
        return DataFrame$.MODULE$.fromSeries(this).prepend(df);
    }

    public <T2> DataFrame prepend(Series<T2> series) {
        return DataFrame$.MODULE$.fromSeries(this).prepend(series);
    }

    public Series<String> prepend(String string) {
        return this.str().map((Function1 & Serializable)_$1 -> string + _$1, ClassTag$.MODULE$.apply(String.class));
    }

    public <T2> Series<Object> equalsByRow(Series<T2> series) {
        return this.map(series, (Function2 & Serializable)(_$2, _$3) -> BoxesRunTime.equals((Object)_$2, (Object)_$3), ClassTag$.MODULE$.apply(Boolean.TYPE));
    }

    public <T2> Series<Object> equalsByRow(T2 v) {
        return this.map((Function1 & Serializable)_$4 -> BoxesRunTime.equals((Object)_$4, (Object)v), ClassTag$.MODULE$.apply(Boolean.TYPE));
    }

    public Series<Object> equalsByRow(boolean v) {
        return this.map((Function1 & Serializable)_$5 -> BoxesRunTime.equals((Object)_$5, (Object)BoxesRunTime.boxToBoolean((boolean)v)), ClassTag$.MODULE$.apply(Boolean.TYPE));
    }

    public Series<Object> equalsByRow(double v) {
        return this.map((Function1 & Serializable)_$6 -> BoxesRunTime.equals((Object)_$6, (Object)BoxesRunTime.boxToDouble((double)v)), ClassTag$.MODULE$.apply(Boolean.TYPE));
    }

    public Series<Object> equalsByRow(int v) {
        return this.map((Function1 & Serializable)_$7 -> BoxesRunTime.equals((Object)_$7, (Object)BoxesRunTime.boxToInteger((int)v)), ClassTag$.MODULE$.apply(Boolean.TYPE));
    }

    public <T2> Series<Object> notEqualsByRow(Series<T2> series) {
        return this.map(series, (Function2 & Serializable)(_$8, _$9) -> !BoxesRunTime.equals((Object)_$8, (Object)_$9), ClassTag$.MODULE$.apply(Boolean.TYPE));
    }

    public <T2> Series<Object> notEqualsByRow(T2 v) {
        return this.map((Function1 & Serializable)_$10 -> !BoxesRunTime.equals((Object)_$10, (Object)v), ClassTag$.MODULE$.apply(Boolean.TYPE));
    }

    public Series<Object> notEqualsByRow(boolean v) {
        return this.map((Function1 & Serializable)_$11 -> !BoxesRunTime.equals((Object)_$11, (Object)BoxesRunTime.boxToBoolean((boolean)v)), ClassTag$.MODULE$.apply(Boolean.TYPE));
    }

    public Series<Object> notEqualsByRow(double v) {
        return this.map((Function1 & Serializable)_$12 -> !BoxesRunTime.equals((Object)_$12, (Object)BoxesRunTime.boxToDouble((double)v)), ClassTag$.MODULE$.apply(Boolean.TYPE));
    }

    public Series<Object> notEqualByRow(int v) {
        return this.map((Function1 & Serializable)_$13 -> !BoxesRunTime.equals((Object)_$13, (Object)BoxesRunTime.boxToInteger((int)v)), ClassTag$.MODULE$.apply(Boolean.TYPE));
    }

    public <R> R agg(R start, Function2<R, T, R> f) {
        return (this.inline$threaded$i1(Settings$.MODULE$) && this.numRows() >= this.inline$minThreadedRows$i1(Settings$.MODULE$) ? this.inline$opsThreaded() : this.inline$opsSingle()).agg(this, start, f);
    }

    public Option<T> apply(int ix) {
        SeriesData<T> SeriesData_this;
        BaseIndex BaseIndex_this = this.index();
        if (ix < 0 || ix >= BaseIndex_this.base().length()) {
            throw IndexBoundsException$.MODULE$.apply(ix, BaseIndex_this.base().length());
        }
        return BaseIndex_this.isContained(ix) ? ((SeriesData_this = this.data()).inline$mask() == null || SeriesData_this.inline$mask()[ix] ? Some$.MODULE$.apply(ScalaRunTime$.MODULE$.array_apply(SeriesData_this.inline$vector(), ix)) : None$.MODULE$) : None$.MODULE$;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Option<T> apply(Option<Object> ix) {
        None$ none$;
        if (ix.isDefined()) {
            int ix$proxy1 = BoxesRunTime.unboxToInt((Object)ix.get());
            BaseIndex BaseIndex_this = this.index();
            if (ix$proxy1 < 0) throw IndexBoundsException$.MODULE$.apply(ix$proxy1, BaseIndex_this.base().length());
            if (ix$proxy1 >= BaseIndex_this.base().length()) throw IndexBoundsException$.MODULE$.apply(ix$proxy1, BaseIndex_this.base().length());
            if (BaseIndex_this.isContained(ix$proxy1)) {
                int ix$proxy2 = BoxesRunTime.unboxToInt((Object)ix.get());
                SeriesData<T> SeriesData_this = this.data();
                if (SeriesData_this.inline$mask() != null && !SeriesData_this.inline$mask()[ix$proxy2]) {
                    none$ = None$.MODULE$;
                    return none$;
                }
                none$ = Some$.MODULE$.apply(ScalaRunTime$.MODULE$.array_apply(SeriesData_this.inline$vector(), ix$proxy2));
                return none$;
            }
        }
        none$ = None$.MODULE$;
        return none$;
    }

    public <T2> Series<T2> as(TypeTest<Object, T2> evidence$1, ClassTag<T2> evidence$2) {
        if (!this.isType(evidence$1)) {
            throw SeriesCastException$.MODULE$.apply(this, TypeString$.MODULE$.mapType(package$.MODULE$.classTag(evidence$2).toString()));
        }
        return Series$.MODULE$.apply(this.data(), this.index(), this.name());
    }

    public Series<T> as(String name) {
        return Series$.MODULE$.apply(this.data(), this.index(), name);
    }

    public <T2> Option<T2> as(int ix, TypeTest<Object, T2> evidence$3) {
        return this.apply(ix);
    }

    public <T2> Option<T2> as(Option<Object> ix, TypeTest<Object, T2> evidence$4, ClassTag<T2> evidence$5) {
        return this.apply(ix);
    }

    public <T2> T2 as(int ix, Function0<T2> function0, TypeTest<Object, T2> evidence$6, ClassTag<T2> evidence$7) {
        Object object;
        BaseIndex BaseIndex_this = this.index();
        if (ix < 0 || ix >= BaseIndex_this.base().length()) {
            throw IndexBoundsException$.MODULE$.apply(ix, BaseIndex_this.base().length());
        }
        if (BaseIndex_this.isContained(ix)) {
            SeriesData<T> SeriesData_this = this.data();
            if (SeriesData_this.inline$mask() == null || SeriesData_this.inline$mask()[ix]) {
                SeriesData<T> SeriesData_this2 = this.data();
                object = ScalaRunTime$.MODULE$.array_apply(SeriesData_this2.inline$vector(), ix);
            } else {
                object = function0.apply();
            }
        } else {
            object = function0.apply();
        }
        return (T2)object;
    }

    /*
     * Enabled aggressive block sorting
     */
    public <T2> T2 as(Option<Object> ix, Function0<T2> function0, TypeTest<Object, T2> evidence$8, ClassTag<T2> evidence$9) {
        Object object;
        if (ix.isDefined()) {
            int ix$proxy3 = BoxesRunTime.unboxToInt((Object)ix.get());
            BaseIndex BaseIndex_this = this.index();
            if (ix$proxy3 < 0) throw IndexBoundsException$.MODULE$.apply(ix$proxy3, BaseIndex_this.base().length());
            if (ix$proxy3 >= BaseIndex_this.base().length()) throw IndexBoundsException$.MODULE$.apply(ix$proxy3, BaseIndex_this.base().length());
            if (BaseIndex_this.isContained(ix$proxy3)) {
                int i = BoxesRunTime.unboxToInt((Object)ix.get());
                SeriesData<T> SeriesData_this = this.data();
                if (SeriesData_this.inline$mask() == null || SeriesData_this.inline$mask()[i]) {
                    SeriesData<T> SeriesData_this2 = this.data();
                    object = ScalaRunTime$.MODULE$.array_apply(SeriesData_this2.inline$vector(), i);
                    return (T2)object;
                }
                object = function0.apply();
                return (T2)object;
            }
        }
        object = function0.apply();
        return (T2)object;
    }

    public int count() {
        return this.inline$vector$i2(this.inline$data()) instanceof double[] ? (this.inline$threaded$i1(Settings$.MODULE$) && this.numRows() >= this.inline$minThreadedRows$i1(Settings$.MODULE$) ? this.inline$opsThreaded() : this.inline$opsSingle()).countD(this) : (this.inline$threaded$i1(Settings$.MODULE$) && this.numRows() >= this.inline$minThreadedRows$i1(Settings$.MODULE$) ? this.inline$opsThreaded() : this.inline$opsSingle()).count(this);
    }

    public Series<T> defined() {
        return this.isDefined() ? this : this.withIndex(SeqIndex$.MODULE$.unchecked(this.index().base(), (int[])this.index().iterator().filter((Function1)(JFunction1.mcZI.sp & Serializable)_$14 -> {
            SeriesData<T> SeriesData_this = this.data();
            return SeriesData_this.inline$mask() == null || SeriesData_this.inline$mask()[_$14];
        }).toArray(ClassTag$.MODULE$.apply(Integer.TYPE))));
    }

    public Series<T> dense() {
        return (this.inline$threaded$i1(Settings$.MODULE$) && this.numRows() >= this.inline$minThreadedRows$i1(Settings$.MODULE$) ? this.inline$opsThreaded() : this.inline$opsSingle()).dense(this);
    }

    public void display(int n, int colWidth) {
        Predef$.MODULE$.println((Object)this.toString(n, colWidth, this.toString$default$3(), this.toString$default$4()));
    }

    public int display$default$1() {
        return Settings$.MODULE$.printRowLength();
    }

    public int display$default$2() {
        return Settings$.MODULE$.printColWidthSeries();
    }

    public Series<T> distinct() {
        Object distinctValues = this.unique();
        return new Series(new SeriesData(distinctValues, SeriesData$.MODULE$.$lessinit$greater$default$2()), new UniformIndex(ScalaRunTime$.MODULE$.array_length(distinctValues)), this.name());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object that) {
        Object object = that;
        if (object instanceof Series) {
            Series that2 = (Series)object;
            if (!this.canEqual(that2)) return false;
            String string = this.name();
            String string2 = that2.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!this.hasSameIndex(that2)) return false;
            if (!this.equalsByValue(that2)) return false;
            return true;
        }
        if (!(object instanceof MutableSeries)) return false;
        MutableSeries that3 = (MutableSeries)object;
        if (!this.canEqual(that3)) return false;
        String string = this.name();
        String string3 = that3.name();
        if (string == null) {
            if (string3 != null) {
                return false;
            }
        } else if (!string.equals(string3)) return false;
        if (!this.hasSameIndex(that3.inner())) return false;
        if (!this.equalsByValue(that3.inner())) return false;
        return true;
    }

    public <T2> boolean equalsByValue(Series<T2> series) {
        BaseIndex BaseIndex_this = this.index();
        return BaseIndex_this.base().equals(series.index().base()) && this.hasSameDefined(series) && this.typeEquals(series) && (this.inline$vector$i2(this.inline$data()) instanceof double[] ? Series$.MODULE$.toSeriesBoolean(this.map(series, (Function2)(JFunction2.mcZDD.sp & Serializable)(a, b) -> a == b || Predef$.MODULE$.double2Double(a).isNaN() && Predef$.MODULE$.double2Double(b).isNaN(), (ClassTag)ClassTag$.MODULE$.apply(Boolean.TYPE))).all() : Series$.MODULE$.toSeriesBoolean(this.map(series, (Function2 & Serializable)(_$15, _$16) -> BoxesRunTime.equals((Object)_$15, (Object)_$16), ClassTag$.MODULE$.apply(Boolean.TYPE))).all());
    }

    public boolean exists(T value) {
        return this.first(value).isDefined();
    }

    public <T2 extends T> Series<T> fill(Series<T2> series) {
        this.requireTypeMatch((T2)series);
        return (this.inline$threaded$i1(Settings$.MODULE$) && this.numRows() >= this.inline$minThreadedRows$i1(Settings$.MODULE$) ? this.inline$opsThreaded() : this.inline$opsSingle()).fill(this, series).withIndex(this.index());
    }

    public Series<T> fill(T value) {
        this.requireTypeMatch(value);
        return (this.inline$threaded$i1(Settings$.MODULE$) && this.numRows() >= this.inline$minThreadedRows$i1(Settings$.MODULE$) ? this.inline$opsThreaded() : this.inline$opsSingle()).fill(this, value);
    }

    public <T2 extends T> Series<T> fillAll(Series<T2> series) {
        this.requireTypeMatch((T2)series);
        return (this.inline$threaded$i1(Settings$.MODULE$) && this.numRows() >= this.inline$minThreadedRows$i1(Settings$.MODULE$) ? this.inline$opsThreaded() : this.inline$opsSingle()).fill(this, series);
    }

    public Series<T> fillAll(T value) {
        this.requireTypeMatch(value);
        return (this.inline$threaded$i1(Settings$.MODULE$) && this.numRows() >= this.inline$minThreadedRows$i1(Settings$.MODULE$) ? this.inline$opsThreaded() : this.inline$opsSingle()).fillAll(this, value);
    }

    public Option<Object> first() {
        return this.inline$vector$i1(this.inline$data()) instanceof boolean[] ? (this.inline$threaded$i1(Settings$.MODULE$) && this.numRows() >= this.inline$minThreadedRows$i1(Settings$.MODULE$) ? this.inline$opsThreaded() : this.inline$opsSingle()).firstB(this, true) : (this.inline$threaded$i1(Settings$.MODULE$) && this.numRows() >= this.inline$minThreadedRows$i1(Settings$.MODULE$) ? this.inline$opsThreaded() : this.inline$opsSingle()).firstIndex(this);
    }

    public Option<Object> first(Function1<T, Object> f) {
        return (this.inline$threaded$i1(Settings$.MODULE$) && this.numRows() >= this.inline$minThreadedRows$i1(Settings$.MODULE$) ? this.inline$opsThreaded() : this.inline$opsSingle()).find(this, f);
    }

    public Option<Object> first(T value) {
        return (this.inline$threaded$i1(Settings$.MODULE$) && this.numRows() >= this.inline$minThreadedRows$i1(Settings$.MODULE$) ? this.inline$opsThreaded() : this.inline$opsSingle()).first(this, value);
    }

    public <T2> Option<T> first(Series<T2> series, T2 value) {
        BaseIndex BaseIndex_this = this.index();
        if (!BaseIndex_this.base().equals(series.index().base())) {
            throw new BaseIndexException(this, series);
        }
        return this.apply(series.first(value));
    }

    /*
     * Enabled aggressive block sorting
     */
    public <T2> T first(Series<T2> series, T2 value, Function0<T> function0) {
        Object object;
        BaseIndex BaseIndex_this = this.index();
        if (!BaseIndex_this.base().equals(series.index().base())) {
            throw new BaseIndexException(this, series);
        }
        Option<Object> ix$proxy4 = series.first(value);
        if (ix$proxy4.isDefined()) {
            int ix$proxy5 = BoxesRunTime.unboxToInt((Object)ix$proxy4.get());
            BaseIndex BaseIndex_this2 = this.inline$index();
            if (ix$proxy5 < 0) throw IndexBoundsException$.MODULE$.apply(ix$proxy5, BaseIndex_this2.base().length());
            if (ix$proxy5 >= BaseIndex_this2.base().length()) throw IndexBoundsException$.MODULE$.apply(ix$proxy5, BaseIndex_this2.base().length());
            if (BaseIndex_this2.isContained(ix$proxy5)) {
                int i = BoxesRunTime.unboxToInt((Object)ix$proxy4.get());
                SeriesData<T> SeriesData_this = this.inline$data();
                if (SeriesData_this.inline$mask() == null || SeriesData_this.inline$mask()[i]) {
                    SeriesData<T> SeriesData_this2 = this.inline$data();
                    object = ScalaRunTime$.MODULE$.array_apply(SeriesData_this2.inline$vector(), i);
                    return (T)object;
                }
                object = Series.default$proxy1$1(function0);
                return (T)object;
            }
        }
        object = Series.default$proxy1$1(function0);
        return (T)object;
    }

    public boolean forall(Function1<T, Object> f) {
        boolean bl;
        Option<Object> option = (this.inline$threaded$i1(Settings$.MODULE$) && this.numRows() >= this.inline$minThreadedRows$i1(Settings$.MODULE$) ? this.inline$opsThreaded() : this.inline$opsSingle()).find(this, (Function1 & Serializable)x -> !BoxesRunTime.unboxToBoolean((Object)f.apply(x)));
        if (option instanceof Some) {
            bl = false;
        } else if (None$.MODULE$.equals(option)) {
            bl = true;
        } else {
            throw new MatchError(option);
        }
        return bl;
    }

    public boolean forallStrictly(Function1<T, Object> f) {
        return !this.hasUndefined() && this.forall(f);
    }

    public int hashCode() {
        return 31 * Statics.anyHash((Object)this.name()) + Statics.anyHash((Object)BoxesRunTime.boxToInteger((int)this.index().length()));
    }

    public <T2> boolean hasSameDefined(Series<T2> series) {
        BaseIndex BaseIndex_this = this.index();
        return BaseIndex_this.base().equals(series.index().base()) && (this.inline$threaded$i1(Settings$.MODULE$) && this.numRows() >= this.inline$minThreadedRows$i1(Settings$.MODULE$) ? this.inline$opsThreaded() : this.inline$opsSingle()).compareNulls(this, series);
    }

    public <T2> boolean hasSameIndex(Series<T2> series) {
        return this.index().equals(series.index());
    }

    public boolean hasUndefined() {
        return !this.isDefined();
    }

    public Option<T> headOption() {
        return this.index().isEmpty() ? None$.MODULE$ : this.apply(this.index().head(1).toSeqIndex().indices()[0]);
    }

    public Option<T> headValue() {
        return this.apply((this.inline$threaded$i1(Settings$.MODULE$) && this.numRows() >= this.inline$minThreadedRows$i1(Settings$.MODULE$) ? this.inline$opsThreaded() : this.inline$opsSingle()).firstIndex(this));
    }

    public boolean indexEmpty() {
        return this.index().isEmpty();
    }

    public Iterator<Object> indexIterator() {
        return this.index().iterator();
    }

    public boolean indexNonEmpty() {
        return this.index().nonEmpty();
    }

    public String info() {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Series '" + this.name() + "':\n         |  Series with " + StringUtils$.MODULE$.asElements(this.index().length()) + ".\n         |  " + this.data().describe() + "\n         |  The Series has a " + this.index().describe() + "\n         |"), '|');
    }

    public boolean isDefined() {
        return !this.data().containsNull() && this.index().isBijective();
    }

    public boolean isEmpty() {
        return this.index().isEmpty() || (this.inline$threaded$i1(Settings$.MODULE$) && this.numRows() >= this.inline$minThreadedRows$i1(Settings$.MODULE$) ? this.inline$opsThreaded() : this.inline$opsSingle()).firstIndex(this).isEmpty();
    }

    public <T2> boolean isType(TypeTest<Object, T2> evidence$10) {
        boolean bl;
        Option option;
        Object object;
        boolean bl2 = true;
        Option option2 = evidence$10.unapply((Object)BoxesRunTime.boxToBoolean((boolean)bl2));
        if (!option2.isEmpty()) {
            boolean bl3 = BoxesRunTime.unboxToBoolean((Object)option2.get());
            int n = 1;
            Option option3 = evidence$10.unapply((Object)BoxesRunTime.boxToInteger((int)n));
            if (!option3.isEmpty()) {
                int n2 = BoxesRunTime.unboxToInt((Object)option3.get());
                return true;
            }
            return this.inline$vector$i1(this.inline$data()) instanceof boolean[];
        }
        double d = 1.0;
        Option option4 = evidence$10.unapply((Object)BoxesRunTime.boxToDouble((double)d));
        if (!option4.isEmpty()) {
            double d2 = BoxesRunTime.unboxToDouble((Object)option4.get());
            return this.inline$vector$i2(this.inline$data()) instanceof double[];
        }
        int n = 1;
        Option option5 = evidence$10.unapply((Object)BoxesRunTime.boxToInteger((int)n));
        if (!option5.isEmpty()) {
            int n3 = BoxesRunTime.unboxToInt((Object)option5.get());
            return this.inline$vector$i3(this.inline$data()) instanceof int[];
        }
        String string = "";
        Option option6 = evidence$10.unapply((Object)string);
        if (!option6.isEmpty()) {
            String string2 = (String)option6.get();
            return this.inline$vector$i4(this.inline$data()) instanceof String[];
        }
        Option<T> option7 = this.headOption();
        if (option7 instanceof Some && (object = ((Some)option7).value()) != null && !(option = evidence$10.unapply(object)).isEmpty()) {
            Object object2 = option.get();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public <T2> boolean isTypeAll(TypeTest<Object, T2> evidence$11) {
        return this.isDefined() && this.isType(evidence$11);
    }

    public <T2> boolean isTypeAllStrictly(TypeTest<Object, T2> evidence$12) {
        return this.isDefined() && this.isTypeStrictly(evidence$12);
    }

    public <T2> boolean isTypeStrictly(TypeTest<Object, T2> evidence$13) {
        boolean bl = true;
        Option option = evidence$13.unapply((Object)BoxesRunTime.boxToBoolean((boolean)bl));
        if (!option.isEmpty()) {
            boolean bl2 = BoxesRunTime.unboxToBoolean((Object)option.get());
            int n = 1;
            Option option2 = evidence$13.unapply((Object)BoxesRunTime.boxToInteger((int)n));
            if (!option2.isEmpty()) {
                int n2 = BoxesRunTime.unboxToInt((Object)option2.get());
                return true;
            }
            return this.inline$vector$i1(this.inline$data()) instanceof boolean[];
        }
        double d = 1.0;
        Option option3 = evidence$13.unapply((Object)BoxesRunTime.boxToDouble((double)d));
        if (!option3.isEmpty()) {
            double d2 = BoxesRunTime.unboxToDouble((Object)option3.get());
            return this.inline$vector$i2(this.inline$data()) instanceof double[];
        }
        int n = 1;
        Option option4 = evidence$13.unapply((Object)BoxesRunTime.boxToInteger((int)n));
        if (!option4.isEmpty()) {
            int n3 = BoxesRunTime.unboxToInt((Object)option4.get());
            return this.inline$vector$i3(this.inline$data()) instanceof int[];
        }
        String string = "";
        Option option5 = evidence$13.unapply((Object)string);
        if (!option5.isEmpty()) {
            String string2 = (String)option5.get();
            return this.inline$vector$i4(this.inline$data()) instanceof String[];
        }
        return this.forall((Function1 & Serializable)_$17 -> {
            boolean bl;
            Option option;
            Object object = _$17;
            if (object != null && !(option = evidence$13.unapply(object)).isEmpty()) {
                Object object2 = option.get();
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        });
    }

    public Iterator<Option<T>> iterator() {
        return this.index().iterator().map((Function1 & Serializable)_$18 -> this.iterator$$anonfun$1(BoxesRunTime.unboxToInt((Object)_$18)));
    }

    public Option<Object> last() {
        return this.inline$vector$i1(this.inline$data()) instanceof boolean[] ? (this.inline$threaded$i1(Settings$.MODULE$) && this.numRows() >= this.inline$minThreadedRows$i1(Settings$.MODULE$) ? this.inline$opsThreaded() : this.inline$opsSingle()).lastB(this, true) : (this.inline$threaded$i1(Settings$.MODULE$) && this.numRows() >= this.inline$minThreadedRows$i1(Settings$.MODULE$) ? this.inline$opsThreaded() : this.inline$opsSingle()).lastIndex(this);
    }

    public Option<Object> last(T value) {
        return (this.inline$threaded$i1(Settings$.MODULE$) && this.numRows() >= this.inline$minThreadedRows$i1(Settings$.MODULE$) ? this.inline$opsThreaded() : this.inline$opsSingle()).last(this, value);
    }

    public <T2> Option<T> last(Series<T2> series, T2 value) {
        BaseIndex BaseIndex_this = this.index();
        if (!BaseIndex_this.base().equals(series.index().base())) {
            throw new BaseIndexException(this, series);
        }
        return this.apply(series.last(value));
    }

    /*
     * Enabled aggressive block sorting
     */
    public <T2> T last(Series<T2> series, T2 value, Function0<T> function0) {
        Object object;
        BaseIndex BaseIndex_this = this.index();
        if (!BaseIndex_this.base().equals(series.index().base())) {
            throw new BaseIndexException(this, series);
        }
        Option<Object> ix$proxy6 = series.last(value);
        if (ix$proxy6.isDefined()) {
            int ix$proxy7 = BoxesRunTime.unboxToInt((Object)ix$proxy6.get());
            BaseIndex BaseIndex_this2 = this.inline$index();
            if (ix$proxy7 < 0) throw IndexBoundsException$.MODULE$.apply(ix$proxy7, BaseIndex_this2.base().length());
            if (ix$proxy7 >= BaseIndex_this2.base().length()) throw IndexBoundsException$.MODULE$.apply(ix$proxy7, BaseIndex_this2.base().length());
            if (BaseIndex_this2.isContained(ix$proxy7)) {
                int i = BoxesRunTime.unboxToInt((Object)ix$proxy6.get());
                SeriesData<T> SeriesData_this = this.inline$data();
                if (SeriesData_this.inline$mask() == null || SeriesData_this.inline$mask()[i]) {
                    SeriesData<T> SeriesData_this2 = this.inline$data();
                    object = ScalaRunTime$.MODULE$.array_apply(SeriesData_this2.inline$vector(), i);
                    return (T)object;
                }
                object = Series.default$proxy2$1(function0);
                return (T)object;
            }
        }
        object = Series.default$proxy2$1(function0);
        return (T)object;
    }

    public int length() {
        return this.index().length();
    }

    public <R> Series<R> map(Function1<T, R> f, ClassTag<R> evidence$14) {
        return (this.inline$threaded$i1(Settings$.MODULE$) && this.numRows() >= this.inline$minThreadedRows$i1(Settings$.MODULE$) ? this.inline$opsThreaded() : this.inline$opsSingle()).map(this, f, evidence$14);
    }

    public <T2, R> Series<R> map(Series<T2> series, Function2<T, T2, R> f, ClassTag<R> evidence$15) {
        return (this.inline$threaded$i1(Settings$.MODULE$) && this.numRows() >= this.inline$minThreadedRows$i1(Settings$.MODULE$) ? this.inline$opsThreaded() : this.inline$opsSingle()).map(this, series, f, evidence$15);
    }

    public MutableSeries<T> mutable() {
        return new MutableSeries<T>(new Series<T>(this.data().clone(), this.index(), this.name()));
    }

    public boolean nonEmpty() {
        return !this.isEmpty();
    }

    public int numRows() {
        return this.index().length();
    }

    public int numRowsBase() {
        return this.index().base().length();
    }

    public <T2 extends T> Series<T> orElse(Series<T2> series) {
        return this.fill((T)series);
    }

    public Series<T> orElse(T value) {
        return this.fill(value);
    }

    public Series<T> resetIndex() {
        return this.index() instanceof UniformIndex ? this : this.extract(this.index().toSeqIndex().indices());
    }

    public void show(int n, boolean annotateIndex, boolean annotateType, int colWidth) {
        Predef$.MODULE$.println((Object)this.toString(n, colWidth, annotateIndex, annotateType));
    }

    public int show$default$1() {
        return Settings$.MODULE$.printRowLength();
    }

    public boolean show$default$2() {
        return false;
    }

    public boolean show$default$3() {
        return false;
    }

    public int show$default$4() {
        return Settings$.MODULE$.printColWidthSeries();
    }

    public void showValues(int n) {
        Predef$.MODULE$.require(n >= -1);
        int len = n == -1 ? this.index().length() : n;
        Predef$.MODULE$.println((Object)this.index().overWithIndex(this.data()).take(len).map((Function1 & Serializable)t -> String.valueOf(((Option)t._2()).getOrElse(Series::showValues$$anonfun$2$$anonfun$1).toString())).mkString("\n"));
    }

    public int showValues$default$1() {
        return -1;
    }

    public Series<T> sorted(Ordering<T> ordering) {
        return this.sorted(Order$.asc, ordering);
    }

    public Series<T> sorted(Order order, Ordering<T> ordering) {
        return this.inline$vector$i4(this.inline$data()) instanceof String[] && ordering instanceof Ordering.StringOrdering ? this.sort(order, SeriesString$DefaultOrder$.MODULE$) : this.sort(order, ordering);
    }

    public Series<String> str() {
        return this.inline$vector$i4(this.inline$data()) instanceof String[] ? this : this.map((Function1 & Serializable)_$19 -> _$19.toString(), ClassTag$.MODULE$.apply(String.class));
    }

    public Series<Object> toAny() {
        return this;
    }

    public Option<T>[] toArray() {
        return (Option[])this.iterator().toArray(ClassTag$.MODULE$.apply(Option.class));
    }

    public Object toFlatArray() {
        return this.defined().resetIndexOrCopy().data().vector();
    }

    public List<T> toFlatList() {
        return Predef$.MODULE$.genericWrapArray(this.toFlatArray()).toList();
    }

    public Seq<T> toFlatSeq() {
        Object object = Predef$.MODULE$.genericArrayOps(this.toFlatArray());
        return ArrayOps$.MODULE$.toSeq$extension(object);
    }

    public List<Option<T>> toList() {
        return this.iterator().toList();
    }

    public Seq<Option<T>> toSeq() {
        return this.iterator().toSeq();
    }

    public String toString() {
        return "\n" + this.toString(this.toString$default$1(), this.toString$default$2(), this.toString$default$3(), this.toString$default$4());
    }

    public String toString(int n, int colWidth, boolean annotateIndex, boolean annotateType) {
        DataFrame dataFrame = DataFrame$.MODULE$.fromSeries(this.name().isEmpty() ? this.as("Series") : this);
        return dataFrame.toString(n, 0, annotateIndex, annotateType, colWidth, dataFrame.toString$default$6());
    }

    public int toString$default$1() {
        return Settings$.MODULE$.printRowLength();
    }

    public int toString$default$2() {
        return Settings$.MODULE$.printColWidthSeries();
    }

    public boolean toString$default$3() {
        return true;
    }

    public boolean toString$default$4() {
        return true;
    }

    public String typeString() {
        return this.data().typeString(this.data().typeString$default$1());
    }

    public <T2 extends T> Series<T> union(Seq<Series<T2>> series) {
        Series<T> series2;
        if (series.isEmpty()) {
            series2 = this.resetIndex();
        } else {
            try {
                Object object = Predef$.MODULE$.refArrayOps((Object[])((IterableOnceOps)series.map((Function1 & Serializable)_$20 -> _$20)).toArray(ClassTag$.MODULE$.apply(Series.class)));
                series2 = (this.inline$threaded$i1(Settings$.MODULE$) && this.numRows() >= this.inline$minThreadedRows$i1(Settings$.MODULE$) ? this.inline$opsThreaded() : this.inline$opsSingle()).union((Series[])ArrayOps$.MODULE$.$plus$colon$extension(object, (Object)this, ClassTag$.MODULE$.apply(Series.class)));
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof ClassCastException || throwable2 instanceof ArrayStoreException) {
                    throw SeriesCastException$.MODULE$.apply(this, series);
                }
                throw throwable;
            }
        }
        return series2;
    }

    public Object unique() {
        Object object = Predef$.MODULE$.genericArrayOps(this.defined().resetIndex().data().vector());
        return ArrayOps$.MODULE$.distinct$extension(object);
    }

    public <T2 extends T> Series<T> update(Series<T2> series) {
        this.requireTypeMatch((T2)series);
        return (this.inline$threaded$i1(Settings$.MODULE$) && this.numRows() >= this.inline$minThreadedRows$i1(Settings$.MODULE$) ? this.inline$opsThreaded() : this.inline$opsSingle()).update(series, this);
    }

    public boolean canEqual(Object a) {
        return a instanceof Series || a instanceof MutableSeries;
    }

    public Series<T> extract(int[] indices) {
        return (this.inline$threaded$i1(Settings$.MODULE$) && this.numRows() >= this.inline$minThreadedRows$i1(Settings$.MODULE$) ? this.inline$opsThreaded() : this.inline$opsSingle()).extract(this, indices);
    }

    public T javaGet(int ix) {
        Object object;
        try {
            BaseIndex BaseIndex_this = this.inline$index();
            if (ix < 0 || ix >= BaseIndex_this.base().length()) {
                throw IndexBoundsException$.MODULE$.apply(ix, BaseIndex_this.base().length());
            }
            if (BaseIndex_this.isContained(ix)) {
                SeriesData<T> SeriesData_this = this.inline$data();
                if (!(SeriesData_this.inline$mask() == null || SeriesData_this.inline$mask()[ix])) {
                    throw new NoSuchElementException("No value for index position " + ix + ".");
                }
            } else {
                throw new NoSuchElementException("Invalid index position " + ix + ".");
            }
            SeriesData<T> SeriesData_this = this.inline$data();
            object = ScalaRunTime$.MODULE$.array_apply(SeriesData_this.inline$vector(), ix);
        }
        catch (Throwable throwable) {
            throw new NoSuchElementException("Invalid index position " + ix + ".");
        }
        return (T)object;
    }

    public <T2> void requireTypeMatch(Series<T2> series) {
        if (!this.typeMatch((T2)series)) {
            throw SeriesCastException$.MODULE$.apply(series, this.typeString());
        }
    }

    public <T2> void requireTypeMatch(T2 value) {
        if (!this.typeMatch(value)) {
            throw new ValueCastException(value, this.typeString());
        }
    }

    public Series<T> resetIndexOrCopy() {
        return this.index() instanceof UniformIndex ? new Series<T>(this.data().clone(), this.index(), this.name()) : this.extract(this.index().toSeqIndex().indices());
    }

    public String seriesName() {
        return "Series" + (this.name().isEmpty() ? "" : " " + this.name());
    }

    public Series<T> sort(Order order, Ordering<T> ordering) {
        SeriesData seriesData = (SeriesData)Predef$.MODULE$.ArrowAssoc(this.data());
        return this.withIndex(this.index().sorted(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)seriesData, (Object)order), ordering));
    }

    public <T2> boolean typeEquals(Series<T2> series) {
        Class<?> classThis = this.data().vectorClass();
        Class<?> classSeries = series.data().vectorClass();
        Class<?> clazz = classThis;
        Class<?> clazz2 = classSeries;
        return !(clazz != null ? !clazz.equals(clazz2) : clazz2 != null);
    }

    public <T2> boolean typeMatch(Series<T2> series) {
        Class<?> classThis = this.data().vectorClass();
        Class<?> classSeries = series.data().vectorClass();
        Class<?> clazz = classThis;
        Class<?> clazz2 = classSeries;
        return !(clazz == null ? clazz2 != null : !clazz.equals(clazz2)) || classThis.isAssignableFrom(classSeries);
    }

    public <T2> boolean typeMatch(T2 value) {
        boolean bl;
        T2 T2 = value;
        if (T2 instanceof Boolean) {
            bl = this.inline$vector$i1(this.inline$data()) instanceof boolean[];
        } else if (T2 instanceof Byte) {
            bl = this.data().vector() instanceof byte[];
        } else if (T2 instanceof Character) {
            bl = this.data().vector() instanceof char[];
        } else if (T2 instanceof Double) {
            bl = this.inline$vector$i2(this.inline$data()) instanceof double[];
        } else if (T2 instanceof Float) {
            bl = this.data().vector() instanceof float[];
        } else if (T2 instanceof Integer) {
            bl = this.inline$vector$i3(this.inline$data()) instanceof int[];
        } else if (T2 instanceof Long) {
            bl = this.data().vector() instanceof long[];
        } else if (T2 instanceof Short) {
            bl = this.data().vector() instanceof short[];
        } else {
            Class<?> classThis = this.data().vectorClass();
            Class<?> classValue = value == null ? null : value.getClass();
            Class<?> clazz = classThis;
            Class<?> clazz2 = classValue;
            bl = !(clazz == null ? clazz2 != null : !clazz.equals(clazz2)) || classThis.isAssignableFrom(classValue);
        }
        return bl;
    }

    public int[] undefinedIndices() {
        return this.isDefined() ? new int[]{} : (int[])this.index().iterator().filterNot((Function1)(JFunction1.mcZI.sp & Serializable)_$21 -> {
            SeriesData<T> SeriesData_this = this.data();
            return SeriesData_this.inline$mask() == null || SeriesData_this.inline$mask()[_$21];
        }).toArray(ClassTag$.MODULE$.apply(Integer.TYPE));
    }

    @Override
    public Series<T> withIndex(BaseIndex index) {
        return new Series<T>(this.data(), index, this.name());
    }

    public BaseIndex inline$index() {
        return this.index();
    }

    public SeriesData<T> inline$data() {
        return this.data();
    }

    public Object inline$vector$i1(SeriesData<T> x$0) {
        return x$0.vector();
    }

    public Object inline$vector$i2(SeriesData<T> x$0) {
        return x$0.vector();
    }

    public Object inline$vector$i3(SeriesData<T> x$0) {
        return x$0.vector();
    }

    public Object inline$vector$i4(SeriesData<T> x$0) {
        return x$0.vector();
    }

    public SeriesOps inline$opsThreaded() {
        return Series$.MODULE$.opsThreaded();
    }

    public SeriesOps inline$opsSingle() {
        return Series$.MODULE$.opsSingle();
    }

    public boolean inline$threaded$i1(Settings$ x$0) {
        return x$0.threaded();
    }

    public int inline$minThreadedRows$i1(Settings$ x$0) {
        return x$0.minThreadedRows();
    }

    private static final Object default$proxy1$1(Function0 default$1) {
        return default$1.apply();
    }

    private final /* synthetic */ Option iterator$$anonfun$1(int _$18) {
        SeriesData<T> SeriesData_this = this.data();
        return SeriesData_this.inline$mask() == null || SeriesData_this.inline$mask()[_$18] ? Some$.MODULE$.apply(ScalaRunTime$.MODULE$.array_apply(SeriesData_this.inline$vector(), _$18)) : None$.MODULE$;
    }

    private static final Object default$proxy2$1(Function0 default$2) {
        return default$2.apply();
    }

    private static final String showValues$$anonfun$2$$anonfun$1() {
        return "null";
    }

    public static class MutableSeriesBuilder {
        private final String name;

        public static String $lessinit$greater$default$1() {
            return Series$MutableSeriesBuilder$.MODULE$.$lessinit$greater$default$1();
        }

        public MutableSeriesBuilder(String name) {
            this.name = name;
        }

        public <T> MutableSeries<T> fill(int length, T value, ClassTag<T> evidence$35) {
            return new MutableSeries<T>(Series$.MODULE$.fill(length, value, evidence$35).as(this.name));
        }

        public <T> MutableSeries<T> from(Object data, ClassTag<T> evidence$36) {
            return new MutableSeries(Series$.MODULE$.from(data).as(this.name));
        }

        public <T> MutableSeries<T> from(Buffer<T> data, ClassTag<T> evidence$37) {
            return new MutableSeries<T>(Series$.MODULE$.from(data, evidence$37).as(this.name));
        }

        public <T> MutableSeries<T> from(Seq<T> data, ClassTag<T> evidence$38) {
            return new MutableSeries<T>(Series$.MODULE$.from(data, evidence$38).as(this.name));
        }

        public <T> MutableSeries<T> fromOption(Option<T>[] data, ClassTag<T> evidence$39) {
            return new MutableSeries<T>(Series$.MODULE$.fromOption(data, evidence$39).as(this.name));
        }

        public <T> MutableSeries<T> fromOption(Seq<Option<T>> data, ClassTag<T> evidence$40) {
            return new MutableSeries<T>(Series$.MODULE$.fromOption(data, evidence$40).as(this.name));
        }

        public String toString() {
            return "MutableSeriesBuilder(" + this.name + ")";
        }

        public <T> MutableSeries<T> wrap(Object array) {
            return new MutableSeries(new Series(SeriesData$.MODULE$.wrapArray(array), new UniformIndex(ScalaRunTime$.MODULE$.array_length(array)), this.name));
        }
    }

    public static class SeriesBuilder {
        private final String name;

        public SeriesBuilder(String name) {
            this.name = name;
        }

        public <T> Series<T> apply(Seq<Object> values, ClassTag<T> evidence$27) {
            return new Series<T>(SeriesData$.MODULE$.fromCollectionWithNull(values, evidence$27), new UniformIndex(values.length()), this.name);
        }

        public <T> Series<T> fill(int length, T value, ClassTag<T> evidence$28) {
            return Series$.MODULE$.fill(length, value, evidence$28).as(this.name);
        }

        public <T> Series<T> from(Object data, ClassTag<T> evidence$29) {
            return Series$.MODULE$.from(data).as(this.name);
        }

        public <T> Series<T> from(Buffer<T> data, ClassTag<T> evidence$30) {
            return Series$.MODULE$.from(data, evidence$30).as(this.name);
        }

        public <T> Series<T> from(Seq<T> data, ClassTag<T> evidence$31) {
            return Series$.MODULE$.from(data, evidence$31).as(this.name);
        }

        public <T> Series<T> fromOption(Option<T>[] data, ClassTag<T> evidence$32) {
            return Series$.MODULE$.fromOption(data, evidence$32).as(this.name);
        }

        public <T> Series<T> fromOption(Seq<Option<T>> data, ClassTag<T> evidence$33) {
            return Series$.MODULE$.fromOption(data, evidence$33).as(this.name);
        }

        public MutableSeriesBuilder mutable() {
            return new MutableSeriesBuilder(this.name);
        }

        public <T> MutableSeries<T> mutable(Seq<Object> values, ClassTag<T> evidence$34) {
            return new MutableSeries<T>(this.apply(values, evidence$34));
        }

        public String toString() {
            return "SeriesBuilder(" + this.name + ")";
        }

        public <T> Series<T> wrap(Object array) {
            return new Series(SeriesData$.MODULE$.wrapArray(array), new UniformIndex(ScalaRunTime$.MODULE$.array_length(array)), this.name);
        }
    }
}

