/*
 * Decompiled with CFR 0.152.
 */
package pd.exception;

import java.io.Serializable;
import pd.DataFrame;
import pd.Series;
import pd.Series$;
import pd.exception.ColumnNotFoundException;
import pd.exception.Requirement$;
import pd.exception.RequirementException$;
import pd.internal.utils.RequireType;
import scala.Function1;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.TypeTest;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class Requirement {
    private final DataFrame df;
    private final boolean _all;
    private final boolean _strict;

    public static boolean $lessinit$greater$default$2() {
        return Requirement$.MODULE$.$lessinit$greater$default$2();
    }

    public static boolean $lessinit$greater$default$3() {
        return Requirement$.MODULE$.$lessinit$greater$default$3();
    }

    public Requirement(DataFrame df, boolean _all, boolean _strict) {
        this.df = df;
        this._all = _all;
        this._strict = _strict;
    }

    public Requirement all() {
        return new Requirement(this.df, true, this._strict);
    }

    public <T> Requirement check(String col, Function1<T, Object> condition, boolean all, ClassTag<T> evidence$1, TypeTest<Object, T> evidence$2, RequireType<T> evidence$3) {
        this.isType(col, all, evidence$2, evidence$3);
        return this.raiseOnErrorTyped(col, (Function1 & Serializable)_$1 -> _$1.forall(condition), "Condition failed.", evidence$1, evidence$2);
    }

    public boolean check$default$3() {
        return this._all;
    }

    public <T> Requirement checkAll(String col, Function1<T, Object> condition, ClassTag<T> evidence$4, TypeTest<Object, T> evidence$5, RequireType<T> evidence$6) {
        return this.check(col, condition, true, evidence$4, evidence$5, evidence$6);
    }

    public Requirement has(Seq<String> cols) {
        cols.foreach((Function1 & Serializable)col -> this.raiseOnError((String)col, (Function1<Series<Object>, Object>)(Function1 & Serializable)_$2 -> true, this.raiseOnError$default$3()));
        return this;
    }

    public Requirement hasExactly(Seq<String> cols) {
        if (cols.length() != ((SeqOps)cols.distinct()).length()) {
            throw RequirementException$.MODULE$.apply("list " + cols.mkString(", "), "Elements are not distinct.");
        }
        cols.foreach((Function1 & Serializable)col -> this.raiseOnError((String)col, (Function1<Series<Object>, Object>)(Function1 & Serializable)_$3 -> true, this.raiseOnError$default$3()));
        if (this.df.numCols() > cols.length()) {
            String extra = ((IterableOnceOps)this.df.columns().filterNot((Function1 & Serializable)elem -> cols.contains(elem))).mkString(", ");
            throw RequirementException$.MODULE$.apply("list " + cols.mkString(", "), "Found unexpected columns: " + extra + ".");
        }
        return this;
    }

    public Requirement hasNumCols(int n) {
        if (n != this.df.numCols()) {
            throw RequirementException$.MODULE$.apply("Expected " + n + " columns but found " + this.df.numCols() + " columns.");
        }
        return this;
    }

    public Requirement hasNumRows(int n) {
        if (n != this.df.numRows()) {
            throw RequirementException$.MODULE$.apply("Expected " + n + " rows but found " + this.df.numRows() + " rows.");
        }
        return this;
    }

    public <T> Requirement equalsCol(String col, Series<T> series, ClassTag<T> evidence$7) {
        this.has((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{col}));
        Series<Object> s = this.df.apply(col);
        Series<T> expected = series.as(col);
        if (s.typeMatch(expected)) {
            if (!s.equals(expected)) {
                throw RequirementException$.MODULE$.apply(s, expected);
            }
        } else {
            throw RequirementException$.MODULE$.apply(s, "Expected type " + expected.typeString() + " but found type " + s.typeString() + ".");
        }
        return this;
    }

    public <T> Requirement equalsCol(Series<T> series, ClassTag<T> evidence$8) {
        return this.equalsCol(series.name(), series, evidence$8);
    }

    public <T> Requirement equalsCol(String col, Seq<Object> values, ClassTag<T> evidence$9) {
        return this.equalsCol(col, Series$.MODULE$.apply(col).apply(values, evidence$9), evidence$9);
    }

    public Requirement equals(DataFrame df) {
        if (!this.df.equals(df)) {
            throw RequirementException$.MODULE$.apply(this.df, df);
        }
        return this;
    }

    public <T> Requirement isType(String col, boolean all, TypeTest<Object, T> evidence$10, RequireType<T> evidence$11) {
        return this._strict ? (all ? this.raiseOnError(col, (Function1<Series<Object>, Object>)(Function1 & Serializable)_$4 -> _$4.isTypeAllStrictly(evidence$10), this.raiseOnError$default$3()) : this.raiseOnError(col, (Function1<Series<Object>, Object>)(Function1 & Serializable)_$5 -> _$5.isTypeStrictly(evidence$10), this.raiseOnError$default$3())) : (all ? this.raiseOnError(col, (Function1<Series<Object>, Object>)(Function1 & Serializable)_$6 -> _$6.isTypeAll(evidence$10), "Incorrect type or contains undefined values.") : this.raiseOnError(col, (Function1<Series<Object>, Object>)(Function1 & Serializable)_$7 -> _$7.isType(evidence$10), "Incorrect type."));
    }

    public boolean isType$default$2() {
        return this._all;
    }

    public <T> Requirement isType(Seq<String> cols, TypeTest<Object, T> evidence$12, RequireType<T> evidence$13) {
        cols.foreach((Function1 & Serializable)_$8 -> this.isType((String)_$8, this._all, evidence$12, evidence$13));
        return this;
    }

    public <T> Requirement isTypeAll(Seq<String> cols, TypeTest<Object, T> evidence$14, RequireType<T> evidence$15) {
        cols.foreach((Function1 & Serializable)_$9 -> this.isType((String)_$9, true, evidence$14, evidence$15));
        return this;
    }

    public <T> Requirement isTypeAllStrictly(Seq<String> cols, TypeTest<Object, T> evidence$16, RequireType<T> evidence$17) {
        cols.foreach((Function1 & Serializable)_$10 -> this.isTypeStrictly((String)_$10, true, evidence$16, evidence$17));
        return this;
    }

    public <T> Requirement isTypeStrictly(String col, boolean all, TypeTest<Object, T> evidence$18, RequireType<T> evidence$19) {
        return all ? this.raiseOnError(col, (Function1<Series<Object>, Object>)(Function1 & Serializable)_$11 -> _$11.isTypeAllStrictly(evidence$18), "Incorrect type.") : this.raiseOnError(col, (Function1<Series<Object>, Object>)(Function1 & Serializable)_$12 -> _$12.isTypeStrictly(evidence$18), "Incorrect type or contains undefined values.");
    }

    public boolean isTypeStrictly$default$2() {
        return this._all;
    }

    public <T> Requirement isTypeStrictly(Seq<String> cols, TypeTest<Object, T> evidence$20, RequireType<T> evidence$21) {
        cols.foreach((Function1 & Serializable)_$13 -> this.isTypeStrictly((String)_$13, this._all, evidence$20, evidence$21));
        return this;
    }

    public Requirement strictly() {
        return new Requirement(this.df, this._all, true);
    }

    private Requirement raiseOnError(String col, Function1<Series<Object>, Object> cond, String msg) {
        Requirement requirement;
        try {
            if (!BoxesRunTime.unboxToBoolean((Object)cond.apply(this.df.apply(col)))) {
                throw RequirementException$.MODULE$.apply(this.df.apply(col), msg);
            }
            requirement = this;
        }
        catch (ColumnNotFoundException columnNotFoundException) {
            throw RequirementException$.MODULE$.apply(col, "Column " + col + " is missing.");
        }
        catch (ClassCastException classCastException) {
            throw RequirementException$.MODULE$.apply(this.df.apply(col), "Incorrect type. Cannot cast class.");
        }
        return requirement;
    }

    private String raiseOnError$default$3() {
        return "";
    }

    private <T> Requirement raiseOnErrorTyped(String col, Function1<Series<T>, Object> cond, String msg, ClassTag<T> evidence$22, TypeTest<Object, T> evidence$23) {
        Requirement requirement;
        try {
            if (!BoxesRunTime.unboxToBoolean((Object)cond.apply(this.df.apply(col).as(evidence$23, evidence$22)))) {
                throw RequirementException$.MODULE$.apply(this.df.apply(col), msg);
            }
            requirement = this;
        }
        catch (ColumnNotFoundException columnNotFoundException) {
            throw RequirementException$.MODULE$.apply(col, "Column " + col + " is missing.");
        }
        catch (ClassCastException classCastException) {
            throw RequirementException$.MODULE$.apply(this.df.apply(col), "Incorrect type. Cannot cast class.");
        }
        return requirement;
    }

    private <T> String raiseOnErrorTyped$default$3() {
        return "";
    }
}

