/*
 * Decompiled with CFR 0.152.
 */
package pd.internal.index;

import java.io.Serializable;
import pd.Series;
import pd.Series$;
import pd.exception.BaseIndexException;
import pd.internal.index.BaseIndex;
import pd.internal.index.BaseIndex$;
import pd.internal.index.IndexIterator;
import pd.internal.index.RangeIterator$;
import pd.internal.index.SeqIndex;
import pd.internal.index.SeqIndex$;
import pd.internal.index.SlicedIndex$;
import pd.internal.index.UniformIndex;
import pd.internal.utils.StringUtils$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public class SlicedIndex
extends BaseIndex {
    private final UniformIndex base;
    private final int start;
    private final int end;

    public static BaseIndex apply(UniformIndex uniformIndex, Range range) {
        return SlicedIndex$.MODULE$.apply(uniformIndex, range);
    }

    public SlicedIndex(UniformIndex base, int start, int end) {
        this.base = base;
        this.start = start;
        this.end = end;
    }

    @Override
    public UniformIndex base() {
        return this.base;
    }

    public int start() {
        return this.start;
    }

    public int end() {
        return this.end;
    }

    @Override
    public String describe() {
        return "Sliced " + this.toString() + " with " + StringUtils$.MODULE$.asElements(this.inline$end() - this.inline$start() + 1) + ".";
    }

    @Override
    public int hasSubIndices(BaseIndex that) {
        int n;
        BaseIndex baseIndex = that;
        if (baseIndex instanceof UniformIndex) {
            n = this.start() == 0 ? (this.end() - 1 > this.inline$end() - this.inline$start() + 1 ? 1 : (this.end() - 1 == this.inline$end() - this.inline$start() + 1 ? 0 : -1)) : -1;
        } else if (baseIndex instanceof SlicedIndex) {
            SlicedIndex ix = (SlicedIndex)baseIndex;
            n = ix.start() == this.start() && ix.end() == this.end() ? 0 : (ix.start() >= this.start() && ix.end() <= this.end() ? 1 : -1);
        } else if (baseIndex instanceof SeqIndex) {
            SeqIndex SeqIndex_this;
            SeqIndex ix = (SeqIndex)baseIndex;
            Object object = Predef$.MODULE$.intArrayOps(ix.indices());
            n = ArrayOps$.MODULE$.forall$extension(object, (Function1)(JFunction1.mcZI.sp & Serializable)i -> i >= this.start() && i <= this.end()) ? ((SeqIndex_this = ix).indices().length == this.inline$end() - this.inline$start() + 1 ? 0 : 1) : -1;
        } else {
            throw new MatchError((Object)baseIndex);
        }
        return n;
    }

    @Override
    public boolean isBase() {
        return false;
    }

    @Override
    public boolean isBijective() {
        return this.base().length() == this.inline$end() - this.inline$start() + 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isContained(int ix) {
        return ix >= this.start() && ix <= this.end();
    }

    @Override
    public IndexIterator iterator() {
        return RangeIterator$.MODULE$.apply(this.start(), this.end());
    }

    @Override
    public int length() {
        return this.inline$end() - this.inline$start() + 1;
    }

    @Override
    public int max() {
        return this.end();
    }

    @Override
    public IndexIterator[] partitions() {
        Object object = Predef$.MODULE$.refArrayOps((Object[])BaseIndex$.MODULE$.partitioning(this.start(), this.end()));
        return (IndexIterator[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$1 -> RangeIterator$.MODULE$.apply((Tuple2<Object, Object>)_$1), ClassTag$.MODULE$.apply(IndexIterator.class));
    }

    @Override
    public BaseIndex slice(Range r) {
        return r.isEmpty() ? SeqIndex$.MODULE$.apply(this.base(), (Seq<Object>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[0])))) : (r.step() == 1 ? SlicedIndex$.MODULE$.apply(this.base(), (Range)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(this.start()), r.start())), RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(this.end()), r.last()))) : this.slice((Seq<Object>)((Seq)r)));
    }

    @Override
    public BaseIndex slice(Seq<Object> seq) {
        return SeqIndex$.MODULE$.apply(this.base(), (Seq<Object>)((Seq)seq.filter((Function1)(JFunction1.mcZI.sp & Serializable)x -> x >= this.start() && x <= this.end())));
    }

    @Override
    public BaseIndex slice(int[] seq) {
        Object object = Predef$.MODULE$.intArrayOps(seq);
        return SeqIndex$.MODULE$.apply(this.base(), (int[])ArrayOps$.MODULE$.filter$extension(object, (Function1)(JFunction1.mcZI.sp & Serializable)x -> x >= this.start() && x <= this.end()));
    }

    @Override
    public BaseIndex slice(Series<Object> series) {
        UniformIndex UniformIndex_this = series.index().base();
        if (!(UniformIndex_this.length() == this.base().length())) {
            throw new BaseIndexException(this.base(), series.index().base());
        }
        return this.slice(Series$.MODULE$.toSeriesBoolean(series).indicesTrue());
    }

    @Override
    public BaseIndex sorted() {
        return this;
    }

    @Override
    public SeqIndex toSeqIndex() {
        return SeqIndex$.MODULE$.apply(this.base(), (Seq<Object>)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(this.start()), this.end()));
    }

    public String toString() {
        return "Index (" + this.start() + " to " + this.end() + ")";
    }

    public int inline$end() {
        return this.end();
    }

    public int inline$start() {
        return this.start();
    }
}

