/*
 * Decompiled with CFR 0.152.
 */
package pd.internal.index;

import java.io.Serializable;
import pd.Series;
import pd.Series$;
import pd.exception.BaseIndexException;
import pd.exception.IllegalIndex;
import pd.internal.index.BaseIndex;
import pd.internal.index.BaseIndex$;
import pd.internal.index.IndexIterator;
import pd.internal.index.RangeIterator$;
import pd.internal.index.SeqIndex;
import pd.internal.index.SeqIndex$;
import pd.internal.index.SlicedIndex;
import pd.internal.index.SlicedIndex$;
import pd.internal.utils.StringUtils$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public class UniformIndex
extends BaseIndex {
    private final int length;

    public UniformIndex(int length) {
        this.length = length;
        if (length < 0) {
            throw new IllegalIndex("Index length cannot be negative (found " + length + ").");
        }
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public UniformIndex base() {
        return this;
    }

    @Override
    public String describe() {
        return "Uniform " + this.toString() + " with " + StringUtils$.MODULE$.asElements(this.length()) + ".";
    }

    @Override
    public boolean equals(BaseIndex that) {
        boolean bl;
        BaseIndex baseIndex = that;
        if (baseIndex instanceof UniformIndex) {
            UniformIndex x = (UniformIndex)baseIndex;
            bl = this.length() == x.length();
        } else if (baseIndex instanceof SlicedIndex) {
            SlicedIndex x = (SlicedIndex)baseIndex;
            bl = this.inline$start$i1(x) == 0 && this.length() == this.inline$end$i1(x) + 1;
        } else if (baseIndex != null) {
            BaseIndex x = baseIndex;
            bl = super.equals(x);
        } else {
            throw new MatchError((Object)baseIndex);
        }
        return bl;
    }

    @Override
    public boolean isBase() {
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.length() < 1;
    }

    @Override
    public int hasSubIndices(BaseIndex that) {
        int n;
        BaseIndex baseIndex = that;
        if (baseIndex instanceof UniformIndex) {
            UniformIndex ix = (UniformIndex)baseIndex;
            n = ix.length() < this.length() ? 1 : (ix.length() == this.length() ? 0 : -1);
        } else if (baseIndex instanceof SlicedIndex) {
            SlicedIndex ix = (SlicedIndex)baseIndex;
            n = ix.end() + 1 < this.length() ? 1 : (ix.end() + 1 == this.length() ? (ix.start() == 0 ? 0 : 1) : -1);
        } else if (baseIndex instanceof SeqIndex) {
            SeqIndex SeqIndex_this;
            SeqIndex ix = (SeqIndex)baseIndex;
            Object object = Predef$.MODULE$.intArrayOps(ix.indices());
            n = ArrayOps$.MODULE$.forall$extension(object, (Function1)(JFunction1.mcZI.sp & Serializable)_$1 -> _$1 < this.length()) ? ((SeqIndex_this = ix).indices().length == this.length() ? 0 : 1) : -1;
        } else {
            throw new MatchError((Object)baseIndex);
        }
        return n;
    }

    @Override
    public boolean isBijective() {
        return true;
    }

    @Override
    public boolean isContained(int ix) {
        return ix >= 0 && ix < this.length();
    }

    @Override
    public IndexIterator iterator() {
        return RangeIterator$.MODULE$.apply(this.length());
    }

    @Override
    public int max() {
        return this.length() - 1;
    }

    @Override
    public IndexIterator[] partitions() {
        Object object = Predef$.MODULE$.refArrayOps((Object[])BaseIndex$.MODULE$.partitioning(this.length()));
        return (IndexIterator[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$2 -> RangeIterator$.MODULE$.apply((Tuple2<Object, Object>)_$2), ClassTag$.MODULE$.apply(IndexIterator.class));
    }

    @Override
    public BaseIndex slice(Range range) {
        return SlicedIndex$.MODULE$.apply(this, range);
    }

    @Override
    public BaseIndex slice(Seq<Object> seq) {
        return SeqIndex$.MODULE$.apply(this, seq);
    }

    @Override
    public BaseIndex slice(int[] array) {
        return SeqIndex$.MODULE$.apply(this.base(), array);
    }

    @Override
    public BaseIndex slice(Series<Object> series) {
        UniformIndex that$proxy1 = this.base();
        UniformIndex UniformIndex_this = series.index().base();
        if (!(UniformIndex_this.length() == that$proxy1.length())) {
            throw new BaseIndexException(this.base(), series.index().base());
        }
        return SeqIndex$.MODULE$.unchecked(this.base(), Series$.MODULE$.toSeriesBoolean(series).indicesTrue());
    }

    @Override
    public BaseIndex sorted() {
        return this;
    }

    @Override
    public SeqIndex toSeqIndex() {
        return SeqIndex$.MODULE$.apply(this, (Seq<Object>)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.length()));
    }

    public String toString() {
        return this.isEmpty() ? "Index (<empty>)" : "Index (0 to " + (this.length() - 1) + ")";
    }

    public int inline$start$i1(SlicedIndex x$0) {
        return x$0.start();
    }

    public int inline$end$i1(SlicedIndex x$0) {
        return x$0.end();
    }
}

