/*
 * Decompiled with CFR 0.152.
 */
package pd.internal.series;

import java.lang.reflect.Array;
import pd.Settings$;
import pd.internal.index.BaseIndex;
import pd.internal.series.SeriesData$;
import pd.internal.utils.StringUtils$;
import pd.internal.utils.TypeString$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.reflect.ClassTag;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class SeriesData<T> {
    private final Object vector;
    private final boolean[] mask;
    private final boolean containsNull;

    public static <T> SeriesData<T> empty(ClassTag<T> classTag) {
        return SeriesData$.MODULE$.empty(classTag);
    }

    public static <T> SeriesData<T> empty(int n, ClassTag<T> classTag) {
        return SeriesData$.MODULE$.empty(n, classTag);
    }

    public static <T> SeriesData<T> fromArray(Object object) {
        return SeriesData$.MODULE$.fromArray(object);
    }

    public static <T> SeriesData<T> fromCollection(Object object, ClassTag<T> classTag) {
        return SeriesData$.MODULE$.fromCollection(object, classTag);
    }

    public static <T> SeriesData<T> fromCollectionWithNull(Object object, ClassTag<T> classTag) {
        return SeriesData$.MODULE$.fromCollectionWithNull(object, classTag);
    }

    public static <T> SeriesData<T> fromOptionCollection(Object object, ClassTag<T> classTag) {
        return SeriesData$.MODULE$.fromOptionCollection(object, classTag);
    }

    public static <T> SeriesData<T> wrapArray(Object object) {
        return SeriesData$.MODULE$.wrapArray(object);
    }

    public static <T> boolean[] $lessinit$greater$default$2() {
        return SeriesData$.MODULE$.$lessinit$greater$default$2();
    }

    public SeriesData(Object vector, boolean[] mask) {
        this.vector = vector;
        this.mask = mask;
        this.containsNull = mask != null;
    }

    public Object vector() {
        return this.vector;
    }

    public boolean[] mask() {
        return this.mask;
    }

    public boolean containsNull() {
        return this.containsNull;
    }

    public SeriesData<T> clone() {
        return this.mask() == null ? new SeriesData<T>(ScalaRunTime$.MODULE$.array_clone(this.vector()), null) : new SeriesData<T>(ScalaRunTime$.MODULE$.array_clone(this.vector()), (boolean[])this.mask().clone());
    }

    public SeriesData<T> cloneSafely() {
        Object object;
        return this.mask() == null ? new SeriesData<T>(ScalaRunTime$.MODULE$.array_clone(this.vector()), null) : (ArrayOps$.MODULE$.contains$extension(object = Predef$.MODULE$.booleanArrayOps(this.mask()), (Object)BoxesRunTime.boxToBoolean((boolean)false)) ? new SeriesData<T>(ScalaRunTime$.MODULE$.array_clone(this.vector()), (boolean[])this.mask().clone()) : new SeriesData<T>(ScalaRunTime$.MODULE$.array_clone(this.vector()), null));
    }

    public SeriesData<T> create(Object vector, boolean[] mask) {
        return new SeriesData<T>(vector, mask);
    }

    public boolean[] create$default$2() {
        return null;
    }

    public Object createArray(int size) {
        return Array.newInstance(this.vector().getClass().getComponentType(), size);
    }

    public int createArray$default$1() {
        return ScalaRunTime$.MODULE$.array_length(this.vector());
    }

    public SeriesData<T> createEmpty() {
        return new SeriesData<T>(this.createArray(0), null);
    }

    public String describe() {
        return "The data type is " + this.typeDescription(this.typeDescription$default$1()) + " " + (this.containsNull() ? "with undefined entries." : "with no undefined entries.") + ("\n  The underlying data vector has " + StringUtils$.MODULE$.asElements(ScalaRunTime$.MODULE$.array_length(this.inline$vector())) + ".");
    }

    public boolean equivalent(SeriesData<?> that) {
        return Predef$.MODULE$.genericWrapArray(this.vector()).sameElements((IterableOnce)Predef$.MODULE$.genericWrapArray(that.vector()));
    }

    public SeriesData<T> maskIndex(BaseIndex index) {
        return SeriesData$.MODULE$.pd$internal$series$SeriesData$$$fromIndex(this, index, ScalaRunTime$.MODULE$.array_length(this.inline$vector()), SeriesData$.MODULE$.pd$internal$series$SeriesData$$$fromIndex$default$4());
    }

    public SeriesData<T> maskIndexResize(BaseIndex index, int size) {
        return SeriesData$.MODULE$.pd$internal$series$SeriesData$$$fromIndex(this, index, size, SeriesData$.MODULE$.pd$internal$series$SeriesData$$$fromIndex$default$4());
    }

    public SeriesData<T> resize(BaseIndex index, int size) {
        return ScalaRunTime$.MODULE$.array_length(this.inline$vector()) == size ? this : SeriesData$.MODULE$.pd$internal$series$SeriesData$$$fromIndex(this, index, size, (Option<boolean[]>)None$.MODULE$);
    }

    public String toString() {
        return Predef$.MODULE$.genericWrapArray(this.vector()).mkString(":");
    }

    public String typeDescription(boolean javaType) {
        return TypeString$.MODULE$.typeDescription(this.vector().getClass(), this.containsNull(), javaType);
    }

    public boolean typeDescription$default$1() {
        return Settings$.MODULE$.printJavaType();
    }

    public String typeString(boolean javaType) {
        return TypeString$.MODULE$.typeString(this.vector().getClass(), javaType);
    }

    public boolean typeString$default$1() {
        return Settings$.MODULE$.printJavaType();
    }

    public Class<?> vectorClass() {
        return this.vector().getClass().getComponentType();
    }

    public boolean[] inline$mask() {
        return this.mask();
    }

    public Object inline$vector() {
        return this.vector();
    }
}

