/*
 * Decompiled with CFR 0.152.
 */
package pd.internal.series.ops;

import java.io.Serializable;
import pd.Series;
import pd.Series$;
import pd.exception.BaseIndexException;
import pd.internal.index.BaseIndex;
import pd.internal.index.IndexIterator;
import pd.internal.index.UniformIndex;
import pd.internal.series.SeriesData;
import pd.internal.series.SeriesOps;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public abstract class OpsCommon
extends SeriesOps {
    @Override
    public <T, R> R aggSeries(Series<T> series, R start, Function2<R, T, R> f) {
        R r;
        SeriesData<T> data;
        SeriesData<T> SeriesData_this = data = this.inline$data$i1(series);
        int size = ScalaRunTime$.MODULE$.array_length(SeriesData_this.inline$vector());
        Object dataVector = this.inline$vector$i1(data);
        Object result = start;
        if (this.inline$index$i1(series).isBase() && !series.hasUndefined()) {
            for (int ix = 0; ix < size; ++ix) {
                result = f.apply(result, ScalaRunTime$.MODULE$.array_apply(dataVector, ix));
            }
            r = result;
        } else {
            boolean[] dataMask = this.inline$mask$i1(data);
            IndexIterator it = this.inline$index$i2(series).iterator();
            while (it.hasNext()) {
                int ix = it.next();
                if (dataMask != null && !dataMask[ix]) continue;
                result = f.apply(result, ScalaRunTime$.MODULE$.array_apply(dataVector, ix));
            }
            r = result;
        }
        return r;
    }

    @Override
    public double aggD(Series<Object> s, double start, Function2<Object, Object, Object> f) {
        double d;
        SeriesData<Object> data;
        SeriesData<Object> SeriesData_this = data = this.inline$data$i1(s);
        int size = ScalaRunTime$.MODULE$.array_length(SeriesData_this.inline$vector());
        double[] dataVector = (double[])this.inline$vector$i1(data);
        double result = start;
        if (this.inline$index$i1(s).isBase() && !s.hasUndefined()) {
            for (int ix = 0; ix < size; ++ix) {
                result = f.apply$mcDDD$sp(result, dataVector[ix]);
            }
            d = result;
        } else {
            boolean[] dataMask = this.inline$mask$i1(data);
            IndexIterator it = this.inline$index$i2(s).iterator();
            while (it.hasNext()) {
                int ix = it.next();
                if (dataMask != null && !dataMask[ix]) continue;
                result = f.apply$mcDDD$sp(result, dataVector[ix]);
            }
            d = result;
        }
        return d;
    }

    @Override
    public int aggD2I(Series<Object> s, int start, Function2<Object, Object, Object> f) {
        int n;
        SeriesData<Object> data;
        SeriesData<Object> SeriesData_this = data = this.inline$data$i1(s);
        int size = ScalaRunTime$.MODULE$.array_length(SeriesData_this.inline$vector());
        double[] dataVector = (double[])this.inline$vector$i1(data);
        int result = start;
        if (this.inline$index$i1(s).isBase() && !s.hasUndefined()) {
            for (int ix = 0; ix < size; ++ix) {
                result = f.apply$mcIID$sp(result, dataVector[ix]);
            }
            n = result;
        } else {
            boolean[] dataMask = this.inline$mask$i1(data);
            IndexIterator it = this.inline$index$i2(s).iterator();
            while (it.hasNext()) {
                int ix = it.next();
                if (dataMask != null && !dataMask[ix]) continue;
                result = f.apply$mcIID$sp(result, dataVector[ix]);
            }
            n = result;
        }
        return n;
    }

    @Override
    public int aggI(Series<Object> s, int start, Function2<Object, Object, Object> f) {
        int n;
        SeriesData<Object> data;
        SeriesData<Object> SeriesData_this = data = this.inline$data$i1(s);
        int size = ScalaRunTime$.MODULE$.array_length(SeriesData_this.inline$vector());
        int[] dataVector = (int[])this.inline$vector$i1(data);
        int result = start;
        if (this.inline$index$i1(s).isBase() && !s.hasUndefined()) {
            for (int ix = 0; ix < size; ++ix) {
                result = f.apply$mcIII$sp(result, dataVector[ix]);
            }
            n = result;
        } else {
            boolean[] dataMask = this.inline$mask$i1(data);
            IndexIterator it = this.inline$index$i2(s).iterator();
            while (it.hasNext()) {
                int ix = it.next();
                if (dataMask != null && !dataMask[ix]) continue;
                result = f.apply$mcIII$sp(result, dataVector[ix]);
            }
            n = result;
        }
        return n;
    }

    @Override
    public <T, T2> boolean compareNulls(Series<T> series, Series<T2> series2) {
        BaseIndex BaseIndex_this = series.index();
        if (!BaseIndex_this.base().equals(series2.index().base())) {
            throw new BaseIndexException((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Series[]{series, series2})));
        }
        SeriesData<T> SeriesData_this = series.data();
        int size = ScalaRunTime$.MODULE$.array_length(SeriesData_this.inline$vector());
        boolean[] dataMask = series.data().mask();
        boolean[] dataMask2 = series2.data().mask();
        BaseIndex index = series.index();
        boolean indexBijective = index.isBijective();
        BaseIndex index2 = series2.index();
        boolean index2Bijective = index2.isBijective();
        for (int ix = 0; ix < size; ++ix) {
            boolean exists2;
            boolean exists = !(dataMask != null && !dataMask[ix] || !indexBijective && !index.isContained(ix));
            boolean bl = exists2 = !(dataMask2 != null && !dataMask2[ix] || !index2Bijective && !index2.isContained(ix));
            if (exists == exists2) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> int count(Series<T> series) {
        int n;
        if (!series.hasUndefined()) {
            n = this.inline$index$i3(series).length();
        } else {
            void var3_3;
            SeriesData<T> data = this.inline$data$i2(series);
            int cnt = 0;
            boolean[] dataMask = this.inline$mask$i2(data);
            IndexIterator it = this.inline$index$i4(series).iterator();
            while (it.hasNext()) {
                int ix = it.next();
                if (dataMask != null && !dataMask[ix]) continue;
                ++cnt;
            }
            n = var3_3;
        }
        return n;
    }

    @Override
    public int countD(Series<Object> series) {
        SeriesData<Object> data = series.data();
        boolean[] dataMask = data.mask();
        double[] dataVector = (double[])data.vector();
        int cnt = 0;
        if (series.index().isBijective()) {
            SeriesData<Object> SeriesData_this = data;
            int size = ScalaRunTime$.MODULE$.array_length(SeriesData_this.inline$vector());
            for (int ix = 0; ix < size; ++ix) {
                if (dataMask != null && !dataMask[ix] || Predef$.MODULE$.double2Double(dataVector[ix]).isNaN()) continue;
                ++cnt;
            }
        } else {
            IndexIterator it = series.index().iterator();
            while (it.hasNext()) {
                int ix = it.next();
                if (dataMask != null && !dataMask[ix] || Predef$.MODULE$.double2Double(dataVector[ix]).isNaN()) continue;
                ++cnt;
            }
        }
        return cnt;
    }

    @Override
    public int countFalse(Series<Object> series) {
        int n;
        SeriesData<Object> data;
        SeriesData<Object> SeriesData_this = data = series.data();
        int size = ScalaRunTime$.MODULE$.array_length(SeriesData_this.inline$vector());
        boolean[] dataVector = (boolean[])data.vector();
        int result = 0;
        if (!series.hasUndefined()) {
            for (int ix = 0; ix < size; ++ix) {
                if (dataVector[ix]) continue;
                ++result;
            }
            n = result;
        } else {
            boolean[] dataMask = data.mask();
            IndexIterator it = series.index().iterator();
            while (it.hasNext()) {
                int ix = it.next();
                if (dataMask != null && !dataMask[ix] || dataVector[ix]) continue;
                ++result;
            }
            n = result;
        }
        return n;
    }

    @Override
    public int countTrue(Series<Object> series) {
        int n;
        SeriesData<Object> data;
        SeriesData<Object> SeriesData_this = data = series.data();
        int size = ScalaRunTime$.MODULE$.array_length(SeriesData_this.inline$vector());
        boolean[] dataVector = (boolean[])data.vector();
        int result = 0;
        if (!series.hasUndefined()) {
            for (int ix = 0; ix < size; ++ix) {
                if (!dataVector[ix]) continue;
                ++result;
            }
            n = result;
        } else {
            boolean[] dataMask = data.mask();
            IndexIterator it = series.index().iterator();
            while (it.hasNext()) {
                int ix = it.next();
                if (dataMask != null && !dataMask[ix] || !dataVector[ix]) continue;
                ++result;
            }
            n = result;
        }
        return n;
    }

    @Override
    public <T> Series<T> denseSeries(Series<T> series) {
        Series<T> series2;
        SeriesData<T> data;
        SeriesData<T> SeriesData_this = data = this.inline$data$i3(series);
        int size = ScalaRunTime$.MODULE$.array_length(SeriesData_this.inline$vector());
        Object dataVector = this.inline$vector$i2(data);
        Object array = data.createArray(size);
        if (!series.hasUndefined()) {
            series2 = this.inline$apply$i1(Series$.MODULE$, data, this.inline$index$i5(series).base(), series.name());
        } else {
            boolean[] dataMask = this.inline$mask$i3(data);
            boolean[] mask = (boolean[])Array$.MODULE$.fill(size, OpsCommon::$anonfun$1, ClassTag$.MODULE$.apply(Boolean.TYPE));
            IndexIterator it = this.inline$index$i6(series).iterator();
            while (it.hasNext()) {
                int ix = it.next();
                if (dataMask != null && !dataMask[ix]) continue;
                ScalaRunTime$.MODULE$.array_update(array, ix, ScalaRunTime$.MODULE$.array_apply(dataVector, ix));
                mask[ix] = true;
            }
            series2 = this.inline$apply$i2(Series$.MODULE$, new SeriesData(array, mask), this.inline$index$i7(series).base(), series.name());
        }
        return series2;
    }

    @Override
    public Series<Object> denseB(Series<Object> s) {
        Series<Object> series;
        SeriesData<Object> data;
        SeriesData<Object> SeriesData_this = data = this.inline$data$i3(s);
        int size = ScalaRunTime$.MODULE$.array_length(SeriesData_this.inline$vector());
        boolean[] dataVector = (boolean[])this.inline$vector$i2(data);
        boolean[] array = (boolean[])data.createArray(size);
        if (!s.hasUndefined()) {
            series = this.inline$apply$i1(Series$.MODULE$, data, this.inline$index$i5(s).base(), s.name());
        } else {
            boolean[] dataMask = this.inline$mask$i3(data);
            boolean[] mask = (boolean[])Array$.MODULE$.fill(size, OpsCommon::$anonfun$2, ClassTag$.MODULE$.apply(Boolean.TYPE));
            IndexIterator it = this.inline$index$i6(s).iterator();
            while (it.hasNext()) {
                int ix = it.next();
                if (dataMask != null && !dataMask[ix]) continue;
                array[ix] = dataVector[ix];
                mask[ix] = true;
            }
            series = this.inline$apply$i2(Series$.MODULE$, new SeriesData(array, mask), this.inline$index$i7(s).base(), s.name());
        }
        return series;
    }

    @Override
    public Series<Object> denseD(Series<Object> s) {
        Series<Object> series;
        SeriesData<Object> data;
        SeriesData<Object> SeriesData_this = data = this.inline$data$i3(s);
        int size = ScalaRunTime$.MODULE$.array_length(SeriesData_this.inline$vector());
        double[] dataVector = (double[])this.inline$vector$i2(data);
        double[] array = (double[])data.createArray(size);
        if (!s.hasUndefined()) {
            series = this.inline$apply$i1(Series$.MODULE$, data, this.inline$index$i5(s).base(), s.name());
        } else {
            boolean[] dataMask = this.inline$mask$i3(data);
            boolean[] mask = (boolean[])Array$.MODULE$.fill(size, OpsCommon::$anonfun$3, ClassTag$.MODULE$.apply(Boolean.TYPE));
            IndexIterator it = this.inline$index$i6(s).iterator();
            while (it.hasNext()) {
                int ix = it.next();
                if (dataMask != null && !dataMask[ix]) continue;
                array[ix] = dataVector[ix];
                mask[ix] = true;
            }
            series = this.inline$apply$i2(Series$.MODULE$, new SeriesData(array, mask), this.inline$index$i7(s).base(), s.name());
        }
        return series;
    }

    @Override
    public Series<Object> denseI(Series<Object> s) {
        Series<Object> series;
        SeriesData<Object> data;
        SeriesData<Object> SeriesData_this = data = this.inline$data$i3(s);
        int size = ScalaRunTime$.MODULE$.array_length(SeriesData_this.inline$vector());
        int[] dataVector = (int[])this.inline$vector$i2(data);
        int[] array = (int[])data.createArray(size);
        if (!s.hasUndefined()) {
            series = this.inline$apply$i1(Series$.MODULE$, data, this.inline$index$i5(s).base(), s.name());
        } else {
            boolean[] dataMask = this.inline$mask$i3(data);
            boolean[] mask = (boolean[])Array$.MODULE$.fill(size, OpsCommon::$anonfun$4, ClassTag$.MODULE$.apply(Boolean.TYPE));
            IndexIterator it = this.inline$index$i6(s).iterator();
            while (it.hasNext()) {
                int ix = it.next();
                if (dataMask != null && !dataMask[ix]) continue;
                array[ix] = dataVector[ix];
                mask[ix] = true;
            }
            series = this.inline$apply$i2(Series$.MODULE$, new SeriesData(array, mask), this.inline$index$i7(s).base(), s.name());
        }
        return series;
    }

    @Override
    public <T> Series<T> fillSeries(Series<T> series, Series<T> series2) {
        Series<T> series3;
        BaseIndex that$proxy1 = this.inline$index$i9(series2);
        BaseIndex BaseIndex_this = this.inline$index$i8(series);
        if (!BaseIndex_this.base().equals(that$proxy1.base())) {
            throw new BaseIndexException((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Series[]{series, series2})));
        }
        if (!series.hasUndefined()) {
            series3 = this.inline$apply$i3(Series$.MODULE$, this.inline$data$i4(series), this.inline$index$i10(series).base(), series.name());
        } else {
            Object dataVector = this.inline$vector$i3(this.inline$data$i5(series));
            Object dataVector2 = this.inline$vector$i4(this.inline$data$i6(series2));
            SeriesData<T> SeriesData_this = this.inline$data$i7(series);
            int size = ScalaRunTime$.MODULE$.array_length(SeriesData_this.inline$vector());
            Object array = this.inline$data$i8(series).createArray(size);
            boolean[] dataMask = this.inline$mask$i4(this.inline$data$i9(series));
            boolean[] dataMask2 = this.inline$mask$i5(this.inline$data$i10(series2));
            BaseIndex index = this.inline$index$i11(series);
            boolean indexBijective = index.isBijective();
            BaseIndex index2 = this.inline$index$i12(series2);
            boolean index2Bijective = index2.isBijective();
            boolean[] mask = (boolean[])Array$.MODULE$.fill(size, OpsCommon::$anonfun$5, ClassTag$.MODULE$.apply(Boolean.TYPE));
            int inserted = 0;
            for (int ix = 0; ix < size; ++ix) {
                if ((dataMask == null || dataMask[ix]) && (indexBijective || index.isContained(ix))) {
                    mask[ix] = true;
                    ScalaRunTime$.MODULE$.array_update(array, ix, ScalaRunTime$.MODULE$.array_apply(dataVector, ix));
                    ++inserted;
                    continue;
                }
                if (dataMask2 != null && !dataMask2[ix] || !index2Bijective && !index2.isContained(ix)) continue;
                mask[ix] = true;
                ScalaRunTime$.MODULE$.array_update(array, ix, ScalaRunTime$.MODULE$.array_apply(dataVector2, ix));
                ++inserted;
            }
            boolean containsNull = inserted < size;
            series3 = this.inline$apply$i4(Series$.MODULE$, new SeriesData(array, containsNull ? mask : (boolean[])null), this.inline$index$i13(series).base(), series.name());
        }
        return series3;
    }

    @Override
    public Series<Object> fillB(Series<Object> s, Series<Object> s2) {
        Series<Object> series;
        BaseIndex that$proxy2 = this.inline$index$i9(s2);
        BaseIndex BaseIndex_this = this.inline$index$i8(s);
        if (!BaseIndex_this.base().equals(that$proxy2.base())) {
            throw new BaseIndexException((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Series[]{s, s2})));
        }
        if (!s.hasUndefined()) {
            series = this.inline$apply$i3(Series$.MODULE$, this.inline$data$i4(s), this.inline$index$i10(s).base(), s.name());
        } else {
            boolean[] dataVector = (boolean[])this.inline$vector$i3(this.inline$data$i5(s));
            boolean[] dataVector2 = (boolean[])this.inline$vector$i4(this.inline$data$i6(s2));
            SeriesData<Object> SeriesData_this = this.inline$data$i7(s);
            int size = ScalaRunTime$.MODULE$.array_length(SeriesData_this.inline$vector());
            boolean[] array = (boolean[])this.inline$data$i8(s).createArray(size);
            boolean[] dataMask = this.inline$mask$i4(this.inline$data$i9(s));
            boolean[] dataMask2 = this.inline$mask$i5(this.inline$data$i10(s2));
            BaseIndex index = this.inline$index$i11(s);
            boolean indexBijective = index.isBijective();
            BaseIndex index2 = this.inline$index$i12(s2);
            boolean index2Bijective = index2.isBijective();
            boolean[] mask = (boolean[])Array$.MODULE$.fill(size, OpsCommon::$anonfun$6, ClassTag$.MODULE$.apply(Boolean.TYPE));
            int inserted = 0;
            for (int ix = 0; ix < size; ++ix) {
                if ((dataMask == null || dataMask[ix]) && (indexBijective || index.isContained(ix))) {
                    mask[ix] = true;
                    array[ix] = dataVector[ix];
                    ++inserted;
                    continue;
                }
                if (dataMask2 != null && !dataMask2[ix] || !index2Bijective && !index2.isContained(ix)) continue;
                mask[ix] = true;
                array[ix] = dataVector2[ix];
                ++inserted;
            }
            boolean containsNull = inserted < size;
            series = this.inline$apply$i4(Series$.MODULE$, new SeriesData(array, containsNull ? mask : (boolean[])null), this.inline$index$i13(s).base(), s.name());
        }
        return series;
    }

    @Override
    public Series<Object> fillD(Series<Object> s, Series<Object> s2) {
        Series<Object> series;
        BaseIndex that$proxy3 = this.inline$index$i9(s2);
        BaseIndex BaseIndex_this = this.inline$index$i8(s);
        if (!BaseIndex_this.base().equals(that$proxy3.base())) {
            throw new BaseIndexException((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Series[]{s, s2})));
        }
        if (!s.hasUndefined()) {
            series = this.inline$apply$i3(Series$.MODULE$, this.inline$data$i4(s), this.inline$index$i10(s).base(), s.name());
        } else {
            double[] dataVector = (double[])this.inline$vector$i3(this.inline$data$i5(s));
            double[] dataVector2 = (double[])this.inline$vector$i4(this.inline$data$i6(s2));
            SeriesData<Object> SeriesData_this = this.inline$data$i7(s);
            int size = ScalaRunTime$.MODULE$.array_length(SeriesData_this.inline$vector());
            double[] array = (double[])this.inline$data$i8(s).createArray(size);
            boolean[] dataMask = this.inline$mask$i4(this.inline$data$i9(s));
            boolean[] dataMask2 = this.inline$mask$i5(this.inline$data$i10(s2));
            BaseIndex index = this.inline$index$i11(s);
            boolean indexBijective = index.isBijective();
            BaseIndex index2 = this.inline$index$i12(s2);
            boolean index2Bijective = index2.isBijective();
            boolean[] mask = (boolean[])Array$.MODULE$.fill(size, OpsCommon::$anonfun$7, ClassTag$.MODULE$.apply(Boolean.TYPE));
            int inserted = 0;
            for (int ix = 0; ix < size; ++ix) {
                if ((dataMask == null || dataMask[ix]) && (indexBijective || index.isContained(ix))) {
                    mask[ix] = true;
                    array[ix] = dataVector[ix];
                    ++inserted;
                    continue;
                }
                if (dataMask2 != null && !dataMask2[ix] || !index2Bijective && !index2.isContained(ix)) continue;
                mask[ix] = true;
                array[ix] = dataVector2[ix];
                ++inserted;
            }
            boolean containsNull = inserted < size;
            series = this.inline$apply$i4(Series$.MODULE$, new SeriesData(array, containsNull ? mask : (boolean[])null), this.inline$index$i13(s).base(), s.name());
        }
        return series;
    }

    @Override
    public Series<Object> fillI(Series<Object> s, Series<Object> s2) {
        Series<Object> series;
        BaseIndex that$proxy4 = this.inline$index$i9(s2);
        BaseIndex BaseIndex_this = this.inline$index$i8(s);
        if (!BaseIndex_this.base().equals(that$proxy4.base())) {
            throw new BaseIndexException((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Series[]{s, s2})));
        }
        if (!s.hasUndefined()) {
            series = this.inline$apply$i3(Series$.MODULE$, this.inline$data$i4(s), this.inline$index$i10(s).base(), s.name());
        } else {
            int[] dataVector = (int[])this.inline$vector$i3(this.inline$data$i5(s));
            int[] dataVector2 = (int[])this.inline$vector$i4(this.inline$data$i6(s2));
            SeriesData<Object> SeriesData_this = this.inline$data$i7(s);
            int size = ScalaRunTime$.MODULE$.array_length(SeriesData_this.inline$vector());
            int[] array = (int[])this.inline$data$i8(s).createArray(size);
            boolean[] dataMask = this.inline$mask$i4(this.inline$data$i9(s));
            boolean[] dataMask2 = this.inline$mask$i5(this.inline$data$i10(s2));
            BaseIndex index = this.inline$index$i11(s);
            boolean indexBijective = index.isBijective();
            BaseIndex index2 = this.inline$index$i12(s2);
            boolean index2Bijective = index2.isBijective();
            boolean[] mask = (boolean[])Array$.MODULE$.fill(size, OpsCommon::$anonfun$8, ClassTag$.MODULE$.apply(Boolean.TYPE));
            int inserted = 0;
            for (int ix = 0; ix < size; ++ix) {
                if ((dataMask == null || dataMask[ix]) && (indexBijective || index.isContained(ix))) {
                    mask[ix] = true;
                    array[ix] = dataVector[ix];
                    ++inserted;
                    continue;
                }
                if (dataMask2 != null && !dataMask2[ix] || !index2Bijective && !index2.isContained(ix)) continue;
                mask[ix] = true;
                array[ix] = dataVector2[ix];
                ++inserted;
            }
            boolean containsNull = inserted < size;
            series = this.inline$apply$i4(Series$.MODULE$, new SeriesData(array, containsNull ? mask : (boolean[])null), this.inline$index$i13(s).base(), s.name());
        }
        return series;
    }

    @Override
    public <T> Series<T> fillSeries(Series<T> series, T v) {
        Series<T> series2;
        SeriesData<T> data;
        SeriesData<T> SeriesData_this = data = this.inline$data$i11(series);
        int size = ScalaRunTime$.MODULE$.array_length(SeriesData_this.inline$vector());
        Object dataVector = this.inline$vector$i5(data);
        Object array = data.createArray(size);
        if (!series.hasUndefined()) {
            series2 = series;
        } else {
            boolean[] dataMask = this.inline$mask$i6(data);
            boolean[] mask = (boolean[])Array$.MODULE$.fill(size, OpsCommon::$anonfun$9, ClassTag$.MODULE$.apply(Boolean.TYPE));
            int inserted = 0;
            IndexIterator it = this.inline$index$i14(series).iterator();
            while (it.hasNext()) {
                int ix = it.next();
                mask[ix] = true;
                if (dataMask == null || dataMask[ix]) {
                    ScalaRunTime$.MODULE$.array_update(array, ix, ScalaRunTime$.MODULE$.array_apply(dataVector, ix));
                } else {
                    ScalaRunTime$.MODULE$.array_update(array, ix, v);
                }
                ++inserted;
            }
            series2 = this.inline$apply$i5(Series$.MODULE$, new SeriesData(array, !this.inline$index$i15(series).isBijective() ? mask : (boolean[])null), this.inline$index$i16(series), series.name());
        }
        return series2;
    }

    @Override
    public Series<Object> fillB(Series<Object> s, boolean v) {
        Series<Object> series;
        SeriesData<Object> data;
        SeriesData<Object> SeriesData_this = data = this.inline$data$i11(s);
        int size = ScalaRunTime$.MODULE$.array_length(SeriesData_this.inline$vector());
        boolean[] dataVector = (boolean[])this.inline$vector$i5(data);
        boolean[] array = (boolean[])data.createArray(size);
        if (!s.hasUndefined()) {
            series = s;
        } else {
            boolean[] dataMask = this.inline$mask$i6(data);
            boolean[] mask = (boolean[])Array$.MODULE$.fill(size, OpsCommon::$anonfun$10, ClassTag$.MODULE$.apply(Boolean.TYPE));
            int inserted = 0;
            IndexIterator it = this.inline$index$i14(s).iterator();
            while (it.hasNext()) {
                int ix = it.next();
                mask[ix] = true;
                array[ix] = dataMask == null || dataMask[ix] ? dataVector[ix] : v;
                ++inserted;
            }
            series = this.inline$apply$i5(Series$.MODULE$, new SeriesData(array, !this.inline$index$i15(s).isBijective() ? mask : (boolean[])null), this.inline$index$i16(s), s.name());
        }
        return series;
    }

    @Override
    public Series<Object> fillD(Series<Object> s, double v) {
        Series<Object> series;
        SeriesData<Object> data;
        SeriesData<Object> SeriesData_this = data = this.inline$data$i11(s);
        int size = ScalaRunTime$.MODULE$.array_length(SeriesData_this.inline$vector());
        double[] dataVector = (double[])this.inline$vector$i5(data);
        double[] array = (double[])data.createArray(size);
        if (!s.hasUndefined()) {
            series = s;
        } else {
            boolean[] dataMask = this.inline$mask$i6(data);
            boolean[] mask = (boolean[])Array$.MODULE$.fill(size, OpsCommon::$anonfun$11, ClassTag$.MODULE$.apply(Boolean.TYPE));
            int inserted = 0;
            IndexIterator it = this.inline$index$i14(s).iterator();
            while (it.hasNext()) {
                int ix = it.next();
                mask[ix] = true;
                array[ix] = dataMask == null || dataMask[ix] ? dataVector[ix] : v;
                ++inserted;
            }
            series = this.inline$apply$i5(Series$.MODULE$, new SeriesData(array, !this.inline$index$i15(s).isBijective() ? mask : (boolean[])null), this.inline$index$i16(s), s.name());
        }
        return series;
    }

    @Override
    public Series<Object> fillI(Series<Object> s, int v) {
        Series<Object> series;
        SeriesData<Object> data;
        SeriesData<Object> SeriesData_this = data = this.inline$data$i11(s);
        int size = ScalaRunTime$.MODULE$.array_length(SeriesData_this.inline$vector());
        int[] dataVector = (int[])this.inline$vector$i5(data);
        int[] array = (int[])data.createArray(size);
        if (!s.hasUndefined()) {
            series = s;
        } else {
            boolean[] dataMask = this.inline$mask$i6(data);
            boolean[] mask = (boolean[])Array$.MODULE$.fill(size, OpsCommon::$anonfun$12, ClassTag$.MODULE$.apply(Boolean.TYPE));
            int inserted = 0;
            IndexIterator it = this.inline$index$i14(s).iterator();
            while (it.hasNext()) {
                int ix = it.next();
                mask[ix] = true;
                array[ix] = dataMask == null || dataMask[ix] ? dataVector[ix] : v;
                ++inserted;
            }
            series = this.inline$apply$i5(Series$.MODULE$, new SeriesData(array, !this.inline$index$i15(s).isBijective() ? mask : (boolean[])null), this.inline$index$i16(s), s.name());
        }
        return series;
    }

    @Override
    public <T> Series<T> fillAllSeries(Series<T> series, T v) {
        Series<T> series2;
        SeriesData<T> data;
        SeriesData<T> SeriesData_this = data = this.inline$data$i12(series);
        int size = ScalaRunTime$.MODULE$.array_length(SeriesData_this.inline$vector());
        Object dataVector = this.inline$vector$i6(data);
        Object array = data.createArray(size);
        if (!series.hasUndefined()) {
            series2 = this.inline$apply$i6(Series$.MODULE$, data, this.inline$index$i17(series).base(), series.name());
        } else {
            boolean[] dataMask = this.inline$mask$i7(data);
            for (int ix = 0; ix < size; ++ix) {
                ScalaRunTime$.MODULE$.array_update(array, ix, dataMask == null || dataMask[ix] ? ScalaRunTime$.MODULE$.array_apply(dataVector, ix) : v);
            }
            series2 = this.inline$apply$i7(Series$.MODULE$, new SeriesData(array, null), this.inline$index$i18(series).base(), series.name());
        }
        return series2;
    }

    @Override
    public Series<Object> fillAllB(Series<Object> s, boolean v) {
        Series<Object> series;
        SeriesData<Object> data;
        SeriesData<Object> SeriesData_this = data = this.inline$data$i12(s);
        int size = ScalaRunTime$.MODULE$.array_length(SeriesData_this.inline$vector());
        boolean[] dataVector = (boolean[])this.inline$vector$i6(data);
        boolean[] array = (boolean[])data.createArray(size);
        if (!s.hasUndefined()) {
            series = this.inline$apply$i6(Series$.MODULE$, data, this.inline$index$i17(s).base(), s.name());
        } else {
            boolean[] dataMask = this.inline$mask$i7(data);
            for (int ix = 0; ix < size; ++ix) {
                array[ix] = dataMask == null || dataMask[ix] ? dataVector[ix] : v;
            }
            series = this.inline$apply$i7(Series$.MODULE$, new SeriesData(array, null), this.inline$index$i18(s).base(), s.name());
        }
        return series;
    }

    @Override
    public Series<Object> fillAllD(Series<Object> s, double v) {
        Series<Object> series;
        SeriesData<Object> data;
        SeriesData<Object> SeriesData_this = data = this.inline$data$i12(s);
        int size = ScalaRunTime$.MODULE$.array_length(SeriesData_this.inline$vector());
        double[] dataVector = (double[])this.inline$vector$i6(data);
        double[] array = (double[])data.createArray(size);
        if (!s.hasUndefined()) {
            series = this.inline$apply$i6(Series$.MODULE$, data, this.inline$index$i17(s).base(), s.name());
        } else {
            boolean[] dataMask = this.inline$mask$i7(data);
            for (int ix = 0; ix < size; ++ix) {
                array[ix] = dataMask == null || dataMask[ix] ? dataVector[ix] : v;
            }
            series = this.inline$apply$i7(Series$.MODULE$, new SeriesData(array, null), this.inline$index$i18(s).base(), s.name());
        }
        return series;
    }

    @Override
    public Series<Object> fillAllI(Series<Object> s, int v) {
        Series<Object> series;
        SeriesData<Object> data;
        SeriesData<Object> SeriesData_this = data = this.inline$data$i12(s);
        int size = ScalaRunTime$.MODULE$.array_length(SeriesData_this.inline$vector());
        int[] dataVector = (int[])this.inline$vector$i6(data);
        int[] array = (int[])data.createArray(size);
        if (!s.hasUndefined()) {
            series = this.inline$apply$i6(Series$.MODULE$, data, this.inline$index$i17(s).base(), s.name());
        } else {
            boolean[] dataMask = this.inline$mask$i7(data);
            for (int ix = 0; ix < size; ++ix) {
                array[ix] = dataMask == null || dataMask[ix] ? dataVector[ix] : v;
            }
            series = this.inline$apply$i7(Series$.MODULE$, new SeriesData(array, null), this.inline$index$i18(s).base(), s.name());
        }
        return series;
    }

    @Override
    public <T> Series<T> update(Series<T> series, Series<T> series2) {
        Series<T> series3;
        BaseIndex BaseIndex_this = series.index();
        if (!BaseIndex_this.base().equals(series2.index().base())) {
            throw new BaseIndexException((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Series[]{series, series2})));
        }
        if (!series.hasUndefined()) {
            series3 = Series$.MODULE$.apply(series.data(), series2.index(), series2.name());
        } else {
            Object dataVector = series.data().vector();
            Object dataVector2 = series2.data().vector();
            SeriesData<T> SeriesData_this = series.data();
            int size = ScalaRunTime$.MODULE$.array_length(SeriesData_this.inline$vector());
            Object array = ScalaRunTime$.MODULE$.array_clone(dataVector2);
            boolean[] dataMask = series.data().mask();
            boolean[] dataMask2 = series2.data().mask();
            BaseIndex index = series.index();
            boolean indexBijective = index.isBijective();
            boolean[] mask = (boolean[])Array$.MODULE$.fill(size, OpsCommon::$anonfun$13, ClassTag$.MODULE$.apply(Boolean.TYPE));
            int inserted = 0;
            IndexIterator it = series2.index().iterator();
            while (it.hasNext()) {
                int ix = it.next();
                if ((dataMask == null || dataMask[ix]) && (indexBijective || index.isContained(ix))) {
                    mask[ix] = true;
                    ScalaRunTime$.MODULE$.array_update(array, ix, ScalaRunTime$.MODULE$.array_apply(dataVector, ix));
                    ++inserted;
                    continue;
                }
                if (dataMask2 != null && !dataMask2[ix]) continue;
                mask[ix] = true;
                ++inserted;
            }
            boolean containsNull = inserted < size;
            series3 = Series$.MODULE$.apply(new SeriesData(array, containsNull ? mask : (boolean[])null), series2.index(), series2.name());
        }
        return series3;
    }

    @Override
    public <T> Option<Object> findSeries(Series<T> series, Function1<T, Object> f) {
        SeriesData<T> data;
        SeriesData<T> SeriesData_this = data = this.inline$data$i13(series);
        int size = ScalaRunTime$.MODULE$.array_length(SeriesData_this.inline$vector());
        Object dataVector = this.inline$vector$i7(data);
        int result = -1;
        if (this.inline$index$i19(series).isBase() && !series.hasUndefined()) {
            for (int ix = 0; ix < size; ++ix) {
                if (!BoxesRunTime.unboxToBoolean((Object)f.apply(ScalaRunTime$.MODULE$.array_apply(dataVector, ix)))) continue;
                result = ix;
                ix = size;
            }
        } else {
            boolean[] dataMask = this.inline$mask$i8(data);
            IndexIterator it = this.inline$index$i20(series).iterator();
            while (it.hasNext() && result == -1) {
                int ix = it.next();
                if (dataMask != null && !dataMask[ix] || !BoxesRunTime.unboxToBoolean((Object)f.apply(ScalaRunTime$.MODULE$.array_apply(dataVector, ix)))) continue;
                result = ix;
            }
        }
        return result == -1 ? None$.MODULE$ : Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)result));
    }

    @Override
    public Option<Object> findB(Series<Object> s, Function1<Object, Object> f) {
        SeriesData<Object> data;
        SeriesData<Object> SeriesData_this = data = this.inline$data$i13(s);
        int size = ScalaRunTime$.MODULE$.array_length(SeriesData_this.inline$vector());
        boolean[] dataVector = (boolean[])this.inline$vector$i7(data);
        int result = -1;
        if (this.inline$index$i19(s).isBase() && !s.hasUndefined()) {
            for (int ix = 0; ix < size; ++ix) {
                if (!BoxesRunTime.unboxToBoolean((Object)f.apply((Object)BoxesRunTime.boxToBoolean((boolean)dataVector[ix])))) continue;
                result = ix;
                ix = size;
            }
        } else {
            boolean[] dataMask = this.inline$mask$i8(data);
            IndexIterator it = this.inline$index$i20(s).iterator();
            while (it.hasNext() && result == -1) {
                int ix = it.next();
                if (dataMask != null && !dataMask[ix] || !BoxesRunTime.unboxToBoolean((Object)f.apply((Object)BoxesRunTime.boxToBoolean((boolean)dataVector[ix])))) continue;
                result = ix;
            }
        }
        return result == -1 ? None$.MODULE$ : Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)result));
    }

    @Override
    public Option<Object> findD(Series<Object> s, Function1<Object, Object> f) {
        SeriesData<Object> data;
        SeriesData<Object> SeriesData_this = data = this.inline$data$i13(s);
        int size = ScalaRunTime$.MODULE$.array_length(SeriesData_this.inline$vector());
        double[] dataVector = (double[])this.inline$vector$i7(data);
        int result = -1;
        if (this.inline$index$i19(s).isBase() && !s.hasUndefined()) {
            for (int ix = 0; ix < size; ++ix) {
                if (!f.apply$mcZD$sp(dataVector[ix])) continue;
                result = ix;
                ix = size;
            }
        } else {
            boolean[] dataMask = this.inline$mask$i8(data);
            IndexIterator it = this.inline$index$i20(s).iterator();
            while (it.hasNext() && result == -1) {
                int ix = it.next();
                if (dataMask != null && !dataMask[ix] || !f.apply$mcZD$sp(dataVector[ix])) continue;
                result = ix;
            }
        }
        return result == -1 ? None$.MODULE$ : Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)result));
    }

    @Override
    public Option<Object> findI(Series<Object> s, Function1<Object, Object> f) {
        SeriesData<Object> data;
        SeriesData<Object> SeriesData_this = data = this.inline$data$i13(s);
        int size = ScalaRunTime$.MODULE$.array_length(SeriesData_this.inline$vector());
        int[] dataVector = (int[])this.inline$vector$i7(data);
        int result = -1;
        if (this.inline$index$i19(s).isBase() && !s.hasUndefined()) {
            for (int ix = 0; ix < size; ++ix) {
                if (!f.apply$mcZI$sp(dataVector[ix])) continue;
                result = ix;
                ix = size;
            }
        } else {
            boolean[] dataMask = this.inline$mask$i8(data);
            IndexIterator it = this.inline$index$i20(s).iterator();
            while (it.hasNext() && result == -1) {
                int ix = it.next();
                if (dataMask != null && !dataMask[ix] || !f.apply$mcZI$sp(dataVector[ix])) continue;
                result = ix;
            }
        }
        return result == -1 ? None$.MODULE$ : Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)result));
    }

    @Override
    public <T> Option<Object> firstSeries(Series<T> series, T value) {
        SeriesData<T> data;
        SeriesData<T> SeriesData_this = data = this.inline$data$i14(series);
        int size = ScalaRunTime$.MODULE$.array_length(SeriesData_this.inline$vector());
        Object dataVector = this.inline$vector$i8(data);
        int result = -1;
        if (this.inline$index$i21(series).isBase() && !series.hasUndefined()) {
            for (int ix = 0; ix < size; ++ix) {
                if (!BoxesRunTime.equals((Object)ScalaRunTime$.MODULE$.array_apply(dataVector, ix), value)) continue;
                result = ix;
                ix = size;
            }
        } else {
            boolean[] dataMask = this.inline$mask$i9(data);
            IndexIterator it = this.inline$index$i22(series).iterator();
            while (it.hasNext() && result == -1) {
                int ix = it.next();
                if (dataMask != null && !dataMask[ix] || !BoxesRunTime.equals((Object)ScalaRunTime$.MODULE$.array_apply(dataVector, ix), value)) continue;
                result = ix;
            }
        }
        return result == -1 ? None$.MODULE$ : Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)result));
    }

    @Override
    public Option<Object> firstB(Series<Object> s, boolean v) {
        SeriesData<Object> data;
        SeriesData<Object> SeriesData_this = data = this.inline$data$i14(s);
        int size = ScalaRunTime$.MODULE$.array_length(SeriesData_this.inline$vector());
        boolean[] dataVector = (boolean[])this.inline$vector$i8(data);
        int result = -1;
        if (this.inline$index$i21(s).isBase() && !s.hasUndefined()) {
            for (int ix = 0; ix < size; ++ix) {
                if (dataVector[ix] != v) continue;
                result = ix;
                ix = size;
            }
        } else {
            boolean[] dataMask = this.inline$mask$i9(data);
            IndexIterator it = this.inline$index$i22(s).iterator();
            while (it.hasNext() && result == -1) {
                int ix = it.next();
                if (dataMask != null && !dataMask[ix] || dataVector[ix] != v) continue;
                result = ix;
            }
        }
        return result == -1 ? None$.MODULE$ : Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)result));
    }

    @Override
    public Option<Object> firstD(Series<Object> s, double v) {
        SeriesData<Object> data;
        SeriesData<Object> SeriesData_this = data = this.inline$data$i14(s);
        int size = ScalaRunTime$.MODULE$.array_length(SeriesData_this.inline$vector());
        double[] dataVector = (double[])this.inline$vector$i8(data);
        int result = -1;
        if (this.inline$index$i21(s).isBase() && !s.hasUndefined()) {
            for (int ix = 0; ix < size; ++ix) {
                if (dataVector[ix] != v) continue;
                result = ix;
                ix = size;
            }
        } else {
            boolean[] dataMask = this.inline$mask$i9(data);
            IndexIterator it = this.inline$index$i22(s).iterator();
            while (it.hasNext() && result == -1) {
                int ix = it.next();
                if (dataMask != null && !dataMask[ix] || dataVector[ix] != v) continue;
                result = ix;
            }
        }
        return result == -1 ? None$.MODULE$ : Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)result));
    }

    @Override
    public Option<Object> firstI(Series<Object> s, int v) {
        SeriesData<Object> data;
        SeriesData<Object> SeriesData_this = data = this.inline$data$i14(s);
        int size = ScalaRunTime$.MODULE$.array_length(SeriesData_this.inline$vector());
        int[] dataVector = (int[])this.inline$vector$i8(data);
        int result = -1;
        if (this.inline$index$i21(s).isBase() && !s.hasUndefined()) {
            for (int ix = 0; ix < size; ++ix) {
                if (dataVector[ix] != v) continue;
                result = ix;
                ix = size;
            }
        } else {
            boolean[] dataMask = this.inline$mask$i9(data);
            IndexIterator it = this.inline$index$i22(s).iterator();
            while (it.hasNext() && result == -1) {
                int ix = it.next();
                if (dataMask != null && !dataMask[ix] || dataVector[ix] != v) continue;
                result = ix;
            }
        }
        return result == -1 ? None$.MODULE$ : Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)result));
    }

    @Override
    public <T> Option<Object> lastSeries(Series<T> series, T value) {
        SeriesData<T> data;
        SeriesData<T> SeriesData_this = data = this.inline$data$i15(series);
        int size = ScalaRunTime$.MODULE$.array_length(SeriesData_this.inline$vector());
        Object dataVector = this.inline$vector$i9(data);
        int result = -1;
        if (this.inline$index$i23(series).isBase() && !series.hasUndefined()) {
            for (int ix = size - 1; ix >= 0; --ix) {
                if (!BoxesRunTime.equals((Object)ScalaRunTime$.MODULE$.array_apply(dataVector, ix), value)) continue;
                result = ix;
                ix = 0;
            }
        } else {
            boolean[] dataMask = this.inline$mask$i10(data);
            IndexIterator it = this.inline$index$i24(series).iterator();
            while (it.hasNext()) {
                int ix = it.next();
                if (dataMask != null && !dataMask[ix] || !BoxesRunTime.equals((Object)ScalaRunTime$.MODULE$.array_apply(dataVector, ix), value)) continue;
                result = ix;
            }
        }
        return result == -1 ? None$.MODULE$ : Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)result));
    }

    @Override
    public Option<Object> lastB(Series<Object> s, boolean v) {
        SeriesData<Object> data;
        SeriesData<Object> SeriesData_this = data = this.inline$data$i15(s);
        int size = ScalaRunTime$.MODULE$.array_length(SeriesData_this.inline$vector());
        boolean[] dataVector = (boolean[])this.inline$vector$i9(data);
        int result = -1;
        if (this.inline$index$i23(s).isBase() && !s.hasUndefined()) {
            for (int ix = size - 1; ix >= 0; --ix) {
                if (dataVector[ix] != v) continue;
                result = ix;
                ix = 0;
            }
        } else {
            boolean[] dataMask = this.inline$mask$i10(data);
            IndexIterator it = this.inline$index$i24(s).iterator();
            while (it.hasNext()) {
                int ix = it.next();
                if (dataMask != null && !dataMask[ix] || dataVector[ix] != v) continue;
                result = ix;
            }
        }
        return result == -1 ? None$.MODULE$ : Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)result));
    }

    @Override
    public Option<Object> lastD(Series<Object> s, double v) {
        SeriesData<Object> data;
        SeriesData<Object> SeriesData_this = data = this.inline$data$i15(s);
        int size = ScalaRunTime$.MODULE$.array_length(SeriesData_this.inline$vector());
        double[] dataVector = (double[])this.inline$vector$i9(data);
        int result = -1;
        if (this.inline$index$i23(s).isBase() && !s.hasUndefined()) {
            for (int ix = size - 1; ix >= 0; --ix) {
                if (dataVector[ix] != v) continue;
                result = ix;
                ix = 0;
            }
        } else {
            boolean[] dataMask = this.inline$mask$i10(data);
            IndexIterator it = this.inline$index$i24(s).iterator();
            while (it.hasNext()) {
                int ix = it.next();
                if (dataMask != null && !dataMask[ix] || dataVector[ix] != v) continue;
                result = ix;
            }
        }
        return result == -1 ? None$.MODULE$ : Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)result));
    }

    @Override
    public Option<Object> lastI(Series<Object> s, int v) {
        SeriesData<Object> data;
        SeriesData<Object> SeriesData_this = data = this.inline$data$i15(s);
        int size = ScalaRunTime$.MODULE$.array_length(SeriesData_this.inline$vector());
        int[] dataVector = (int[])this.inline$vector$i9(data);
        int result = -1;
        if (this.inline$index$i23(s).isBase() && !s.hasUndefined()) {
            for (int ix = size - 1; ix >= 0; --ix) {
                if (dataVector[ix] != v) continue;
                result = ix;
                ix = 0;
            }
        } else {
            boolean[] dataMask = this.inline$mask$i10(data);
            IndexIterator it = this.inline$index$i24(s).iterator();
            while (it.hasNext()) {
                int ix = it.next();
                if (dataMask != null && !dataMask[ix] || dataVector[ix] != v) continue;
                result = ix;
            }
        }
        return result == -1 ? None$.MODULE$ : Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)result));
    }

    @Override
    public <T> Series<T> extract(Series<T> series, int[] indices) {
        int size = indices.length;
        Object dataVector = series.data().vector();
        boolean[] dataMask = series.data().mask();
        Object array = series.data().createArray(size);
        boolean[] mask = (boolean[])Array$.MODULE$.fill(size, OpsCommon::$anonfun$14, ClassTag$.MODULE$.apply(Boolean.TYPE));
        boolean containsNull = false;
        for (int i = 0; i < size; ++i) {
            int ix = indices[i];
            if (ix != -1 && (dataMask == null || dataMask[ix])) {
                ScalaRunTime$.MODULE$.array_update(array, i, ScalaRunTime$.MODULE$.array_apply(dataVector, ix));
                continue;
            }
            mask[i] = false;
            containsNull = true;
        }
        return Series$.MODULE$.apply(new SeriesData(array, containsNull ? mask : (boolean[])null), new UniformIndex(size), series.name());
    }

    @Override
    public Option<Object> firstIndex(Series<?> series) {
        Object object;
        if (series.index().isBase() && !series.hasUndefined() && series.index().nonEmpty()) {
            object = Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0));
        } else {
            int result = -1;
            boolean[] dataMask = series.data().mask();
            IndexIterator it = series.index().iterator();
            while (it.hasNext() && result == -1) {
                int ix = it.next();
                if (dataMask != null && !dataMask[ix]) continue;
                result = ix;
            }
            object = result == -1 ? None$.MODULE$ : Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)result));
        }
        return object;
    }

    @Override
    public Option<Object> lastIndex(Series<?> series) {
        Object object;
        if (series.index().isBase() && !series.hasUndefined() && series.index().nonEmpty()) {
            SeriesData<?> SeriesData_this = series.data();
            object = Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)(ScalaRunTime$.MODULE$.array_length(SeriesData_this.inline$vector()) - 1)));
        } else {
            int result = -1;
            boolean[] dataMask = series.data().mask();
            IndexIterator it = series.index().iterator();
            while (it.hasNext()) {
                int ix = it.next();
                if (dataMask != null && !dataMask[ix]) continue;
                result = ix;
            }
            object = result == -1 ? None$.MODULE$ : Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)result));
        }
        return object;
    }

    @Override
    public int[] toIndex(Series<Object> series) {
        SeriesData<Object> data;
        SeriesData<Object> SeriesData_this = data = series.data();
        int size = ScalaRunTime$.MODULE$.array_length(SeriesData_this.inline$vector());
        boolean[] dataVector = (boolean[])data.vector();
        int arraySize = this.countTrue(series);
        int[] array = new int[arraySize];
        int arrayIx = 0;
        if (series.index().isBase() && !series.hasUndefined()) {
            for (int ix = 0; ix < size; ++ix) {
                if (!dataVector[ix]) continue;
                array[arrayIx] = ix;
                ++arrayIx;
            }
        } else {
            boolean[] dataMask = data.mask();
            IndexIterator it = series.index().iterator();
            while (it.hasNext()) {
                int ix = it.next();
                if (dataMask != null && !dataMask[ix] || !dataVector[ix]) continue;
                array[arrayIx] = ix;
                ++arrayIx;
            }
        }
        Predef$.MODULE$.require(arraySize == arrayIx);
        return array;
    }

    @Override
    public <T> Series<T> union(Series<T>[] series) {
        int n = series.length;
        Object object = Predef$.MODULE$.refArrayOps((Object[])series);
        int length = BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.wrapIntArray((int[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$1 -> _$1.length(), ClassTag$.MODULE$.apply(Integer.TYPE))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        IntRef ix = IntRef.create((int)0);
        BooleanRef containsNull = BooleanRef.create((boolean)false);
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])series);
        Object vector = ((Series)ArrayOps$.MODULE$.head$extension(object2)).data().createArray(length);
        boolean[] mask = (boolean[])Array$.MODULE$.fill(length, OpsCommon::$anonfun$16, ClassTag$.MODULE$.apply(Boolean.TYPE));
        for (int ni = 0; ni < n; ++ni) {
            Iterator<Object> it = series[ni].indexIterator();
            Object vec = series[ni].data().vector();
            boolean[] m = series[ni].data().mask();
            it.foreach((Function1)(JFunction1.mcVI.sp & Serializable)is -> {
                int n;
                if (m == null || m[is]) {
                    ScalaRunTime$.MODULE$.array_update(vector, ix$1.elem, ScalaRunTime$.MODULE$.array_apply(vec, is));
                } else {
                    boolean bl;
                    mask$1[ix$1.elem] = false;
                    containsNull$1.elem = bl = true;
                }
                ix$1.elem = n = ix$1.elem + 1;
            });
        }
        Object object3 = Predef$.MODULE$.refArrayOps((Object[])series);
        return Series$.MODULE$.apply(new SeriesData(vector, containsNull.elem ? mask : (boolean[])null), new UniformIndex(length), ((Series)ArrayOps$.MODULE$.head$extension(object3)).name());
    }

    public <T> SeriesData<T> inline$data$i1(Series<T> x$0) {
        return x$0.data();
    }

    public <T> Object inline$vector$i1(SeriesData<T> x$0) {
        return x$0.vector();
    }

    public <T> BaseIndex inline$index$i1(Series<T> x$0) {
        return x$0.index();
    }

    public <T> boolean[] inline$mask$i1(SeriesData<T> x$0) {
        return x$0.mask();
    }

    public <T> BaseIndex inline$index$i2(Series<T> x$0) {
        return x$0.index();
    }

    public <T> BaseIndex inline$index$i3(Series<T> x$0) {
        return x$0.index();
    }

    public <T> SeriesData<T> inline$data$i2(Series<T> x$0) {
        return x$0.data();
    }

    public <T> boolean[] inline$mask$i2(SeriesData<T> x$0) {
        return x$0.mask();
    }

    public <T> BaseIndex inline$index$i4(Series<T> x$0) {
        return x$0.index();
    }

    public <T> SeriesData<T> inline$data$i3(Series<T> x$0) {
        return x$0.data();
    }

    public <T> Object inline$vector$i2(SeriesData<T> x$0) {
        return x$0.vector();
    }

    public <T> Series<T> inline$apply$i1(Series$ x$0, SeriesData<T> data, BaseIndex index, String name) {
        return x$0.apply(data, index, name);
    }

    public <T> BaseIndex inline$index$i5(Series<T> x$0) {
        return x$0.index();
    }

    public <T> boolean[] inline$mask$i3(SeriesData<T> x$0) {
        return x$0.mask();
    }

    public <T> BaseIndex inline$index$i6(Series<T> x$0) {
        return x$0.index();
    }

    public <T> Series<T> inline$apply$i2(Series$ x$0, SeriesData<T> data, BaseIndex index, String name) {
        return x$0.apply(data, index, name);
    }

    public <T> BaseIndex inline$index$i7(Series<T> x$0) {
        return x$0.index();
    }

    public <T> BaseIndex inline$index$i8(Series<T> x$0) {
        return x$0.index();
    }

    public <T> BaseIndex inline$index$i9(Series<T> x$0) {
        return x$0.index();
    }

    public <T> Series<T> inline$apply$i3(Series$ x$0, SeriesData<T> data, BaseIndex index, String name) {
        return x$0.apply(data, index, name);
    }

    public <T> SeriesData<T> inline$data$i4(Series<T> x$0) {
        return x$0.data();
    }

    public <T> BaseIndex inline$index$i10(Series<T> x$0) {
        return x$0.index();
    }

    public <T> Object inline$vector$i3(SeriesData<T> x$0) {
        return x$0.vector();
    }

    public <T> SeriesData<T> inline$data$i5(Series<T> x$0) {
        return x$0.data();
    }

    public <T> Object inline$vector$i4(SeriesData<T> x$0) {
        return x$0.vector();
    }

    public <T> SeriesData<T> inline$data$i6(Series<T> x$0) {
        return x$0.data();
    }

    public <T> SeriesData<T> inline$data$i7(Series<T> x$0) {
        return x$0.data();
    }

    public <T> SeriesData<T> inline$data$i8(Series<T> x$0) {
        return x$0.data();
    }

    public <T> boolean[] inline$mask$i4(SeriesData<T> x$0) {
        return x$0.mask();
    }

    public <T> SeriesData<T> inline$data$i9(Series<T> x$0) {
        return x$0.data();
    }

    public <T> boolean[] inline$mask$i5(SeriesData<T> x$0) {
        return x$0.mask();
    }

    public <T> SeriesData<T> inline$data$i10(Series<T> x$0) {
        return x$0.data();
    }

    public <T> BaseIndex inline$index$i11(Series<T> x$0) {
        return x$0.index();
    }

    public <T> BaseIndex inline$index$i12(Series<T> x$0) {
        return x$0.index();
    }

    public <T> Series<T> inline$apply$i4(Series$ x$0, SeriesData<T> data, BaseIndex index, String name) {
        return x$0.apply(data, index, name);
    }

    public <T> BaseIndex inline$index$i13(Series<T> x$0) {
        return x$0.index();
    }

    public <T> SeriesData<T> inline$data$i11(Series<T> x$0) {
        return x$0.data();
    }

    public <T> Object inline$vector$i5(SeriesData<T> x$0) {
        return x$0.vector();
    }

    public <T> boolean[] inline$mask$i6(SeriesData<T> x$0) {
        return x$0.mask();
    }

    public <T> BaseIndex inline$index$i14(Series<T> x$0) {
        return x$0.index();
    }

    public <T> Series<T> inline$apply$i5(Series$ x$0, SeriesData<T> data, BaseIndex index, String name) {
        return x$0.apply(data, index, name);
    }

    public <T> BaseIndex inline$index$i15(Series<T> x$0) {
        return x$0.index();
    }

    public <T> BaseIndex inline$index$i16(Series<T> x$0) {
        return x$0.index();
    }

    public <T> SeriesData<T> inline$data$i12(Series<T> x$0) {
        return x$0.data();
    }

    public <T> Object inline$vector$i6(SeriesData<T> x$0) {
        return x$0.vector();
    }

    public <T> Series<T> inline$apply$i6(Series$ x$0, SeriesData<T> data, BaseIndex index, String name) {
        return x$0.apply(data, index, name);
    }

    public <T> BaseIndex inline$index$i17(Series<T> x$0) {
        return x$0.index();
    }

    public <T> boolean[] inline$mask$i7(SeriesData<T> x$0) {
        return x$0.mask();
    }

    public <T> Series<T> inline$apply$i7(Series$ x$0, SeriesData<T> data, BaseIndex index, String name) {
        return x$0.apply(data, index, name);
    }

    public <T> BaseIndex inline$index$i18(Series<T> x$0) {
        return x$0.index();
    }

    public <T> SeriesData<T> inline$data$i13(Series<T> x$0) {
        return x$0.data();
    }

    public <T> Object inline$vector$i7(SeriesData<T> x$0) {
        return x$0.vector();
    }

    public <T> BaseIndex inline$index$i19(Series<T> x$0) {
        return x$0.index();
    }

    public <T> boolean[] inline$mask$i8(SeriesData<T> x$0) {
        return x$0.mask();
    }

    public <T> BaseIndex inline$index$i20(Series<T> x$0) {
        return x$0.index();
    }

    public <T> SeriesData<T> inline$data$i14(Series<T> x$0) {
        return x$0.data();
    }

    public <T> Object inline$vector$i8(SeriesData<T> x$0) {
        return x$0.vector();
    }

    public <T> BaseIndex inline$index$i21(Series<T> x$0) {
        return x$0.index();
    }

    public <T> boolean[] inline$mask$i9(SeriesData<T> x$0) {
        return x$0.mask();
    }

    public <T> BaseIndex inline$index$i22(Series<T> x$0) {
        return x$0.index();
    }

    public <T> SeriesData<T> inline$data$i15(Series<T> x$0) {
        return x$0.data();
    }

    public <T> Object inline$vector$i9(SeriesData<T> x$0) {
        return x$0.vector();
    }

    public <T> BaseIndex inline$index$i23(Series<T> x$0) {
        return x$0.index();
    }

    public <T> boolean[] inline$mask$i10(SeriesData<T> x$0) {
        return x$0.mask();
    }

    public <T> BaseIndex inline$index$i24(Series<T> x$0) {
        return x$0.index();
    }

    private static final boolean $anonfun$1() {
        return false;
    }

    private static final boolean $anonfun$2() {
        return false;
    }

    private static final boolean $anonfun$3() {
        return false;
    }

    private static final boolean $anonfun$4() {
        return false;
    }

    private static final boolean $anonfun$5() {
        return false;
    }

    private static final boolean $anonfun$6() {
        return false;
    }

    private static final boolean $anonfun$7() {
        return false;
    }

    private static final boolean $anonfun$8() {
        return false;
    }

    private static final boolean $anonfun$9() {
        return false;
    }

    private static final boolean $anonfun$10() {
        return false;
    }

    private static final boolean $anonfun$11() {
        return false;
    }

    private static final boolean $anonfun$12() {
        return false;
    }

    private static final boolean $anonfun$13() {
        return false;
    }

    private static final boolean $anonfun$14() {
        return true;
    }

    private static final boolean $anonfun$16() {
        return true;
    }
}

